# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#SocketOutputStream a class for writing to a socket

#don't source the script more then once
if [info exists SocketOutputStream] {
    return
}


#this line helps the auto loader find this class
proc SocketOutputStream {} {}


catch {class new -Name SocketOutputStream -init {-Extends OutputStream}}



#init
#-Address - specifies an remote host to connect to (name,or ip)
#-Port - the tcp port to connect to
#[-Timeout] - timeout in seconds
#***Switches***
#-Raw - indicates not to send data in messages but straight over the socket
#       no flags will be available ie (eof,eot,eod)
SocketOutputStream method init {args} {
    array set check [CheckParms -Proc "SocketOutputStream_init parm" -Provided $args \
			 -Required {-Address -Port} -Optional {-Timeout} -Switches {-Raw}]

    array set parms $check(Flags)

    $this public address port QStreamRef

    #handle args
    set address $parms(-Address)
    set port $parms(-Port)
    set use_flags 1

    if [catch {set timeout $parms(-Timeout)} result] {
	set timeout -1
	#default timeout to forever
    }

    if {[lsearch $check(Switches) "-Raw"] != -1} {
	set use_flags 0
    }
    global QSTREAM_OPENWRITE

    #create the socket stream
    set QStreamRef [QS_PRIM_StreamCreate 2 $QSTREAM_OPENWRITE $address $port \
			$use_flags $timeout]


    #call super init
    $this super init

};#endof SocketOutputStream_init


