# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#Streamer class is used to copy the contents of one stream to another

#don't source the script more then once
if [info exists Streamer] {
    return
}


#this line helps the auto loader find this class
proc Streamer {} {}


catch {class new -Name Streamer}



#Streamer_init
#INPUT
#-Input - the input stream
#-Output - the output stream
#[-BlockSize] - the size of blocks to transfer
Streamer method init {args} {
    #call parent constructor
    $this super init

    array set check [CheckParms -Proc "Streamer_init parm" -Provided $args \
			 -Required {-Input -Output} -Optional {-BlockSize}]

    array set parms $check(Flags)

    $this public Input Output QStreamerRef
    #handle parms
    set Input $parms(-Input)
    set Output $parms(-Output)

    #handle optional parms
    if [catch {set blockSize $parms(-BlockSize)} result] {
	global QS_GlobalValues
	set blockSize $QS_GlobalValues(DefaultStreamerBlockSize)
    }

    #create the streamer
    
    set inRef [$Input set QStreamRef]
    set outRef [$Output set QStreamRef]

    #mark the streams as used
    $Input attach
    $Output attach

    set QStreamerRef [QS_PRIM_StreamerCreate $inRef $outRef $blockSize]

};#endof Streamer_init

Streamer method destroy {} {
    $this public QStreamerRef Input Output

    #the streamer is automatically stopped if still active
    #this takes place in the C code
    
    #free the stream
    QS_PRIM_StreamerDestroy $QStreamerRef

    #mark streams as unused
    $Input detach
    $Output detach

    #call parent class destructor
    $this super destroy
};#endof Streamer_destroy


#Streamer_SetTerm - sets terination condition for the input stream
#term - a bit field can be set to QEOF|QEOT|QEOD or a combination
Streamer method SetTerm {term} {

    $this public QStreamerRef

    QS_PRIM_StreamerSetTerm $QStreamerRef $term

};#endof Streamer_SetTerm

#Streamer_GetTerm - gets terination condition for the input stream
#returns a bit field can be QEOF|QEOT|QEOD or a combination
Streamer method GetTerm {} {

    $this public QStreamerRef

    return [QS_PRIM_StreamerGetTerm $QStreamerRef]

};#endof Streamer_GetTerm


#Streamer_Stream - transfers the contents of one stream to the other, up to the term
#this method blocks untill the tranfer is complete
#any current xfers are stopped before this starts
Streamer method Stream {} {
    $this Start
    $this Wait
    return
};#endof Streamer_Stream

#Streamer_Start - transfers the contents of one stream to the other, up to the term
#this method returns once the tranfer has started
#as with stream, any current xfers stop first
Streamer method Start {} {

    $this public QStreamerRef Input Output

    #ensure that both stream objects still exist
    global $Input $Output
    if {![info exists $Input] || ![info exists $Output]} {
	QS_ERROR -Error "ObjectDoesNotExist"
    }


    QS_PRIM_StreamerStart $QStreamerRef

    return
};#endof Streamer_Start

#Streamer_Stop - requests that the tranfer be stoped
#this method returns after the xfer has stopped
Streamer method Stop {} {

    $this public QStreamerRef

    QS_PRIM_StreamerStop $QStreamerRef
    
    return
};#endof Streamer_Stop

#Streamer_Wait - waits for the current xfer to complete
Streamer method Wait {} {

    $this public QStreamerRef


    vwait QS_StreamerRef_$QStreamerRef

    return
};#endof Streamer_Wait

#Streamer_registerCallback - registers a callback handler to be called when streaming finishes
Streamer method registerCallback {args} {

    array set check [CheckParms -Proc "Streamer_registerCallback" -Provided $args \
			 -Required {-Proc} -Optional {-Obj}]

    $this public QStreamerRef
    
    array set parms $check(Flags)

    set cbProc $parms(-Proc)

    if [catch {set cbObj $parms(-Obj)} result] {
	#procedure callback

	set cb "proc QS_StreamerRef_$QStreamerRef \{\} \{
                   after 0 $cbProc $this
                \}"	
    } else {
	#method callback
	set cb "proc QS_StreamerRef_$QStreamerRef \{\} \{
                   after 0 $cbObj $cbProc $this
                \}"	
    }

    eval $cb


    return
};#endof Streamer_registerCallback





