# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if ![info exists ToneGen] {
    source ${qscript_library}/tgendefs.qs
    #this line helps the auto loader find this class
    proc ToneGen {} {}
    catch {AddressableClass new -Name ToneGen -init {-Extends Instance}}
}

#this is done so that the SigDet class is definitely loaded
catch {SigDet}
ToneGen set ComponentType $Tgen_Std_ComponentType
ToneGen set typeDefRegistry ToneGen_TypeDefs
ToneGen method init {args} {
    eval $this super init $args
    global Tgen_MsgPlaySequenceCmplt Tgen_MsgPlayToneCmplt Tgen_MsgDialCmplt
    $this asyncRegister -MsgType $Tgen_MsgPlaySequenceCmplt -TypeDef {} -Proc {}
    $this asyncRegister -MsgType $Tgen_MsgPlayToneCmplt -TypeDef {} -Proc {}
    $this asyncRegister -MsgType $Tgen_MsgDialCmplt -TypeDef {} -Proc {}
    return
}

#ToneGen_Dial
#INPUTS
#digits
#OUTPUTS
#{Reason # RtcLabel #}
ToneGen method Dial {digits} {
    global Tgen_MsgDial Tgen_MsgDialCmplt
    #lookup typedefs
    set tdr [$this Class set typeDefRegistry]
    set out_td [$tdr lookup -MsgType $Tgen_MsgDial]
    set in_td [$tdr lookup -MsgType $Tgen_MsgDialCmplt]
    #fill in msg data
    set data [list \
		  Count [expr [string length $digits] +1] \
		  List $digits ]
    #I do the string length +1 to make sure the string is null terminated
    #since all data is initially 0 it is a null
    #issue request
    set retval [$this request -Data $data \
		    -Type $Tgen_MsgDial -TypeDef $out_td \
		    -RetType $Tgen_MsgDialCmplt -RetTypeDef $in_td \
		    ]
    return $retval
}


#ToneGen_Dial
#INPUTS
#digits
#OUTPUTS
ToneGen method StartDial {digits} {
   

    global Tgen_MsgDial
    #lookup typedefs
    set tdr [$this Class set typeDefRegistry]

    set out_td [$tdr lookup -MsgType $Tgen_MsgDial]

 
    #fill in msg data
    set data [list \
		  Count [expr [string length $digits] +1] \
		  List $digits ]

    #I do the string length +1 to make sure the string is null terminated
    #since all data is initially 0 it is a null

    #issue request
    set retval [$this request -Data $data \
		    -Type $Tgen_MsgDial -TypeDef $out_td \
		    ]

 
    return $retval
};#endof ToneGen_StartDial


#***ToneGen_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an ToneGen object, it also recognizes all types specified in Addressable_TypeDefs

if ![info exists ToneGen_TypeDefs] {
    TypeDefRegistry new -Name ToneGen_TypeDefs \
	-init [list -Extends [[ToneGen set Extends] set typeDefRegistry]]
}

ToneGen_TypeDefs define -MsgType Tgen_MsgCreateTone \
    -TypeDef [list \
		  SignalId $Tgen_MsgCreateTone_SignalId \
		  SegCount $Tgen_MsgCreateTone_SegCount \
		  SignalLabel $Tgen_MsgCreateTone_SignalLabel \
		  SegList [list -Count SegCount -DataType \
				[list \
				     SignalType $Tgen_MsgCreateTone_segs_SignalType \
				     Freq1 $Tgen_MsgCreateTone_segs_Freq1 \
				     Amp1 $Tgen_MsgCreateTone_segs_Amp1 \
				     Freq2 $Tgen_MsgCreateTone_segs_Freq2 \
				     Amp2 $Tgen_MsgCreateTone_segs_Amp2 \
				     OnDuration $Tgen_MsgCreateTone_segs_OnDuration \
				     OffDuration $Tgen_MsgCreateTone_segs_OffDuration \
				     Reps $Tgen_MsgCreateTone_segs_Reps \
				     NextSeg $Tgen_MsgCreateTone_segs_NextSeg \
				     ] \
				] \
		  ]


ToneGen_TypeDefs define -MsgType Tgen_MsgDeleteTone \
    -TypeDef [list \
		  SignalId $Tgen_MsgDeleteTone_SignalId \
		  ]

ToneGen_TypeDefs define -MsgType Tgen_MsgPlayTone \
    -TypeDef [list \
		  SignalId $Tgen_MsgPlayTone_SignalId \
		  ]

ToneGen_TypeDefs define -MsgType Tgen_MsgPlayToneCmplt \
    -TypeDef [list \
		  Reason $Tgen_MsgPlayToneCmplt_Reason \
		  RtcLabel $Tgen_MsgPlayToneCmplt_RtcLabel \
		 ]

ToneGen_TypeDefs define -MsgType Tgen_MsgPlaySequence \
    -TypeDef [list \
		  Count $Tgen_MsgPlaySequence_Count \
		  List [list -Count Count -DataType \
			     [list \
				  SignalId $Tgen_MsgPlaySequence_List_SignalId \
				  ] \
			     ] \
	      ]


ToneGen_TypeDefs define -MsgType Tgen_MsgPlaySequenceCmplt \
    -TypeDef [list \
		  Reason $Tgen_MsgPlaySequenceCmplt_Reason \
		  RtcLabel $Tgen_MsgPlaySequenceCmplt_RtcLabel \
		 ]


ToneGen_TypeDefs define -MsgType Tgen_MsgDial \
    -TypeDef [list \
		  Count $Tgen_MsgDial_Count \
		  List $QS_String \
		 ]

ToneGen_TypeDefs define -MsgType Tgen_MsgDialCmplt \
    -TypeDef [list \
		  Reason $Tgen_MsgDialCmplt_Reason \
		  RtcLabel $Tgen_MsgDialCmplt_RtcLabel \
		 ]

ToneGen_TypeDefs define -MsgType Tgen_MsgCreateToneCmplt \
    -TypeDef {}

ToneGen_TypeDefs define -MsgType Tgen_MsgDeleteToneCmplt \
    -TypeDef {}


ToneGen_TypeDefs define -EvtGroup Tgen_Event_Type_EvtStarted \
    -TypeDef [list \
		  EvtGroup $Tgen_EvtStopped_EventLabel \
		  ReturnAddress $QS_CompDesc \
		  Type $Tgen_Event_Type \
		  Label $Tgen_Event_Label \
		  ]

ToneGen_TypeDefs define -EvtGroup Tgen_Event_Type_EvtStopped \
    -TypeDef [list \
		  EvtGroup $Tgen_EvtStopped_EventLabel \
		  Reason $Tgen_EvtStopped_Reason \
		  RtcLabel $Tgen_EvtStopped_RtcLabel \
		  ]


#auto method definitions

ToneGen defineMsgMethod -MethodName CreateTone \
    -Type $Tgen_MsgCreateTone -TypeDef lookup \
    -Defaults {-SegCount {}} \
    -RetType $Tgen_MsgCreateToneCmplt

ToneGen defineMsgMethod -MethodName DeleteTone \
    -Type $Tgen_MsgDeleteTone -TypeDef lookup \
    -RetType $Tgen_MsgDeleteToneCmplt

ToneGen defineMsgMethod -MethodName PlayTone \
    -Type $Tgen_MsgPlayTone -TypeDef lookup \
    -RetType $Tgen_MsgPlayToneCmplt -RetTypeDef lookup

ToneGen defineMsgMethod -MethodName StartPlayTone \
    -Type $Tgen_MsgPlayTone -TypeDef lookup

ToneGen defineMsgMethod -MethodName PlaySequence \
    -Type $Tgen_MsgPlaySequence -TypeDef lookup \
    -Defaults {-Count {}} \
    -RetType $Tgen_MsgPlaySequenceCmplt -RetTypeDef lookup

ToneGen defineMsgMethod -MethodName StartPlaySequence \
    -Type $Tgen_MsgPlaySequence -TypeDef lookup \
    -Defaults {-Count {}}

ToneGen defineMsgMethod -MethodName Stop \
    -Type $Tgen_MsgStop



return

