# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists object] {
    return
}

proc object {} {}

proc obj_init {this} {
    upvar \#0 $this obj
    set obj(field_ReferenceCounter) 0
    set obj(field_destroyOnUnreferenced) 1
}

proc obj_destroy {this} {
    upvar \#0 $this obj

    unset obj
    rename $this {}
}

proc obj_puts {this {file stdout}} {
    upvar \#0 $this obj
    puts $file [array get obj]
}

proc obj_fieldIncr {this field args} {
    upvar \#0 $this obj
    if {[llength $args]>0} {
	return [incr obj(field_$field) $args]
    }
    return [incr obj(field_$field)]
};#obj_fieldIncr

proc obj_fieldAppend {this field value} {
    upvar \#0 $this obj
    return [lappend obj(field_$field) $value]
};#obj_fieldAppend

proc obj_fieldSet {this field args} {
    upvar \#0 $this obj
    if {[llength $args] == 1} {
	return [set obj(field_$field) [lindex $args 0]]
    } elseif {[llength $args] > 1} {
	error "wrong \# args: should be \"obj set fieldName \[newValue\]\""
    }
    return $obj(field_$field)
};#endof obj_fieldSet

proc obj_fieldUnset {this args} {
    upvar \#0 $this obj
    eval $this public $args
    eval unset $args
    return
};#endof obj_fieldSet

proc obj_Class_call {this method args} {
    upvar \#0 $this obj
    uplevel 1 eval $obj(field_Class) $method $args
};#endof obj_Class_call

proc obj_public {this args} {
    foreach field $args {
	uplevel 1 upvar \#0 [list ${this}(field_$field) $field]
    }
}

proc obj_clone {this} {
    upvar \#0 $this obj
    set clone [$this Class new -DontInit]
    upvar \#0 $clone obj_clone
    #copy all fields
    array set obj_clone [array get obj]
    #modify certian fields
    array set obj_clone [list \
			     field_Name $clone \
			     field_ClassContext $obj_clone(field_Class)]
    return $clone
};#endof obj_clone


#obj_attach - register a user for this object, (reference counting)
proc obj_attach {this} {
    upvar \#0 $this obj
    incr obj(field_ReferenceCounter)
}

#obj_detach - detach a user, destroy if 0
proc obj_detach {this} {
    upvar \#0 $this obj
    incr obj(field_ReferenceCounter) -1
    if {$obj(field_destroyOnUnreferenced) && $obj(field_ReferenceCounter) <=0} {
	$this destroy
    }
}

array set object {
    field_Name object
    field_Class class
    field_ClassContext class
    field_instanceCounter 0
    method_init {object obj_init}
    method_destroy {object obj_destroy}
    method_Class {object obj_Class_call}
    method_public {object obj_public}
    method_clone {object obj_clone}
    method_puts {object obj_puts}
    method_set {object obj_fieldSet}
    method_unset {object obj_fieldUnset}
    method_incr {object obj_fieldIncr}
    method_append {object obj_fieldAppend}
    method_attach {object obj_attach}
    method_detach {object obj_detach}
}

#make object object
class_obj_make object

