# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

proc hot_register {tsc Module cpu} {
    dprint "Registering module $Module"

    # Link to get actual size  
    array set result [hot_link $Module 0x0 $cpu]
    set Size $result(size)

    dprint "   calling \[\$tsc ModuleRegister -MemSize $Size -ModName $Module\]"

    array set result [$tsc ModuleRegister -MemSize $Size -ModName $Module]
    set ndx [format "%d" $result(Id)]
    set LocateAddress $result(LocateAddress)

    # record info for this module
    set modInfo(ndx) $ndx
    set modInfo(name) $Module
    set modInfo(address) $LocateAddress
    set modInfo(size) $Size

    dprint "      Id:         $ndx"
    dprint "      Size:       $Size"
    dprint "      Locate:     $LocateAddress"
    dprint "   $Module has been Registered"

    return [array get modInfo]
}

proc hot_load {tsc Module ndx locateAddress cpu} {
    global cfgpath

    set BlockSize 2000
    set hotfile [file join $cfgpath $Module.hot]

    if [file exists $hotfile] {

	dprint "Loading module $Module"
	# status from board to retrieve link addresses
	array set status [$tsc ModuleCheckStatus -Id $ndx]

	# do final link to resolve addresses, get entry and exit points
	array set result [hot_link $Module $locateAddress $cpu]

	set EntryPoint $result(entry)
	set ExitPoint $result(exit)
	set Size $result(size)
	set Data $result(data)

	dprint "   Loading"
	dprint "      Id:         $ndx"
	dprint "      Size:       $Size"
	dprint "      EntryPoint: $EntryPoint"
	dprint "      ExitPoint:  $ExitPoint"

	set sizesent 0
	set dataleft $Size
	while {$sizesent < $Size} {
	    if {$dataleft <= $BlockSize} {
		set datasize $dataleft
	    } else {
		set datasize $BlockSize
	    }
	    incr dataleft -$datasize
	    set first $sizesent
	    set last [expr $first + $datasize - 1]
	    set datablock [lrange $Data $first $last]

	    dprint "   BS:$BlockSize ds:$datasize ($first to $last)"
	    dprint "calling \$tsc ModuleLoad -Id $ndx -EntryPoint $EntryPoint -ExitPoint $ExitPoint -MemSize $datasize"
	    $tsc ModuleLoad -Id $ndx -EntryPoint $EntryPoint -ExitPoint $ExitPoint -MemSize $datasize -Data $datablock
	    incr sizesent $datasize
	    set percentdone [format "%3.0f" [expr ([format "%f" $sizesent] / $Size) * 100]]
	    dprint " "
	    dprint "   $Module is $percentdone\% Loaded"
	    dprint "- ss:$sizesent dl:$dataleft - $percentdone\% Loaded"
	}
	dprint "\n$Module is Loaded"
    } else {
	dprint "Unable to open file $hotfile"
    }
}

for {set i 0} {[expr $i <= 255]} {incr i} {
    set char2byte([format %c $i]) [format 0x%02x $i]
}

proc determine_cpu {} {
    global parms qscript_path

    # The check for PPC binary MUST be first. For some reason, 
    # the nm960 delivered with the build works on the PPC symbol file ??
    # the reverse is NOT true, so is is safe to run nmppc on an i960 binary
    # (it will fail as expected
    if {![catch {exec [file join $qscript_path powerpc-elf-nm] $parms(-mlmfile)}]} {
	return pq2
    }
    if {![catch {exec [file join $qscript_path nm960] $parms(-mlmfile)}]} {
	return i960
    }
    if {![catch {exec [file join $qscript_path nmarm] $parms(-mlmfile)}]} {
	return arm
    }
    return unknown
}

proc hot_link {Module location cpu} {
    global qscript_path
    global char2byte parms
    global cfgpath

    set MLM_File $parms(-mlmfile)
    dprint "   Link1: $cpu"

    set hotfile [file join $cfgpath $Module.hot]

    if {$cpu == "i960"} {
	set ldexe ld960
	set nmexe nm960
	set makeexe makemod
    } elseif {$cpu == "arm"} {
	set ldexe ldarm
	set nmexe nmarm
	set makeexe makearm
    } elseif {$cpu == "pq2"} {
	set ldexe powerpc-elf-ld
	set nmexe powerpc-elf-nm
	set makeexe makeppc
    } else {
      log "Unsupported cpu: $cpu"
      exit_fail
    } 
    # Link and locate the module (creates hlm file)
    dprint "\t$ldexe $hotfile -Ttext $location"
    if {$cpu == "i960"} {
        dprint "exec [file join $qscript_path $ldexe] -N -ACA -X -R $MLM_File -t -o $Module.hlm $hotfile -Ttext $location"
        exec [file join $qscript_path $ldexe] -N -ACA -X -R $MLM_File -t -o $Module.hlm $hotfile -Ttext $location
    } elseif {$cpu == "arm" || $cpu == "pq2" } {
        dprint "exec [file join $qscript_path $ldexe] -N -X -R $MLM_File -o $Module.hlm $hotfile -e _sysInit -Ttext $location"
        exec [file join $qscript_path $ldexe] -N -X -R $MLM_File -o $Module.hlm $hotfile -e _sysInit -Ttext $location
    }

    dprint "\tmakemod $Module.hlm"
    dprint "exec [file join $qscript_path $makeexe] $Module.hlm > ${Module}_1.lst"
    exec [file join $qscript_path $makeexe] $Module.hlm > ${Module}_1.lst
    dprint "\tfile rename -force mod.bin $Module.bin"
    file rename -force mod.bin $Module.bin

    #read file data
    dprint "\tReading $Module.bin"
    set mod_file [open ${Module}.bin r]
    fconfigure $mod_file -translation binary
    set stringdata [read $mod_file]
    close $mod_file

    #turn string data into list of integers
    set data_list [split $stringdata {}]
    set Data {}
    if {$location != 0} {
	foreach element $data_list {
	    lappend Data $char2byte($element)
	}
        dprint "exec [file join $qscript_path $nmexe] $Module.hlm"
        set nmData [exec [file join $qscript_path $nmexe] $Module.hlm]
        set entryIndex [lsearch -regexp $nmData .*entryFunc.*]
        set exitIndex [lsearch -regexp $nmData .*exitFunc.*]

	set EntryPoint "0x[lindex $nmData [expr $entryIndex-2]]"
	set ExitPoint "0x[lindex $nmData [expr $exitIndex-2]]"
	dprint "\t\tEntry Point: $EntryPoint"
	dprint "\t\t Exit Point: $ExitPoint"
	set result(entry) $EntryPoint
	set result(exit) $ExitPoint
    } else {
	dprint "Location was 0 so size only."
    }    
    set result(size) [llength $data_list]
    set result(data) $Data

    dprint "\t\tSize: $result(size)"

    # remove temporary files UNLESS noclobber
    set noclobber 0
    if {!$noclobber} {
	dprint "\tremoving temporary files"
	file delete $Module.hlm ${Module}_1.lst $Module.bin
    }

    return [array get result]
}

proc hot_start {tsc ndx} {
    dprint "Starting module $ndx"
    dprint "calling \$tsc ModuleStart -Id $ndx"
    $tsc ModuleStart -Id $ndx
}


