# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

set version 2.0
source ${qscript_path}/pdk_parser_tools.qs
source ${qscript_path}/tscdefs_hotload.qs
unset TSC
catch {wm withdraw .}
catch {TSCComponent}

# override qs ToneGen init to not setup callbacks.
ToneGen method init {args} {
    eval $this super init $args
    return
}

source ${qscript_path}/tscdefs_ext.qs
source ${qscript_path}/PDKHotload.qs

proc exit_warning {} {
	global switches
	if {[info exists switches(-autodownload)] && ![info exists switches(-console)]} {
		log "*DONE Warning*"
		exit 16384
	} else {
		log "*DONE Warning*"
		exit 16384
	}
}
proc exit_fail {} {
	global switches
	if {[info exists switches(-autodownload)] && ![info exists switches(-console)]} {
		log "*DONE Fail*"
		exit 1
	} else {
		log "*DONE Fail*"
		exit 1
	}
}

proc exit_success {} {
	global switches
	if {[info exists switches(-autodownload)] && ![info exists switches(-console)]} {
		log "*DONE Success*"
		exit 0
	} else {
		log "*DONE Success*"
		exit 0
	}
}

set starttime [clock clicks -milliseconds]
proc log {string} {
	global parms switches logfile
	global starttime
	global env

	set now [expr [clock clicks -milliseconds] - $starttime]
	if {[info exists switches(-console)] || ![info exists parms(-L)]} {
		puts "$now: $string"
	}
	if {[info exists parms(-L)]} {
		if ![info exists logfile] {
			if {[string first "/" $parms(-L)] < 0 ||
                            [string first "\\" $parms(-L)] < 0} {
			    set parms(-L) [file join $env(INTEL_DIALOGIC_DIR) "log" $parms(-L)]
			}
			if {[info exists parms(-board)]} {
			    set logfile [open $parms(-L).$parms(-board) w]
			} else {
			    set logfile [open $parms(-L) w]
			}
		}
		puts $logfile "$now: $string"
	}
}

proc main {} {
    global argv debug parms switches env version datapath cfgpath

    #parse command line arguments
    set Lindex [expr [string first "-L" $argv] + 1]
    if {$Lindex > 0} {
        set argv [concat [string range $argv 0 $Lindex] \
                         [string range $argv [expr $Lindex + 1] end] \
                 ]
    }
    if [catch {array set check [CheckParms \
	    -Proc PDKManager.qs \
	    -Provided $argv \
	    -Required {} \
	    -Optional {-board -line -chan -load -unload -setvariant
    -setchanstate -setlinestate -cfgfile -mlmfile -pcdfile -fcdfile -L} \
	    -Switches {-help -status -protocolstatus -autodownload -console
    -configure -fastset -debug -inservice} \
	    ]} result ] {
	puts stderr $result
	exit_fail
    }

    array set parms $check(Flags)
    foreach {switch} $check(Switches) {
	set switches($switch) 1
    }

    log "PDKManager v$version (c) Intel Dialogic 2004"

    set debug 0
    catch {set debug $switches(-debug)}
    dprint "Debug output will be printed."
    dprint [pwd]

    if ![info exists switches(-fastset)] { set switches(-fastset) 0 }

    if ![info exists parms(-board)] { set parms(-board) -1 }
    set board $parms(-board)

    #line 0 indicates all lines
    if ![info exists parms(-line)] { set parms(-line) 0 }
    set line $parms(-line)

    #chan 0 indicates all channels
    if ![info exists parms(-chan)] { set parms(-chan) 0 }
    set chan $parms(-chan)

    # Test location for Dialogic config files
    # Normally set by DNA install script
    if { [info exists env(INTEL_DIALOGIC_FWL)] } {
	set env(DLGCFWLPATH) $env(INTEL_DIALOGIC_FWL)
    } elseif { [info exists env(DLFWLPATH)] } {
	set env(DLGCFWLPATH) $env(DLFWLPATH)
    } else {
	log "Environment Variable INTEL_DIALOGIC_FWL not set\n"
	log "Using default /usr/dialogic/data\n"
	set env(DLGCFWLPATH) "/usr/dialogic/data"
    }
    # we'll cd there and hopefully that'll simplify things
    cd $env(DLGCFWLPATH)
    set datapath $env(DLGCFWLPATH) 
    set cfgpath [file join $env(DLGCFWLPATH) ../cfg]

    catch {set fcdfile $parms(-fcdfile)}

    if ![info exists parms(-cfgfile)] {set parms(-cfgfile) pdk.cfg}
    if ![info exists parms(-fcdfile)] {set parms(-fcdfile) qs_r2mf.fcd}
    if ![info exists parms(-pcdfile)] {set parms(-pcdfile) qs_r2mf.pcd}

    if ![info exists parms(-mlmfile)] {
	# if autodownload, these flags get ignored.
	if ![info exists switches(-autodownload)] {
	    set parms(-mlmfile) [get_mlmfile $parms(-pcdfile)]
	}
    }

    #functional branch
    #these options are mutually exclusive. if more than one specified,
    #only first listed will execute.


    if       [info exists switches(-help)] {
	help
    } elseif [info exists switches(-configure)] {
	log "not yet supported"
    } elseif [info exists switches(-autodownload)] {
	set autolist [read_cfg $parms(-cfgfile)]
	set boardlist $parms(-board)
	dprint $autolist
	set allpass 1
	foreach {autoelem} $autolist {
	    catch {unset autoarray}
	    array set autoarray $autoelem
	    set parms(-board) $autoarray(b)
	    set parms(-line) $autoarray(l)
	    set parms(-chan) $autoarray(c)
	    set parms(-fcdfile) $autoarray(f)
	    set parms(-pcdfile) $autoarray(p)
	    set parms(-mlmfile) [file join $datapath $autoarray(m)]
	    set parms(-setvariant) $autoarray(v)
          set parms(-rocboard) $autoarray(r)
	    log "Autodownloading board $parms(-board) line $parms(-line) chan $parms(-chan) variant $parms(-setvariant) rocboard $parms(-rocboard)"
	    validate_lines
	    foreach {b} $parms(-board) {
		if { $boardlist == -1 } {
			dprint "No specific boards. Doing all"
		    if { -1 == [set_variant $b]} {
			set allpass 0
		    }
		} elseif {-1 != [lsearch -exact $boardlist $b]} {
			dprint "Matched on board $b"
                    set boardpath [file join $datapath pdktemp $b]
                    file mkdir $boardpath
                    cd $boardpath
		    if { -1 == [set_variant $b]} {
			set allpass 0
		    }
                    cd $datapath
		} else {
			dprint "Did not match board. skipping"
		}
	    }
	}
	if {0 == $allpass} {
		log "At least one board did not download. This situation is normal if "
		log "boards are disabled in DCM."
		log "Otherwise, please verify the settings in pdk.cfg for your system."
		exit_warning
	}
    } elseif [info exists switches(-status)] {
	log "not yet supported"
    } elseif [info exists switches(-protocolstatus)] {
	log "not yet supported"
    } elseif [info exists parms(-load)] {
	validate_lines
	foreach {b} $board {
	    foreach {v} $parms(-load) {
		load_variant $b $v
	    }
	}
    } elseif [info exists parms(-unload)] {
	log "not yet supported"
    } elseif [info exists parms(-setvariant)] {
	validate_lines
	foreach {b} $board {
	    set_variant $b
	}
    } elseif [info exists parms(-setchanstate)] {
	log "not yet supported"
    } elseif [info exists parms(-setlinestate)] {
	log "not yet supported"
    } else {
	help
    }
	exit_success
}

proc help {} {
    global version
    log "PDKManager v$version (c) Intel Dialogic 2004"
    log { }
    log {PDKManager [-help]}
    log {           [-board <n> | {<n1> <n2> ...}]}
    log {           [-line <n> | {<n1> <n2> ...}]}
    log {           [-chan <n> | {<n1> <n2> ...}]}
    log {           [-load <vdffile>]}
    log {           [-setvariant <n> | <vdffile>]}
    log { }
    log {           [-pcdfile <pcdfile>] - default to qs_r2mf.pcd}
    log {           [-fcdfile <fcdfile>] - default to qs_r2mf.fcd}
    log {           [-mlmfile <mlmfile>]}
    log {           [-debug]}
    log {           [-console]}
    log {           [-autodownload]}
    log {           [-inservice] - Experimental functionality }
}

proc protocol_status {board} {
    # Display which protocols and variants are present on the
    # specified board
    dprint "Protocol Status"
    log "Protocol Modules on board $board"

}

proc dprint {message} {
    # put out message if debugging is on
    global debug
    if {$debug} {
	log "**** $message"
    }
}

proc read_cfg {cfgfile} {
    global parms cfgpath
    # cfg file is a sequence of lines
    # b[oard] <b> [l[ine] <l>] [c[han] <c>] v[ariant] <v>
    # [p[cdfile] <p>] [f[cdfile] <f>]
    # [r[ocboard] <rb>
    # return a list of arrays

    #cfgfiles located in cfgpath
    set cfgfile [file join $cfgpath $cfgfile]

    if ![file exists $cfgfile] {
	log "Error, could not find configuration file $cfgfile."
	exit_fail
    }
    
    set infile [open $cfgfile r]
    set returnlist {}
    set linenum 0
    while {![eof $infile]} {
	set line [gets $infile]
	incr linenum
	if [string match {[#;]*} $line] {
	    #ignore comment
	} elseif [string match {?*} $line] { # non-empty
	    catch {
		unset linearray
		unset procarray
	    }
	    if [catch {
		array set linearray $line
	    } result ] {
		log "Unable to parse line $linenum of $cfgfile."
		dprint [llength $line]
		dprint $result
		exit_fail
	    }
	    
	    # check and normalize params
	    set names [array names linearray {[Bb]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous board number on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		log "No board number found on line $linenum of $cfgfile."
		exit_fail
	    } else {
		set procarray(b) $linearray($names)
	    }

	    set names [array names linearray {[Vv]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous variant file on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		log "No variant file found on line $linenum of $cfgfile."
		exit_fail
	    } else {
		set procarray(v) $linearray($names)
	    }

	    set names [array names linearray {[Ll]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous line number on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		# don't need it
		set procarray(l) 0
	    } else {
		set procarray(l) $linearray($names)
	    }

	    set names [array names linearray {[Cc]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous chan number on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		set procarray(c) 0
	    } else {
		set procarray(c) $linearray($names)
	    }

	    set names [array names linearray {[Pp]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous pcdfile on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		set procarray(p) $parms(-pcdfile)
	    } else {
		set procarray(p) $linearray($names)
	    }

	    set names [array names linearray {[Ff]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous fcdfile on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		set procarray(f) $parms(-fcdfile)
	    } else {
		set procarray(f) $linearray($names)
	    }

	    set names [array names linearray {[Mm]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous mlmfile on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		set procarray(m) [get_mlmfile $procarray(p)]
	    } else {
		set procarray(m) $linearray($names)
	    }

	    set names [array names linearray {[Rr]*}]
	    if {[llength $names] > 1} {
		log "Ambiguous rocboard on line $linenum of $cfgfile."
		exit_fail
	    } elseif {[llength $names] < 1} {
		set procarray(r) $procarray(b)
	    } else {
		set procarray(r) $linearray($names)
	    }

	    lappend returnlist [array get procarray]
	}
    }
    return $returnlist
}

proc validate_lines {} {
    global parms
    global lineinfo

    array set lineinfo [read_fcdfile $parms(-fcdfile)]
    if {$parms(-line) == 0} {
	if {$lineinfo(lines) == {}} {
	    log "No lines were found in $parms(-fcdfile)."
	    log "Aborting."
	    exit_fail
	}
	set parms(-line) $lineinfo(lines)
    }

    if {$parms(-chan) == 0} {
	foreach {line} $parms(-line) {
	    if ![info exists lineinfo(line,$line)] {
		log "Couldn't find line $line info in $parms(-fcdfile)."
		log "Aborting."
		exit_fail
	    }
	}
    }
}

proc read_vdf {vdffile} {

    # Read a vdf file and return its cdpfile, hotfile, and variant data.
    # append .vdf extension if one not provided.
    if [string compare .vdf [string tolower [file extension $vdffile]]] {
	set vdffile $vdffile.vdf
    }

    # load $vdffile and scan
    if ![file exists $vdffile] {
	log "Error, could not find file $vdffile."
	exit_fail
    }
    set vdfdesc [open $vdffile r]

    #first line is .cdp
    gets $vdfdesc vdf(cdpfile)

    #second line is .hot
    gets $vdfdesc vdf(hotfile)

    # read cdp file for variantname
    array set tempvdf [read_cdp $vdf(cdpfile)]
    set vdf(variantname) $tempvdf(variantname)

    return [array get vdf]
}

proc read_cdp {cdpfile} {

    # Read a cdp file and return its hotfile data.

    # load $cdpfile and scan
    if ![file exists $cdpfile] {
	log "Error, could not find file $cdpfile."
	exit_fail
    }
    set cdpdesc [open $cdpfile r]
    set vdf(cdpfile) $cdpfile

    #default variantname to filename
    set vdf(variantname) [file tail [file rootname $cdpfile]]

    #search file for sys_i960hotfile line
    #search file for sys_variantname line

    set done 0
    while [expr !$done] {
	if [catch {
	    set line [readLine $cdpdesc {} {/*} {*/}]
	} result] {
	    if {$result == "eof"} {
		#end of infile reached
		close $cdpdesc
		return [array get vdf]
	    } else {
		log $result
		exit_fail
	    }
	}

	#remove any comment which are between // and end of line
	set index [string first "//" $line]
	if [expr $index != -1] {
	    set line [string range $line 0 [expr $index - 1]]
	}
	
	set line [string trim $line]

	#anything else from this point should be data
	set key1 [string tolower [lindex $line 0]]
	set key2 [string tolower [lindex $line 1]]

	# Use '=' to locate parm name and value
	set index [string first "=" $line]

	# Parm name is last item in string prior to '='
	set parmName [lindex [string range $line -1 [expr $index - 1]] end]
	set parmName [string tolower $parmName]

	# Value is rest of line after '='
	# Use lindex to strip quotes from strings
	set parmVal [lindex [string range $line [expr $index + 1] end] 0]
	
	if {($key1 == "dm3") && ($key2 == "charstring_t") } {
	    if { ($parmName == "sys_i960hotfile")} {
		set vdf(i960hotfile) $parmVal
		dprint "Found match $vdf(i960hotfile)"
	    } elseif { ($parmName == "sys_armhotfile")} {
		set vdf(armhotfile) $parmVal
		dprint "Found match $vdf(armhotfile)"
	    } elseif { ($parmName == "sys_pq2hotfile")} {
		set vdf(pq2hotfile) $parmVal
		dprint "Found match $vdf(pq2hotfile)"
	    } elseif { ($parmName == "sys_variantname")} {
		set vdf(variantname) $parmVal
		dprint "Found match $vdf(variantname)"
	    }
	}
    }

    return [array get vdf]
}

proc get_mlmfile {pcdfile} {
    #scan pcdfile for PLMFile in mlm
    global parms

    if ![file exists $pcdfile] {
	log "Error, could not find pcd file $pcdfile."
	exit_fail
    }
    set infile [open $pcdfile r]
    set found 0
    while {![eof $infile]} {
	set line [gets $infile]
	if [string match "*PLMFile*" $line] {
	    #delete colon and retrieve 1 index
	    set line [ReplaceStringInLine $line ":" " "]
	    set mlmfile [lindex $line 1]
	    if ![string compare ".mlm" [file extension $mlmfile]] {
		dprint "Found mlm file $mlmfile"
		set found 1
		break
	    }
	}
    }
    if {$found == 1} {
	return $mlmfile
    } else {
	dprint "Warning, no mlm file found for $pcdfile"
	return "qs_pdk.mlm"
    }
}

proc read_fcdfile {fcdfile} {
    #scan fcdfile for ;; definebset lines

    if ![file exists $fcdfile] {
	log "Error, could not find fcd file $fcdfile."
	exit_fail
    }
    set infile [open $fcdfile r]
    set result(lines) {}
    while {![eof $infile]} {
	set line [gets $infile]
	if [string match ";; DefineBSet*" $line] {
	    dprint "Matched on $line"
	    #split on commas and retrieve 3 and 5 indexes
	    set line [ReplaceStringInLine $line "(" " "]
	    set line [ReplaceStringInLine $line ")" " "]
	    set line [ReplaceStringInLine $line "," " "]

	    #sanity
	    if [string compare ";;" [lindex $line 0]] {
		dprint "false match ;;"
		continue
	    }
	    if [string compare "definebset" [lindex $line 1]] {
		dprint [concat "false match definebset" [lindex $line 1]]
		continue
	    }
	    # everything okay, continue
	    set lineid [lindex $line 3]
	    set numchans [lindex $line 5]
	    dprint "Found $lineid with $numchans channels"
	    set result(line,$lineid) $numchans
	    lappend result(lines) $lineid
	}
    }
    return [array get result]
}

proc load_variant {boardnum vdffile} {
    # for board $boardnum, load variant $vdffile
    global cfgpath
    global parms

    if [catch {
	set board [Board new -init [list -BoardNum $boardnum]]
    } result ] {
	log "Board $boardnum is not downloaded. Unable to hotload variant."
	dprint $result
	return -1
    }
    if {$parms(-rocboard) == $parms(-board)} {
	set rocboard $board
    } else {
	if [catch {
		set rocboard [Board new -init [list -BoardNum $parms(-rocboard)]]
	} result ] {
		log "Board $parms(-rocboard) is not downloaded. Unable to configure tonegen/sigdet information."
		dprint $result
		return -1
	}
    }
    if [catch {
	set tsc [$board findComp -CompClass TSCComponent]
    } result ] {
	log "Board $boardnum has no TSC Component. Unable to hotload variant."
	dprint $result
	return -1
    }
    if [catch {
	set cas [$board findComp -CompClass CASComponent]
    } result ] {
	log "Board $boardnum has no CAS Component. Unable to hotload variant."
	dprint $result
	return -1
    }

    if [catch {
	set tgen [$rocboard findComp -CompClass ToneGen]
    } result ] {
	log "Board [$rocboard set tgtDesc] has no ToneGen Component. Unable to hotload variant."
	dprint $result
	return -1
    }
    if [catch {
	set sigdet [$rocboard findComp -CompClass SigDet]
    } result ] {
	log "Board [$rocboard set tgtDesc] has no SigDet Component. Unable to hotload variant."
	dprint $result
	return -1
    }

    set vdffile [file join $cfgpath $vdffile]

    if {![string compare .vdf [string tolower [file extension $vdffile]]]} {
	#vdffile specified
	log "Loading vdf $vdffile to board $boardnum."
	
	array set vdf [read_vdf $vdffile]
	if ![array size vdf] { exit_fail }

	set vdf(cdpfile) [file join $cfgpath $vdf(cdpfile)]
	set vdf(hotfile) [file join $cfgpath $vdf(hotfile)]

	log "Data from cdp $vdf(cdpfile)."
	log "Protocol is $vdf(hotfile)."

	if ![file exists $vdf(cdpfile)] {
	    log "Error, could not find cdp file $vdf(cdpfile)."
	    exit_fail
	}
	if ![file exists $vdf(hotfile)] {
	    log "Error, could not find hot file $vdf(hotfile)."
	    exit_fail
	}
    } elseif {![string compare .cdp [string tolower [file extension $vdffile]]]} {
	#cdpfile specified
	set vdf(cdpfile) $vdffile
	set vdf(cdpfile) [file join $cfgpath $vdf(cdpfile)]
	if ![file exists $vdf(cdpfile)] {
	    log "Error, could not find cdp file $vdf(cdpfile)."
	    exit_fail
	}
	array set vdf [read_cdp $vdffile]
	set vdf(cpu) [determine_cpu]
	dprint "determine_cpu $vdf(cpu)"
	if {$vdf(cpu) == "i960"} {
	    if {[info exists vdf(i960hotfile)]} {
		set vdf(hotfile) [file join $cfgpath $vdf(i960hotfile)]
	    } else {
		log "sys_i960hotfile was not defined in cdp file."
		exit_fail
	    }
	} elseif {$vdf(cpu) == "arm"} {
	    if {[info exists vdf(armhotfile)]} {
		set vdf(hotfile) [file join $cfgpath $vdf(armhotfile)]
	    } else {
		log "sys_armhotfile was not defined in cdp file."
		exit_fail
	    }
	} elseif {$vdf(cpu) == "pq2"} {
	    if {[info exists vdf(pq2hotfile)]} {
		set vdf(hotfile) [file join $cfgpath $vdf(pq2hotfile)]
	    } else {
		log "sys_pq2hotfile was not defined in cdp file."
		exit_fail
	    }
	} else {
	    log "$parms(-mlmfile) is not an i960, xscale, or ppc binary."
	    exit_fail
	}

	if ![file exists $vdf(hotfile)] {
	    log "Error, could not find hot file $vdf(hotfile)."
	    exit_fail
	}
    } else {
	#bad extension
	log "$vdffile was not .vdf or .cdp file"
	exit_fail
    }

    # Load hotfile
    load_hotfile $tsc $vdf(hotfile) $vdf(cpu)

    # Check if variant is loaded. If not, load.
    set result [load_variantdata $tsc $cas $tgen $sigdet \
		$vdf(cdpfile) $vdf(variantname) $boardnum]
    log "Variant loaded into $result."
    return $result
}

proc load_hotfile {tsc hotfile cpu} {
    # Check if module already loaded.
    # If it is, then done. If it isn't, load it.
    # Count number of modules registered
    if [catch {
	array set result [$tsc ModuleCheckCount]
    } cresult] {
	log "ModuleCheckCount failed. Verify that your configuration only includes PDK/R2MF boards."
	dprint $cresult
	exit_fail
    }	

    set NumRegister [format %d $result(RegisterCount)]
    set MaxModules [format %d $result(MaxModules)]

    dprint "load_hotfile Start"
    dprint "$NumRegister of $MaxModules reported registered."
    dprint "Checking if module $hotfile already loaded."

    # Search for our module among registered
    set modname [file tail [file rootname $hotfile]]
    for {set ndx 0} {$ndx < $NumRegister} {incr ndx} {
	array set result [$tsc ModuleCheckStatus -Id $ndx]
	if ![string compare $modname $result(ModName)] {
	    # module found.
	    dprint " Found module already registered as index $ndx."
	    break
	}
    }

    if {$ndx >= $NumRegister} then {
	# module not registered.
	dprint "Module not yet registered."
	if [catch {
	    array set modInfo [hot_register $tsc $modname $cpu]
	} cresult] {
	    dprint $cresult
	    log "Error occurred when trying to register protocol."
	    exit_fail
	}
	set ndx $modInfo(ndx)
	array set result [$tsc ModuleCheckStatus -Id $ndx]
    }

    # Check state of module
    if {$result(state) == 0x1} then {
	dprint " Module $modname needs to be downloaded."
	if [catch {
	    hot_load $tsc $modname $ndx $result(LocateAddress) $cpu
	} cresult ] {
	    dprint $cresult
	    log "Error occurred when trying to load protocol."
	    exit_fail
	}
	dprint " Module $modname now needs to be started."
	hot_start $tsc $ndx
    } elseif {$result(state) == 0x2} then {
	dprint " Another process is downloading so abort."
	log "Another process is currently downloading this module."
	exit_warning
    } elseif {$result(state) == 0x3} then {
	dprint " Module needs to be started."
	hot_start $tsc $ndx
    } elseif {$result(state) == 0x4} then {
	dprint " Module already started so done."
    } elseif {$result(state) == 0x5} then {
	dprint " Another process is unloading so abort."
	log "Another process is currently unloading this module."
	exit_fail
    } else {
	dprint " Shoudln't be here. Error."
	log "Module is in an unknown state $result(state)."
	exit_fail
    }
}

proc load_variantdata {tsc cas tgen sigdet cdpfile variantname boardnum} {
    global cfgpath datapath

    include pdkdefs.qs
    include sd_defs.qs
    include tgendefs.qs

    set MaxVariants 32
    dprint "load_variantdata Start"
    dprint "Checking if variantdata already loaded"

    set vdfname [file tail [file rootname $cdpfile]]

    # Search to see if variant already loaded.

    if {[string length $variantname] > 8} {
	log "Warning: variant name will be truncated to 8 characters.\n"
    }

    set name_1 [gen_crc32 $vdfname [string length $vdfname]]
    dprint "Searching for $name_1"

    set emptyVariant 0
    # until unloading is supported, grab the first empty slot
    # if variant not found before then. Because we're loading
    # sequentially and we can't delete variants yet, first empty slot
    # marks end of all variants
    for {set ndx 1} {$ndx <= $MaxVariants} {incr ndx} {
	if [catch {
	    array set result [$tsc GetxParms -Parms [list \
		    [list Parm $CHP_VParm_VariantId Val $ndx]\
		    [list Parm $CHP_VParm_VariantFormat Val 4]\
		    [list Parm $CHP_PDK_VParm_Name_1]]]
	}] then {
	    # variant wasn't defined. Mark to be used if variant
	    # isn't loaded.
	    if {$emptyVariant == 0} then {
		set emptyVariant $ndx
		break;
	    }
	} else {
	    # variant was defined
	    array set res1 [lindex $result(Parms) 2]
	    if {($res1(Val) == $name_1)} {
		# variant found.
		dprint " Found variant already downloaded as index $ndx."
		break
	    }
	}
    }

    if {$emptyVariant != 0} then {
	# variant not yet defined.
	set cdpfile $vdfname.cdp
	cd $cfgpath
	dprint "Variant not yet registered. Loading into $emptyVariant."
	dprint [pwd]
	dprint "    exec cdpparser -cdpFile $cdpfile -hotload -variantId $emptyVariant \
		    -maxMsgSize 1500 -board $boardnum"
	if [catch {
	    exec cdpparser -cdpFile $cdpfile -hotload -variantId $emptyVariant \
		    -maxMsgSize 1500 -board $boardnum
	    source $vdfname.$boardnum.pdkconfig
	} cresult ] {
	    dprint $cresult
	    log "cdpparser call failed. Check that all necessary .cdp .map .qs files "
	    log "are present and correct."
	    exit_fail
	}
	cd $datapath
	return $emptyVariant
    } else {
	return $ndx
    }
}

proc set_variant {boardnum} {
    global parms switches lineinfo
    global qscript_path 
    global  CHP_VParm_VariantId \
	    CHP_VParm_VariantFormat \
	    CHP_PDK_VParm_Name_1 \
	    Std_ComponentType \
	    TSC_Std_ComponentType \
	    TSC_AttrLineId \
	    TSC_AttrChanId \
	    TSC_ParmOutboundVariantId \
	    TSC_ParmInboundVariantId \
	    Std_MsgSetParmCmplt

    #for board $boardnum, set lines and channels to parms(-setvariant)
    #If parms(-setvariant) is a number, then check that variant is defined
    #and set.
    #If parms(-setvariant) is a file, then load/define and set.

    dprint "Entering setvariant board $boardnum"
    if [catch {
        set board [Board new -init [list -BoardNum $boardnum]]
        set tsc [$board findComp -CompClass TSCComponent]
    } result ] {
        log "Board $boardnum is not downloaded. Unable to hotload variant."
        dprint $result
	return -1
    }

    set isnumber 1
    foreach {digit} [split $parms(-setvariant) {}] {
	if ![string match {[0-9]} $digit] {
	    set isnumber 0
	    break
	}
    }

    if {$isnumber == 0} {
	dprint "Filename specified."
	set variantnum [load_variant $boardnum $parms(-setvariant)]
    } else {
	dprint "Variant digit specified."
	#verify that variant is loaded  unless variant 0
	set variantnum $parms(-setvariant)
	if {$variantnum == 0} {
	    dprint "Variant 0"
	} elseif [catch {
	    array set result [$tsc GetxParms -Parms [list \
		    [list Parm $CHP_VParm_VariantId Val $variantnum]\
		    [list Parm $CHP_VParm_VariantFormat Val 4]\
		    [list Parm $CHP_PDK_VParm_Name_1]\
		    ]]
	}] then {
	    #variant wasn't loaded
	    log "Error: Variant $variantnum was not defined.\n"
	    log "Aborting.\n"
	    exit_fail
	} else {
	    #variant was loaded so continue
	    dprint "Variant $variantnum was present"
	}
    }
    if {$variantnum < 0} {
	dprint "Variant wasn't loaded, exiting set_variant."
	return
    }
    # proceed with setting channels
    if {$parms(-line) == 0} then {
	log "Default setting all lines not available yet.\n"
	exit_fail
    }
    global tcl_platform
    switch $tcl_platform(platform) {
        windows {
          if [info exists switches(-inservice)] then {
	       set inservice 1
    	    } else {
	       set inservice 0
    	    }
          set setparm \"[file join $qscript_path setparm]\"
          set sphandle [open "|$setparm $parms(-board) $inservice" r+]
          foreach {l} $parms(-line) {
	      dprint "Setting line $l"
            set chanlist {}
	      if {$parms(-chan) == 0} then {
	        for {set c 1} {$c <= $lineinfo(line,$l)} {incr c} {
	          puts $sphandle "s $l $c $variantnum"
	        }
	      } else {
              foreach {c} $parms(-chan) {
                puts $sphandle "s $l $c $variantnum"
	        }
	      }
          }
          puts $sphandle "e"
          flush $sphandle
          while {![eof $sphandle]} {
	      dprint [gets $sphandle]
          }
        }
        default {
	    foreach {l} $parms(-line) {
	      dprint "Setting line $l"
	      set c 1
	      set clust [$board findClust -Attrs [list \
		          [list -key $Std_ComponentType \
		          -value $TSC_Std_ComponentType] \
		          [list -key $TSC_AttrLineId -value $l] \
		          [list -key $TSC_AttrChanId -value $c] ] ]
	      set ins [$clust find -InstClass TSC]
	      $ins SetErrorWait 0
	      set oldInstance [$ins GetInstance]
	      if {$parms(-chan) == 0} then {
		  for {set c 1} {$c <= $lineinfo(line,$l)} {incr c} {
		    $ins SetInstance [expr $oldInstance + $c - 1]
		    $ins SetParm -Val $variantnum \
		       -Parm $TSC_ParmOutboundVariantId
		    $ins SetParm -Val $variantnum \
		       -Parm $TSC_ParmInboundVariantId
		    if [info exists switches(-inservice)] then {
                  $ins SetChanState -State 0x100
			if {$l > 2} then {
                    $ins SetChanState -State 0x101
                    $ins SetChanState -State 0x100
                  }
		    }
		  }
	      } else {
		  foreach {c} $parms(-chan) {
		    $ins SetInstance [expr $oldInstance + $c - 1]
		    $ins SetParmAsync -Val $variantnum \
			-Parm $TSC_ParmOutboundVariantId
		    $ins SetParmAsync -Val $variantnum \
			-Parm $TSC_ParmInboundVariantId
		  }
	      }
	      $ins SetInstance $oldInstance
	      $ins destroy
	    }
        }
    }
}

proc handleAsyncCmplt {obj msgType data} {
    log "."
}

if [catch {main} cresult] {
    log "Unhandled error in main loop:"
    log $cresult
    exit_fail
}


