# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

array set check [CheckParms -Proc SignalEditor.qs -Provided $argv_clean -Required {-board} -Optional {-signalId}]
array set parms $check(Flags)
set boardnum $parms(-board)

if [info exists parms(-signalId)] {
    set signalId $parms(-signalId)
}

wm title . "DM3 CAS Signal Editor - Board $boardnum"

source ${qscript_library}/CASComponent_Class.qs

array set curr_def {}
set sigtype -1


set sigtypelist [list \
		     $CAS_SignalType_Transition \
		     $CAS_SignalType_Pulse \
		     $CAS_SignalType_Train \
		     $CAS_SignalType_Sequence \
		     ]

array set sigtypename [list \
			   $CAS_SignalType_Transition Trans \
			   $CAS_SignalType_Pulse Pulse \
			   $CAS_SignalType_Train Train \
			   $CAS_SignalType_Sequence Sequence \
			  ]

array set sigtypedefs [list \
			   $CAS_SignalType_Transition $CAS_Transition_t \
			   $CAS_SignalType_Pulse $CAS_Pulse_t \
			   $CAS_SignalType_Train $CAS_Train_t \
			   $CAS_SignalType_Sequence $CAS_Sequence_t \
			  ]


proc refresh_sigdef_display {{new_def {}} {new_sigtype force}} {
    global sigtype curr_def sigtypedefs


    set f .sigdef.def

    if {$new_sigtype == "force" || [expr $new_sigtype != $sigtype]} {
	destroy $f
	frame $f
    }


    unset curr_def

    if {$new_def == {}} {
	array set curr_def $sigtypedefs($sigtype)
	#make blank
	foreach field [array names curr_def] {
	    set curr_def($field) {}
	}    
    } else {
	array set curr_def $new_def
    }

    set maxwidth 0

    set names [lsort [array names curr_def]]


    foreach field $names {
	#convert interval entries to decimal
	if {[string first "Interval" $field] !=-1} {
	    #interval field
	    catch {set curr_def($field) [format "%d" $curr_def($field)]}
	}

	#check if string name is largest
	if [expr [string length $field] > $maxwidth] {
	    set maxwidth [string length $field]
	}
    }

    #update display field layout only if needed
    if {$new_sigtype == "force" || [expr $new_sigtype != $sigtype]} {
	foreach field $names {
	    frame $f.line_$field
	
	    set b $f.line_$field



	    label $b.l_$field -text $field -width $maxwidth -anchor e
	    entry $b.e_$field -textvariable curr_def($field)


	    pack $b.l_$field -side left
	    pack $b.e_$field -expand true -fill x

	    pack $b -anchor e -expand true -fill x
	}

    pack $f -expand true -fill x
    }

    if {$new_sigtype != "force"} {
	set sigtype $new_sigtype
    }


}

proc def_get {} {
    global cas signalId  curr_def

    array set retval [$cas GetSignalDefinition -SignalId $signalId]

    set signalId $retval(SignalId)

    refresh_sigdef_display $retval(SignalDefinition) $retval(SignalType)
    
    
}

proc def_define {} {
    global cas signalId sigtype curr_def

    $cas DefineSignal -SignalId $signalId -SignalType $sigtype -SignalDefinition [array get curr_def]
    
}

proc def_redefine {} {
    global cas signalId sigtype curr_def

    $cas RedefineSignal -SignalId $signalId -SignalType $sigtype -SignalDefinition [array get curr_def]
    
}

proc def_delete {} {
    global cas signalId

    $cas DeleteSignal -SignalId $signalId
}



#definition display setup
frame .sigdef
frame .sigdef.def

pack .sigdef.def

#refresh_sigdef_display {} 1

#sigtype display setup
frame .sigtype

set f .sigtype

foreach st $sigtypelist {

    radiobutton $f.sig_$st -text $sigtypename($st) \
	-variable sigtype -value $st -command {refresh_sigdef_display}

    pack $f.sig_$st -side left
}

#control display setup
frame .control

set f .control

label $f.l_id -text "SignId"
entry $f.e_id -textvariable signalId
button $f.b_get -text "Get" -command def_get
button $f.b_define -text "Define" -command def_define
button $f.b_redefine -text "Redefine" -command def_redefine
button $f.b_delete -text "Delete" -command def_delete
button $f.b_enable -text "Enable" -command sig_enable
button $f.b_disable -text "Disable" -command sig_disable

pack $f.l_id -side left
pack $f.e_id -side left
pack $f.b_get -side left
pack $f.b_define -side left
pack $f.b_redefine -side left
pack $f.b_delete -side left


#pack main displays

pack .sigdef -expand true -fill x
pack .sigtype
pack .control


#refresh_sigdef_display {} 1


#find resources

set board [Board new -init [list -BoardNum $boardnum]]
set cas [$board findComp -CompClass CASComponent]


if [info exists signalId] {
    def_get
}





