# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

cd $qscript_path
source ${qscript_library}/TSC_Class.qs
source ${qscript_library}/ToneGen_Class.qs
source ${qscript_library}/CHPComponent_Class.qs
source ${qscript_library}/qsie.qs
source ${qscript_library}/isdnmsgs.qs
source tscdefs_ext.qs

#parse command line arguments
if [catch {array set check [CheckParms -Proc callinfo.qs -Provided $argv_clean -Required {-board} \
	       -Optional {-line -chan}]} result ] {
    puts stderr $result
    return
}

array set argvarr $argv_clean

set dialogic_font -*-*-bold-r-normal-*-16-*-*-*-*-*-*-*
set dialogic_color blue

proc qsLoadGeometry { winName win } {
	global env

	if [info exists env(QSCRIPT_GEOMETRY)] {
		# See if a location file exists
		if [file exists $env(QSCRIPT_GEOMETRY)/$winName.loc] {
			# Read window geometry and enact on root window
			if [catch {open $env(QSCRIPT_GEOMETRY)/$winName.loc r } fileId] {
				puts stderr "Unable open $env(QSCRIPT_GEOMETRY)/$winName.loc: $fileId"
				puts stderr "Window position not loaded - using default"
			} else {
				# load the geometry
				wm geometry $win [read -nonewline $fileId]
				close $fileId
			}
		}
	}
}

proc qsSaveGeometry { winName win } {
	global env

	if [info exists env(QSCRIPT_GEOMETRY)] {
		# Write widget name and location
		if [catch {open $env(QSCRIPT_GEOMETRY)/$winName.loc w } fileId] {
			puts stderr "Unable to create $env(QSCRIPT_GEOMETRY)/$winName.loc: $fileId"
			puts stderr "Window position not saved."
		} else {
			# save the geometry
			scan [wm geometry $win] {%[0-9x]%[+\-0-9]} width pos
			puts -nonewline $fileId $pos
			close $fileId
		}
	}
}

proc quit { } {
	global boardnum line chan
	# Record location
	qsSaveGeometry callinfo$boardnum$line$chan .

	exit
}

#async event handlers

proc handleCallInfoSet { this type evt } {
	global tsc callInfo TSC_CallInfo_State_Unavailable 

	array set msg $evt

#	puts stdout "CallId $msg(CallId)"
#	puts stdout "Count $msg(Count)"

	foreach item $msg(CallInfo) {
		array set info $item 
		if { $info(State) == $TSC_CallInfo_State_Unavailable } { 
			set callInfo($info(InfoId)) {Not Available}
		} else {
			set callInfo($info(InfoId)) $info(Value)
		}
	}
}

proc handleIESet { this type evt } {
	global tsc callInfo TSC_CallInfo_State_Unavailable 
	global isdn_ie_name isdn_message_name

	array set msg $evt

#	puts stdout "Got IESet from Msg $isdn_message_name($msg(MessageType))"

	set ieList {}
	foreach ieInfo $msg(Data) {
		array set ie $ieInfo
		if { $ie(Value) == {} } {
			set callInfo($ie(IEId)) "Single byte IE"
		} else {
			set callInfo($ie(IEId)) $ie(Value)
		}
	}

}

proc handleIsdnMsgSet { this type evt } {
	global tsc callInfo TSC_CallInfo_State_Unavailable 
	global isdn_ie_name isdn_message_name

	array set msg $evt

	puts stdout "Got ISDNMsg $isdn_message_name($msg(MessageType))"

	set ieList {}
	foreach ieInfo $msg(Data) {
		array set ie $ieInfo
		lappend ieList "$isdn_ie_name($ie(IEId)) $ie(Value)"
	}

	if { $ieList == {} } {
		set callInfo($msg(MessageType)) "No Info Elements"
	} else {
		set callInfo($msg(MessageType)) $ieList
	}
}

# Enable event detection
proc detectEvt { } {
	global evtIds tsc selectedEvtType

	if { $selectedEvtType == "CallInfoSet" } {
		set prefix CIDV_
	} else {
		set prefix ""
	}

	foreach id $evtIds {
		global $prefix$id
		set idList [lappend idList [set $prefix$id]]
	}

	showIds $prefix $evtIds

	global menu_SelectEvt menu_DetectEvt menu_CancelEvt
	.menu_action entryconfigure $menu_SelectEvt -state disabled
	.menu_action entryconfigure $menu_DetectEvt -state disabled
	.menu_action entryconfigure $menu_CancelEvt -state normal

	global TSC_EvtCallInfoSet_Type_$selectedEvtType
	$tsc DetectEvtSet -EvtType [set TSC_EvtCallInfoSet_Type_$selectedEvtType] \
			-EvtGroup [set TSC_EvtCallInfoSet_Type_$selectedEvtType] -Set $idList
}

#**********************************************************************
# PROCEDURE:	cancelEvt()
# DESCRIPTION:	Disable event detection.  This procedure disables the
#					the currently enabled TSC_EvtCallInfoSet event.
#					The procedure also clears the values of the info 
#					identifiers that the event was enabled to report.
# GLOBALS:		tsc 					- the tsc instance to cancel the event on
#					evtIds				- the current list of event info ids
#					callInfo 			- info values
#					selectedEvtType	- current event type
# RETURNS:		none
#**********************************************************************
proc cancelEvt { } {
	global tsc evtIds callInfo selectedEvtType

	pack forget .id.list
	destroy .id.list

	if { $selectedEvtType == "CallInfoSet" } {
		set prefix CIDV_
	} else {
		set prefix ""
	}

	global menu_SelectEvt menu_DetectEvt menu_CancelEvt
	.menu_action entryconfigure $menu_SelectEvt -state normal
	.menu_action entryconfigure $menu_DetectEvt -state normal
	.menu_action entryconfigure $menu_CancelEvt -state disabled

	global TSC_EvtCallInfoSet_Type_$selectedEvtType
	$tsc CancelEvt -EvtType [set TSC_EvtCallInfoSet_Type_$selectedEvtType]

	# Clear call info values

	foreach id $evtIds {
		global $prefix$id

		# Clear info value
		set callInfo([set $prefix$id]) { }
	}

}

proc addId { id } {
	global evtIds

	set ind [lsearch -exact $evtIds $id]

	if { $ind != -1 } {
		# item is already in list, so delete it first 
		set evtIds [lreplace $evtIds $ind $ind]
	}

	# Add identifier to id list
	lappend evtIds $id
}

proc showIds { prefix evtIds } {

	frame .id.list

	foreach id $evtIds {

		set item $prefix$id

		global $item

		# Clear info value
		set callInfo($item) { }

		# Add value field
		set field .id.list.f_$id
		frame $field
		label $field.label_$id -text $id -width 20
		entry $field.entry_$id -textvar callInfo([set $item]) -width 40 -state disabled
		pack $field.label_$id -side left
		pack $field.entry_$id -side left -expand true -fill x
		pack $field -side top -expand true -fill x
	}

	pack .id.list -expand true -fill x
}

proc selectExit { } {
	global evtIds idList selectedEvtType menu_CancelEvt menu_DetectEvt

	set evtIds { }

	# Get the selection list
	set idList($selectedEvtType,selection) [.idlist.list curselection]

	# Set the event ids from the selection list
	foreach item $idList($selectedEvtType,selection) {
		lappend evtIds [.idlist.list get $item]
	}

	.menu_action entryconfigure $menu_DetectEvt -state normal

	# Record location
	global boardnum line chan
	qsSaveGeometry callinfo$boardnum$line$chan.select .idlist

	destroy .idlist
}

proc selectItem { list index } {
	
	set selindex [$list nearest $index]
	set item [$list get $selindex]
	puts stdout "Selected $list at $index, item $selindex, $item"
}

proc selectEvt { evtType } {
	global idList selectedEvtType

	set selectedEvtType $evtType

	toplevel .idlist

	global boardnum line chan
	qsLoadGeometry callinfo$boardnum$line$chan.select .idlist

	wm title .idlist $evtType
	wm protocol .idlist WM_DELETE_WINDOW selectExit

	listbox .idlist.list -selectmode multiple -setgrid true \
				-yscrollcommand {.idlist.yscroll set} \
				-selectforeground white -selectbackground black
	scrollbar .idlist.yscroll -command {.idlist.list yview}
	foreach item $idList($evtType,list) {
		.idlist.list insert end $item
	}

	# fill in current selection 
	foreach item $idList($evtType,selection) {
		.idlist.list selection set $item
	}

#	bind .idlist.list <ButtonRelease-1> { selectItem %W %y }

	pack .idlist.yscroll -side right -fill y
	pack .idlist.list -expand true -fill y
}

#Draw Screen

frame .display
label .display.label_ids -text { Identifiers } -width 20
entry .display.entry_ids -textvar evtIds -width 40
pack .display.label_ids -side left
pack .display.entry_ids -side left -expand true -fill x
pack .display -side top -expand true -fill x

frame .id
pack .id -side top -expand true -fill x

# Create select menu
menu .menu_select -tearoff false
.menu_select add command -label CallInfoSet -command { selectEvt CallInfoSet }
.menu_select add command -label IESet -command { selectEvt IESet }
.menu_select add command -label ISDNMsgSet -command { selectEvt ISDNMsgSet }

# Create action menu
menu .menu_action -tearoff false
.menu_action add cascade -label { Select Ids } -menu .menu_select
set menu_SelectEvt 0
set index 1
foreach {item cmd} { DetectEvt detectEvt CancelEvt cancelEvt Exit quit } {
	.menu_action add command -label $item -command $cmd
	set menu_$item $index
	incr index
}
unset index

# Add action menu to menu bar
menu .menubar  -tearoff false
.menubar add cascade -label Action -menu .menu_action

# Add menu bar to top of window
. config -menu .menubar

.menu_action entryconfigure $menu_DetectEvt -state disabled
.menu_action entryconfigure $menu_CancelEvt -state disabled

#frame .control
#button .control.b_detect -text DetectEvt -command detectEvt -width 20
#button .control.b_cancel -text CancelEvt -command cancelEvt -width 20
#pack .control.b_detect -side left
#pack .control.b_cancel -side left

#pack .control -side top

menu .menu_ids -tearoff false
foreach item $call_info_name_list {
	set $item [menu .menu_ids.id_$item]
	.menu_ids add command -label $item -command "addId $item"
}

bind .display.entry_ids <ButtonPress-3> { tk_popup .menu_ids %X %Y }

wm protocol . WM_DELETE_WINDOW quit

#main
#default values
set line 1
set chan 1

#command line arguments
set boardnum $argvarr(-board)

if [info exists argvarr(-line)] {set line $argvarr(-line)}
if [info exists argvarr(-chan)] {set chan $argvarr(-chan)}

# restore last geometry if available
qsLoadGeometry callinfo$boardnum$line$chan .

wm title . [list DM3 CallInfo $boardnum.$line.$chan]

#find cluster
set board [Board new -init [list -BoardNum $boardnum]]

set clust [$board findClust -Attrs [list \
			 [list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
					[list -key $TSC_AttrLineId -value $line] \
					[list -key $TSC_AttrChanId -value $chan] ] ]


#allocate or get instances in cluster
set tsc [$clust find -InstClass TSC]

#enable call info callbacks
$tsc asyncRegister -EvtGroup $TSC_EvtCallInfoSet_Type_CallInfoSet -Proc handleCallInfoSet

$tsc asyncRegister -EvtGroup $TSC_EvtCallInfoSet_Type_IESet -Proc handleIESet
$tsc asyncRegister -EvtGroup $TSC_EvtCallInfoSet_Type_ISDNMsgSet -Proc handleIsdnMsgSet

set idList(CallInfoSet,list) $call_info_name_list
set idList(CallInfoSet,selection) { }
set idList(IESet,list) $isdn_ie_name_list
set idList(IESet,selection) { }
set idList(ISDNMsgSet,list) $isdn_message_name_list
set idList(ISDNMsgSet,selection) { }
  
#refresh

