# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#**********************************************************************
# NAME:			buildLedStatus { root rows labels alarms }
# DESCRIPTION: Build led status display for each line in rows to show
#					the status of each alarm in alarms
# INPUTS:		root		- frame to build status display in
#					rows		- rows and lines to display
#					labels	- Labels to use for each alarm
#					alarms	- Alarms to display for each line
#**********************************************************************
proc buildLedStatus { root rows labels alarms } {
	global $root line alarms_name alarm_state qscript_path
	global alarmLed

	global LineAlarm_Inactive LineAlarm_Active

	set row 1
	foreach alarmRow $rows {
		frame $root.row$row
		
		# Add alarm labels
		set cfa $root.row$row.cfa_names
		frame $cfa
		foreach alarm $labels {
			label $cfa.cfa_$alarm -text $alarm -width 10 -anchor e
			pack $cfa.cfa_$alarm -side top -expand true -fill y
		}
		pack $cfa -side left -anchor w -expand true -fill y

		foreach linenum $alarmRow {
			set ls $root.row$row.line$linenum
			# Record line
			set line($linenum,$root) $ls

			# Get line admin object
			set lad $line($linenum,lad)

			frame $ls -relief groove -border 3

			label $ls.line -text $linenum -anchor w
			pack $ls.line -side top -anchor w -padx 3 -expand true -fill y

			foreach alarm $alarms {
				set cfa $ls.cfa_$alarms_name($alarm)
				label $cfa -bitmap @${qscript_path}/led.xbm

				set alarmLed($lad,$alarm) $cfa
				trace variable alarm_state($lad,$alarm) w updateAlarmLed


				pack $cfa -side top -expand true -fill y
			}
			pack $ls -side left -expand true -fill y
		}
		pack $root.row$row -side top
		incr row
	}

}

proc updateAlarmLed { varName index op } {
	global alarmLed alarmOnColor alarmOffColor alarm_state
	global LineAlarm_Active

	upvar $varName var

	# Get alarm name
	set alarm [lindex [split $index ,] 1]

	if {$alarm_state($index) == $LineAlarm_Active} {
		$alarmLed($index) configure -foreground $alarmOnColor($alarm)
	} else {
		$alarmLed($index) configure -foreground $alarmOffColor($alarm)
	}
}

proc updateAlarmTx { varName index op } {
	global alarmLed alarmOnColor alarmOffColor alarm_state
	global LineAlarm_Active alarmLedCommand

	upvar $varName var

	# Get alarm name
	set alarm [lindex [split $index ,] 1]

	if {$alarm_state($index) == $LineAlarm_Active} {
		$alarmLed($index) configure -selectcolor $alarmOnColor($alarm)
	} else {
		$alarmLed($index) configure -selectcolor $alarmOffColor($alarm)
	}
}



#**********************************************************************
# NAME:			buildTx { root rows labels alarms }
# DESCRIPTION: Build contol display for sending alarms
# INPUTS:		root		- frame to build status display in
#					rows		- rows and lines to display
#					labels	- Labels to use for each alarm
#					alarms	- Alarms to control for each line
#**********************************************************************
proc buildTx { root rows labels alarms } {
	global $root line alarms_name  alarm_state

	global LineAlarm_Inactive LineAlarm_Active
	global alarmLed alarmOnColor alarmOffColor

	global tcl_platform

	set row 1
	foreach alarmRow $rows {
		frame $root.row$row
		
		# Add alarm labels
		set cfa $root.row$row.cfa_names
		frame $cfa
		foreach alarm $labels {
			label $cfa.cfa_$alarm -text $alarm -width 10 -anchor e -pady 0
			pack $cfa.cfa_$alarm -side top -expand true -fill y -pady 0
		}
		pack $cfa -side left -anchor w -expand true -fill y

		foreach linenum $alarmRow {
			set ls $root.row$row.line$linenum
			# Record line
			set line($linenum,$root) $ls

			# Get line admin object
			set lad $line($linenum,lad)

			frame $ls

			label $ls.line -text $linenum -anchor w -pady 0
			pack $ls.line -side top 

			foreach alarm $alarms {
				set cfa $ls.cfa_$alarms_name($alarm)

				if { [string compare $tcl_platform(platform) windows] == 0 } {
					# No color for windows - uses "tick" mark
					checkbutton $cfa \
						-offvalue $LineAlarm_Inactive -onvalue $LineAlarm_Active \
						-variable alarm_state($lad,$alarm) -pady 0 \
						-command [list updateAlarm $lad $alarm]

						set alarmOffColor($alarm) white

						set alarmLed($lad,$alarm) $cfa
						trace variable alarm_state($lad,$alarm) w updateAlarmTx
				} else {
					checkbutton $cfa \
						-offvalue $LineAlarm_Inactive -onvalue $LineAlarm_Active \
						-variable alarm_state($lad,$alarm) -selectcolor $alarmOnColor($alarm) \
						-command [list updateAlarm $lad $alarm]
				}

					pack $cfa -side top
			}
			pack $ls -side left -expand true -fill y
		}
		pack $root.row$row -side top -anchor n -expand true -fill y
		incr row
	}

}

#**********************************************************************
# NAME:			buildLineState { root rows labels alarms }
# DESCRIPTION: Build LineState status and control frame
# INPUTS:		root		- frame to build status display in
#					rows		- rows and lines to display
#					labels	- Labels to use for each line state
#					alarms	- state to control for each line
#**********************************************************************
proc buildLineState { root rows } {
	global $root line 

	global LineState_InService LineState_OutOfService

	frame $root.label
	label $root.label.l2 -text "Line In/OutService" -anchor w
	pack $root.label.l2 -side top -anchor w
	pack $root.label -side left -anchor w

	set row 1
	foreach stateRow $rows {
		frame $root.row$row
		foreach linenum $stateRow {
			set ls $root.row$row.line$linenum
			# Record line
			set line($linenum,$root) $ls
		
			# Get line admin object
			set lad $line($linenum,lad)

			frame $ls

			label $ls.line -text $linenum -anchor w
			pack $ls.line -side top

			checkbutton $ls.linestate \
				-offvalue $LineState_OutOfService \
				-onvalue $LineState_InService -selectcolor green \
				-variable line($lad,linestate) \
			   -command [list updateLineState $lad]

			pack $ls.linestate -side top
			pack $ls -side left
		}
		pack $root.row$row -side top
		incr row
	}

}


#**********************************************************************
# NAME:			buildLineState { root rows labels alarms }
# DESCRIPTION: Build LineState status and control frame
# INPUTS:		root		- frame to build status display in
#					rows		- rows and lines to display
#					labels	- Labels to use for each line state
#					alarms	- state to control for each line
#**********************************************************************
proc buildLineState2 { root linenums } {
	global $root line
	global LineState_InService LineState_OutOfService
	frame $root.label
	label $root.label.l2 -text "Line InService" -anchor w
	pack $root.label.l2 -side top -anchor w
	pack $root.label -side left -anchor w
	foreach linenum $linenums {
		set ls $root.line$linenum
		frame $ls
		# Record line
		set line($linenum,$root) $ls.state
	
		# Get line admin object
		set lad $line($linenum,lad)
		checkbutton $ls.state \
				-offvalue $LineState_OutOfService \
				-onvalue $LineState_InService -selectcolor green \
				-variable line($lad,linestate) \
				-anchor w -text $linenum -padx 3 \
			   -command [list updateLineState $lad $ls.state]

		pack $ls.state -side top -anchor n
		pack $ls -side left -anchor w -padx 2
	}
}

