# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

cd $qscript_path
source ${qscript_library}/TSC_Class.qs
source ${qscript_library}/ToneGen_Class.qs
source ${qscript_library}/CHPComponent_Class.qs
source ${qscript_library}/qsie.qs
source ${qscript_library}/isdnmsgs.qs
source tscdefs_ext.qs
source isdn_ext.qs

#make sure the ccs class has been loaded
catch {CCS}

#parse command line arguments
if [catch {array set check [CheckParms -Proc phone.qs -Provided $argv_clean -Required {-board} \
	       -Optional {-line -chan} -Switches {-log}]} result ] {
    puts stderr $result
    return
}
array set argvarr $check(Flags)

#default values
set line 1
set chan 1

#command line arguments
set boardnum $argvarr(-board)

if [info exists argvarr(-line)] {set line $argvarr(-line)}
if [info exists argvarr(-chan)] {set chan $argvarr(-chan)}
if [expr [lsearch -exact $check(Switches) {-log}] == -1] {
    #switch not supplied, don't show the log
    set showLog 0
} else {
    set showLog 1
}

set r4Mode 0
set isdnMode 0
set showLog 0

set dialogic_font -*-*-bold-r-normal-*-16-*-*-*-*-*-*-*
set dialogic_color blue


proc quit { } {
    exit
}


proc change_buttons { new } {
    global current_buttons var_All_CC

    if {$var_All_CC == 1} {
	set new All_CC
    }

    if [info exists current_buttons] {
	pack forget .control.callcontrol.op.state_$current_buttons
    }
    pack .control.callcontrol.op.state_$new

    set current_buttons $new
}


# Enable event detection
proc detectEvt { evtType } {
	global tsc isdn_message_name_list 

        set selectedEvtType $evtType 
        global  TSC_EvtCallInfoSet_Type_$selectedEvtType TSC_EvtCallInfo_Type_$selectedEvtType
        
        if { $selectedEvtType == "ISDNMsgSet" } {
            foreach id $isdn_message_name_list {
                global $id
                set idList [lappend idList [set $id]]
            }
            $tsc DetectEvtSet -EvtType [set TSC_EvtCallInfoSet_Type_$selectedEvtType] \
	              -EvtGroup [set TSC_EvtCallInfoSet_Type_$selectedEvtType] -Set $idList

        } else {
            $tsc DetectEvt -EvtType [set TSC_EvtCallInfo_Type_$selectedEvtType] \
                 -EvtGroup [set TSC_EvtCallInfo_Type_$selectedEvtType]
        }
        
        logString "$selectedEvtType events enabled. \n"
}

# Disable event detection.
proc cancelEvt { evtType } {
	global tsc callInfo selectedEvtType

        set selectedEvtType $evtType
        if { $selectedEvtType == "ISDNMsgSet" } {
            global TSC_EvtCallInfoSet_Type_$selectedEvtType

            $tsc CancelEvt -EvtType [set TSC_EvtCallInfoSet_Type_$selectedEvtType]
        } else {
           global TSC_EvtCallInfo_Type_$selectedEvtType  

           $tsc CancelEvt -EvtType [set TSC_EvtCallInfo_Type_$selectedEvtType]
        }

        logString "$selectedEvtType events disabled. \n"
}


#async event handlers
proc handle_StateChange { this type evt } {
    global var_CallId var_CallState var_Reason call_state_names call_state_reason_name

    array set change $evt

  #  pack forget .control.callcontrol.op.state_$var_CallState

    set var_CallId $change(CallId)
    set var_CallState $call_state_names($change(CallState))
    set var_Reason [getCallStateReason $change(Reason)]

#    pack .control.callcontrol.op.state_$var_CallState

    change_buttons $var_CallState

    if {$var_CallState == "Idle" || $var_CallState=="Null" } {
	global var_ANI var_DNIS
	set var_ANI ""
	set var_DNIS ""
        logString "Call state set to $var_CallState\(CallId:$var_CallId, Reason:$var_Reason)\n"
    } else {
        logString "Call $var_CallState\(CallId:$var_CallId, Reason:$var_Reason)\n"
    }
}

proc handle_ChanStateChange { this type evt } {
    global var_ChanState chan_state_name

    array set change $evt

    set var_ChanState $chan_state_name($change(ChanState))
    
    if { $var_ChanState == "OutOfServiceLocal" } {
        logString "Channel put Out of Service ($var_ChanState) \n"
    } elseif { $var_ChanState == "OutOfService" } {
        logString "Line put Out of Service ($var_ChanState) \n"
    } else {
        logString "Channel state set to $var_ChanState \n"
    }
}

proc handle_InfoEvents { this type evt } {
    global tsc var_CallId TSC_EvtCallInfo_Type_CalledId TSC_EvtCallInfo_Type_CallerId \
	TSC_EvtCallInfoSet_Type_CallInfoSet var_ANI var_DNIS call_info_names call_infoset_names \
	call_analysis_names TSC_EvtCallInfo_Type_CallAnalysis

    #puts $evt
    array set info $evt
    
    if { $info(Type) == $TSC_EvtCallInfoSet_Type_CallInfoSet } {
      set var_CallInfo $call_infoset_names($info(Type))
      foreach element $info(CallInfo) {
         array set var_callInfoType $element
      }
      logString "$var_CallInfo: $call_analysis_names($var_callInfoType(Value)) \n"
    } else {
      set var_CallInfo $call_info_names($info(Type))
    }
    
    if { $info(Type) == $TSC_EvtCallInfo_Type_CalledId } {
      set var_DNIS $info(Value)
      logString "$var_CallInfo: $info(Value) \n"
	
    }
    if { $info(Type) == $TSC_EvtCallInfo_Type_CallerId } {
      set var_ANI $info(Value)
      logString "$var_CallInfo: $info(Value) \n"
    }
    
    if { $info(Type) == $TSC_EvtCallInfo_Type_CallAnalysis } {
      logString "$var_CallInfo: $call_analysis_names($info(Value)) \n"
    }

}

proc handle_ISDNEvents { this type evt } {
    global tsc isdn_message_name isdn_ie_names isdn_message_name_list isdn_ie_name_list 

    #puts $evt
    array set isdnMsg $evt

    set ieList {}
    foreach ie $isdnMsg(Data) {
        array set ieInfo $ie
        lappend ieList "$isdn_ie_names($ieInfo(IEId)) $ieInfo(Value)"
    }
    
    if { $ieList == {} } {
        logString "Recieved $isdn_message_name($isdnMsg(MessageType)) Msg \n"
    } else {
        logString "Recieved $isdn_message_name($isdnMsg(MessageType)) Msg $ieList \n"
    }

}


#call controls procedures
proc MakeCall { } {
    global tsc var_CallProgress var_DestAddr var_OrigAddr var_CallId TSC_KVSet_Key_VariantParm \
	TSC_VariantParm_Size var_IE_MakeCall TSC_KVSet_Key_IE

    upvar \#0 makecall_parms makecall_parms
    upvar \#0 parm_fd parm_fd
    upvar \#0 parm_id parm_id

    set parm_kvset(Key) $TSC_KVSet_Key_VariantParm

    set parm_kvset(ByteLength) 0

    #build list of parm structures
    set makecall_parm_list {}
    foreach parm [array names makecall_parms] {
	if {$makecall_parms($parm) != {}} {
	    lappend makecall_parm_list [list Id $parm_id($parm) Type $parm_fd($parm) Value $makecall_parms($parm)]
	    #incr size
	    array set fd [QS_FieldDefGet $parm_fd($parm)]
	    incr parm_kvset(ByteLength) [expr $fd(Count) * [QS_DataTypeGetSize $fd(DataType)]]
	}
    }
  
    #incr size of makecall_parm_list in bytes, plus the terminator
    incr parm_kvset(ByteLength) [expr ([llength $makecall_parm_list] +1) * $TSC_VariantParm_Size]
    set parm_kvset(Value) $makecall_parm_list

    set kvset [list [array get parm_kvset]]


    array set ie_kvset {}

    if {$var_IE_MakeCall != {}} {
	set ie_kvset(Key) $TSC_KVSet_Key_IE

	set data {}
	foreach byte $var_IE_MakeCall {
	    if [catch {expr $byte} result] {
		#not a number, assume it is a variable name defined in the global scope
		global $byte
		set byte [set $byte]
	    }
	    lappend data $byte
	}

	set ie_kvset(Value) $data
	set kvset [lappend $kvset [array get ie_kvset]]
    }
    array set retval [$tsc MakeCall -DestAddr $var_DestAddr -OrigAddr $var_OrigAddr \
			-CallProgress $var_CallProgress -KVSet $kvset]
    set var_CallId $retval(CallId)

}

proc InitTransfer { } {
    global tsc var_CallProgress var_DestAddr var_CallId

    set var_CallId [$tsc InitTransfer -DestAddr $var_DestAddr -CallId $var_CallId \
		       -CallProgress $var_CallProgress]
}

proc SetChanState { state } {
    global tsc var_CallId TSC_MsgSetChanState_state_$state

    $tsc SetChanState -State [set TSC_MsgSetChanState_state_$state]

}

proc Pickup { } {
    global tsc var_ParkId var_ParkAddr var_CallId
    
    set var_CallId [$tsc PickupCall -ParkId $var_ParkId -ParkAddr $var_ParkAddr]
}

proc Park { } {
    global tsc var_ParkId var_ParkAddr var_CallId
    
    set var_CallId [$tsc ParkCall -CallId $var_ParkId -ParkAddr $var_ParkAddr]
}

proc Release { } {
    set reason Normal
    global tsc var_CallId CallStateR_$reason

    $tsc ReleaseCall -CallId $var_CallId -Reason [set CallStateR_$reason]
}

proc ReleaseReason { reason } {
    global tsc var_CallId

    $tsc ReleaseCall -CallId $var_CallId -Reason $reason
}

proc Answer { } {
    global tsc var_CallId

    $tsc AnswerCall -CallId $var_CallId -NumRings 1
}

proc Drop { } {
    set reason Normal
    global tsc var_CallId CallStateR_$reason

    $tsc DropCall -CallId $var_CallId -Reason [set CallStateR_$reason]
}

proc DropReason { reason } {
    global tsc var_CallId 

    $tsc DropCall -CallId $var_CallId -Reason $reason
}

proc Proceed { } {
    global tsc var_CallId

    $tsc ProceedCall -CallId $var_CallId
}

proc Hold { } {
    global tsc var_CallId
    $tsc HoldCall -CallId $var_CallId
}

proc Reject { reason } {
    global tsc var_CallId TSC_MsgRejectCall_Reason_$reason

    $tsc RejectCall -CallId $var_CallId -Reason [set TSC_MsgRejectCall_Reason_$reason]

}

# Supports CallStateR_ reasons
proc RejectReason { reason } {
    global tsc var_CallId

    $tsc RejectCall -CallId $var_CallId -Reason $reason
}

proc BlindTransfer { } {
    global tsc var_CallId var_DestAddr var_OrigAddr var_CallProgress
    $tsc BlindTransferCall -CallId $var_CallId -DestAddr $var_DestAddr -OrigAddr $var_OrigAddr -CallProgress $var_CallProgress
}

proc CancelTransfer { } {
    global tsc var_CallId
    $tsc CancelTransfer -CallId $var_CallId
}

proc CompleteTransfer { } {
    global tsc var_CallId var_ConCallId
    $tsc CompleteTransfer -CallId $var_CallId -ConCallId $var_ConCallId
}

proc Complete { mode } {
    global tsc var_CallId TSC_MsgCompleteCall_Mode_$mode var_CmpltId

    set var_CmpltId [$tsc CompleteCall -CallId $var_CallId \
			 -Mode [set TSC_MsgCompleteCall_Mode_$mode]]
}


proc SendISDN {msgName} {
    global tsc var_CallId

    upvar \#0 $msgName msgType

    upvar \#0 var_IE_$msgName real_data

    set data {}
    foreach byte $real_data {
	if [catch {expr $byte} result] {
	    #not a number, assume it is a variable name defined in the global scope
	    global $byte
	    set byte [set $byte]
	}
	lappend data $byte
    }

    $tsc SendISDN -CallId $var_CallId -MessageType $msgType -Data $data

}


proc CancelComplete { } {
    global tsc var_CmpltId
    
    $tsc CancelComplete -CmpltId $var_CmpltId
}

proc Accept { } {
    global tsc var_CallId
    $tsc AcceptCall -CallId $var_CallId
}

proc Redirect { } {
    global tsc var_CallId var_DestAddr

    $tsc RedirectCall -CallId $var_CallId -DestAddr $var_DestAddr
}

proc Reconnect { } {
    global tsc var_CallId
    $tsc ReconnectCall -CallId $var_CallId
}

proc Retrieve { } {
    global tsc var_CallId
    $tsc RetrieveCall -CallId $var_CallId
}

proc CancelTransfer { } {
    global tsc var_CallId
    $tsc CancelTransfer -CallId $var_CallId
}

proc DialDigits { } {
    global tsc var_CallId var_DestAddr
    $tsc Dial -CallId $var_CallId -DigitString $var_DestAddr
}

proc ResetLineDevice { state } {
    global tsc TSC_MsgSetChanState_state_$state
    $tsc ResetLineDevice -state [set TSC_MsgSetChanState_state_$state]
}

proc AttachMedia {} {
    global clust tsc MediaArray attach_groups inst Std_ComponentType
	 global tgen sigdet callanalysis sigbufdtmf sigbufmf 

    #build a list of media component types and their qCompDescs
    #needed for the TSC_MsgAttach message, reqd. for call control.

    if [info exists mediainfolist] {
		unset mediainfolist
    }

    foreach group $attach_groups {
    	upvar \#0 var_Media_$group media_inst

   	set mediadesc $media_inst

		set validcomp [lindex $mediadesc 3] 

		if { $validcomp != 0} {

#        if [catch {set inst($group) [$clust find -Attrs [list \
#				[list -key $Std_ComponentType \
#					      -value $MediaArray($group)] ] ]\
#		  	} result] {
#		 		puts stderr $result	
#       	}

			if [ catch { set inst($group) [$clust allocateInst \
					-CompType $MediaArray($group) \
					-Processor [lindex $mediadesc 2] \
					-InstNo [lindex $mediadesc 4] ] \
		  	} result] {
				puts "Could not allocate $mediadesc into cluster"
    			puts stderr $result
   		}


			#  To find TGEN instance on board, the instance has first to be
			#  allocated into a cluster, otherwise QREGMGT_I_NOT_ALLOCATED is
	 		#	error returned from kernel 

			if {[string compare $group "TGEN"] == 0} {
    			if [catch {set tgen [$clust find -InstClass ToneGen]} result] {
					puts "Gettgen_instance result = $result"
				}
			  # set tgen [$board findInst -CompType $MediaArray($group) \
			  #					 -Processor [lindex $mediadesc 2] \
			  #					 -InstNo [lindex $mediadesc 4] ]
			}

			if {[string compare $group "SD"] == 0} {
    			if [catch {set sigdet [$clust find -InstClass SigDet]} result] {
					puts "Getsd_instance result = $result"
				}
			}

#			if {[string compare $group "CA"] == 0} {
#    			if [catch {set callanalysis [$clust find -InstClass CallAnalysis]} result] {
#					puts "GetCA_instance result = $result"
#				}
#			}

			if {[string compare $group "SEB_DTMF"] == 0} {
    			if [catch {set sigbufdtmf [$clust find -InstClass SigBuff]} result] {
					puts "GetSEBDTMF_instance result = $result"
				}
			}

			if {[string compare $group "SEB_MF"] == 0} {
    			if [catch {set sigbufmf [$clust find -InstClass SigBuff]} result] {
					puts "GetSEBMF_instance result = $result"
				}
			}

			set mediadesc [linsert $mediadesc 4 Instance ]  
			set mediadesc [linsert $mediadesc 3 Component ] 
			set mediadesc [linsert $mediadesc 2 Processor ]
			set mediadesc [linsert $mediadesc 1 Board ]
			set mediadesc [linsert $mediadesc 0 Node ]

    		lappend mediainfolist [list ComponentType $MediaArray($group) \
				    InstDesc $mediadesc ]
      }

    } 

    #send media attach message to TSC.
    $tsc Attach -MediaInfo $mediainfolist

}

proc DetachMedia {} {
    global clust tsc MediaArray attach_groups inst Std_ComponentType
	 global tgen sigdet callanalysis sigbufdtmf sigbufmf 

    #send media detach message to TSC.
    $tsc Detach 


    #Deallocate the same media instances from the TSC's cluster.

	 if [ catch [$clust freeInst -Instance $tgen]  result] {
		  puts "Could not deallocate TGEN from cluster"
		  puts stderr $result
	 } else {
		set tgen 0 
	 }

	 if [ catch [$clust freeInst -Instance $sigdet]  result] {
		  puts "Could not deallocate SD from cluster"
		  puts stderr $result
	 }
#	 if [ catch [$clust freeInst -Instance $callanalysis]  result] {
#		  puts "Could not deallocate CA from cluster"
#		  puts stderr $result
#	 }
	 if [ catch [$clust freeInst -Instance $sigbufdtmf]  result] {
		  puts "Could not deallocate SB_DTMF from cluster"
		  puts stderr $result
	 }
	 if [ catch [$clust freeInst -Instance $sigbufmf]  result] {
		  puts "Could not deallocate SB_MF from cluster"
		  puts stderr $result
	 }

#  exit 

#    foreach group $attach_groups {
#       if [catch {set inst($group) [$clust find -Attrs [list \
#				[list -key $Std_ComponentType \
#				      -value $MediaArray($group)] ] ]\
#		 } result] {
#		 	puts stderr $result	
#       } else {
#	   	puts "inst(group) = $inst($group)\n"
#	   	if [ catch [$clust freeInst -Instance $inst($group)]  result] {
#				puts "Could not deallocate $inst($group) ($group) from cluster"
#    			puts stderr $result
#	   	}
#       }	
#    }

}

#other procs

proc keypad_DialDigit { digit } {
    global tgen clust

#this either gets a tonegenerator from a cluster or assigns one into it
    
    if {$tgen == 0} {
    	if [catch {set tgen [$clust find -InstClass ToneGen]} result] {
			puts "Gettgeninstance result = $result"
  			if [catch {set tgen [$clust allocateInst -InstClass ToneGen]} result] {
	   		puts "Allocatetgeninstance result = $result"
   		}
    	}
    }

    if {$tgen!=0} {
		$tgen Dial $digit
    }
}


# In R4 mode the reasons are Q.931 cause codes for
# ISDN protocols
proc getCallStateReason { reason } {
	global tsc call_state_reason_name r4Mode isdnMode 

	if { $isdnMode } {
		return $reason
	} else {
		return $call_state_reason_name($reason)
	}
}
 
proc phSaveLog { fileName } {

    set fileName [tk_getSaveFile -defaultextension log \
                     -initialfile $fileName \
                     -filetypes {{{Log file} {.log}} {{Text file} {.txt}} {{All files} {*.*}}} \
                     -title "Save Phone log file as"]

    if {[string length $fileName] > 0} {
        # Save the log
        logString "Saving log to $fileName"
        set logFile [open $fileName w]
        puts $logFile [.log.data get 1.0 end]
        close $logFile
    }
}

proc logString { string } {
    .log.data insert end "[clock format [clock seconds] -format {%m/%d/%Y %I:%M:%S %p}] - "
    .log.data insert end $string
    .log.data see end
    update idletasks
}

proc refresh { } {
    global var_ChanState var_CallId var_CallState var_Reason current_buttons tsc \
	chan_state_name call_state_names r4Mode isdnMode Log \
        TSC_ParmProtocolBase TSC_ParmProtocolBase_ISDN \
	TSC_EvtCallState_Type_Null TSC_EvtCallInfo_Type_CalledId \
	TSC_EvtChanState_Type_Active call_state_evt_list \
	TSC_EvtCallInfo_Type_CallerId chan_state_evt_list \
	TSC_EvtCallInfo_Type_BearerChanId

    #first cancel any enabled events
    catch {$tsc CancelAllEvts}

    #enable state chnge detection
    $tsc DetectxEvts -EvtGroup $TSC_EvtCallState_Type_Null \
	-EvtTypeList $call_state_evt_list

    #enable call info detection
    $tsc DetectxEvts -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId  \
	-EvtTypeList [list $TSC_EvtCallInfo_Type_CalledId \
			  $TSC_EvtCallInfo_Type_CallerId]
    #enable chan state detection
    $tsc DetectxEvts -EvtGroup $TSC_EvtChanState_Type_Active  \
	-EvtTypeList $chan_state_evt_list

    #check FW parms
    array set parm [$tsc GetParm $TSC_ParmProtocolBase]
    if { $parm(Val) == $TSC_ParmProtocolBase_ISDN } { 
        set isdnMode 1
    } else {
        $Log entryconfigure 1 -state disabled
        set r4Mode 1
    }


    #get current call information
    #chan state
    
    array set change [$tsc GetChanState]
    set var_ChanState $chan_state_name($change(ChanState))

    #call state
    array set change [$tsc GetCallState -CallId $var_CallId]

    set var_CallId $change(CallId)
    set var_CallState $call_state_names($change(CallState))
    set var_Reason [getCallStateReason $change(Reason)]

#    pack .control.callcontrol.op.state_$var_CallState
#    set current_buttons $var_CallState
    change_buttons $var_CallState
}

#Draw Screen

#control frame
frame .control 


#info frame
frame .info

set info_list {{OrigAddr DestAddr} {DNIS ANI} {CallState Reason} {ChanState CallId}}

set info_disabled(DNIS) 1
set info_disabled(ANI) 1
set info_disabled(CallState) 1
set info_disabled(Reason) 1
set info_disabled(ChanState) 1

foreach info_group $info_list {
    set cf .info.group_[lindex $info_group 0]
    frame $cf
    foreach info $info_group {
	label $cf.label_$info -text $info -width 10
	entry $cf.entry_$info -textvar var_$info -width 20
	if [info exists info_disabled($info)] {
	    $cf.entry_$info configure -state disabled
	}
	pack $cf.label_$info -side left
	pack $cf.entry_$info -side left
    }
    pack $cf
}



#digit frame
#eventually make this send a tone when clicked

frame .control.digit

set digit_list {{D I A L} {1 2 3 O} {4 5 6 G} {7 8 9 I} {* 0 \# C}}

foreach digit_group $digit_list {
    frame .control.digit.group_$digit_group
    set cf .control.digit.group_$digit_group
    foreach digit $digit_group {
	button $cf.button_$digit -text $digit -command [list keypad_DialDigit $digit] -width 1
	pack $cf.button_$digit -side left
    }
    pack $cf
}

set cf {D I A L}
foreach digit {D I A L} {
    .control.digit.group_$cf.button_$digit configure -borderwidth 1 \
	-disabledforeground $dialogic_color -state disabled -font $dialogic_font -relief sunken
}

foreach cf {{1 2 3 O} {4 5 6 G} {7 8 9 I} {* 0 \# C}} {
    set digit [lindex $cf 3]
    .control.digit.group_$cf.button_$digit configure -borderwidth 1 \
	-disabledforeground $dialogic_color -state disabled -font $dialogic_font -relief sunken
}


#call control frame 

frame .control.callcontrol
frame .control.callcontrol.op

#valid state operations
set vop(Null) {{MakeCall InitTransfer} {Pickup Release} {SetChanState ResetLineDevice}}
set vop(Accepted) {{Answer Drop} {Hold Reject} {Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(Connected) {{Drop Hold} {Park InitTransfer} {BlindTransfer Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(ConnectedPendXfer) {{Drop CancelTransfer} {CompleteTransfer Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(Delivered) {{Drop Hold} {Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(Dialing) {{Drop Hold} {Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(Disconnected) {{Drop Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(DialReady) {{Drop Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(Failed) {{Drop Complete} {CancelComplete Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(Idle) {{MakeCall InitTransfer} {Pickup Release} {SetChanState ResetLineDevice}}
set vop(Initiated) {{Drop Hold} {Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(Offered) {{Answer Accept} {Reject Redirect} {Proceed DialDigits} {Release SetChanState} {SendISDN ResetLineDevice}}
set vop(Hold) {{Drop Park} {Reconnect Retrieve} {Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(OnHoldPendXfer) {{CancelTransfer CompleteTransfer} {Release DialDigits} {SetChanState SendISDN}}
set vop(Originated) {{Drop Release} {DialDigits SetChanState} {SendISDN ResetLineDevice}}
set vop(Proceeding) {{Release DialDigits} {SetChanState SendISDN} {ResetLineDevice}}
set vop(Unknown) {{Release SetChanState} {SendISDN ResetLineDevice}}
set vop(Alerting) {{Release SetChanState} {SendISDN ResetLineDevice}}

set vop(All_CC) {{MakeCall InitTransfer} {Pickup Release}\
		     {Answer Drop} {Hold Reject} \
		     {Park InitTransfer} {BlindTransfer CancelTransfer} \
		     {CompleteTransfer Complete} {CancelComplete CompleteTransfer}\
		     {Proceed Accept} {Retrieve Redirect} {Reconnect DialDigits} \
		     {SendISDN SetChanState} {AttachMedia DetachMedia} {ResetLineDevice}}	
		     

#some of these will be menus
set call_control_menu(Complete) {CampOn CallBack}
set call_control_menu(Reject) {Busy Congestion NumUnavailable Operator NumVacant}
set call_control_menu(SendISDN) {FACILITY CONG_CON NOTIFY USER_INFO INFO}
set call_control_menu(SetChanState) {InService OutOfService FinishCalls}
set call_control_menu(ResetLineDevice) {InService OutOfService}

# Call Control Commands with Right click menus
set rightClick(Reject) .menu_Reject
set rightClick(Drop) .menu_Drop
set rightClick(Release) .menu_Release

# Build Right Click Call Reason menus
foreach cmd { Reject Drop Release } {
   menu .menu_$cmd -tearoff false
	foreach {itemName itemValue} $isdn_cause_list {
	   #menu .menu_$cmd.id_$itemName
	   .menu_$cmd add command -label $itemName -command "${cmd}Reason $itemValue"
   }
}


foreach state [array names vop] {
    frame .control.callcontrol.op.state_$state
    set cf .control.callcontrol.op.state_$state
    foreach cmd_group $vop($state) {
	frame $cf.group_$cmd_group
	set sf $cf.group_$cmd_group
	foreach cmd $cmd_group {
	    if [info exists call_control_menu($cmd)] {
		menubutton $sf.button_$cmd -text $cmd -menu $sf.button_$cmd.menu \
		    -relief raised -width 15
		pack $sf.button_$cmd -side left -fill both -expand true -padx 1
		set m [menu $sf.button_$cmd.menu -tearoff 0]
		foreach item $call_control_menu($cmd) {
		    $m add command -label $item -command [list $cmd $item]  
		}
	    } else {
		button $sf.button_$cmd -text $cmd -command $cmd -width 15
		pack $sf.button_$cmd -side left -fill both
	    }
	    if [info exists rightClick($cmd)] {
		bind $sf.button_$cmd <ButtonPress-3> "tk_popup $rightClick($cmd) %X %Y"
	    }
	}

	if [expr [llength $cmd_group] % 2] {
	    button $sf.filler -width 15 -relief flat -state disabled
	    pack $sf.filler -side left -fill both
	}
	pack $sf -anchor w -fill x
    }
}


#secondary control options
frame .control.callcontrol2

#button .control.callcontrol2.exit -text "Exit" -command quit
button .control.callcontrol2.refresh -text "Refresh" -command refresh -width 15
button .control.callcontrol2.audio -text "Audio" \
    -command {exec audio -board $boardnum -line $line -chan $chan &}

checkbutton .control.callcontrol2.cb_All_CC -text More -variable var_All_CC \
    -command {change_buttons $var_CallState}


checkbutton .control.callcontrol2.cb_show_parms -text Parms -variable var_show_parms \
    -command {showParms}

checkbutton .control.callcontrol2.cb_show_ies -text {ISDN IEs} -variable var_show_IEs \
    -command {showIEs}

checkbutton .control.callcontrol2.cb_show_attach -text {Attach Media CompDescs} -variable var_show_attaches \
    -command {showAttaches}
    
frame .control.callcontrol2.cb_CallProgress
#checkbutton .control.callcontrol2.cb_CallProgress.check -text CallProgress -variable show_CallProgress -command showCallProgress
menubutton .control.callcontrol2.cb_CallProgress.menub -text CallProgress -relief raised \
            -menu .control.callcontrol2.cb_CallProgress.menub.menu
#-variable show_CallProgress -command showCallProgress
menu .control.callcontrol2.cb_CallProgress.menub.menu -tearoff 1
.control.callcontrol2.cb_CallProgress.menub.menu add radio -label Disabled -variable var_CallProgress -value 0x0
.control.callcontrol2.cb_CallProgress.menub.menu add radio -label Pre-Connect -variable var_CallProgress -value 0x2
.control.callcontrol2.cb_CallProgress.menub.menu add radio -label Post-Connect -variable var_CallProgress -value 0x3
.control.callcontrol2.cb_CallProgress.menub.menu add radio -label Both -variable var_CallProgress -value 0x1
entry .control.callcontrol2.cb_CallProgress.value -textvariable var_CallProgress -width 3   
#pack .control.callcontrol2.cb_CallProgress.check -side left
pack .control.callcontrol2.cb_CallProgress.menub -side left
#if {$show_CallProgress == 1} {
   pack .control.callcontrol2.cb_CallProgress.value -side left
#} else {
#   pack forget .control.callcontrol2.cb_CallProgress.value -side left
#}

#pack .control.callcontrol2.exit -fill x
pack .control.callcontrol2.refresh -fill x
pack .control.callcontrol2.audio -fill x
pack .control.callcontrol2.cb_All_CC -anchor w
pack .control.callcontrol2.cb_show_parms -anchor w
pack .control.callcontrol2.cb_show_ies -anchor w
pack .control.callcontrol2.cb_show_attach -anchor w
pack .control.callcontrol2.cb_CallProgress -anchor w

proc showCallProgress {} {
   global show_CallProgress
   logString "showCallProgress: show_CallProgress == $show_CallProgress\n"
   if {$show_CallProgress == 1} {
	#display the parms
	pack .control.callcontrol2.cb_CallProgress.value -side left
	return
    }
    #hide the parms
    pack forget .control.callcontrol2.cb_CallProgress.value -side left
    return

}

#find cluster
set board [Board new -init [list -BoardNum $boardnum]]

set clust [$board findClust -Attrs [list \
			      [list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
					[list -key $TSC_AttrLineId -value $line] \
					[list -key $TSC_AttrChanId -value $chan] ] ]

#allocate or get instances in cluster
set tsc [$clust find -InstClass TSC]

array set protocolParm [$tsc GetParm $TSC_ParmProtocolBase]
set protocolBase $protocolParm(Val)

#...sks don't allocate tonegen into a cluster here, wait for attach message.
#this either gets a tonegenerator from a cluster or assigns one into it
#	if [catch {set tgen [$clust find -InstClass ToneGen]} result] {
#	    if [catch {set tgen [$clust allocateInst -InstClass ToneGen]} result] {
#		set tgen 0
#	    }
#	}

set tgen 0

#parameter frame
set f [frame .control.callcontrol.parms]

set parm_groups {CallControl CallProgress BlindTransfer ISDN_Outbound}

#parm groups, each has two arrays one with ids and one with fds
array set CallControl_parms_id [list \
				     StartTimeout $CHP_VParm_StartTimeout \
				     AnswerTimeout $CHP_VParm_AnswerTimeout \
				     ReconnectTimeout $CHP_VParm_ReconnectTimeout \
				     DisconnectTimeout $CHP_VParm_DisconnectTimeout \
				     DialFormat $CHP_VParm_DialFormat \
				     ANIFormat $CHP_VParm_ANIFormat \
				  ]


array set CallControl_parms_fd [list \
				     StartTimeout $CHP_OS_T1_Variant_StartTimeout \
				     AnswerTimeout $CHP_OS_T1_Variant_AnswerTimeout \
				     ReconnectTimeout $CHP_OS_T1_Variant_ReconnectTimeout \
				     DisconnectTimeout $CHP_OS_T1_Variant_DisconnectTimeout \
				     DialFormat $CHP_OS_T1_Variant_DialFormat \
				     ANIFormat $CHP_OS_T1_Variant_ANIFormat \
				    ]

array set BlindTransfer_parms_id [list \
				      BtDialToneId $CHP_VParm_BtDialToneId \
				      BtStartTimeout $CHP_VParm_BtStartTimeout \
				      ]

array set BlindTransfer_parms_fd [list \
				      BtDialToneId $CHP_T1_Variant_BtDialToneId \
				      BtStartTimeout $CHP_T1_Variant_BtStartTimeout \
				      ]

array set ISDN_Outbound_parms_id [list \
				      Layer1Protocol $CHP_VParm_Layer1Protocol \
				      InfoTransferRate $CHP_VParm_InfoTransferRate \
				      InfoTransferCap $CHP_VParm_InfoTransferCap \
				      CalledNumberType $CHP_VParm_CalledNumberType \
				      CalledNumberPlan $CHP_VParm_CalledNumberPlan \
				      CalledNumberCount $CHP_VParm_CalledNumberCount \
				      CalledSubaddressType $CHP_VParm_CalledSubaddressType \
				      CallingNumberType $CHP_VParm_CallingNumberType \
				      CallingNumberPlan $CHP_VParm_CallingNumberPlan \
				      CallingNumberPresentation $CHP_VParm_CallingNumberPresentation \
				      CallingNumberScreening $CHP_VParm_CallingNumberScreening \
				      CallingNumberCount $CHP_VParm_CallingNumberCount \
				      CallingSubaddressType $CHP_VParm_CallingSubaddressType \
				      ]

array set ISDN_Outbound_parms_fd [list \
				      Layer1Protocol $CHP_ISDN_Variant_Layer1Protocol \
				      InfoTransferRate $CHP_ISDN_Variant_InfoTransferRate \
				      InfoTransferCap $CHP_ISDN_Variant_InfoTransferCap \
				      CalledNumberType $CHP_ISDN_Variant_CalledNumberType \
				      CalledNumberPlan $CHP_ISDN_Variant_CalledNumberPlan \
				      CalledNumberCount $CHP_ISDN_Variant_CalledNumberCount \
				      CalledSubaddressType $CHP_ISDN_Variant_CalledSubaddressType \
				      CallingNumberType $CHP_ISDN_Variant_CallingNumberType \
				      CallingNumberPlan $CHP_ISDN_Variant_CallingNumberPlan \
				      CallingNumberPresentation $CHP_ISDN_Variant_CallingNumberPresentation \
				      CallingNumberScreening $CHP_ISDN_Variant_CallingNumberScreening \
				      CallingNumberCount $CHP_ISDN_Variant_CallingNumberCount \
				      CallingSubaddressType $CHP_ISDN_Variant_CallingSubaddressType \
				      ]

switch -exact -- $protocolBase \
   $TSC_ParmProtocolBase_ISDN {
      array set CallProgress_parms_id [list \
				     CaRingingSet $CHP_VParm_CaRingingSet \
				     CaBusySet $CHP_VParm_CaBusySet \
				     CaSitSet $CHP_VParm_CaSitSet \
				     CaFaxSet $CHP_VParm_CaFaxSet \
				     CaPvdId $CHP_VParm_CaPvdId \
				     CaPamdId $CHP_VParm_CaPamdId \
				     CaSignalTimeout $CHP_VParm_CaSignalTimeout \
				     CaAnswerTimeout $CHP_VParm_CaAnswerTimeout \
				     CaPvdTimeout $CHP_VParm_CaPvdTimeout \
				     CaHdgLoHiGl $CHP_VParm_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_VParm_CaAnsdglPSV \
				     ]

      array set CallProgress_parms_fd [list \
				     CaRingingSet $CHP_ISDN_Variant_CaRingingSet \
				     CaBusySet $CHP_ISDN_Variant_CaBusySet \
				     CaSitSet $CHP_ISDN_Variant_CaSitSet \
				     CaFaxSet $CHP_ISDN_Variant_CaFaxSet \
				     CaPvdId $CHP_ISDN_Variant_CaPvdId \
				     CaPamdId $CHP_ISDN_Variant_CaPamdId \
				     CaSignalTimeout $CHP_ISDN_Variant_CaSignalTimeout \
				     CaAnswerTimeout $CHP_ISDN_Variant_CaAnswerTimeout \
				     CaPvdTimeout $CHP_ISDN_Variant_CaPvdTimeout \
				     CaHdgLoHiGl $CHP_ISDN_Variant_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_ISDN_Variant_CaAnsdglPSV \
				     ]
   }\
   $TSC_ParmProtocolBase_PDK {
      array set CallProgress_parms_id [list \
				     CaRingingSet $CHP_PDK_VParm_CaRingingSet \
				     CaBusySet $CHP_PDK_VParm_CaBusySet \
				     CaSitSet $CHP_PDK_VParm_CaSitSet \
				     CaFaxSet $CHP_PDK_VParm_CaFaxSet \
				     CaPvdId $CHP_PDK_VParm_CaPvdId \
				     CaPamdId $CHP_PDK_VParm_CaPamdId \
				     CaSignalTimeout $CHP_PDK_VParm_CaSignalTimeout \
				     CaAnswerTimeout $CHP_PDK_VParm_CaAnswerTimeout \
				     CaPvdTimeout $CHP_PDK_VParm_CaPvdTimeout \
				     CaHdgLoHiGl $CHP_PDK_VParm_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_PDK_VParm_CaAnsdglPSV \
				     ]   
				     
      array set CallProgress_parms_fd [list \
				     CaRingingSet $CHP_PDK_Variant_CaRingingSet \
				     CaBusySet $CHP_PDK_Variant_CaBusySet \
				     CaSitSet $CHP_PDK_Variant_CaSitSet \
				     CaFaxSet $CHP_PDK_Variant_CaFaxSet \
				     CaPvdId $CHP_PDK_Variant_CaPvdId \
				     CaPamdId $CHP_PDK_Variant_CaPamdId \
				     CaSignalTimeout $CHP_PDK_Variant_CaSignalTimeout \
				     CaAnswerTimeout $CHP_PDK_Variant_CaAnswerTimeout \
				     CaPvdTimeout $CHP_PDK_Variant_CaPvdTimeout \
				     CaHdgLoHiGl $CHP_PDK_Variant_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_PDK_Variant_CaAnsdglPSV \
				     ]
	}\
   default {
      array set CallProgress_parms_id [list \
				     CaRingingSet $CHP_VParm_CaRingingSet \
				     CaBusySet $CHP_VParm_CaBusySet \
				     CaSitSet $CHP_VParm_CaSitSet \
				     CaFaxSet $CHP_VParm_CaFaxSet \
				     CaPvdId $CHP_VParm_CaPvdId \
				     CaPamdId $CHP_VParm_CaPamdId \
				     CaSignalTimeout $CHP_VParm_CaSignalTimeout \
				     CaAnswerTimeout $CHP_VParm_CaAnswerTimeout \
				     CaPvdTimeout $CHP_VParm_CaPvdTimeout \
				     DialToneId $CHP_VParm_DialToneId \
				     CaHdgLoHiGl $CHP_VParm_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_VParm_CaAnsdglPSV \
				     ]

      array set CallProgress_parms_fd [list \
				     CaRingingSet $CHP_OS_T1_Variant_CaRingingSet \
				     CaBusySet $CHP_OS_T1_Variant_CaBusySet \
				     CaSitSet $CHP_OS_T1_Variant_CaSitSet \
				     CaFaxSet $CHP_OS_T1_Variant_CaFaxSet \
				     CaPvdId $CHP_OS_T1_Variant_CaPvdId \
				     CaPamdId $CHP_OS_T1_Variant_CaPamdId \
				     CaSignalTimeout $CHP_OS_T1_Variant_CaSignalTimeout \
				     CaAnswerTimeout $CHP_OS_T1_Variant_CaAnswerTimeout \
				     CaPvdTimeout $CHP_OS_T1_Variant_CaPvdTimeout \
				     DialToneId $CHP_OS_T1_Variant_DialToneId \
				     CaHdgLoHiGl $CHP_OS_T1_Variant_CaHdgLoHiGl \
				     CaAnsdglPSV $CHP_OS_T1_Variant_CaAnsdglPSV \
				     ]
   }   

#build internal control for parms
foreach group $parm_groups {
    set grpf [frame $f.pg_$group]

    checkbutton $grpf.cb_show_$group -text $group -variable var_show_parm_$group \
	-command [list showParmGroup $group]

    pack $grpf.cb_show_$group -anchor w

    set pf [frame $grpf.parms]

    set var_show_parm_$group 0
    array set parm_fd [array get ${group}_parms_fd]
    array set parm_id [array get ${group}_parms_id]


    foreach parm [array names ${group}_parms_fd] {
	set ef [frame $pf.fr_${parm}]

	label $ef.l -text $parm
	entry $ef.e -textvariable makecall_parms($parm)

	pack $ef.l -side left
	pack $ef.e
	pack $ef -anchor e

    }
    pack $grpf -anchor w
}


proc showParmGroup {group} {
    global var_show_parm_$group
    set show [set var_show_parm_$group]

    if {$show == 1} {
	#display the parms
	pack .control.callcontrol.parms.pg_$group.parms -anchor s -fill x -expand true
	return
    }
    #hide the parms
    pack forget .control.callcontrol.parms.pg_$group.parms
    return

}

proc showParms {} {
    global var_show_parms

    if {$var_show_parms == 1} {
	#display the parms
	pack .control.callcontrol.parms -anchor sw
	return
    }
    #hide the parms
    pack forget .control.callcontrol.parms
    return
}

set var_show_parms 0


#show IEs
#IEs frame
set f [frame .control.callcontrol.ies]

set ie_groups {MakeCall FACILITY CONG_CON NOTIFY USER_INFO INFO}


menu ${f}.ie_list -tearoff false


proc add_active_IE {ieid} {
    global active_IE
    $active_IE insert insert " $ieid "
}

set sorted_ie_list [lsort $isdn_ie_name_list]

set ie_group tmp
set group_size 9

for {set group 0} {$ie_group != {}} {incr group} {
    set ie_group [lrange $sorted_ie_list [expr $group * $group_size] [expr ($group * $group_size) + $group_size]]
    if {$ie_group !={}} {
	lappend ie_group_list $ie_group
    }
}

foreach group $ie_group_list {
    set group_id [lindex $group 0]
    ${f}.ie_list add cascade -label "$group_id ... [lindex $group end]" -menu ${f}.ie_list.group$group_id
    menu ${f}.ie_list.group$group_id -tearoff false
    foreach ieid $group {
	${f}.ie_list.group$group_id add command -label $ieid -command  "add_active_IE $ieid"
    }
}

#build internal control for IEs
foreach group $ie_groups {
    set grpf [frame $f.pg_$group]

    label ${grpf}.l -text ${group} -width 10 -anchor e
    entry ${grpf}.e -textvariable var_IE_$group

    bind ${grpf}.e <ButtonPress-3> { tk_popup ${f}.ie_list %X %Y; set active_IE %W }


    pack ${grpf}.l -side left
    pack ${grpf}.e -fill x -expand true
    
    pack $grpf -anchor w -fill x -expand true
}


#setup default ie values
#set var_IE_MakeCall {}
#set var_IE_FACILITY {FACILITY_IE 0x04 0x91 0xA1 0x01 0x56}
#set var_IE_CONG_CON {REPEAT_IND_IE}
#set var_IE_NOTIFY {NOTIFY_IND_IE 0x01 0x80}
#set var_IE_USER_INFO {USER_USER_IE 0x04 0x08 0x31 0x32 0x33}
#set var_IE_INFO {KEYPAD_FACILITY_IE 0x04 0x01 0x02 0x03 0x04}



proc showIEs {} {
    global var_show_IEs

    if {$var_show_IEs == 1} {
	#display the IEs
	pack .control.callcontrol.ies -anchor sw -fill x -expand true
	return
    }
    #hide the IEs
    pack forget .control.callcontrol.ies
    return
}



set var_show_IEs 0

#show Attaches 
#Attaches frame
set f [frame .control.callcontrol.attach]

set attach_groups {TGEN SD CA SEB_DTMF SEB_MF R2MF}
set MediaArray(TGEN) 		0x05
set MediaArray(SD)   		0x07
set MediaArray(CA)   		0x0a
set MediaArray(SEB_DTMF)  	0x08
set MediaArray(SEB_MF)   	0x08
set MediaArray(R2MF)		0x42

#build internal control for Media Attaches 
foreach group $attach_groups {

    set grpf [frame $f.pg_$group]

    label ${grpf}.l -text ${group} -width 10 -anchor e
    entry ${grpf}.e -textvariable var_Media_$group

    set var_Media_$group [list 0 0 0 0 0]

    pack ${grpf}.l -side left
    pack ${grpf}.e -fill x -expand true
    
    pack $grpf -anchor w -fill x -expand true
}

proc showAttaches {} {
    global var_show_attaches

    if {$var_show_attaches == 1} {
	#display the Attaches
	pack .control.callcontrol.attach -anchor sw -fill x -expand true
	return
    }
    #hide the attaches
    pack forget .control.callcontrol.attach
    return
}

set var_show_attaches 0

#pack frames

pack .info
pack .control.digit -side left -fill both
pack .control.callcontrol -side left -fill both
pack .control.callcontrol.op -anchor n -fill both
pack .control.callcontrol2 -fill both
pack .control


wm protocol . WM_DELETE_WINDOW quit


#main

wm title . [list DM3 Phone $boardnum.$line.$chan]

# Create log window
frame .log -border 3 -relief ridge
text .log.data -width 60 -height 10 -yscrollcommand {.log.scroll set}
scrollbar .log.scroll -command {.log.data yview}
pack .log.data -side left -fill both -expand true -anchor n
pack .log.scroll -fill y -expand true -anchor n

if { $showLog } {
    pack .log -side top -fill both -expand true -anchor n
}

#Add a menu bar
menu .menubar

#Attach the menu bar to the top of the main window
. config -menu .menubar

#Create cascaded menus
foreach m {File Display Log} {
    set $m [menu .menubar.m$m]
    .menubar add cascade -label $m -menu .menubar.m$m
}

set detectISDN 0
set detectCallAnalysis 0

$File add command -label "Save Log" -command { phSaveLog phone.log}
$File add command -label Exit -command quit
$Display add command -label "Clear Log" -command { .log.data delete 0.0 end }
$Display add check -label "View Log" -variable showLog -command { 
            if { $showLog } {
                pack .log -side top -fill both -expand true -anchor n
            } else {
                pack forget .log
            }
        }
$Log add check -label "Detect ISDNMsgSet" -variable detectISDN -command { 
           if { $detectISDN } {
               detectEvt ISDNMsgSet
           } else {
               cancelEvt ISDNMsgSet 
           }
        }

$Log add check -label "Detect CallAnalysis" -variable detectCallAnalysis -command { 
           if { $detectCallAnalysis } {
               detectEvt CallAnalysis
           } else {
               cancelEvt CallAnalysis 
           }
        }        

#enable state change callbacks
$tsc asyncRegister -EvtGroup $TSC_EvtCallState_Type_Null -Proc handle_StateChange

#enable call info callbacks
$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId -Proc handle_InfoEvents
$tsc asyncRegister -EvtGroup $TSC_EvtCallInfoSet_Type_ISDNMsgSet -Proc handle_ISDNEvents
$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_CallAnalysis -Proc handle_InfoEvents
  
#enable chan state callbacks
$tsc asyncRegister -EvtGroup $TSC_EvtChanState_Type_Active -Proc handle_ChanStateChange

set var_CallId 0x0

refresh

logString "Phone started on board $boardnum line $line channel $chan\n\n"


