# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2008 Dialogic Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

set transCallState($CallState_Null) Null
set transCallState($CallState_Accepted) Accepted
set transCallState($CallState_Connected) Connected
set transCallState($CallState_ConnectedPendXfer) ConnectedPendXfer
set transCallState($CallState_Delivered) Delivered
set transCallState($CallState_Dialing) Dialing
set transCallState($CallState_Disconnected) Disconnected
set transCallState($CallState_DialReady) DialReady
set transCallState($CallState_Failed) Failed
set transCallState($CallState_Idle) Idle
set transCallState($CallState_Initiated) Initiated
set transCallState($CallState_Offered) Offered
set transCallState($CallState_Hold) Hold
set transCallState($CallState_HoldPendXfer) OnHoldPendXfer
set transCallState($CallState_Originated) Originated
set transCallState($CallState_Proceeding) Proceeding
set transCallState($CallState_Unknown) Unknown
set transCallState($CallState_Alerting) Alerting

set transCallState($TSC_EvtCallState_Type_Null) Null
set transCallState($TSC_EvtCallState_Type_Accepted) Accepted
set transCallState($TSC_EvtCallState_Type_Connected) Connected
set transCallState($TSC_EvtCallState_Type_ConnectedPendXfer) ConnectedPendXfer
set transCallState($TSC_EvtCallState_Type_Delivered) Delivered
set transCallState($TSC_EvtCallState_Type_Dialing) Dialing
set transCallState($TSC_EvtCallState_Type_Disconnected) Disconnected
set transCallState($TSC_EvtCallState_Type_DialReady) DialReady
set transCallState($TSC_EvtCallState_Type_Failed) Failed
set transCallState($TSC_EvtCallState_Type_Idle) Idle
set transCallState($TSC_EvtCallState_Type_Initiated) Initiated
set transCallState($TSC_EvtCallState_Type_Offered) Offered
set transCallState($TSC_EvtCallState_Type_Hold) Hold
set transCallState($TSC_EvtCallState_Type_OnHoldPendXfer) OnHoldPendXfer
set transCallState($TSC_EvtCallState_Type_Originated) Originated
set transCallState($TSC_EvtCallState_Type_Proceeding) Proceeding
set transCallState($TSC_EvtCallState_Type_Unknown) Unknown
set transCallState($TSC_EvtCallState_Type_Alerting) Alerting

set transCallInfo($TSC_EvtCallInfo_Type_CalledId) CalledId 
set transCallInfo($TSC_EvtCallInfo_Type_CallerId) CallerId
set transCallInfo($TSC_EvtCallInfo_Type_BearerChanId) BearerChanId
set transCallInfo($TSC_EvtCallInfo_Type_CalledIdType) CalledIdType
set transCallInfo($TSC_EvtCallInfo_Type_CalledIdCategory) CalledIdCategory
set transCallInfo($TSC_EvtCallInfo_Type_CalledSubId) CalledSubId
set transCallInfo($TSC_EvtCallInfo_Type_CalledSubIdType) CalledSubIdType
set transCallInfo($TSC_EvtCallInfo_Type_CallerIdType) CallerIdType
set transCallInfo($TSC_EvtCallInfo_Type_CallerIdCategory) CallerIdCategory
set transCallInfo($TSC_EvtCallInfo_Type_CallerSubId) CallerSubId
set transCallInfo($TSC_EvtCallInfo_Type_CallerSubIdType) CallerSubIdType
set transCallInfo($TSC_EvtCallInfo_Type_Charge) Charge
set transCallInfo($TSC_EvtCallInfo_Type_ChargeType) ChargeType
set transCallInfo($TSC_EvtCallInfo_Type_Display) Display
set transCallInfo($TSC_EvtCallInfo_Type_Language) Language
set transCallInfo($TSC_EvtCallInfo_Type_LineId) LineId
set transCallInfo($TSC_EvtCallInfo_Type_Origin) Orgin
set transCallInfo($TSC_EvtCallInfo_Type_Rate) Rate
set transCallInfo($TSC_EvtCallInfo_Type_Reason) Reason
set transCallInfo($TSC_EvtCallInfo_Type_RedirectedId) RedirectedId
set transCallInfo($TSC_EvtCallInfo_Type_RedirectedIdType) RedirectedType
set transCallInfo($TSC_EvtCallInfo_Type_RedirectingId) RedirectingId
set transCallInfo($TSC_EvtCallInfo_Type_RedirectingIdType) RedirectingIdType
set transCallInfo($TSC_EvtCallInfo_Type_CallAnalysis) CallAnalysis
set transCallInfo($TSC_EvtCallInfo_Type_InfoTransferCap) InfoTxCap
set transCallInfo($TSC_EvtCallInfo_Type_InfoTransferRate) InfoTxRate
set transCallInfo($TSC_EvtCallInfo_Type_Layer1Protocol) Layer1Protocol

set transCallStateReason($CallStateR_Busy) Busy
set transCallStateReason($CallStateR_CallCompletion) CallCompletion
set transCallStateReason($CallStateR_Canceled) Canceled
set transCallStateReason($CallStateR_Congestion) Congestion
set transCallStateReason($CallStateR_DestBusy) DestBusy
set transCallStateReason($CallStateR_DestAddrBad) DestAddrBad
set transCallStateReason($CallStateR_DestOutOfOrder) DestOutOfOrder
set transCallStateReason($CallStateR_DestUnobtainable) DestUnobtainable
set transCallStateReason($CallStateR_Forward) Forward
set transCallStateReason($CallStateR_Incompatible) Incompatible
set transCallStateReason($CallStateR_IncomingCall) IncomingCall
set transCallStateReason($CallStateR_NewCall) NewCall
set transCallStateReason($CallStateR_NoAnswer) NoAnswer
set transCallStateReason($CallStateR_Normal) Normal
set transCallStateReason($CallStateR_NetworkAlarm) NetworkAlarm
set transCallStateReason($CallStateR_PickUp) PickUp
set transCallStateReason($CallStateR_ProtocolError) ProtocolError
set transCallStateReason($CallStateR_Redirection) Redirection
set transCallStateReason($CallStateR_RemoteTermination) RemoteTermination
set transCallStateReason($CallStateR_Rejection) Rejection
set transCallStateReason($CallStateR_SIT) SIT
set transCallStateReason($CallStateR_SITCustIrreg) SITCustIrreg
set transCallStateReason($CallStateR_SITNoCircuit) SITNoCircuit
set transCallStateReason($CallStateR_SITReorder) SITReorder
set transCallStateReason($CallStateR_Transfer) Transfer
set transCallStateReason($CallStateR_Unavailable) Unavailable
set transCallStateReason($CallStateR_Unknown) Unknown
set transCallStateReason($CallStateR_UnallocatedNumber) UnallocatedNumber
set transCallStateReason($CallStateR_NoRoute) NoRoute
set transCallStateReason($CallStateR_NumberChanged) NumberChanged
set transCallStateReason($CallStateR_OutOfOrder) OutOfOrder
set transCallStateReason($CallStateR_InvalidFormat) InvalidFormat
set transCallStateReason($CallStateR_ChanUnavailable) ChanUnavailable
set transCallStateReason($CallStateR_ChanUnacceptable) ChanUnacceptable
set transCallStateReason($CallStateR_ChanNotImplemented) ChanNotImplemented
set transCallStateReason($CallStateR_NoChan) NoChan
set transCallStateReason($CallStateR_NoResponse) NoResponse
set transCallStateReason($CallStateR_FacilityNotSubscribed) FacilityNotSubscribed
set transCallStateReason($CallStateR_FacilityNotImplemented) FacilityNotImplemented
set transCallStateReason($CallStateR_ServiceNotImplemented) ServiceNotImplemented
set transCallStateReason($CallStateR_BarredInbound) BarredInbound
set transCallStateReason($CallStateR_BarredOutbound) BarredOutbound
set transCallStateReason($CallStateR_DestIncompatible) DestIncompatible
set transCallStateReason($CallStateR_BearerCapUnavailable) BearerCapUnavailable
set transCallStateReason($CallStateR_NormalUnspecified) NormalUnspecified
set transCallStateReason($CallStateR_ReqTimedout) ReqTimedout
set transCallStateReason($CallStateR_RemoteRetrieve) RemoteRetrieve
set transCallStateReason($CallStateR_RemoteReconnect) RemoteReconnect
set transCallStateReason($CallStateR_LocalTimeout) LocalTimeout
set transCallStateReason($CallStateR_Ack) Ack
set transCallStateReason($CallStateR_Max) Max

set transChanState($TSC_EvtChanState_Type_Active) Active
set transChanState($TSC_EvtChanState_Type_ActivePending) ActivePending
set transChanState($TSC_EvtChanState_Type_Alarm) Alarm
set transChanState($TSC_EvtChanState_Type_OutOfService) OutOfService
set transChanState($TSC_EvtChanState_Type_Maintenance) Maintenance
set transChanState($TSC_EvtChanState_Type_OutOfServiceLocal) OutOfServiceLocal
set transChanState($TSC_EvtChanState_Type_MaintenanceLocal) MaintenanceLocal
set transChanState($TSC_EvtChanState_Type_Idle) Idle
set transChanState($TSC_EvtChanState_Type_IdlePending) IdlePending
set transChanState($TSC_EvtChanState_Type_Null) Null
set transChanState($TSC_EvtChanState_Type_Unknown) Unknown
set transChanState($TSC_EvtChanState_Type_OutOfServiceMediaDetached) OutOfServiceMediaDetached
set transChanState($TSC_EvtChanState_Type_OutOfServiceRemote) OutOfServiceRemote

set transChanState($ChanState_Active) Active
set transChanState($ChanState_ActivePending) ActivePending
set transChanState($ChanState_Alarm) Alarm
set transChanState($ChanState_OutOfService) OutOfService
set transChanState($ChanState_Maintenance) Maintenance
set transChanState($ChanState_OutOfServiceLocal) OutOfServiceLocal
set transChanState($ChanState_MaintenanceLocal) MaintenanceLocal
set transChanState($ChanState_Idle) Idle
set transChanState($ChanState_IdlePending) IdlePending
set transChanState($ChanState_Null) Null
set transChanState($ChanState_Unknown) Unknown
set transChanState($ChanState_OutOfServiceMediaDetached) OutOfServiceMediaDetached
set transChanState($ChanState_OutOfServiceRemote) OutOfServiceRemote

set LedOnColor(inactive) grey
set LedOnColor(Red) red
set LedOnColor(Yellow) yellow
set LedOnColor(Signal) grey
set LedOnColor(Loopback) orange
set LedOnColor(AISStatus) blue
set LedOnColor(LineState) green
set LedOnColor(RAI) yellow
set LedOnColor(AIS) blue
set LedOnColor(TS16RAI) yellow
set LedOnColor(TS16AIS) blue
set LedOnColor(DChannel) grey
set LedOnColor(TS16Red) red
set LedOnColor(TS16Yellow) yellow
set LedOnColor(TS16AISStatus) blue
set LedOnColor(CRC) yellow

set LedOffColor(Red) grey
set LedOffColor(Yellow) grey
set LedOffColor(Signal) green
set LedOffColor(Loopback) grey
set LedOffColor(AISStatus) grey
set LedOffColor(LineState) {}
set LedOffColor(RAI) {}
set LedOffColor(AIS) {}
set LedOffColor(TS16RAI) {}
set LedOffColor(TS16AIS) {}
set LedOffColor(DChannel) green
set LedOffColor(TS16Red) grey
set LedOffColor(TS16Yellow) grey
set LedOffColor(TS16AISStatus) grey
set LedOffColor(CRC) grey

set alarmTrans($AllAlarms) AllAlarms
set alarmTrans($RED_CFA) Red
set alarmTrans($YELLOW_CFA) Yellow
set alarmTrans($AIS_CFA) AISStatus
set alarmTrans($LOS_CFA) Signal
set alarmTrans($LOOPBACK_CFA) Loopback
set alarmTrans($RAI_CRC_CFA) CRC
set alarmTrans($TS16_RED_CFA) TS16Red
set alarmTrans($TS16_YELLOW_CFA) TS16Yellow
set alarmTrans($TS16_AIS_CFA) TS16AISStatus
set alarmTrans($DCHAN_CFA) DChannel
set alarmTrans($Transmit_RAI) RAI
set alarmTrans($Transmit_AIS) AIS
set alarmTrans($Transmit_RAI_TS16) TS16RAI
set alarmTrans($Transmit_AIS_TS16) TS16AIS
set alarmTrans($BPVS_CFA) BPVS_CFA
set alarmTrans($FERR_CFA) FERR_CFA
set alarmTrans($ECS_CFA) ECS_CFA
set alarmTrans($CECS_CFA) CECS_CFA
set alarmTrans($OOF_CFA) OOF_CFA
set alarmTrans($LCON_InitialAlarmState_DefaultNoAlarms) Initial_NoAlarms

set xmitAlarmTrans(RAI) $Transmit_RAI
set xmitAlarmTrans(AIS) $Transmit_AIS
set xmitAlarmTrans(TS16RAI) $Transmit_RAI_TS16
set xmitAlarmTrans(TS16AIS) $Transmit_AIS_TS16

set transAPIMsg(0x1200)	{ACCEPT CALL}
set transAPIMsg(0x1201)	{ANSWER CALL}
set transAPIMsg(0x1202)	{BLIND XFER CALL}
set transAPIMsg(0x1203)	{CANCEL XFER}
set transAPIMsg(0x1204)	{CANCEL CMPLT}
set transAPIMsg(0x1205)	{COMPLETE CALL}
set transAPIMsg(0x1206)	{COMPLETECALL CMPLT}
set transAPIMsg(0x1207)	{COMPLETE XFER}
set transAPIMsg(0x1208)	{DEF BSET}
set transAPIMsg(0x1209)	{DEFBSET CMPLT}
set transAPIMsg(0x120a)	{DROP CALL}
set transAPIMsg(0x120b)	{GET CALL INFO}
set transAPIMsg(0x120c)	{GETCALLINFO CMPLT}
set transAPIMsg(0x120d)	{GET CALL STATE}
set transAPIMsg(0x120e)	{GETCALLSTATE CMPLT}
set transAPIMsg(0x120f)	{GET CHAN STATE}
set transAPIMsg(0x1210)	{GETCHANSTATE CMPLT}
set transAPIMsg(0x1211)	{HOLD CALL}
set transAPIMsg(0x1212)	{INIT XFER}
set transAPIMsg(0x1213)	{INITXFER CMPLT}
set transAPIMsg(0x1214)	{MAKE CALL}
set transAPIMsg(0x1215)	{MAKECALL CMPLT}
set transAPIMsg(0x1216)	{PARK CALL}
set transAPIMsg(0x1217)	{PARKCALL CMPLT}
set transAPIMsg(0x1218)	{PICKUP CALL}
set transAPIMsg(0x1219)	{PICKUPCALL CMPLT}
set transAPIMsg(0x121a)	{RECONNECT CALL}
set transAPIMsg(0x121b)	{RECONNECTCALL CMPLT}
set transAPIMsg(0x121c)	{RELEASE CALL}
set transAPIMsg(0x121d)	{REJECT CALL}
set transAPIMsg(0x121e)	{RETRIEVE CALL}
set transAPIMsg(0x121f)	{SET CHAN STATE}
set transAPIMsg(0x1220)	{SETCHANSTATE CMPLT}
set transAPIMsg(0x1221)	{WAIT CALL}
set transAPIMsg(0x126b)	{CALL CONTROL}
set transAPIMsg(na)	{UNKNOWN}


array set AppEvents [list \
	LogStarted   [binary format I 0]\
	LogClosed    [binary format I 1]\
	LogResumed   [binary format I 2]\
	LogSuspended [binary format I 3]\
	QueryBoard   [binary format I 10]\
	BoardFound   [binary format I 11]\
	BoardNotPresent [binary format I 12]\
	NumLines     [binary format I 13]\
	LineType     [binary format I 14]\
	ProtocolType [binary format I 15]\
	NumChans     [binary format I 16]\
	CreateView   [binary format I 20]\
	CloseView    [binary format I 21]\
	DisplayView  [binary format I 22]\
	LaunchApp    [binary format I 23]\
	Snapshot     [binary format I 24]\
	ClusterMode  [binary format I 25]\
	CmdSetChanState     [binary format I 0x1000]\
	CmdResetLineDevice  [binary format I 0x1001]\
	CmdMakeCall         [binary format I 0x1002]\
	CmdDialDigits       [binary format I 0x1003]\
	CmdDrop             [binary format I 0x1004]\
	CmdDropReason       [binary format I 0x1005]\
	CmdRelease          [binary format I 0x1006]\
	CmdReleaseReason    [binary format I 0x1007]\
	CmdAnswer           [binary format I 0x1008]\
	CmdAccept           [binary format I 0x1009]\
	CmdProceed          [binary format I 0x100a]\
	CmdReject           [binary format I 0x100b]\
	CmdRedirect         [binary format I 0x100c]\
	CmdHold             [binary format I 0x100d]\
	CmdRetrieve         [binary format I 0x100e]\
	CmdReconnect        [binary format I 0x100f]\
	CmdInitTransfer     [binary format I 0x1010]\
	CmdBlindTransfer    [binary format I 0x1011]\
	CmdCancelTransfer   [binary format I 0x1012]\
	CmdCompleteTransfer [binary format I 0x1013]\
	CmdSendISDN         [binary format I 0x1014]\
	CmdComplete         [binary format I 0x1015]\
	CmdCancelComplete   [binary format I 0x1016]\
	CmdPark             [binary format I 0x1017]\
	CmdPickup           [binary format I 0x1018]\
	CmdAudio            [binary format I 0x1019]\
	CmdAttachMedia      [binary format I 0x101a]\
        CmdDetachMedia      [binary format I 0x101b]\
	LCONSendAlarm       [binary format I 0x2000]\
	LCONSendAlarmFail   [binary format I 0x2001]\
	LCONStopAlarm       [binary format I 0x2002]\
	LCONStopAlarmFail   [binary format I 0x2003]\
	LCONLineState       [binary format I 0x2004]\
	LCONLineStateFail   [binary format I 0x2005]\
	LCONLoopback        [binary format I 0x2006]\
	LCONLoopbackFail    [binary format I 0x2007]\
	LCONLineStateRefresh [binary format I 0x2010]\
	LCONAlarmRefresh     [binary format I 0x2011]\
	LCONLoopbackRefresh  [binary format I 0x2012]\
]

foreach name [array names AppEvents] {
    set transAppEvent($AppEvents($name)) $name
    set decodeAppEvent($name) DecodeNOP
}

array set decodeAppEvent [list \
	NumLines DecodeInt8\
	LineType DecodeLineType\
	ProtocolType DecodeProtocolType\
	NumChans DecodeInt8\
	LaunchApp DecodeString\
	ClusterMode DecodeInt8\
	CmdSetChanState     DecodeChanState \
	CmdResetLineDevice  DecodeChanState \
	CmdMakeCall         DecodeMakeCall \
	CmdDialDigits       DecodeDialDigits \
	CmdDrop             DecodeCallId\
	CmdRelease          DecodeCallId\
	CmdAnswer           DecodeCallId\
	CmdAccept           DecodeCallId\
	CmdProceed          DecodeCallId\
	CmdReject           DecodeCallId\
	CmdRedirect         DecodeCallId\
	CmdHold             DecodeCallId\
	CmdRetrieve         DecodeCallId\
	CmdReconnect        DecodeCallId\
	CmdInitTransfer     DecodeInitTransfer\
	CmdBlindTransfer    DecodeBlindTransfer\
	CmdCancelTransfer   DecodeCallId\
	CmdCompleteTransfer DecodeCallId\
	CmdSendISDN         DecodeCallId\
	CmdComplete         DecodeCallId\
	CmdCancelComplete   DecodeCallId\
	CmdPark             DecodeParkId\
	CmdPickup           DecodeParkId\
	CmdAttachMedia      DecodeInt32\
	LCONLineStateRefresh DecodeInt32 \
	LCONAlarmRefresh DecodeAlarmState \
	LCONSendAlarmFail DecodeAlarm \
	LCONSendAlarm DecodeAlarm \
	LCONStopAlarmFail DecodeAlarm \
	LCONStopAlarm DecodeAlarm \
	LCONLineStateFail DecodeServiceState \
	LCONLineState DecodeServiceState \
	LCONLoopbackFail DecodeLoopback \
	LCONLoopback DecodeLoopback \
	LCONLoopbackRefresh DecodeLoopback \
]

array set transMsgEvent [list \
	$LineState_AllService LineStateChange \
	$TSC_EvtChanState_Type_Active ChanStateChange \
	$AllAlarms AlarmStateChange \
	$TSC_EvtCallState_Type_Null CallStateChange\
	$TSC_EvtCallInfoSet_Type_CallInfoSet CallInfoSet\
	$TSC_EvtCallInfo_Type_CalledId CalledId\
	$TSC_EvtCallInfo_Type_CallerId CallerId\
	$TSC_EvtCallInfo_Type_CallAnalysis CallAnalysis\
	0x126b CallControl \
	0x20 Signal \
	0x21 Transition \
]



array set decodeMsgEvent [list \
	$LineState_AllService DecodeServiceState \
	$TSC_EvtChanState_Type_Active DecodeEvtChanState \
	$AllAlarms DecodeAlarmState \
	$TSC_EvtCallState_Type_Null DecodeEvtCallState \
	$TSC_EvtCallInfoSet_Type_CallInfoSet DecodeCallInfoset\
	$TSC_EvtCallInfo_Type_CalledId DecodeCalledId\
	$TSC_EvtCallInfo_Type_CallerId DecodeCallerId\
	$TSC_EvtCallInfo_Type_CallAnalysis DecodeCallAnalysis\
	0x126b DecodeCallControl \
	0x20 DecodeSignal \
	0x21 DecodeTransition \
]


proc DecodeNOP { data } {
    return {}
}

proc DecodeInt8 { data } {
    binary scan $data c int
    return $int
}

proc DecodeInt32 { data } {
    binary scan $data I int
    return $int
}

proc DecodeLineType { data } {
    binary scan $data c int
    switch $int {
	0 { return "T1(D4)" }
	1 { return "T1(ESF)" }
	2 { return "E1(No CRC)" }
	3 { return "E1(CRC)" }
	4 { return "Analog" }
	default {
	    return $int
	}
    }
}

proc DecodeProtocolType { data } {
    binary scan $data c int
    switch $int {
	4 {
	    return CAS
	}
	5 {
	    return ISDN
	}
	6 {
	    return ClearChannel
	}
	default {
	    return $int
	}
    }
}
	
proc DecodeString { data } {
    binary scan $data a* str
    return [StripStringNulls $str]
}

proc DecodeAlarm { data } {
    global alarmTrans
    binary scan $data I alarm
    return $alarmTrans([format 0x%x $alarm])
}

proc DecodeAlarmState { data } {
    global alarmTrans
    binary scan $data II alarm state
    if {$state} {
	return "$alarmTrans([format 0x%x $alarm]) Active"
    } else {
	return "$alarmTrans([format 0x%x $alarm]) Inactive"
    }
}

proc DecodeServiceState { data } {
    binary scan $data I state
    if {$state} {
	return "In Service"
    } else {
	return "Out Of Service"
    }
}

proc DecodeLoopback { data } {
    binary scan $data I mode
    switch $mode {
	0 { return "Loopback Off" }
	1 { return "Payload Loopback" }
	2 { return "Line Loopback" }
	3 { return "Digital Loopback" }
	4 { return "Metallic Loopback" }
	default { return "Unknown loopback $mode"}
    }
}

proc DecodeChanState { data } {
    binary scan $data I chanstate
    switch [format 0x%x $chanstate] {
	0x100 { return "Inservice" }
	0x101 { return "OutOfService" }
	0x102 { return "FinishCalls" }
	default { return "Unknown [format 0x%x $chanstate]" }
    }
}

proc DecodeMakeCall { data } {
    binary scan $data a64a64c destaddr origaddr callprog
    return "DestAddr: [StripStringNulls $destaddr] OrigAddr: [StripStringNulls $origaddr] CallProgress: $callprog"
}

proc DecodeDialDigits { data } {
    binary scan $data Ia64 callid dialstr
    return "CallId: [format 0x%x $callid] DialAddr: [StripStringNulls $dialstr]"
}

proc DecodeCallId { data } {
    binary scan $data I callid
    return "CallId: [format 0x%x $callid]"
}

proc DecodeParkId { data } {
    binary scan $data Ia64 parkid parkaddr
    return "ParkId: [format 0x%x $parkid] ParkAddr: [StripStringNulls $parkaddr]"
}

proc DecodeInitTransfer { data } {
    binary scan $data Ia64c callid destaddr callprogress
    return "CallId: $callid DestAddr: [StripStringNulls $destaddr] CallProgress: $callprogress"
}

proc DecodeBlindTransfer { data } {
    binary scan $data Ia64a64c callid destaddr origaddr callprogress
    return "CallId: $callid DestAddr: [StripStringNulls $destaddr] OrigAddr: [StripStringNulls $origaddr] CallProgress: $callprogress"
}


proc DecodeEvtChanState { data type } {
    global transChanState
    binary scan $data I chanstate
    return $transChanState([format 0x%x $chanstate])
}

proc DecodeEvtCallState { data type } {
    global transCallState
    binary scan $data III callid callstate reason
    if {$type} {
	return $transCallState([format 0x%x $callstate])
    } else {
    return "CallId: [format 0x%x $callid] CallState: $transCallState([format 0x%x $callstate]) / [format 0x%x $reason]"
    }
}

proc DecodeCallerId { data type } {
    if {$type} {
        return CallerId
    } else {
        return [DecodeString $data]
    }
}

proc DecodeCalledId { data type } {
    if {$type} {
        return CalledId
    } else {
        return [DecodeString $data]
    }
}

proc DecodeCallAnalysis { data type } {
    if {$type} {
        return CallAnalysis
    } else {
        return [DecodeInt32 $data]
    }
}

proc DecodeCallInfoset { data type } {
    if {$type} {
        return CallInfo
    } else {
        return [DecodeInt32 $data]
    }
}

proc DecodeCallControl { data type } {
    global transAPIMsg
    binary scan $data Ia* msgType data
    set msg [format 0x%x $msgType]
    if {[info exists transAPIMsg($msg)]} {
	set msg $transAPIMsg($msg)
    }
    if {$type} {
	return $msg
    } else {
	return [StripStringNulls "$msg: $data"]
    }
}

proc DecodeSignal { data type } {
    binary scan $data cI dir id
    set id [format 0x%x $id]
    if {$type} {
	return "$dir $id"
    } else {
	return "Dir: $dir Signal: $id"
    }
}

proc DecodeTransition { data type } {
    binary scan $data ccc dir pre post
    set pre [format 0x%x $pre]
    set post [format 0x%x $post]
    if {$type} {
	return "$dir $pre $post"
    } else {
	return "Dir: $dir Pre: $pre Post: $post"
    }
}

proc StripStringNulls { str } {
    return [string map "\0 {}" $str]
}

#### graphical logging stuff
  set canvas_width	500
  set canvas_height	300
  set canvas_time_sec	1200
  set pixels_per_sec	100

  set compress_time_sec	1
  set event_label_space 1/2
  set scroll_lock	1
  set event_line_width	1
  set bit_line_width	2
  set font_size		10
  set font_name		helvetica
  set font_weight	bold
  set font_style	r
# colors
  set color(BIT_A)	blue
  set color(BIT_B)	yellow
  set color(BIT_C)	red
  set color(BIT_D)	green
  set color(CAS_TO)	deepskyblue
  set color(CAS_FROM)	blue
  set color(CCS_TO)	deepskyblue
  set color(CCS_FROM)	blue
  set color(TSC_STATE)	red
  set color(TSC_INFO)	purple
  set color(TSC_CNTRL)	orange
  set color(TSC_CHANSTATE) yellow
  set color(TIME_E)	white
  set color(TIME_D)	yellow
  set color(PSTN_CMD)   green
  set color(UNKNOWN)    grey
set pixels_per_msec [expr ${pixels_per_sec}e+0 / 1000]
set compress_time_msec [expr ${compress_time_sec}e+0 * 1000]

set font -*-$font_name-$font_weight-$font_style-normal-*-$font_size-*-*-*-*-*-*-*

set canvas_max_width [expr [expr $canvas_time_sec * $pixels_per_sec]]
set canvas_region [list 0 0 $canvas_max_width $canvas_height]



proc DisplayGeneralHelp {} {
    toplevel .help2
    text .help2.text -yscrollcommand ".help2.yscroll set" -width 60 \
	    -wrap word -height 20
    scrollbar .help2.yscroll -orient vertical -command ".help2.text yview"
    button .help2.ok -text "Dismiss" -command "destroy .help2"

    grid .help2.text .help2.yscroll -sticky ns
    grid .help2.ok - -sticky ew

    set buf \
{== General Information
The PSTN Diagnostics tool provides monitoring of and command interaction with hardware products based on the DM3 architecture.

== Menus
The File menu contains the following menu options:
  Open log file
    Opens a previously saved log file and allow viewing of the contents in graphical format and text format.

  Exit
    Exits the tool.

The Log menu contains the following menu options:
  View running log
    Displays the current log file in a window.

  Logging active
    Enables logging. The default setting is logging enabled. To disable logging, you can either click the menu item or use the "-nolog" option at the command line.

The View menu contains the following menu options:
  Open system view
    Opens a system level view.

  Open new view
    Opens a board, trunk, or channel level view.

The Help menu contains the following menu options:
  About
    Displays the version number of the pstndiag tool as well as copyright information.
  General information
    Displays this help information.
  Command line
    Displays help information for command line options.

== Views
The PSTN Diagnostics tool is based on views.  At any one time, there can be 2 views visible simultaneously - the upper pane and lower pane.  The two view buttons under the main menu indicate which views are currently visible on each pane.  One can left click on the view button to select a different view.  One can right click on the view button to close the active view for that pane.

Views can be opened from the system view or from the View|Open new view menu item.

The System View provides an overview of all downloaded boards in the system.  It shows the number of trunks per board and number of channels per trunk.  Information is listed as <b>.<t>.<c> where <b> is board, <t> is trunk, and <c> is channel.   Double clicking on an item will open a view of that item in the upper pane.  Shift-double clicking will open the view in the lower pane.

The Board View provides information on the service state and alarms for all trunks on the board.

The Trunk View provides advanced alarm information for the particular trunk in addition to the basic information provided by board view.  It also provides access to the external ISDNTrace and CASTrace tools.

The Channel View provides channel level information such as Call State and Channel State.  The Channel View is divided into 4 sub-panes.  
The left pane shows basic trunk information.  
The upper center pane shows various information fields and call parameters.  The different fields may be toggled by clicking on the button at the top of the pane.  
The lower center pane shows various commands that can be sent to the firmware.  Like with the information pane, different commands can be presented by clicking on the button at the top of the pane. 
The right pane shows logging information.  One can switch between text information and graphical information by clicking on the button at the top of the pane.

The Log View shows overall logging for all open views.  Note that this differs from the Channel View in that the Channel View log shows only events for that specific channel.

For more detailed information, please refer to the "Intel(r) NetMerge Call Manager Software Package User Guide."
}

    .help2.text insert end $buf

    .help2.text configure -state disabled
    wm title .help2 "PSTNDiag Help"
    raise .help2
}


