/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
////
//  FILE:         heb_interface.h
//
//  DESCRIPTION:  Defines the driver interface for HMP-enabled boards that
//                support the HMP 2.0 Licensing.
//
////


#ifndef __HEB_INTERFACE__
#define __HEB_INTERFACE__




////
//  Drivers that support the HEB Licensing interface must export the following
//  GUID which allows clients to query the OS for devices that support this
//  interface through the Plug and Play Manager.
////
#ifdef DEFINE_GUID

// {5D8FB154-D825-4d49-A756-6BC6871A2C49}
DEFINE_GUID(GUID_DEVINTERFACE_INTEL_HEB_LICENSING,
0x5d8fb154, 0xd825, 0x4d49, 0xa7, 0x56, 0x6b, 0xc6, 0x87, 0x1a, 0x2c, 0x49);

#endif




////
//  Magic Numbers
////
#define MAX_DONGLE_ID_LENGTH        ( 32 )




////
//  Structures for HEB_GET_DONGLE_ID_IOCTL
////
typedef struct
{
	unsigned int  logicalId; // 32-bit ID passed by admin component to ID board
	unsigned int time;      // Time (in ms) since the system was rebooted
}
HEB_GET_DONGLE_ID_INPUT, *PHEB_GET_DONGLE_ID_INPUT;


typedef struct
{
	unsigned int blockSize;                 // Length of encrypted key (in bytes)
	unsigned int key[MAX_DONGLE_ID_LENGTH]; // Encrypted Key and Data
}
HEB_GET_DONGLE_ID_OUTPUT, *PHEB_GET_DONGLE_ID_OUTPUT;




////
//  Generic Macro to build Windows I/O Control codes using some default values
////
#if defined( _WIN32 ) || defined( WIN32 ) || defined( __WINDOWS__ )

    #define HEB_IOCTL_PACK_CODE( Dev, Code )       ( CTL_CODE( Dev, Code | 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS ))

#else

	#if defined( KMBC_USER_MODE )
		#include <sys/ioctl.h>
	#else
		#include <linux/ioctl.h>
	#endif

	#define HEB_IOCTL_PACK_CODE( Dev, Code )       ( _IO( Dev, Code ))

#endif  // #if defined( KMBC_TARGET_WIN32 )




////
//  Define IOCTLs for the HEB Licensing Driver Interface
////
#define FILE_DEVICE_HEB             0x52
#define HEB_GET_DONGLE_ID_IOCTL     HEB_IOCTL_PACK_CODE( FILE_DEVICE_HEB, 0x801 )


#endif	// __HEB_INTERFACE__
