/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2013 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdmacro.h
 * Description                  : Macro Definations
 *
 *
 **********************************************************************/

#ifndef _MDMACRO_
#define _MDMACRO_

#define MD_SET_MDMSG_BIND_HANDLE(msg,bind) \
	msg->MessageAddress.Bind.BindHandle = bind

#define MD_GET_MDMSG_BIND_HANDLE(msg) \
	msg->MessageAddress.Bind.BindHandle 

#define MD_SET_MDMSG_STREAM_HANDLE(msg,stream) \
	msg->MessageAddress.StreamHandle= stream

#define MD_GET_MDMSG_STREAM_HANDLE(msg) \
	(msg->MessageAddress.StreamHandle)

#define MD_EXTRACT_MDMSG_FROM_STRMMSG(msg) ((PMDRV_MSG)(msg->b_rptr))

#define MD_CONVERT_MDMSG_TO_MDMSG32(MdMsg, MdMsg32) { \
	(MdMsg32->MessageAddress.Bind.BindHandle = MdMsg->MessageAddress.Bind.BindHandle); \
	(MdMsg32->MessageAddress.Bind.UserContext = MdMsg->MessageAddress.Bind.UserContext); \
	(MdMsg32->MessageFlags = MdMsg->MessageFlags); \
	(MdMsg32->MessageClass = MdMsg->MessageClass); \
	(MdMsg32->MessageId = MdMsg->MessageId); \
	(MdMsg32->MessagePtr = MdMsg->MessagePtr); \
}

#define MD_CONVERT_MDMSG32_TO_MDMSG(MdMsg32, MdMsg) { \
	(MdMsg->MessageAddress.Bind.BindHandle = MdMsg32->MessageAddress.Bind.BindHandle); \
	(MdMsg->MessageAddress.Bind.UserContext = (void *)((merc_ulong_t)MdMsg32->MessageAddress.Bind.UserContext)); \
	(MdMsg->MessageFlags = MdMsg32->MessageFlags); \
	(MdMsg->MessageClass = MdMsg32->MessageClass); \
	(MdMsg->MessageId = MdMsg32->MessageId); \
	(MdMsg->MessagePtr = MdMsg32->MessagePtr); \
}

#define MD_ADJUST_LEN (sizeof(MDRV_MSG) - sizeof(MDRV_MSG32));

#define MD_GET_MDMSG_PAYLOAD(msg) ((PMDRV_MSG)msg+1)

#define MD_MAP_BIND_TO_OPEN_CONTEXT(BindHandle) \
	(MsdControlBlock->pbind_block_list[BindHandle]->popen_block)

#define MD_MAP_BINDBLOCK_TO_OPEN_CONTEXT(BindBlock) \
	((BindBlock)->popen_block)

#define MD_MAP_BIND_TO_USER_CONTEXT(BindHandle) \
	(MsdControlBlock->pbind_block_list[BindHandle]->UserContext)

#define MD_GET_MDMSG_CLASS(msg) (msg->MessageClass)

#define MD_SET_MDMSG_CLASS(msg,class) (msg->MessageClass = class)

#define MD_GET_MDMSG_SUBCLASS1(msg) (msg->MessageId & MD_SUBCLASS1_MASK)

#define MD_GET_MDMSG_SUBCLASS2(msg) (msg->MessageId & MD_SUBCLASS2_MASK)

#define MD_GET_MDMSG_ID(msg) (msg->MessageId)

#define MD_SET_MDMSG_ID(msg,id) (msg->MessageId = id)

#define MD_SET_MDMSG_USER_CONTEXT(msg,Context) \
		(msg->MessageAddress.Bind.UserContext = Context)

#define MD_GET_NEXT_SEQUENCE_FOR_STREAM(AdapterBlock,StreamId,Sequence) { \
		MSD_ASSERT(AdapterBlock->StreamIdMapTable[StreamId]); \
		Sequence=AdapterBlock->StreamIdMapTable[StreamId]->BlockSequence++; \
	}

#define MD_IS_MSG_ASYNC(msg) \
		(((PMDRV_MSG)(msg->b_rptr))->MessageFlags & MD_MSG_FLAG_ASYNC)
		
#define MD_IS_MSG_SYNC(msg) \
		(((PMDRV_MSG)(msg->b_rptr))->MessageFlags & MD_MSG_FLAG_SYNC)
		
#define MD_IS_MSG_NO_ACK(msg) \
		(((PMDRV_MSG)(msg->b_rptr))->MessageFlags & MD_MSG_FLAG_NO_ACK)
		
#define MD_IS_MSG_NACK(msg) \
		(((PMDRV_MSG)(msg->b_rptr))->MessageFlags & MD_MSG_FLAG_NACK)
		
#define MD_SET_MSG_NACK(msg) \
		(((PMDRV_MSG)(msg->b_rptr))->MessageFlags |= MD_MSG_FLAG_NACK)
		

#define MD_SET_MSG_B_CONT(msg,ptr)  (msg->b_cont = ptr)

#define MD_GET_MSG_B_CONT(msg)  (msg->b_cont)

#define MD_GET_MSG_READ_PTR(msg) (msg->b_rptr)

#define MD_SET_MSG_READ_PTR(msg,ptr) (msg->b_rptr = (ptr))

#define MD_GET_MSG_WRITE_PTR(msg) (msg->b_wptr)

#define MD_SET_MSG_WRITE_PTR(msg,ptr) (msg->b_wptr = (ptr))

#define MD_GET_MSG_DATABUF_SIZE(msg) \
	(msg->b_datap->db_lim - msg->b_datap->db_base)

#define MD_GET_MSG_DATABUF_LIMIT(msg) \
	(msg->b_datap->db_lim) 

#define MD_SET_MSG_TYPE(msg,type) \
	msg->b_datap->db_type = type

#define MD_GET_MSG_TYPE(msg) \
	(msg->b_datap->db_type)

#define MD_GET_MSG_SIZE(msg) \
	(msg->b_wptr - msg->b_rptr)

#define MSD_DRIVER_STATE_CHECK(state) { \
	if (!(MsdControlBlock->MsdState & state)) { \
		ErrorCode = CD_ERR_BAD_STATE; \
		ReturnValue = MsdControlBlock->MsdState; \
		goto out; \
	} \
}

// Define Driver State Checking and Return Message Size checking micros

#define MSD_RETURN_MSG_SIZE_CHECK(MsgSize, type, where) { \
	if(MsgSize < sizeof(type) || MsgSize < sizeof(MD_ACK)) { \
		MSD_ERR_DBGPRINT("mercd:%s:Return msg too small  (%d < %d, %d).", \
				where, MsgSize, sizeof(type), sizeof(MD_ACK)); \
		ErrorCode = CD_ERR_BAD_MSG_SIZE; \
		ReturnValue = MsgSize; \
		goto out; \
	} \
}

// Macro defination for cheching the SRAM Address
#define CHECK_SRAM_ADDRESS(addr, cPtr, padatpter ) { \
	if ( ((merc_ulong_t)addr < (padapter->phost_info->reg_block.HostRamStart)) || \
	     ((merc_ulong_t)addr > (padapter->phost_info->reg_block.ClrMsgReadyIntr)) )\
	{ \
		MSD_ERR_DBGPRINT("================================================\n"); \
		MSD_ERR_DBGPRINT("Mercury Kernel Shared RAM Corrupted!\n"); \
		MSD_ERR_DBGPRINT("%s\n", cPtr); \
		MSD_ERR_DBGPRINT("Marking Board number %d INOPERABLE\n", \
				padapter->phw_info->slot_number); \
		MSD_ERR_DBGPRINT("=================================================\n"); \
		padapter->state = MERCD_ADAPTER_STATE_OUT_OF_SERVICE; \
		return(MD_FAILURE); \
	} \
}
 
#define CHANGE_ADAPTER_STATE(x){ \
		MSD_ERR_DBGPRINT("AdapterState Chaged from %x\n",AdapterBlock->state); \
		AdapterBlock->state = x; \
		MSD_ERR_DBGPRINT("Changed to %x\n",AdapterBlock->state); \
	}


#if defined( MERCD_LINUX )
#	define	MSD_SYSTEM_TICK jiffies
#else 
#	define	MSD_SYSTEM_TICK lbolt
#endif

// Macros for clean up
#define DM3_SETUP_MSDCONTROLBLOCK(MsdControlBlock) \
   { \
      mercd_zalloc(MsdControlBlock->padapter_block_list, pmercd_adapter_block_sT *, MERCD_ADAPTER_BLOCK_LIST); \
      mercd_zalloc(MsdControlBlock->pbind_block_list, pmercd_bind_block_sT *, MERCD_INITIAL_BIND_BLOCK_LIST); \
      mercd_zalloc(MsdControlBlock->pbind_free_block_list, pmercd_bind_block_sT *, sizeof(pmercd_bind_block_sT)*(MSD_MAX_BINDTOBE_FREED_INDEX+1)); \
      mercd_zalloc(MsdControlBlock->popen_block_queue, pmercd_open_block_sT *, MERCD_INITIAL_OPEN_BLOCK_LIST); \
      mercd_zalloc(MsdControlBlock->popen_free_block_queue, pmercd_open_block_sT *, (MSD_MAX_OPENTOBE_FREED_INDEX+1) * sizeof(pmercd_open_block_sT)); \
      MsdControlBlock->maxbind = MSD_INITIAL_MAX_BIND; \
      MsdControlBlock->maxopen = MSD_INITIAL_OPEN_ALLOWED; \
      MsdControlBlock->open_block_count = 0; \
      MsdControlBlock->OpenFreeIndex=0; \
      MsdControlBlock->BindFreeIndex=0; \
      for (i=0;i<MSD_MAX_BOARD_ID_COUNT;++i) { \
           mercd_adapter_map[i] = 0xFF; \
           mercd_adapter_log_to_phy_map_table[i] = 0xFF; \
           MsdControlBlock->padapter_block_list[i] = NULL; \
      } \
      for (i=0;i<MsdControlBlock->maxbind;++i) { \
           MsdControlBlock->pbind_block_list[i] = NULL; \
      } \
      MsdControlBlock->MsdState  = MERCD_CTRL_BLOCK_INIT; \
   }

#define DM3_ALLOC_PADAPTER(padapter) \
   { \
      mercd_zalloc(padapter, pmercd_adapter_block_sT, MERCD_ADAPTER_BLOCK); \
      if (!padapter) { \
          printk("linux_pci_drvr_probe: Unable to allocate memory for padpater\n"); \
          return; \
      } \
      mercd_zalloc(padapter->phw_info, pmercd_hw_info_sT, MERCD_HW_INFO); \
      if (!padapter->phw_info) { \
          mercd_free(padapter, MERCD_ADAPTER_BLOCK, MERCD_FORCE); \
          printk("linux_pci_drvr_probe: Unable to allocate memory for phw_info\n"); \
	  padapter = NULL; \
          return; \
      } \
      mercd_zalloc(padapter->phost_info, pmercd_host_info_sT, MERCD_HOST_INFO); \
      if (!padapter->phost_info) { \
          mercd_free(padapter->phw_info, MERCD_HW_INFO, MERCD_FORCE); \
          mercd_free(padapter, MERCD_ADAPTER_BLOCK, MERCD_FORCE); \
          printk("linux_pci_drvr_probe: Unable to allocate memory for phost_info\n"); \
	  padapter = NULL; \
          return; \
      } \
      mercd_zalloc(padapter->phw_info->timer_info, pmercd_timer_info_sT, MERCD_TIMER_INFO); \
      if (!padapter->phw_info->timer_info) { \
          mercd_free(padapter->phost_info, MERCD_HOST_INFO, MERCD_FORCE); \
          mercd_free(padapter->phw_info, MERCD_HW_INFO, MERCD_FORCE); \
          mercd_free(padapter, MERCD_ADAPTER_BLOCK, MERCD_FORCE); \
          printk("linux_pci_drvr_probe: Unable to allocate memory for timer_info\n"); \
	  padapter = NULL; \
          return; \
      } \
      mercd_zalloc(padapter->pstream_connection_list, pmerc_void_t *, MERCD_STREAMS_BLOCK_LIST); \
      if (!padapter->pstream_connection_list) { \
          mercd_free(padapter->phw_info->timer_info, MERCD_TIMER_INFO, MERCD_FORCE); \
          mercd_free(padapter->phost_info, MERCD_HOST_INFO, MERCD_FORCE); \
          mercd_free(padapter->phw_info, MERCD_HW_INFO, MERCD_FORCE); \
          mercd_free(padapter, MERCD_ADAPTER_BLOCK, MERCD_FORCE); \
          printk("linux_pci_drvr_probe: Unable to allocate memory for pstream_connection_list\n"); \
	  padapter = NULL; \
          return; \
      } \
   }

#define DM3_INIT_MUTEX(padapter) \
   { \
      MSD_INIT_MUTEX(&padapter->adapter_block_mutex, "Adapter Block Mutex", NULL); \
      MSD_INIT_MUTEX(&padapter->snd_msg_mutex, "Send Msg Mutex", NULL); \
      MSD_INIT_MUTEX(&padapter->snd_data_mutex, "Send Data Mutex", NULL); \
      MSD_INIT_MUTEX(&padapter->stream_connection_mutex, "Stream Connection Mutex", NULL); \
      MSD_INIT_MUTEX(&padapter->phw_info->timer_info->timer_flag_mutex, " Timer Flag Mutex ", NULL); \
      MSD_INIT_MUTEX(&padapter->hsiIntrMutex, "HSI Interrupt Mutex", NULL); \
   }

// Some BIOS set the max payload size register to 128 bytes
// for the Direct Master(DM) read.  This register value
// conflicts with the Mode-A setting and the board download fails.
// Set the max paylod to 512 bytes via PCIe control register offset.
#define DM3_SEAVILLE_CHIP_SETUP(padapter) \
   { \
      padapter->phw_info->seaville_chip = 1; \
      pci_read_config_word(padapter->pdevi, PCI_EXPRESS_CONTROL_REG_OFFSET, &Register); \
      Register &= 0xFFFF8FFF; \
      Register |= 0x2000; \
      pci_write_config_word(padapter->pdevi, PCI_EXPRESS_CONTROL_REG_OFFSET, Register); \
   }

// Pacific Chip boards have a problem with BIOS Post Configuration
// where the eeprom burned to 1 on certain BIOS will habg the machine.
// All Pacific Chip boards will be burned to 0 as default and the
// driver will set the LAS0BA and LAS1BA registers to 1 to enable
// decoding to local address spaces 0 and 1.
#define DM3_PACIFIC_CHIP_SETUP(padapter) \
   { \
      padapter->phw_info->pacific_chip = 1; \
      Paddr = pci_resource_start(pdrvr->pdevi, 0); \
      Vaddr = (merc_uint_t)ioremap((size_t)Paddr, PCI_BASE_ADDRESS_0); \
      PacificReg = *((volatile merc_uchar_t *)(Vaddr +  0x04 )); \
      PacificReg |= 0x1; \
      *((volatile merc_uchar_t *)(Vaddr +  0x04 )) = PacificReg; \
      PacificReg = *((volatile merc_uchar_t *)(Vaddr +  0xF4 )); \
      PacificReg |= 0x1; \
      *((volatile merc_uchar_t *)(Vaddr +  0xF4 )) = PacificReg; \
      iounmap((void *)Vaddr); \
   }

#define DM3_CONFIG_PCI_EXPRESS(padapter) \
   { \
      padapter->phw_info->typePCIExpress = 0; \
      pci_read_config_dword(padapter->pdevi, PCI_CAPABILITY_LIST_REG_OFFSET, &CListOffset); \
      while (CListOffset) { \
         /* Get to the end of the capability list to determine if the board is PCIe */ \
         pci_read_config_dword(padapter->pdevi, CListOffset, &NextCListOffset); \
         CurrOffset = CListOffset; \
         CListOffset = (NextCListOffset&PCI_CAPABILITY_LIST_OFFSET_MASK) >> PCI_CAPABILITY_LIST_OFFSET; \
         NextCListOffset &= PCI_CAPABILITY_TYPE_MASK; \
         /* Check for PCIe board */ \
         if (NextCListOffset == PCI_EXPRESS_CAPABILITY) { \
             /* Get all the Power Status Values located in the register after the capability list */ \
             CurrOffset += 0x4; \
             pci_read_config_dword(padapter->pdevi, CurrOffset, &PowerProvided); \
             if (PowerProvided != 0xFFFFFFFF) { \
                 /* Get the power scale and limit values to determine actual power provided */ \
                 PowerScale = (PowerProvided & PCI_EXPRESS_POWER_SCALE_MASK) >> PCI_EXPRESS_POWER_SCALE_OFFSET; \
                 PowerLimit = (PowerProvided & PCI_EXPRESS_POWER_LIMIT_MASK) >> PCI_EXPRESS_POWER_LIMIT_OFFSET; \
                 switch (PowerScale) { \
                    case 0x01: padapter->phw_info->actualPowerProvided = PowerLimit/10; break; \
                    case 0x10: padapter->phw_info->actualPowerProvided = PowerLimit/100; break; \
                    case 0x11: padapter->phw_info->actualPowerProvided = PowerLimit/1000; break; \
                    default:   padapter->phw_info->actualPowerProvided = PowerLimit; break; \
                 } \
             } else { \
                 printk("Error: Unable to read Power Status Registers on PCIe board at %#x\n", CurrOffset); \
                 padapter->phw_info->actualPowerProvided = 0xFFFFFFFF; \
             } \
             /* Read the power good value and calculate the power required by the board */ \
             CurrOffset=SEAVILLE_POWER_GOOD_REG_OFFSET; \
             padapter->phw_info->powerRequiredByBoard = 0x0; \
             Paddr = pci_resource_start(pdrvr->pdevi, 0); \
             Vaddr = (merc_ulong_t)ioremap((size_t)Paddr, PCI_BASE_ADDRESS_0); \
	     for (j=0; j<4; j++) { \
                  PowerProvided =  *(volatile ULONG * const)(Vaddr+CurrOffset); \
                  if (PowerProvided & SEAVILLE_POWER_BUDGETTING_REG_USED) { \
                      /* Need to add all 4 up to calculate the required voltage */ \
                      padapter->phw_info->powerRequiredByBoard+= (PowerProvided & SEAVILLE_POWER_WATTAGE_READ_MASK); \
                  } \
                  /* Save the power good value from the first read */ \
                  if (!j) { \
                      padapter->phw_info->powerGoodReg = (PowerProvided & SEAVILLE_POWER_GOOD_MASK) >> SEAVILLE_POWER_GOOD_OFFSET; \
                  } \
                  CurrOffset += 0x4; \
             } \
             /* Read in the User Override Power Management value */ \
             CurrOffset=SEAVILLE_USER_OVERRIDE_POWER_REG_OFFSET; \
             PowerProvided =  *(volatile ULONG * const)(Vaddr+CurrOffset); \
             padapter->phw_info->powerOverrideReg = (PowerProvided & SEAVILLE_USER_OVERRIDE_POWER_MASK) >> SEAVILLE_USER_OVERRIDE_POWER_OFFSET; \
             MSD_LEVEL2_DBGPRINT("DrvProbe: Found PCIe - actualPower %#x, powerReq %#x, powerGood %#x, powerOverride %#x\n", padapter->phw_info->actualPowerProvided, padapter->phw_info->powerRequiredByBoard, padapter->phw_info->powerGoodReg, padapter->phw_info->powerOverrideReg); \
             CListOffset = 0; \
             iounmap((void *)Vaddr); \
             padapter->phw_info->typePCIExpress = 1; \
         } \
      } \
   }

#define DM3_RH_SLOT_SETUP(padapter) \
   { \
      /* Static table entry for ZT-5085 RH */ \
      switch ((padapter->phw_info->bus_number << 8 | padapter->phw_info->slot_number) & 0x0000ffff) { \
         case 0x209:  padapter->phw_info->slot_number = 3;  break; \
         case 0x20a:  padapter->phw_info->slot_number = 4;  break; \
         case 0x20b:  padapter->phw_info->slot_number = 5;  break; \
         case 0x20c:  padapter->phw_info->slot_number = 6;  break; \
         case 0x20d:  padapter->phw_info->slot_number = 7;  break; \
         case 0x20e:  padapter->phw_info->slot_number = 8;  break; \
         case 0x40e: \
         case 0x150e: padapter->phw_info->slot_number = 13; break; \
         case 0x40d: \
         case 0x150d: padapter->phw_info->slot_number = 14; break; \
         case 0x40c: \
         case 0x150c: padapter->phw_info->slot_number = 15; break; \
         case 0x40b: \
         case 0x150b: padapter->phw_info->slot_number = 16; break; \
         case 0x40a: \
         case 0x150a: padapter->phw_info->slot_number = 17; break; \
         case 0x409: \
         case 0x1509: padapter->phw_info->slot_number = 18; break; \
         default: \
              printk("Non ZT-5085 Chassis\n"); \
              LocatorId = MsdRegReadUchar(padapter->phw_info->virt_map_q[MERCD_PCI_SRAM_MAP]->virt_addr+PCI_CR_OFFSET_LOCATOR_ID); \
              if (LocatorId != 0xFF) { \
                  LocatorId &= 0x1F; \
                  padapter->phw_info->slot_number = (LocatorId & 0xFF); \
              } \
              break; \
      } \
   }
   
#define be2h(v) ((v << 24) | ((v << 8) & 0xff0000) | ((v >> 8) & 0xff00) | (v >> 24))
#define rmwl(adr, clr, set) \
   { \
      merc_uint_t tmp;  \
      tmp = readl(adr); \
      tmp &=~ clr;      \
      tmp |=  set;      \
      writel(tmp, adr); \
   }
#define rmw_bel(adr, clr, set) \
   { \
      merc_uint_t tmp;   \
      tmp = readl(adr);  \
      tmp &=~ be2h(clr); \
      tmp |=  be2h(set); \
      writel(tmp, adr);  \
   }

#endif
