/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdmmgr.h
 * Description                  : message mamager definitions
 *
 *
 **********************************************************************/

#define MERCD_NOT_FORCE 0
#define MERCD_FORCE 	1
#define MERCD_STREAMS_BUFFER 1
#define MERCD_KERNEL_BUFFER  0

#define mercd_free(Address, Size, Force) \
        if ((Address) == NULL) { \
        printk("DM3: mercd_free: Addr=0x%x, %s, %d\n",Address, __FILE__, __LINE__); \
        } else { \
        MSD_FREE_KERNEL_MEMORY(Address,Size); \
        (Address) = NULL; \
        }

#define mercd_allocator(Size) MSD_ALLOCATE_KERNEL_MEMORY(Size)

#ifndef	MERCD_LINUX

#define mercd_zalloc(Address, Type, Size) \
	(Address)= (Type) MSD_ALLOCATE_KERNEL_MEMORY(Size)
#else
#define mercd_zalloc(Address, Type, Size) \
	(Address)= (Type) MSD_ALLOCATE_KERNEL_MEMORY(Size);\
	if ( (Address) ) \
		MSD_ZERO_MEMORY( (Address), Size)
#endif

#define mercd_streams_free(mp, Type, Force) MSD_FREE_MESSAGE(mp)
#define mercd_streams_allocator(Size,Type, Force) allocb(Size, GFP_ATOMIC)

#ifndef LiS
// For now, define this way (aa)......
#define allocb(Size,type) 	native_allocb(Size,type)

#define freeb(mp) 		{if( native_freeb(mp) < 0 ) printk("Freeb: Line %d File %s \n", __LINE__, __FILE__);}
#define freemsg(mp) 		{if( native_freemsg(mp) < 0 ) printk("FreeMsg: Line %d File %s \n", __LINE__, __FILE__);}
#define linkb(mp1,mp2)  	native_linkb(mp1,mp2)
#define unlinkb(mp) 		native_unlinkb(mp)
#define dupb(mp)  		native_dupb(mp)
#define bcopy(src,dst,n)        memcpy(dst,src,n)
#endif
