/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef __QSTREAMTYPES_H__
#define __QSTREAMTYPES_H__
/******************************************************************************
*       FILE: qstrmapi.h
*
*
******************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

#define QMAX_BLOCKS_STREAM       5

typedef struct {
   Uint24   id;
   Uint24   mode;
   void *   gHandle;
   Uint8    head;
   Uint8    tail;
} QStreamHandleEntry;

typedef QStreamHandleEntry *QStreamHandle;


typedef struct {
   QStreamHandle  bHandle;
   Uint8          offsetIdx;
   void           *pUsrHead;
} QBufRefEntry;

typedef QBufRefEntry *QBufRef;


/*
 * The following structure is used in the bstream layer to process stream
 * reference to handle conversions (must be 11 mmdl bytes).
 */   
typedef struct {
   Uint24         openMode;      /* Mode stream was originally opened in */
   QStreamHandle  bHandle;
   Uint16         streamId;      /* */
   Uint16         pad;           /* */
} QStreamReference;

typedef QStreamReference   QStreamRef;

#ifdef __cplusplus
}
#endif

#endif /* __QSTREAMTYPES_H__ */
