/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name 			: msdsnd.c
 * Description			: Host FW Send functions
 *
 *
 **********************************************************************/

#include "msd.h"
#include "msdpciif.h"
#define _MSDSND_C
#include "msdextern.h"
#undef _MSDSND_C
extern int NewCanTakeProtocol;

/***************************************************************************
 * Function Name		: snd_msgs2adapter
 * Function Type		: Host FW Send function
 * Inputs			: 
 * Outputs			: 
 * Calling functions		:
 * Description			: Streams Driver snd_msgs2adapter Routine.
 *				  This routine sends message to adapter.
 * Additional comments		:
 ****************************************************************************/
int snd_msgs2adapter(pmercd_adapter_block_sT padapter)
{

   PMDRV_MSG               MdMsg;
   PSTRM_MSG               Msg;
   pmercury_host_info_sT   HostIfPtr;
   PMERC_CIR_BUFFER        CirBuffer= NULL;
   PMERC_HOSTIF_MSG        MercMsg;
   PMERC_DATA_BLK_HDR      KvDataBlockPtr;
   PMERC_DATA_BLK_HDR      DataBlkPtr;
   mercd_dhal_mem_copy_sT  mem_copyinfo = { 0 } ;
   pmerc_char_t            SramDataPtr;
   size_t                  NextWrite;
   size_t                  ReadIndex;
   merc_ulong_t            NextMessageAddress;
   merc_uint_t             MaxMessages;
   merc_uint_t             MsgBodySize;


   HostIfPtr=&padapter->phost_info->merc_host_info;
   CirBuffer=(PMERC_CIR_BUFFER)HostIfPtr->host_to_fw_msg_start;
   MaxMessages = padapter->phost_info->host_config.maxHostMsgs;
	
   NextWrite = CirBuffer->Write;
   ReadIndex = CirBuffer->Read;

   // If sram is corrupt, let the sanity function take care of it
   if (!(ReadIndex < MaxMessages)||!(NextWrite < MaxMessages)){
       printk("snd_msgs2adapter\n");
       msd_sram_sanity_dump(padapter);
       return(MD_FAILURE);
   }

   if ((NextWrite+1)%MaxMessages == ReadIndex)  {
#ifdef DRVR_STATISTICS
       padapter->fw_overrun_msg++;
#endif
        return(MD_FAILURE);
   }

   // get a message from the send queue
   if ((Msg = queue_get_msg_Q(&padapter->snd_msg_queue)) == NULL) {
       MSD_ERR_DBGPRINT("snd_msgs2adapter: Sendqueue empty.\n");
       return(MD_FAILURE);
   }
	                                                  
   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(Msg);
	
   // keep writing to cir buf until full 
   while (Msg && ((NextWrite+1)%MaxMessages != ReadIndex)) {
       MSD_ASSERT(Msg->b_cont);
       MercMsg = (PMERC_HOSTIF_MSG)Msg->b_cont->b_rptr;

       if (MERCURY_GET_TRANSACTION_ID(MercMsg) == 0x800000) {
           padapter->sndflowcount++;
       }
	  
       NextMessageAddress = (merc_ulong_t)HostIfPtr->host_to_fw_msg_start+
           sizeof(MERC_CIR_BUFFER)+((sizeof(MERC_HOSTIF_MSG)+MD_OLD_BODY_SIZE)*NextWrite);

       // Big message?
       if ((MsgBodySize=MERCURY_GET_BODY_SIZE(MercMsg)) > MD_OLD_BODY_SIZE) {
           // get a free data node from sram
           KvDataBlockPtr = snd_alloc_Hif_data_blk(padapter);
           if (KvDataBlockPtr == NULL) {
       	       MSD_ERR_DBGPRINT("snd_msgs2adapter:Free list empty.\n"); 
	       // put back msg to list 
	       queue_put_bk_msg_Q(&padapter->snd_msg_queue,Msg);
	       goto out;
	   }

	   DataBlkPtr=(PMERC_DATA_BLK_HDR)KvDataBlockPtr;

	   if (!DataBlkPtr->DataBlockOffset){
	       //padapter->state = MERCD_ADAPTER_STATE_OUT_OF_SERVICE;
               printk("snd_msgs2adapter: Sram Corrupt \n");
	       queue_put_bk_msg_Q(&padapter->snd_msg_queue,Msg);
	       snd_release_Hif_data_blk(padapter, (PMERC_DATA_BLK_HDR)DataBlkPtr);
	       return(MD_FAILURE);
	   }
	
 	   SramDataPtr = (pmerc_char_t)TO_KV_ADDRESS(padapter, DataBlkPtr->DataBlockOffset);
	   CHECK_SRAM_ADDRESS(SramDataPtr, "snd_msgs2adapter1", padapter);

	   mem_copyinfo.src = (pmerc_char_t)MercMsg;
	   mem_copyinfo.dest = (pmerc_char_t)SramDataPtr;
	   mem_copyinfo.size = sizeof(MERC_HOSTIF_MSG) + MsgBodySize;
	   mem_copyinfo.datatype = MSD_INT_DATA;
	   mem_copyinfo.dir = MSD_TO_SRAM;

	   (*mercd_dhal_func[MERCD_DHAL_MEM_COPY])((void *)&mem_copyinfo);

	   // Buffer data count set to body plus hdr 
	   DataBlkPtr->DataCount= sizeof(MERC_HOSTIF_MSG)+MsgBodySize;
	   DataBlkPtr->BufFlags = 0;
	   DataBlkPtr->Sequence = 0;

	   MercMsg = (PMERC_HOSTIF_MSG)NextMessageAddress;

	   // save the body start offset in the merc msg buffer field 
	   MercMsg->BodySize = TO_HIF_OFFSET(padapter,DataBlkPtr);

       } else {
	   // Small message
	   CHECK_SRAM_ADDRESS(NextMessageAddress, "snd_msgs2adapter2", padapter);

	   mem_copyinfo.src = (pmerc_char_t)Msg->b_cont->b_rptr;
	   mem_copyinfo.dest = (pmerc_char_t)NextMessageAddress;
	   mem_copyinfo.size = sizeof(MERC_HOSTIF_MSG) + MsgBodySize;
	   mem_copyinfo.datatype = MSD_INT_DATA;
	   mem_copyinfo.dir = MSD_TO_SRAM;

	   (*mercd_dhal_func[MERCD_DHAL_MEM_COPY])((void *)&mem_copyinfo);

       }

       // Trace Code: Copy the Message to the buffer (if required)
       if (padapter->flags.TraceLevelInfo & MERC_ADAPTER_FLAG_TRACE_STRUCT_ALLOCATED) {
           supp_push_trace_msg(padapter, MSD_DRV2BRD_TRACE, (PMERC_HOSTIF_MSG)(Msg->b_cont->b_rptr));
       }

       // point to next msg in the cir queue 
       NextWrite = (NextWrite+1)%MaxMessages;

       MSD_FREE_MESSAGE(Msg);

       if ((Msg = queue_get_msg_Q(&padapter->snd_msg_queue)) == NULL) {
	   // no more msgs to process
	   break;
       }
       MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(Msg);
   }

   if (Msg!=NULL && ((NextWrite+1)%MaxMessages == ReadIndex)) {
       // Full Queue in SRAM
       queue_put_bk_msg_Q(&padapter->snd_msg_queue,Msg);
   }

out:	
   CirBuffer->Write = NextWrite;
   // indicate the need for interrupting the board
   padapter->flags.LaunchIntr |=  MERC_ADAPTER_FLAG_LAUNCH_INTR;
   return(MD_SUCCESS);
}


/***************************************************************************
 * Function Name		: snd_data2adapter
 * Function Type		: Host FW Send function
 * Inputs			: 
 * Outputs			: 
 * Calling functions		:
 * Description			: Streams Driver snd_data2adapter Routine.
 *				  This routine sends data to adapter.
 * Additional comments		:
 ****************************************************************************/
int snd_data2adapter(pmercd_adapter_block_sT padapter)
{

   PSTRM_MSG                            Msg;
   PSTRM_MSG                            TmpMsg;
   PMDRV_MSG                            MdMsg;
   pmercury_host_info_sT                HostIfPtr;
   PMERC_CIR_BUFFER                     CirBuffer= NULL;
   PMERC_DATA_BLK_HDR                   KvDataBlockPtr;
   PMERC_DATA_BLK_HDR                   DataBlkPtr;
   PMERC_DATA_CIR_BUF_ENTRY             CirBufEntry= NULL;
   PSTREAM_SEND                         Ptr;
   PUSER_HEADER                         UserHeaderPtr;
   mercd_dhal_mem_copy_sT               mem_copyinfo = { 0 } ;
   size_t                               NextWrite;
   size_t                               ReadIndex;
   merc_ulong_t                         NextMessageAddress;
   pmerc_uchar_t                        MsgDataPtr;
   pmerc_char_t                         SramDataPtr;
   merc_uint_t                          SentCount=0;
   merc_uint_t                          MsgDataSize;
   merc_uint_t                          MaxMessages;
   MSD_HANDLE  				StreamHandle;
   merc_ushort_t 			Flags;
   pmercd_stream_connection_sT  	StreamBlock;


   // Before proceeding Collect the Data to be sent
   strm_gather_snd_blks(padapter);

   MSD_LEVEL2_DBGPRINT("snd_data2adapter: Msg1->b_next=%x\n",Msg->b_next);

   HostIfPtr=&padapter->phost_info->merc_host_info;
   CirBuffer = (PMERC_CIR_BUFFER) HostIfPtr->host_to_fw_data_start;
   MaxMessages = padapter->phost_info->host_config.maxHostDataXfer;

   NextWrite = CirBuffer->Write;
   ReadIndex = CirBuffer->Read;


   if ((NextWrite+1)%MaxMessages == ReadIndex)  {
#ifdef DRVR_STATISTICS
       padapter->fw_overrun_data++;
#endif
       return(MD_FAILURE);
   }	

   // If sram is corrupt, let the sanity function take care of it
   if (!(ReadIndex < MaxMessages)||!(NextWrite < MaxMessages)){
       printk("snd_data2adapter\n");
       msd_sram_sanity_dump(padapter);
       padapter->snd_data_queue= NULL;
       return(MD_FAILURE);
   }

   if ((Msg = padapter->snd_data_queue) == NULL){
       MSD_LEVEL2_DBGPRINT("snd_data2adapter: Sendqueue empty.\n"); 
       return(MD_FAILURE);
   } 

   // start sending messages and data blocks 
   while (Msg && ((NextWrite+1)%MaxMessages != ReadIndex)) {
       // Msg must have the data portion attached 
       if (!(MD_GET_MSG_B_CONT(Msg))) {
           printk("snd_data2adapter: No data porion attached in the message\n");
       }
       MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(Msg);

       // Following code is to send user ack from here
       StreamHandle = MD_GET_MDMSG_STREAM_HANDLE(MdMsg);

       Ptr= (PSTREAM_SEND)MD_GET_MDMSG_PAYLOAD(MdMsg);
       StreamBlock = padapter->pstream_connection_list[Ptr->StreamId];

       if (StreamBlock == NULL) {
	   MSD_FREE_MESSAGE(Msg);
	   padapter->snd_data_queue= NULL;
	   return(MD_FAILURE);
       }
			
       UserHeaderPtr = &Ptr->StreamUserHeader;

#ifdef SKIP 
       // No Tracing For Data yet .... VISIT LATER
       // Trace Code: Copy the Message to the buffer (if required)
       if (padapter->TraceLevel) {
 	   supp_push_trace_msg(padapter, MSD_DRV2BRD_TRACE, (PMDRV_MSG)MdMsg);
       }
#endif 

       MSD_LEVEL1_DBGPRINT("snd_data2adapter: In Outer loop.\n"); 

       while ((TmpMsg = (PSTRM_MSG)MD_GET_MSG_B_CONT(Msg)) && 
		  ((NextWrite+1)%MaxMessages != ReadIndex) &&
	          padapter->pstream_connection_list[Ptr->StreamId]) {

	   MSD_LEVEL1_DBGPRINT("snd_data2adapter: In Inner loop. TmpMsg=%x\n",TmpMsg);

	   // get a free data node from sram 
	   KvDataBlockPtr = snd_alloc_Hif_data_blk(padapter);
	   if (KvDataBlockPtr == NULL) {
	       MSD_LEVEL1_DBGPRINT("snd_data2adapter: Free list empty.\n");
	       // put back msg to list 
	       padapter->snd_data_queue = Msg;
	       goto out;
	   }
	   
	   DataBlkPtr=(PMERC_DATA_BLK_HDR)KvDataBlockPtr;
 	   if (!DataBlkPtr->DataBlockOffset) {
	       //padapter->state = MERCD_ADAPTER_STATE_OUT_OF_SERVICE;
               printk("snd_data2adapter: Null DataBlockOffset \n");
	       MSD_FREE_MESSAGE(Msg);
	       padapter->snd_data_queue= NULL;
	       return(MD_FAILURE);
	   }

	   SramDataPtr = (pmerc_char_t) TO_KV_ADDRESS(padapter, DataBlkPtr->DataBlockOffset);

	   // calculate local data block ptr and size 
	   MsgDataPtr = MD_GET_MSG_READ_PTR(TmpMsg);

	   // cannot assume data are in 4K block 
	   MsgDataSize = MD_GET_MSG_WRITE_PTR(TmpMsg) - MD_GET_MSG_READ_PTR(TmpMsg);

	   if (StreamBlock->type == STREAM_OPEN_F_GSTREAM) {
	       if (MsgDataSize > (MERCURY_HOST_IF_BLK_SIZE + sizeof(USER_HEADER)))
	 	   MsgDataSize = (MERCURY_HOST_IF_BLK_SIZE + sizeof(USER_HEADER));
	   } else {
	       if (MsgDataSize > MERCURY_HOST_IF_BLK_SIZE)
	 	   MsgDataSize = MERCURY_HOST_IF_BLK_SIZE;
	   }

	   MD_SET_MSG_READ_PTR(TmpMsg, MD_GET_MSG_READ_PTR(TmpMsg)+MsgDataSize);

 	   if ((Ptr->Flags & STREAM_FLAG_EOS) && (MsgDataSize)) {
               MSD_ERR_DBGPRINT("snd_data2adapter: Copying nothing, zero byte EOS\n");
	   } else if (StreamBlock->type == STREAM_OPEN_F_GSTREAM) {
	       CHECK_SRAM_ADDRESS(SramDataPtr, "MsdSendDataToAdapterGS", padapter);

	       mem_copyinfo.src = (pmerc_char_t)MsgDataPtr;
	       mem_copyinfo.dest = (pmerc_char_t)SramDataPtr;
	       mem_copyinfo.size = MsgDataSize;
	       mem_copyinfo.datatype = MSD_SYS_DATA;
	       mem_copyinfo.dir = MSD_TO_SRAM;
	       (*mercd_dhal_func[MERCD_DHAL_MEM_COPY])((void *)&mem_copyinfo);
	   } else {
 	       CHECK_SRAM_ADDRESS(SramDataPtr, "snd_data2adapter1", padapter);

	       mem_copyinfo.src = (pmerc_char_t)UserHeaderPtr;
	       mem_copyinfo.dest = (pmerc_char_t)SramDataPtr;
	       mem_copyinfo.size = sizeof(USER_HEADER);
	       mem_copyinfo.datatype = MSD_SYS_DATA;
	       mem_copyinfo.dir = MSD_TO_SRAM;
	       (*mercd_dhal_func[MERCD_DHAL_MEM_COPY])((void *)&mem_copyinfo);

	       CHECK_SRAM_ADDRESS((SramDataPtr + sizeof(USER_HEADER)), "snd_data2adapter2", padapter);

	       mem_copyinfo.src = (pmerc_char_t)MsgDataPtr;
	       mem_copyinfo.dest = (pmerc_char_t)(SramDataPtr + sizeof(USER_HEADER));
	       mem_copyinfo.size = MsgDataSize;
	       mem_copyinfo.datatype = MSD_SYS_DATA;
	       mem_copyinfo.dir = MSD_TO_SRAM;
 	       (*mercd_dhal_func[MERCD_DHAL_MEM_COPY])((void *)&mem_copyinfo);
	   }

	   if ((Ptr->Flags & STREAM_FLAG_EOS) && !(MsgDataSize)) {
               DataBlkPtr->DataCount = MsgDataSize;
           } else {
               // Setup System header
               // Whatever was the data size make it 4056
               if (StreamBlock->type == STREAM_OPEN_F_GSTREAM)
                   DataBlkPtr->DataCount = MsgDataSize;
               else              
                   DataBlkPtr->DataCount = 4056;
           }

	   MSD_LEVEL2_DBGPRINT("snd_data2adapter: flags %x, size %d, setsize %d.\n", 
				    Ptr->Flags, MsgDataSize, DataBlkPtr->DataCount);
	   Flags = 0;
	   // set the data block flags 
	   if (Ptr->Flags & STREAM_FLAG_EOS) {
	       Flags |= HIF_STREAM_F_EOS;
	   }

	   DataBlkPtr->BufFlags = Flags;

	   MSD_LEVEL2_DBGPRINT("snd_data2adapter:SB %d	0x%x %d	%d\n", Ptr->StreamId,
		  DataBlkPtr->BufFlags, DataBlkPtr->DataCount, DataBlkPtr->Sequence);
	   SentCount++;

	   // Here Send an Ack to user :Send new Can Take to the user
	   StreamBlock->accumulated_usr_ack += MsgDataSize;

           if (!NewCanTakeProtocol) {
	       if (((StreamBlock->state != MERCD_STREAM_STATE_CLOSE_PEND) || 
		   (StreamBlock->state != MERCD_STREAM_STATE_TERMINATE_PEND)) &&
		   (StreamBlock->accumulated_usr_ack)) {

	           // send broken to prevent latency
		   if (Ptr->Flags & MD_MSG_FLAG_LATENCY) {
		       strm_sndbrokenstream2usr(StreamBlock);
		   } else {
		       if (!(Ptr->Flags & STREAM_FLAG_EOS)) {
		           if ((Ptr->Flags & MULTI_BLK_SEND_CAN_TAKE) ||
			       !(Ptr->Flags & MULTI_BLK_NO_CAN_TAKE))  {
			       if (strm_ack2usr(StreamBlock, StreamBlock->accumulated_usr_ack) != MD_SUCCESS) {
			           MSD_ERR_DBGPRINT("snd_data2adapter: strm_ack2usr failed.\n");
			       }
			       StreamBlock->accumulated_usr_ack = 0;   /* clean it out. */
			   }
		       } 
                   }
	       } 
	   } else { 
	       // The following will only be executed with New Can Take feature 
               if (((StreamBlock->state != MERCD_STREAM_STATE_CLOSE_PEND) ||
		   (StreamBlock->state != MERCD_STREAM_STATE_TERMINATE_PEND)) &&
                   (StreamBlock->accumulated_usr_ack)) {
                   if (!(Ptr->Flags & STREAM_FLAG_EOS)) {
                       if ((Ptr->Flags & MULTI_BLK_SEND_CAN_TAKE) || 
			   !(Ptr->Flags & MULTI_BLK_NO_CAN_TAKE))  {
                           stream_add_cantake_queue(padapter, StreamBlock);
                       } 
                   }
               }
	   }

	   // calc the next message start 
	   NextMessageAddress = (merc_ulong_t)HostIfPtr->host_to_fw_data_start
		+sizeof(MERC_CIR_BUFFER) +(sizeof(MERC_DATA_CIR_BUF_ENTRY)*NextWrite);

	   CirBufEntry = (PMERC_DATA_CIR_BUF_ENTRY)NextMessageAddress;
	   CirBufEntry->DataHeaderOffset = TO_HIF_OFFSET(padapter,KvDataBlockPtr);
	   CirBufEntry->StreamId = Ptr->StreamId;
	   MSD_LEVEL2_DBGPRINT("snd_data2adapter: StreamId %d\n", CirBufEntry->StreamId);

	   NextWrite = (NextWrite+1)%MaxMessages;

	   if (MD_GET_MSG_WRITE_PTR(TmpMsg) <= MD_GET_MSG_READ_PTR(TmpMsg)) {
	       // should free just the data blk here 
	       Msg->b_cont = TmpMsg->b_cont;
	       MSD_FREE_BUFFER(TmpMsg);
	   }
       } /* inner while */
		
       if (!TmpMsg) {
	   TmpMsg = Msg->b_next;
	   MSD_FREE_MESSAGE(Msg);	
	   Msg = TmpMsg;
	   padapter->snd_data_queue = Msg;
	   MSD_LEVEL2_DBGPRINT("snd_data2adapter: NewMsg=%x,NextWr=%d,ReadInd=%d, MaxMsg=%d \n", 
						          Msg,NextWrite,ReadIndex, MaxMessages);
       } else {
	   break;
       }
   } /* outer while */

   if (Msg !=NULL && ((NextWrite+1)%MaxMessages == ReadIndex)) {
       // Queue full - return msg queue to adapter block 
       MSD_LEVEL2_DBGPRINT("snd_data2adapter: Re-inserting msg on Adapter send queue.Msg=%x\n", Msg);
       MSD_LEVEL2_DBGPRINT("   NextWr=%d,ReadInd=%d, MaxMsg=%d \n", NextWrite,ReadIndex,MaxMessages);
       padapter->snd_data_queue = Msg;
       padapter->flags.SendDataPending |= MERC_ADAPTER_FLAG_SEND_DATA_PEND ; 
   }

out:
   // save write pointer 
   CirBuffer->Write = NextWrite;
   MSD_LEVEL2_DBGPRINT("snd_data2adapter: SendCnt = %d  ",SentCount); 
   padapter->flags.LaunchIntr |=  MERC_ADAPTER_FLAG_LAUNCH_INTR;
   return(MD_SUCCESS);
}


/***************************************************************************
 * Function Name		: snd_alloc_Hif_data_blk
 * Function Type		: Host FW Send function
 * Inputs			: 
 * Outputs			: 
 * Calling functions		:
 * Description			: Streams Driver snd_alloc_Hif_data_blk Routine.
 *				  This routine is used to allocate a Data block
 *				  from SRAM
 * Additional comments		: Will need mutexes  intrdpc. timerdpc if included
 ****************************************************************************/
PMERC_DATA_BLK_HDR snd_alloc_Hif_data_blk(pmercd_adapter_block_sT padapter)
{
   pmercury_host_info_sT        HostIfPtr;
   pmercury_free_hdr_list_sT	FreePtr; 
   PMERC_DATA_BLK_HDR		Ptr; 


   HostIfPtr=&padapter->phost_info->merc_host_info;

   FreePtr = (pmercury_free_hdr_list_sT)HostIfPtr->pfree_list_header_start; 

   if (FreePtr->HeadNodeOffset == FreePtr->TailNodeOffset) {
       return(NULL);
   }

   // If the SRAM is corrupt. Then declare the adapter out of service
   if (!((FreePtr->HeadNodeOffset != 0) && (FreePtr->TailNodeOffset != 0))) {
       padapter->state = MERCD_ADAPTER_STATE_OUT_OF_SERVICE;
       printk("snd_alloc_Hif_data_blk: Sram Corruption - Adapter Out Of Service\n");
       return(NULL);
   }

   Ptr = (PMERC_DATA_BLK_HDR)TO_KV_ADDRESS(padapter,FreePtr->HeadNodeOffset); 

   FreePtr->HeadNodeOffset = Ptr->NextNodeOffset;
   FreePtr->FreeBlockCount--;

   // CpFreeCounter not used for now 
   if (FreePtr->HeadNodeOffset == 0) {
       FreePtr->TailNodeOffset = 0;
   }

   Ptr->NextNodeOffset = 0;

   return(Ptr);
}

/***************************************************************************
 * Function Name		: snd_release_Hif_data_blk
 * Function Type		: Host FW Send function
 * Inputs			: 
 * Outputs			: 
 * Calling functions		:
 * Description			: Streams Driver snd_release_Hif_data_blk Routine.
 *				  This routine is used to release a transfer 
 *				  completed Data block to the SRAM
 * Additional comments		:
 ****************************************************************************/
merc_void_t snd_release_Hif_data_blk(pmercd_adapter_block_sT padapter, PMERC_DATA_BLK_HDR DataBlockAddr)
{
   pmercury_host_info_sT HostIfPtr;
   PMERC_FREE_LIST_HDR	 FreePtr; 
   PMERC_DATA_BLK_HDR	 Ptr; 
   merc_uint_t		 DataBlockOffset;


   HostIfPtr=&padapter->phost_info->merc_host_info;

   // calc hif offset for data block  node
   DataBlockOffset = (merc_uint_t)TO_HIF_OFFSET(padapter,DataBlockAddr);

   FreePtr = (PMERC_FREE_LIST_HDR)HostIfPtr->pfree_list_header_start; 

   // is the free list empty
   if (FreePtr->HeadNodeOffset == 0) {
       FreePtr->HeadNodeOffset = DataBlockOffset;
       FreePtr->TailNodeOffset = DataBlockOffset;
       goto out;
   }

   Ptr = (PMERC_DATA_BLK_HDR)TO_KV_ADDRESS(padapter,FreePtr->TailNodeOffset);

   // link current tail to new node 
   Ptr->NextNodeOffset = DataBlockOffset;

   // update the tail
   FreePtr->TailNodeOffset = DataBlockOffset;

out:	

   Ptr = (PMERC_DATA_BLK_HDR)TO_KV_ADDRESS(padapter,FreePtr->TailNodeOffset);

   // set it's link to null 
   Ptr->NextNodeOffset = 0;

   // Increament the Free count in shared Ram 
   FreePtr->FreeBlockCount++;
   return;
}


/***************************************************************************
 * Function Name                : snd_gem_msgs2adapter
 * Function Type                : Host FW Send function
 * Inputs                       :
 * Outputs                      :
 * Calling functions            :
 * Description                  : Streams Driver snd_msgs2adapter Routine.
 *                                This routine sends message to adapter.
 * Additional comments          :
 ****************************************************************************/
int snd_gem_msgs2adapter(pmercd_adapter_block_sT padapter)
{
   PSTRM_MSG               Msg;
   pmercury_host_info_sT   HostIfPtr;
   PMERC_CIR_BUFFER        CirBuffer= NULL;
   PMERC_HOSTIF_MSG        MercMsg;
   pmerc_uchar_t           Sram_Temp;
   pmerc_uchar_t           Sram_Start;
   pmerc_uchar_t           Sram_End;
   merc_uint_t             Read;
   merc_uint_t             Write;
   merc_uint_t             WriteSize;
   merc_uint_t             TrottleCnt;
   merc_uint_t             MaxMessages;
   merc_uint_t             MsgBodySize;
   merc_uint_t             BlocksNeeded;
   merc_uint_t             BlocksAvailable;

   HostIfPtr=&padapter->phost_info->merc_host_info;
   CirBuffer=(PMERC_CIR_BUFFER)HostIfPtr->host_to_fw_msg_start;
   MaxMessages = padapter->phost_info->host_config.maxHostMsgs;

   Read = CirBuffer->Read;
   Write = CirBuffer->Write;
   Sram_Start = (pmerc_uchar_t) HostIfPtr->host_to_fw_msg_start + sizeof(MERC_CIR_BUFFER);
   Sram_End = (pmerc_uchar_t) Sram_Start + (MaxMessages * (GEM_MSG_INDEX_SIZE)); 

   // Check if Bootkernel is resetting
   if ((Read == -1) || (Write == -1)) {
       return (MD_FAILURE);
   }

   // If sram is corrupt, empty out the circular queue
   if ((Read > MaxMessages) || (Write > MaxMessages)) {
       //printk("snd_gem_msgs2adapter: Read=%d, Write=%d, MaxMessages=%d\n", Read, Write, MaxMessages);
       return(MD_FAILURE);
   }

   // get a message from the send queue
   if ((Msg = queue_get_msg_Q(&padapter->snd_msg_queue)) == NULL) {
       //printk("snd_gem_msgs2adapter: Sendqueue empty.\n");
       return (MD_FAILURE);
   }

   BlocksAvailable = (MaxMessages - Write) + Read;

   TrottleCnt = MaxMessages/4;
   // keep writing to cir buf until full
   while ((Msg && ((Write+1)%MaxMessages != Read)) && (TrottleCnt--)) {

       MercMsg = (PMERC_HOSTIF_MSG)Msg->b_cont->b_rptr;
       MsgBodySize = sizeof(MERC_HOSTIF_MSG) + (MERCURY_GET_BODY_SIZE(MercMsg));
#if 1
       Sram_Temp = Sram_Start + (Write * (GEM_MSG_INDEX_SIZE)); 
       if (MsgBodySize < GEM_MSG_INDEX_SIZE) {
	   BlocksNeeded = 1;
           MERCD_WRITE_TO_SRAM(Sram_Temp, MercMsg, MsgBodySize);
       } else {
	   WriteSize = BlocksNeeded = 0;
           printk("snd_gem_msgs2adapter: Msg size > GEM_MSG_INDEX_SIZE\n");
           printk("snd_gem_msgs2adapter: Cannnot send %#x of sz %d\n",  MercMsg->MessageType, MsgBodySize);
       }
#else
       // For Msg size greater than GEM_MSG_INDEX_SIZE - Support later
       BlocksNeeded = MsgBodySize / GEM_MSG_INDEX_SIZE;
       if (MsgBodySize % GEM_MSG_INDEX_SIZE) {
           BlocksNeeded++;
       }

       // Are there enough to write this message...
       if (BlocksNeeded > BlocksAvailable) {
           printk("snd_gem_msgs2adapter: BlocksNeeded=%d, BlocksAvailable=%d\n", BlocksNeeded, BlocksAvailable);
           queue_put_bk_msg_Q(&padapter->snd_msg_queue,Msg);
           break;
       }

       // Write Message to Sram, but test Wrap around
       if (BlocksNeeded > (MaxMessages - Write)) {
           // need to wrap
           printk("snd_gem_msgs2adapter: Wrap needed \n");
           WriteSize = (MaxMessages - Write) * GEM_MSG_INDEX_SIZE;
           MERCD_WRITE_TO_SRAM(Sram_Temp, MercMsg, WriteSize);
           MERCD_WRITE_TO_SRAM(Sram_Start, (MercMsg+WriteSize), (MsgBodySize-WriteSize));
           printk(" R=%d, W=%d, MsgSz=%d, WS=%d, BN=%d, BA=%d, ST=%#x, SS=%#x\n",
                    Read, Write, MsgBodySize, WriteSize, BlocksNeeded, BlocksAvailable, Sram_Temp, Sram_Start);
       } else {
           // No need to wrap
           MERCD_WRITE_TO_SRAM(Sram_Temp, MercMsg, MsgBodySize);
           printk("snd_gem_msgs2adapter: Wrap Not needed \n");
           printk(" R=%d, W=%d, MsgSz=%d, BN=%d, BA=%d, ST=%#x, SS=%#x\n",
                    Read, Write, MsgBodySize, BlocksNeeded, BlocksAvailable, Sram_Temp, Sram_Start);
       }
#endif
       //printk("HOST->FW:  R=%d, W=%d, MType=%#x MSz=%d\n", Read, Write, MercMsg->MessageType, MercMsg->BodySize+24);

       // update Index
       Write = (BlocksNeeded + Write) % MaxMessages;

       // Trace Code: Copy the Message to the buffer (if required)
       if (padapter->flags.TraceLevelInfo & MERC_ADAPTER_FLAG_TRACE_STRUCT_ALLOCATED) {
           supp_push_trace_msg(padapter, MSD_DRV2BRD_TRACE, (PMERC_HOSTIF_MSG)(Msg->b_cont->b_rptr));
       }
       
       MSD_FREE_MESSAGE(Msg);

       if ((Msg = queue_get_msg_Q(&padapter->snd_msg_queue)) == NULL) {
           // no more msgs to process
           break;
       }
   }

   if (Msg!=NULL) {
       // Full Queue in SRAM
       queue_put_bk_msg_Q(&padapter->snd_msg_queue,Msg);
   }

   CirBuffer->Write = Write;

   // indicate the need for interrupting the board
   padapter->flags.LaunchIntr |=  MERC_ADAPTER_FLAG_LAUNCH_INTR;
   return(MD_SUCCESS);
}

/***************************************************************************
 * Function Name                : rcv_gem_msgs_from_adapter
 * Function Type                : Host FW Send function
 * Inputs                       :
 * Outputs                      :
 * Calling functions            :
 * Description                  : Streams Driver snd_msgs2adapter Routine.
 *                                This routine sends message to adapter.
 * Additional comments          :
 ****************************************************************************/
int rcv_gem_msgs_from_adapter(pmercd_adapter_block_sT padapter)
{

   PSTRM_MSG               Msg;
   PMDRV_MSG               MdMsg;
   PSTRM_MSG               DataMsg;
   pmercury_host_info_sT   HostIfPtr;
   PMERC_CIR_BUFFER        CirBuffer= NULL;
   PMERC_HOSTIF_MSG        MercMsg;
   PMERC_HOSTIF_MSG        FwMessage;
   pmerc_uchar_t           Sram_Temp;
   pmerc_uchar_t           Sram_Start;
   pmerc_uchar_t           Sram_End;
   merc_uint_t             Read;
   merc_uint_t             Write;
   merc_uint_t             ReadSize;
   merc_uint_t             TrottleCnt;
   merc_uint_t             MaxMessages;
   merc_uint_t             MsgBodySize;
   merc_uint_t             BlocksNeeded;

   HostIfPtr=&padapter->phost_info->merc_host_info;
   CirBuffer=(PMERC_CIR_BUFFER)HostIfPtr->fw_to_host_msg_start;
   MaxMessages = padapter->phost_info->host_config.maxFwMsgs;

   Read = CirBuffer->Read;
   Write = CirBuffer->Write;
   Sram_Start = (pmerc_uchar_t) HostIfPtr->fw_to_host_msg_start + sizeof(MERC_CIR_BUFFER);
   Sram_End = (pmerc_uchar_t) Sram_Start + (MaxMessages * GEM_MSG_INDEX_SIZE);

   // Check if Bootkernel is resetting
   if ((Read == -1) || (Write == -1)) {
       return (MD_SUCCESS);       
   }

   // If sram is corrupt, empty out the circular queue
   if ((Read > MaxMessages) || (Write > MaxMessages)) {
       //printk("rcv_gem_msgs_from_adapter: Read=%d, Write=%d, MaxMessages=%d\n", Read, Write, MaxMessages);
       return (MD_FAILURE);       
   }

   TrottleCnt = MaxMessages;
   // do while there's more to process
   while ((Read != Write) && (TrottleCnt--)) {
       
       Sram_Temp = Sram_Start + (Read * GEM_MSG_INDEX_SIZE);
    
       MercMsg = (PMERC_HOSTIF_MSG)Sram_Temp;
       MsgBodySize = MercMsg->BodySize; //MERCURY_GET_BODY_SIZE(MercMsg);
       MsgBodySize += sizeof(MERC_HOSTIF_MSG);
	if (MsgBodySize > GEM_MSG_INDEX_SIZE)
	{
	   printk("rcv_gem_msgs_from_adapter: Bad MsgSize=%d Read=%d, Write=%d\n", MsgBodySize, Read, Write);
            BlocksNeeded=1;
	    goto End;
	}
       BlocksNeeded = MsgBodySize / GEM_MSG_INDEX_SIZE;
       if (MsgBodySize % GEM_MSG_INDEX_SIZE) {
           BlocksNeeded++;
       }

       Msg = supp_alloc_buf(sizeof(MDRV_MSG)+MD_MAX_DRIVER_BODY_SZ,GFP_ATOMIC);
       if (Msg == NULL) {
           printk("rcv_gem_msgs_from_adapter: Unable to allocate memory\n");
           return (MD_FAILURE);
       }

       DataMsg = supp_alloc_buf(MsgBodySize,GFP_ATOMIC);
       if (DataMsg == NULL) {
           printk("rcv_gem_msgs_from_adapter: Unable to allocate data memory\n");
           MSD_FREE_MESSAGE(Msg);
           return (MD_FAILURE);
       }

       MD_SET_MSG_TYPE(DataMsg, M_DATA);
       MSD_LINK_MESSAGE(Msg,DataMsg);

       MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(Msg);
       FwMessage = (PMERC_HOSTIF_MSG)DataMsg->b_rptr;

#if 1
       if (MsgBodySize < GEM_MSG_INDEX_SIZE) {
	   BlocksNeeded = 1;
           MERCD_READ_FROM_SRAM(FwMessage, Sram_Temp, MsgBodySize);
       } else {
	   ReadSize = BlocksNeeded = 0;
           MSD_FREE_MESSAGE(Msg);
           MSD_FREE_MESSAGE(DataMsg);
           printk("rcv_gem_msgs_from_adapter: Msg size > GEM_MSG_INDEX_SIZE\n");
           printk("rcv_gem_msgs_from_adapter: Cannnot rcv of sz %d\n",  MsgBodySize);
       }
#else
       // For Msg size greater than GEM_MSG_INDEX_SIZE - Support later
       // Read Message from Sram, but test Wrap around
       if (BlocksNeeded > (MaxMessages - Read)) {
           // need to wrap
           ReadSize = (MaxMessages - Read) * GEM_MSG_INDEX_SIZE;
           MERCD_READ_FROM_SRAM(FwMessage, Sram_Temp, ReadSize);
           MERCD_READ_FROM_SRAM(Sram_Start, (FwMessage+ReadSize), (MsgBodySize-ReadSize));
           printk("rcv_gem_msgs_from_adapter: Wrap needed \n");
           printk(" R=%d, W=%d, MsgSz=%d, RS=%d, BN=%d, ST=%#x, SS=%#x\n",
                    Read, Write, MsgBodySize, ReadSize, BlocksNeeded, Sram_Temp, Sram_Start);
       } else {
           // No need to wrap
           MERCD_READ_FROM_SRAM(FwMessage, Sram_Temp, MsgBodySize);
           printk("rcv_gem_msgs_from_adapter: Wrap Not needed \n");
           printk(" R=%d, W=%d, MsgSz=%d, BN=%d, ST=%#x, SS=%#x\n",
                    Read, Write, MsgBodySize, BlocksNeeded, Sram_Temp, Sram_Start);
       }
#endif

       //printk("FW->HOST:  R=%d, W=%d, MType=%#x MSz=%d\n", Read, Write, FwMessage->MessageType, FwMessage->BodySize+24);

       // process the mesage and send up - Msg will be freed as well
       if (rcv_rceive_process_msg(padapter, Msg)) {
           printk("rcv_gem_msgs_from_adapter: Process Msg failed for Type=%#x\n", FwMessage->MessageType);
       }
End:
       // update Index
       Read = (BlocksNeeded + Read) % MaxMessages;
   }

   CirBuffer->Read = Read;

   return(0);
}

/***************************************************************************
 * Function Name                : snd_gem_data2host
 * Function Type                : Host FW Send function
 * Inputs                       :
 * Outputs                      :
 * Calling functions            :
 * Description                  : Streams Driver snd_gem_data2host Routine.
 *                                This routine sends message to host.
 * Additional comments          :
 ****************************************************************************/
merc_void_t snd_gem_data2host(pmercd_adapter_block_sT padapter)
{
   PMDRV_MSG          MdMsg = NULL;
   PSTRM_MSG          Msg = NULL;
   PSTRM_MSG          DataMsg = NULL;
   PGEM_DBG_INFO      DgbInfo = NULL;
   PSTREAM_RECEIVE    Ptr = NULL;
   PMERC_HOSTIF_MSG   FwMessage;
   QUserHeader        *qUH;
   pmerc_uchar_t      MemAddr;
   pmerc_uchar_t      Sram_Temp;
   pmerc_uchar_t      Sram_Start;
   merc_uint_t        Read;
   merc_uint_t        Write;
   merc_uint_t        DataSz;
   merc_uint_t        BlockSz;
   merc_uint_t        MaxMessages;
   merc_uint_t        Status = MD_SUCCESS;

   switch (padapter->flags.GeminiFlags) {
      case MERCD_STREAM_STATE_OPEN_PEND:
      { 
           if (padapter->pstream_connection_list[1]) {
               Status = mid_strmmgr_send_open_ack(padapter, padapter->pstream_connection_list[1]);
               if (Status == MD_SUCCESS)
                   padapter->flags.GeminiFlags = MERCD_STREAM_STATE_CONNECTED;
           }
           break;
      }
      case MERCD_STREAM_STATE_CLOSE_PEND:
      {
           if (padapter->pstream_connection_list[1]) {
               Status = mid_strmmgr_send_close_ack(padapter, padapter->pstream_connection_list[1]);
               if (Status == MD_SUCCESS)
                   padapter->flags.GeminiFlags = MERCD_STREAM_STATE_NOT_OPENED;
           }
           break;
      }
      case MERCD_STREAM_STATE_CONNECTED:
      {
	   Sram_Start = (pmerc_uchar_t) padapter->phw_info->bar[MSD_GEM_DBG_BAR].virt_addr;
           DgbInfo = (PGEM_DBG_INFO) Sram_Start;
           MaxMessages = MSD_GEM_DBG_SIZE; 

           Read = DgbInfo->Read;
	   Read = SwitchEndian(Read); 
           Write = DgbInfo->Write;
	   Write = SwitchEndian(Write); 

           // If sram is corrupt, empty out the circular queue
           if ((Read > MSD_GEM_DBG_SIZE) || (Write > MSD_GEM_DBG_SIZE)) {
               printk("snd_gem_data2host:: Error Read=%d, Write=%d, MaxMessages=%d\n", Read, Write, MaxMessages);
               Read = 0;
               Write = 0;
               break;
           }

           // Check if Bootkernel is resetting
           if ((Read == -1) || (Write == -1)) {
               break;
           }

           while (Read != Write) {

              Sram_Temp = Sram_Start + sizeof(GEM_DBG_INFO) + Read;

	      if (Write < Read) {
	          DataSz = MSD_GEM_DBG_SIZE - Read;
	      } else { 
	          DataSz = Write - Read;
	      }
	      if (DataSz > (MERCURY_HOST_IF_BLK_SIZE - sizeof(MERC_HOSTIF_MSG))) {
	          DataSz = (MERCURY_HOST_IF_BLK_SIZE - sizeof(MERC_HOSTIF_MSG) );
	      }
              if (Write > MSD_GEM_DBG_SIZE) {
                  // Prevents panic if Write is beyond mapped area
                  DataSz -= (Write - MSD_GEM_DBG_SIZE);
              }

              BlockSz = DataSz + sizeof(MERC_HOSTIF_MSG);	

              // get a local buffer
              Msg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(STREAM_RECEIVE), GFP_ATOMIC);
              if (Msg == NULL) {
                  printk("snd_gem_data2host: Unable to allocate memory\n");
                  break;
              }
              DataMsg = supp_alloc_buf(BlockSz, GFP_ATOMIC);
              if (DataMsg == NULL) {
                  printk("snd_gem_data2host: Unable to allocate memory\n");
                  MSD_FREE_MESSAGE(Msg);
                  break;
              }

              // setup..
              MD_SET_MSG_TYPE(DataMsg,M_DATA);
              MSD_LINK_MESSAGE(Msg,DataMsg);

              MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(Msg);
              MD_SET_MDMSG_CLASS(MdMsg, MD_CLASS_CORE);
	      MD_SET_MDMSG_ID(MdMsg, MID_STREAM_RECEIVE);

              Ptr = (PSTREAM_RECEIVE)MD_GET_MDMSG_PAYLOAD(MdMsg);
              Ptr->Sequence = 0;
              Ptr->StreamId = 1;
              Ptr->Flags = 0;
              qUH = (QUserHeader*) Ptr->StreamUserHeader.UserHeaderBytes;
              qUH->sequence = 0;
              qUH->encoding = 0;
              qUH->bufFlags = 1; // QEOD
              qUH->blocksize = BlockSz;
              qUH->datasize = 32; // sizeof(QMsg)

              // copy data to msg
	      MemAddr = (pmerc_uchar_t) (Msg->b_cont->b_rptr + sizeof(MERC_HOSTIF_MSG));
              MERCD_READ_FROM_SRAM(MemAddr, Sram_Temp, DataSz);

              FwMessage = (PMERC_HOSTIF_MSG) Msg->b_cont->b_rptr;
	      FwMessage->BodySize = DataSz; 
              FwMessage->MessageType = QMsoPrintf;
	      FwMessage->Destination = Ptr->StreamId;
	      FwMessage->SourceDestComponent = Ptr->StreamId;
	      MERCURY_SET_SOURCE_PROC(FwMessage, Ptr->StreamId);

	      Read = (DataSz + Read) % MSD_GEM_DBG_SIZE;
	      DgbInfo->Read = SwitchEndian(Read);
	      
              // send up
              fwmgr_msg_reply_mgr(Msg, padapter);
	   }
           break;
      }
      default:
      {
         padapter->flags.GeminiFlags = 0;
	 break;
      }
   }

   return;

}
