/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdwwtime.c
 * Description                  : WW Time functions
 *
 *
 **********************************************************************/

#include "msd.h"
#define _MSDTIME_C_
#define _MSDWWTIME_C_
#include "msdextern.h"
#undef _MSDWWTIME_C_
#undef _MSDTIME_C_

/***************************************************************************
 * Function Name                : time_ww_chk_snd_timer
 * Function Type                : Time function
 * Inputs                       :
 * Outputs                      :
 * Calling functions            :
 * Description                  : Streams Driver CheckSendTimer Routine.
 *                                This routine sets the PAM send timer which
 *                                when kicked off, will cause the driver to
 *                                send all messages and bulk data to the target
 *                                adapter.
 * Additional comments          :
 ****************************************************************************/
md_status_t time_ww_chk_snd_timer(pmercd_adapter_block_sT padapter)
{
        md_status_t     Status;
        mercd_osal_timeout_start_sT timeoutinfo = { 0 };

/*
        MSD_FUNCTION_TRACE("time_ww_chk_snd_timer 0x%x\n", (size_t) padapter); */

        MSD_ASSERT(padapter);

        if(( padapter->flags.SendTimeoutPending & MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND ) ||
          ( padapter->state ==  MERCD_ADAPTER_STATE_MAPPED ) ||
	    (!(padapter->pww_info->mfaBaseAddressDescr.host_address))) {
           return(MD_SUCCESS);
        }

        if (!padapter->shutdown_timer) {
           padapter->flags.SendTimeoutPending |= MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND;

           timeoutinfo.Interval = padapter->phw_info->timer_info->snd_timeout_interval;
           timeoutinfo.Function = (PMSD_FUNCTION)mercd_ww_generic_timeout_processing;
           timeoutinfo.Context = padapter;
           timeoutinfo.Handle = &padapter->phw_info->timer_info->timeout_id;

           (*mercd_osal_func[MERCD_OSAL_TIMEOUT_START])((void *)&timeoutinfo);


           Status = timeoutinfo.ret;

           if(Status != MD_SUCCESS) {
                   MSD_ASSERT(Status==MD_SUCCESS);
                   padapter->flags.SendTimeoutPending &= ~MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND;
                   return(MD_FAILURE);
           }
        } else {
           // Timer will no longer run.
           padapter->flags.SendTimeoutPending = 0;
        }

        return(MD_SUCCESS);
}
