# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#BlockInputStream a class for reading from DM3 BlockStrea

#don't source the script more then once
if [info exists BlockInputStream] {
    return
}


#this line helps the auto loader find this class
proc BlockInputStream {} {}

catch {class new -Name BlockInputStream -init {-Extends InputStream}}



BlockInputStream method init {args} {
    array set check [CheckParms -Proc "BlockInputStream_init parm" -Provided $args \
			 -Required {-Source}]

    array set parms $check(Flags)

    $this public DestDesc QStreamRef StreamId

    #handle args
    set src $parms(-Source)

    set DestDesc [$src set TgtDesc]

    global QSTREAM_OPENREAD QS_GlobalValues env

    set timeout 60

    if {$QS_GlobalValues(HOST)==$env(HOST)} {
	#create local block stream
	set QStreamRef [QS_PRIM_StreamCreate 1 $QSTREAM_OPENREAD $DestDesc]
    } else {
	#create remote block stream
	set QStreamRef [QS_PRIM_StreamCreate 1 $QSTREAM_OPENREAD $DestDesc \
			    $QS_GlobalValues(HOST) $timeout \
			    $QS_GlobalValues(DefaultStreamerBlockSize)]
    }

    #get the stream id
    set StreamId [QS_PRIM_StreamGetStreamId $QStreamRef]
    
    #call super init
    $this super init

};#endof BlockInputStream_init

BlockInputStream method GetStreamId {} {
    
    return [$this set StreamId]

};#endof BlockInputStream_getStreamId


