# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#BlockOutputStream a class for reading from DM3 BlockStrea

#don't source the script more then once
if [info exists BlockOutputStream] {
    return
}


#this line helps the auto loader find this class
proc BlockOutputStream {} {}


catch {class new -Name BlockOutputStream -init {-Extends OutputStream}}



#init
#-Target - specifies an StdResource object to connect to
BlockOutputStream method init {args} {
    array set check [CheckParms -Proc "BlockOutputStream_init parm" -Provided $args \
			 -Required {-Target}]

    array set parms $check(Flags)

    $this public DestDesc QStreamRef StreamId

    #handle args
    set tgt $parms(-Target)

    set DestDesc [$tgt set TgtDesc]

    global QSTREAM_OPENWRITE QS_GlobalValues env

    set timeout 60

    if {$QS_GlobalValues(HOST)==$env(HOST)} {
	#create local block stream
	set QStreamRef [QS_PRIM_StreamCreate 1 $QSTREAM_OPENWRITE $DestDesc]
    } else {
	#create remote block stream
	set QStreamRef [QS_PRIM_StreamCreate 1 $QSTREAM_OPENWRITE $DestDesc \
			    $QS_GlobalValues(HOST) $timeout \
			    $QS_GlobalValues(DefaultStreamerBlockSize)]
    }


    #get the stream id
    set StreamId [QS_PRIM_StreamGetStreamId $QStreamRef]

    #call super init
    $this super init

};#endof BlockOutputStream_init


BlockOutputStream method GetStreamId {} {
    
    return [$this set StreamId]

};#endof BlockOutputStream_getStreamId

