# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists Board] {
    return
}

#this line helps the auto loader find this class
proc Board {} {}

catch {class new -Name Board -init {-Extends Addressable}}



#Board_init - init a new Board object
#***Inputs***
#-BoardNum - board number to attach to
#[-MsgQueue] - MsgQueue to use
#***Outputs***
#***Exceptions***
Board method init {args} {

    array set check [CheckParms -Proc Board_init -Provided $args \
			 -Required {-BoardNum} -Optional {-MsgQueue}]

    array set parms $check(Flags)

    #required args
    set boardNum $parms(-BoardNum)

    set tgtDesc [list \
		     Node 0 \
		     Board $boardNum \
		     Processor 1 \
		     Component 0 \
		     Instance 0]

    #remove unwanted flags
    unset parms(-BoardNum)

    #call parent constructor
    eval $this super init -TgtDesc [list $tgtDesc] [array get parms]

    $this public resourceMgr clusterMgr MsgQueue

    #create new cluster and resource managers
    set resourceMgr [ResourceMgr new -init [list -BoardNum $boardNum -MsgQueue $MsgQueue]]
    set clusterMgr [ClusterMgr new -init [list -BoardNum $boardNum -MsgQueue $MsgQueue]]


};#endof Board_init



#Board_destroy - Destroy a Board
#***Inputs***
#Boardobj
#***Outputs***
#***Exceptions***
Board method destroy {} {

    $this public resourceMgr clusterMgr

    $resourceMgr destroy
    $clusterMgr destroy

    #call parent class destrcutor 
    $this super destroy
};#endof Board_destroy

#Board_findComp - find a component on a board
#***Inputs***
#[-CompClass] - ComponentClass to use
#[-CompType] - Component type to search for
#[-Processor] - Processor to look on, defaults to nil
#[-Attrs] - attributes to use to match the component
#***Outputs***
#a Component object
Board method findComp {args} {
    $this public resourceMgr

   array set check [CheckParms -Proc Board_findComp -Provided $args \
			 -Optional {-CompClass -CompType -Processor -Attrs}]

    array set vals $check(Flags)
	
    if [info exists vals(-CompClass)] {
	set vals(-Class) $vals(-CompClass)
	unset vals(-CompClass)
    } else {
	set vals(-Class) Component
    }

    #make sure were're looking for a component
    set vals(-InstNo) 0

    set retval [eval $resourceMgr find [array get vals]]

    return $retval
};#enof Board_findComp



#Board_findInst - find a instance on a board
#***Inputs***
#[-InstClass] - ComponentClass to use
#[-CompType] - Component type to search for
#[-Processor] - processor to search on, defaults to nil
#[-InstNo] - instance number to search for, defaults to nil
#[-Attrs] - attributes to use to match the component
#***Outputs***
#a Instance object
Board method findInst {args} {
    $this public resourceMgr


   array set check [CheckParms -Proc Board_findInst -Provided $args \
			 -Optional {-InstClass -CompType -Processor -InstNo -Attrs}]

    array set vals $check(Flags)
	
    if [info exists vals(-InstClass)] {
	set vals(-Class) $vals(-InstClass)
	unset vals(-InstClass)
    } else {
	set vals(-Class) Instance
    }


    set retval [eval $resourceMgr find [array get vals]]

    return $retval
};#enof Board_findInst



#Board_allocateInst - allocate an instance on a board
#***Inputs***
#[-InstClass] - ComponentClass to use
#[-CompType] - Component type to search for
#[-Processor] - processor to search on, defaults to nil
#[-InstNo] - instance number to search for, defaults to nil
#[-Attrs] - attributes to use to match the component
#***Outputs***
#a Instance object
Board method allocateInst {args} {
    $this public resourceMgr


   array set check [CheckParms -Proc Board_allocateInst -Provided $args \
			 -Optional {-InstClass -CompType -Processor -InstNo -Attrs}]

    array set vals $check(Flags)
	
    set retval [eval $resourceMgr allocate [array get vals]]

    return $retval
};#enof Board_allocateInst

#Board_allocateClust - allocate a cluster on a board
#****Inputs****
#-Attrs - attributes to use to match the cluster
#****Outputs***
#a Cluster object
Board method allocateClust {args} {
    $this public clusterMgr

    eval $clusterMgr allocate $args
};#enof Board_allocateClust

#Board_findClust - find a cluster on a board
#****Inputs****
#-Attrs - attributes to use to match the cluster
#****Outputs***
#a Cluster object
Board method findClust {args} {
    $this public clusterMgr

    eval $clusterMgr find $args
};#enof Board_findClust


#Board_findClustByTSC - find a cluster on a board containing TSC
#****Inputs****
#-Line - line attributes to use to match the cluster
#-Chan - chan attributes to use to match the cluster
#****Outputs***
#a Cluster object
Board method findClustByTSC {args} {
    $this public clusterMgr

    eval $clusterMgr findByTSC $args
};#enof Board_findClustByTSC


#Board_findClustByLCON - find a cluster on a board containing LCON
#****Inputs****
#-Line - line attributes to use to match the cluster
#****Outputs***
#a Cluster object
Board method findClustByLCON {args} {
    $this public clusterMgr

    eval $clusterMgr findByLCON $args
};#enof Board_findClustByLCON

#Board_findClustByInst - find a cluster on a board containing Inst
#****Inputs****
#-Inst a QScript instance object
#****Outputs***
#a Cluster object
Board method findClustByInst {args} {
    $this public clusterMgr

    eval $clusterMgr findByInst $args
};#enof Board_findClustByInst


#Board_createClust - creates a cluster on a board
#****Inputs****
#[-Attrs] attributes to add during creation
#****Outputs***
#a Cluster object
Board method createClust {args} {
    array set check [CheckParms -Proc Board_createClust -Provided $args \
			 -Required {} -Optional {-Attrs}]

    array set parms $check(Flags)

    $this public clusterMgr MsgQueue

    array set clustDesc [eval $clusterMgr ClusterCreate]
    set clust [Cluster new -init [list -TgtDesc $clustDesc(desc) -MsgQueue $MsgQueue]]
    $clust set DestroyResourceOnDestroy 1

    if [info exists parms(-Attrs)] {
	$clust AttrAdd -Attrs $parms(-Attrs)
    }

    return $clust
};#enof Board_createClust







