# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists ClusterMgr] {
    return
}

#this line helps the auto loader find this class
proc ClusterMgr {} {}

catch {AddressableClass new -Name ClusterMgr -init {-Extends Addressable}}


ClusterMgr set typeDefRegistry ClusterMgr_TypeDefs




#ClusterMgr_init - init a new ClusterMgr object
#***Inputs***
#-BoardNum - board on which to manage Clusters
#[-MsgQueue] - MsgQueue to use
#***Outputs***
#***Exceptions***
ClusterMgr method init {args} {

    array set check [CheckParms -Proc ClusterMgr_init -Provided $args \
			 -Required {-BoardNum} -Optional {-MsgQueue}]

    array set parms $check(Flags)
    
    set boardNum $parms(-BoardNum)

    global QCOMP_I_CLUSTERMGR
    set tgtDesc [list \
		     Node 0 \
		     Board $boardNum \
		     Processor 1 \
		     Component 0 \
		     Instance $QCOMP_I_CLUSTERMGR]
    

    #remove unwanted flags
    unset parms(-BoardNum)

    #call parent constructor
    eval $this super init -TgtDesc [list $tgtDesc] [array get parms]

};#endof ClusterMgr_init



#ClusterMgr_free - free a cluster
#***Inputs***
#***Outputs***
#Component
#***Exceptions***
ClusterMgr method free {args} {

    array set check [CheckParms -Proc ClusterMgr_init -Provided $args \
			 -Required {-Cluster}]

    array set parms $check(Flags)
    
    $parms(-Cluster) public TgtDesc

   set tdr [$this Class set typeDefRegistry]

   global QClusterFree QClusterResult

   set typedef [$tdr lookup -MsgType $QClusterFree]
   set rettypedef [$tdr lookup -MsgType $QClusterResult]

    #fill in request data
    set req [list ClustDesc $TgtDesc]

    #issue the request to the ClusterManager
    #NOTE: Ignore source must be used here, the response comes in from a different
    #address

    array set retval [$this request \
			  -Type $QClusterFree -TypeDef $typedef -Data $req \
			  -RetTypeDef $rettypedef -RetType $QClusterResult -IgnoreSource]

    return $retval
    
};#endof ClusterMgr_FindCluster




#ClusterMgr_findClusterByTSC - find a Cluster containing TSC
#***Inputs***
#ClusterMgr - ClusterMgr containing Component
#-Line - line attribute
#-Chan - chan attribute
#***Outputs***
#Component
#***Exceptions***
ClusterMgr method findByTSC {args} {
    array set check [CheckParms -Proc ClusterMgr_findByTSC -Provided $args \
			 -Required {-Line -Chan}]

    array set parms $check(Flags)

    #required arguments
    set line $parms(-Line)
    set chan $parms(-Chan)

    global Std_ComponentType TSC_Std_ComponentType TSC_AttrLineId TSC_AttrChanId 

    set attrs [list \
		   [list -key $Std_ComponentType \
			-value $TSC_Std_ComponentType] \
		   [list -key $TSC_AttrLineId \
			-value $line] \
		   [list -key $TSC_AttrChanId \
			-value $chan]]

    return [$this find -Attrs $attrs]
};#endof ClusterMgr_findClusterByTSC


#ClusterMgr_findClusterByLCON - find a Cluster containing LCON
#***Inputs***
#ClusterMgr - ClusterMgr containing Component
#-Line - line attribute
#***Outputs***
#Component
#***Exceptions***
ClusterMgr method findByLCON {args} {
    array set check [CheckParms -Proc ClusterMgr_findByLCON -Provided $args \
			 -Required {-Line}]

    array set parms $check(Flags)

    #required arguments
    set line $parms(-Line)

    global Std_ComponentType LCON_Std_ComponentType LCON_LineId 

    set attrs [list \
		   [list -key $Std_ComponentType \
			-value $LCON_Std_ComponentType] \
		   [list -key $LCON_LineId \
			-value $line]]

    return [$this find -Attrs $attrs]
};#endof ClusterMgr_findClusterByLCON


#ClusterMgr_allocateCluster - allocate a Cluster by its attributes
#***Inputs***
#-Attrs - attribute list {{-key # -value #}...}
#***Outputs***
#Component
#***Exceptions***
#QCOMP_ErrAttribute - error in attibutes
#QCOMP_ErrComponentNotFound - not found
ClusterMgr method allocate {args} {

    array set check [CheckParms -Proc ClusterMgr_Allocate -Provided $args \
			 -Required {-Attrs}]

    array set parms $check(Flags)

    #required arguments
    set attrs $parms(-Attrs)
    
    $this public TgtDesc MsgQueue
    
    array set CompStart $TgtDesc

    global QCOMP_P_CP QCOMP_C_NIL QCOMP_I_NIL

    set CompStart(Processor) $QCOMP_P_CP
    set CompStart(Component) $QCOMP_C_NIL
    set CompStart(Instance) $QCOMP_I_NIL

   set tdr [$this Class set typeDefRegistry]

   global QClusterAllocate QClusterResult

   set typedef [$tdr lookup -MsgType $QClusterAllocate]
   set rettypedef [$tdr lookup -MsgType $QClusterResult]

    #fill in request data
    set req [list \
		 CompStart [array get CompStart] \
		 count [llength $attrs] \
		 attr $attrs \
		]

    #issue the request to the ClusterManager
    #NOTE: Ignore source must be used here, the response comes in from a different
    #address

    array set retval [$this request \
			  -Type $QClusterAllocate -TypeDef $typedef -Data $req \
			  -RetTypeDef $rettypedef -RetType $QClusterResult -IgnoreSource]

    
    #returned with descriptor of Cluster
    #create new instance for this Cluster

    set Comp [Cluster new -init [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)]]

#    $Comp set clusterMgr $this

     
    return $Comp
    
};#endof ClusterMgr_allocateCluster


#ClusterMgr_findCluster - find a Cluster by its attributes
#***Inputs***
#-Attrs - attribute list {{-key # -value #}...}
#***Outputs***
#Component
#***Exceptions***
#QCOMP_ErrAttribute - error in attibutes
#QCOMP_ErrComponentNotFound - not found
ClusterMgr method find {args} {

    array set check [CheckParms -Proc ClusterMgr_find -Provided $args \
			 -Required {-Attrs}]

    array set parms $check(Flags)

    #required arguments
    set attrs $parms(-Attrs)
    
    
    $this public TgtDesc MsgQueue
    
    array set CompStart $TgtDesc

    global QCOMP_P_CP QCOMP_C_NIL QCOMP_I_NIL

    set CompStart(Processor) $QCOMP_P_CP
    set CompStart(Component) $QCOMP_C_NIL
    set CompStart(Instance) $QCOMP_I_NIL

   set tdr [$this Class set typeDefRegistry]

   global QClusterFind QClusterResult

   set typedef [$tdr lookup -MsgType $QClusterFind]
   set rettypedef [$tdr lookup -MsgType $QClusterResult]

    #fill in request data
    set req [list \
		 CompStart [array get CompStart] \
		 count [llength $attrs] \
		 attr $attrs \
		]

    #issue the request to the ClusterManager
    #NOTE: Ignore source must be used here, the response comes in from a different
    #address

    array set retval [$this request \
			  -Type $QClusterFind -TypeDef $typedef -Data $req \
			  -RetTypeDef $rettypedef -RetType $QClusterResult -IgnoreSource]

    
    #returned with descriptor of Cluster
    #create new instance for this Cluster

    set Comp [Cluster new -init [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)]]

#    $Comp set clusterMgr $this

     
    return $Comp
    
};#endof ClusterMgr_FindCluster


#ClusterMgr_findClusterByInst - find a Cluster with specified instance
#***Inputs***
#-Inst
#***Outputs***
#Component
#***Exceptions***
#QCOMP_ErrComponentNotFound - not found
ClusterMgr method findByInst {args} {

    array set check [CheckParms -Proc ClusterMgr_findByInst -Provided $args \
			 -Required {-Inst}]

    array set parms $check(Flags)

    $this public MsgQueue

    #required arguments
    set inst $parms(-Inst)
    
    set instDesc [$inst set TgtDesc]
    
    array set retval [$this ClusterFindByComp -desc $instDesc]
    #returned with descriptor of Cluster
    #create new instance for this Cluster

    set Comp [Cluster new -init [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)]]

#    $Comp set clusterMgr $this

     
    return $Comp
    
};#endof ClusterMgr_FindClusterByInst


#***ClusterMgr_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an TSC object, it also recognizes all types specified in Addressable_TypeDefs


TypeDefRegistry new -Name ClusterMgr_TypeDefs \
    -init [list -Extends [[ClusterMgr set Extends] set typeDefRegistry]]

ClusterMgr_TypeDefs define -MsgType QClusterAllocate \
    -TypeDef [list \
		 CompStart $QS_CompDesc \
		 count $QClusterAllocate_count \
		 attr [list -DataType $QCompAttr -Count count] \
	    ]

ClusterMgr_TypeDefs define -MsgType QClusterFree \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		 ]

ClusterMgr_TypeDefs define -MsgType QClusterCreate \
    -TypeDef {}

ClusterMgr_TypeDefs define -MsgType QClusterDestroy \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		 ]


ClusterMgr_TypeDefs define -MsgType QClusterFind \
    -TypeDef [list \
		 CompStart $QS_CompDesc \
		 count $QClusterFind_count \
		 attr [list -DataType $QCompAttr -Count count] \
	    ]

ClusterMgr_TypeDefs define -MsgType QClusterResult \
    -TypeDef [list desc $QS_CompDesc]


ClusterMgr_TypeDefs define -MsgType QClusterCompByAttr \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  CompType $QClusterCompByAttr_compType \
		  Count $QClusterCompByAttr_count \
		  Attrs [list -DataType $QCompAttr -Count Count] \
		 ]

ClusterMgr_TypeDefs define -MsgType QComponentResult \
    -TypeDef [list desc $QS_CompDesc]

ClusterMgr_TypeDefs define -MsgType QClusterByComp \
    -TypeDef [list desc $QS_CompDesc]


#auto define methods


ClusterMgr defineMsgMethod -MethodName ClusterFindInst \
    -Type $QClusterCompByAttr -TypeDef lookup -Defaults {-Count {}} \
    -RetType $QComponentResult -RetTypeDef lookup \
    -RequestFlags {-IgnoreSource}

ClusterMgr defineMsgMethod -MethodName ClusterCreate \
    -Type $QClusterCreate -TypeDef lookup \
    -RetType $QClusterResult -RetTypeDef lookup

ClusterMgr defineMsgMethod -MethodName ClusterDestroy \
    -Type $QClusterDestroy -TypeDef lookup

ClusterMgr defineMsgMethod -MethodName ClusterFree \
    -Type $QClusterFree -TypeDef lookup

ClusterMgr defineMsgMethod -MethodName ClusterFindByComp \
    -Type $QClusterByComp -TypeDef lookup \
    -RetType $QClusterResult -RetTypeDef lookup

