# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#FileOutputStream a class for reading from files

#don't source the script more then once
if [info exists FileOutputStream] {
    return
}


#this line helps the auto loader find this class
proc FileOutputStream {} {}


catch {class new -Name FileOutputStream -init {-Extends OutputStream}}




#error description
set QS_ErrorCode_Descriptions(FileStream_DirNotWritable) {Directory not Writable}
set QS_ErrorCode_Descriptions(FileStream_FileNotWritable) {File not Writable}

FileOutputStream method init {args} {
    array set check [CheckParms -Proc "FileOutputStream_init parm" -Provided $args \
			 -Required {-FileName} -Optional {-Size}]

    array set parms $check(Flags)

    set filename $parms(-FileName)
    set filesize 10000000
    if [info exists $parms(-Size)] {set filesize $parms(-Size)}

    #if file exists make sure its writable
    if [file exists $filename] {
	if ![file writable $filename] {
	    QS_Error -Error FileStream_FileNotWritable -Data [list FileName $filename]
	}
    } else {
	#make sure directory is writable
	if ![file writable [file dirname $filename]] {
	    QS_Error -Error FileStream_DirNotWritable \
		-Data [list Directory [file dirname]]
	}
    }

    #create the stream
    $this public QStreamRef
    global QSTREAM_OPENWRITE

    #the 0 indicates to create a file stream
    set QStreamRef [QS_PRIM_StreamCreate 0 $QSTREAM_OPENWRITE $filename $filesize]

    #call parent constructor
    $this super init

};#endof FileOutputStream_init

