# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists Msg] {
    return
}

#this line helps the auto loader find this class
proc Msg {} {}


catch {class new -Name Msg}



#the methods

#Msg_init - init
#***Inputs***
#***Outputs***
#msg
#***Exceptions***
Msg method init {} {
    $this super init

    global QT_UINT8
    $this public TypeDef Head Offset
    set Offset 0
    set TypeDef [list -ByteData [list -DataType $QT_UINT8 -Count -1]]
    set Head {}
};#endof Msg_init



#Msg_destroy - Free's a DM3 message
#***Inputs***
#msg
#***Outputs***
#***Exceptions***
Msg method destroy {} {

    #call the primitive to free the msg
    $this public MsgRef
    
    #if MsgRef exists free it
    if [info exists MsgRef] {
	QS_PRIM_MsgFree $MsgRef
	unset MsgRef
    }

    #call parent class destrcutor
    $this super destroy
};#endof Msg_destroy




#Msg_bodyGet - Gets the Body info from a message
#***Inputs***
#msg
#[-Offset] - offset to start reading from, defaults to current positiong
#[-TypeDef] - typedef to use, default is stored in TypeDef file of this object
#***Outputs***
#the msg data, according to the typedef
#***Exceptions***
#UnsupportedDataType
#MsgAccessOutOfBounds
Msg method bodyGet {args} {
    array set check [CheckParms -Proc "Msg_bodyGet" -Provided $args \
		   -Optional {-Offset -TypeDef}]
 
    array set parms $check(Flags)

    $this public Offset TypeDef MsgRef Head

    if [catch {set offset $parms(-Offset)} result] {
	set offset $Offset
    }

    if [catch {set td $parms(-TypeDef)} result] {
	set td $TypeDef
    }

    set Head [QS_MsgRefGetHead $MsgRef]

    array set retval [QS_MsgRefUnpack $MsgRef -TypeDef $td -Offset $offset]

    #update the internal offset
    set Offset $retval(Offset)


    return $retval(Data)
};#endof Msg_bodyGet



#Msg_bodySet - Sets the Body of a message
#***Inputs***
#msg
#-Data - data to put into msg
#[-Offset] - offset to start reading from, defaults to current position
#[-TypeDef] - typedef to use, default is stored in TypeDef file of this object
#***Outputs***
#***Exceptions***
#MsgAllocateSizeError
#UnsupportedDataType
#MsgAccessOutOfBounds
Msg method bodySet {args} {
    array set check [CheckParms -Proc Msg_bodySet -Provided $args \
			 -Required {-Data} -Optional {-Offset -TypeDef}]
 
    array set parms $check(Flags)

    set data $parms(-Data)

    $this public TypeDef MsgRef Offset Head

    if [catch {set offset $parms(-Offset)} result] {
	set offset $Offset
    }
    

    if [catch {set td $parms(-TypeDef)} result] {
	set td $TypeDef
    }

    if ![info exists MsgRef] {
	array set allocate [QS_MsgRefAllocate]
	set MsgRef $allocate(MsgRef)
    }

    if {[llength $td]==0} {
	return
    }

    array set retval [QS_MsgRefPack -MsgRef $MsgRef -Data $data \
			  -TypeDef $td -Offset $offset]
    
    set MsgRef $retval(MsgRef)

    set Head [QS_MsgRefGetHead $MsgRef]

    set Offset $retval(Offset)
    return
};#endof Msg_bodySet



#Msg_bodyPuts - Prints the data of a message
#***Inputs***
#msg
#[channelId]
#***Outputs***
#Head
#Data
#***Exceptions***
#UnsupportedDataType
#MsgAccessOutOfBounds
Msg method bodyPuts {args} {

    $this public Offset
    set oldOff $Offset
    set body [$this bodyGet -Offset 0]

    set Offset $oldOff

    if {[llength $args]==0} {
	set out stdout
    } else {
	set out [lindex $args 0]
    }
    puts $out "Head: [$this set Head] \nData: $body \n"
};#endof Msg_bodyPuts

Msg method bodyBytePuts {args} {
    
    $this public Offset
    set oldOff $Offset
    global QT_UINT8
    set body [$this bodyGet -Offset 0 \
		  -TypeDef [list ByteData [list -DataType $QT_UINT8 -Count -1]]]

    set Offset $oldOff

    if {[llength $args]==0} {
	set out stdout
    } else {
	set out [lindex $args 0]
    }
    puts $out "Head: [$this set Head] \nData: $body \n"
};#endof Msg_bodyBytePuts


#Msg_clone - Copies a msg
#***Inputs***
#msg
#***Outputs***
#msg
#***Exceptions***
Msg method clone {} {

    set clone [$this super clone]

    #copy the msg ref
    array set msg [QS_MsgRefCopy [$this set MsgRef]]

    $clone set MsgRef $msg(MsgRef)

    $clone set Head [QS_MsgRefGetHead $msg(MsgRef)]

    return $clone
};#endof Msg_Clone



return


