# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists TSC] {
    return
}

source ${qscript_library}/tscdefs.qs
catch {CCS}
unset TSC

#this line helps the auto loader find this class
proc TSC {} {}
catch {AddressableClass new -Name TSC -init {-Extends Instance}}
TSC set ComponentType $TSC_Std_ComponentType
TSC set typeDefRegistry TSC_TypeDefs
set QS_ErrorCode_Descriptions($TSC_ErrCallIdentifier) {TSC_ErrCallIdentifier: The call identifier specified was not valid.  No call matching the call identifier exists on the TSC Instance that received the command}
set QS_ErrorCode_Descriptions($TSC_ErrCallState) {TSC_ErrCallState: The call state is not valid for the requested operation.}
set QS_ErrorCode_Descriptions($TSC_ErrChanState) {TSC_ErrChanState: Channel state is not valid for the operation}
set QS_ErrorCode_Descriptions($TSC_ErrExhausted) {TSC_ErrExhausted: command can not be completed as there are no resources available}
set QS_ErrorCode_Descriptions($TSC_ErrIdentifierInUse) {TSC_ErrIdentifierInUse: The specified identifier is already in use.}
set QS_ErrorCode_Descriptions($TSC_ErrNotEnabled) {TSC_ErrNotEnabled}
set QS_ErrorCode_Descriptions($TSC_ErrSystem) {TSC_ErrSystem: A system error has occurred.}
set QS_ErrorCode_Descriptions($TSC_ErrUnsupportedOp) {TSC_ErrUnsupportedOp: The Call Operation is not supported.}
set QS_ErrorCode_Descriptions($TSC_ErrVariantId) {TSC_ErrVariantId: the Protocol Variant identifier provided for the operation is invalid (undefined)}
set QS_ErrorCode_Descriptions($TSC_ErrNotInitState) {TSC_ErrNotInitState: The TSC received a Std_MsgInit message and it was not in the initialization state (i.e. already done Std_MsgInit).}
set QS_ErrorCode_Descriptions($TSC_ErrChannelRange) {TSC_ErrChannelRange: Too many channels specified in the Bearer Channel Set.  Cannot define more channels than can be supported by a line.}
set QS_ErrorCode_Descriptions($TSC_ErrIdentifier) {TSC_ErrIdentifier: An invalid, message specific, identifier was specified.}
set QS_ErrorCode_Descriptions($TSC_ErrBadParm) {TSC_ErrBadParm: An invalid, message specific, parameter value was specified.}
set QS_ErrorCode_Descriptions($TSC_ErrReadOnly) {TSC_ErrReadOnly: A client attempted to write (Std_MsgSetParm) a read-only parameter.}
set QS_ErrorCode_Descriptions($TSC_ErrWriteOnly) {TSC_ErrWriteOnly: A client attempted to read (Std_MsgGetParm) a write-only parameter.}
set QS_ErrorCode_Descriptions($TSC_ErrKVSetNotSupported) {TSC_ErrKVSetNotSupported}
set QS_ErrorCode_Descriptions($TSC_ErrFeatureDisabled) {TSC_ErrFeatureDisabled}
set QS_ErrorCode_Descriptions($TSC_ErrMediaMissing) {TSC_ErrMediaMissing}
set QS_ErrorCode_Descriptions($TSC_ErrMediaInUse) {TSC_ErrMediaInUse}

TSC method init {args} {
    eval $this super init $args
    global TSC_MsgSetChanStateCmplt
    $this asyncRegister -MsgType $TSC_MsgSetChanStateCmplt -TypeDef {} -Proc {}
    return
}

#TSC_DetectEvtSet
#***INPUTS***
#-EvtType - event Type to enable
#-Set - the set of ids to use
#[-EvtGroup] - group this event is in, defaults to EvtType
#[-Receiver] - see definiont of StdResource_DetectEvt
#***Outputs***
TSC method DetectEvtSet {args} {
    array set check [CheckParms -Proc TSC_DetectEvtSet -Provided $args \
			 -Required {-EvtType -Set} -Optional {-EvtGroup -Receiver}]
    array set parms $check(Flags)
    #required arguments
    set idSet $parms(-Set)
    global TSC_MsgDetectEvtSet_Id TSC_MsgDetectEvtSet_Count
    array set QS_temp [QS_FieldDefGet $TSC_MsgDetectEvtSet_Id]
    set extra(TypeDef) [list \
			    Count $TSC_MsgDetectEvtSet_Count \
			    Set [list -Count Count \
				     -DataType $QS_temp(DataType) \
				    ] \
			   ]
    set extra(Data) [list Set $idSet]
    unset parms(-Set)
    #issue request
    return [eval $this super DetectEvt [array get parms] -Extra [list [array get extra]]]
}

#***TSC_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an TSC object, it also recognizes all types specified in Addressable_TypeDefs
TypeDefRegistry new -Name TSC_TypeDefs \
    -init [list -Extends [[TSC set Extends] set typeDefRegistry]]
array set temp [QS_FieldDefGet $TSC_MsgGetCallInfo_InfoId]
TSC_TypeDefs define -MsgType TSC_MsgGetCallInfo \
    -TypeDef [list \
	       CallId $TSC_MsgGetCallInfo_CallId \
	       Count $TSC_MsgGetCallInfo_Count \
	       InfoIds [list -DataType $temp(DataType) -Count Count] \
	  ]
unset temp
array set QS_temp [QS_FieldDefGet $TSC_MsgDetectEvtSet_Id]
TSC_TypeDefs define -Name MsgDetectEvtSet -MsgType Std_MsgDetectEvt \
    -TypeDef [list \
		  RetAddr $QS_CompDesc \
		  EvtType $Std_MsgDetectEvt_Type \
		  EvtGroup $Std_MsgDetectEvt_Label \
		  Count $TSC_MsgDetectEvtSet_Count \
		  Set [list -Count Count \
			   -DataType $QS_temp(DataType) \
			  ] \
		 ]
unset QS_temp
# Here is where the TSC Specific Field definitions for the Call info structure are stored
set TSC_CallInfo_FieldDefs(default) Type
set TSC_CallInfo_FieldDefs($CIDV_CalledId) [list -DataType $QT_CHAR -Count Length]
set TSC_CallInfo_FieldDefs($CIDV_CallerId)  [list -DataType $QT_CHAR -Count Length] 
set TSC_CallInfo_FieldDefs($CIDV_CallerSubId)  [list -DataType $QT_CHAR -Count Length] 
set TSC_CallInfo_FieldDefs($CIDV_CalledSubId)  [list -DataType $QT_CHAR -Count Length] 
set TSC_CallInfo_FieldDefs($CIDV_Display)  [list -DataType $QT_CHAR -Count Length] 
set TSC_CallInfo_FieldDefs($CIDV_RedirectedId)  [list -DataType $QT_CHAR -Count Length] 
set TSC_CallInfo_FieldDefs($CIDV_RedirectingId)  [list -DataType $QT_CHAR -Count Length]
set TSC_CallInfo_FieldDefs($CIDV_PhoneList) [list -DataType $QT_CHAR -Count Length]
set TSC_CallInfo_FieldDefs($CIDV_UUI) [list -DataType $QT_CHAR -Count Length] 
			
#this can be used in the definition of any message which contains the TSC_CallInfo_t structure
set TSC_CallInfo_t [list \
			InfoId $TSC_CallInfo_Id \
			State $TSC_CallInfo_State \
			Type $TSC_CallInfo_Type \
			Length $TSC_CallInfo_Length \
			Value   [list -Switch InfoId -Cases [array get TSC_CallInfo_FieldDefs]] \
		       ]
TSC_TypeDefs define -MsgType TSC_MsgGetCallInfoCmplt \
    -TypeDef [list \
		  CallId $TSC_MsgGetCallInfoCmplt_CallId \
		  Count $TSC_MsgGetCallInfoCmplt_Count \
		  CallInfo [list -Count Count -DataType  $TSC_CallInfo_t] \
	       ]
#the InfoId field contains both the data type and the callinfo  identifier, rather then deal with this, I just switch off the Type field which contains
#the event id
TSC_TypeDefs define -Name EvtCallInfo -EvtGroup TSC_EvtCallInfo_Type_BearerChanId \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallInfo_Type \
		  Timestamp $TSC_EvtCallInfo_Timestamp \
		  CallId $TSC_EvtCallInfo_CallId \
		  InfoId $TSC_EvtCallInfo_InfoId \
		  Value [list -Switch Type -Cases [list \
				  $TSC_EvtCallInfo_Type_CalledId $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_CallerId $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_CallerSubId $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_CalledSubId $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_Display $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_RedirectedId $TSC_EvtCallInfo_ValueStr \
				  $TSC_EvtCallInfo_Type_RedirectingId $TSC_EvtCallInfo_ValueStr \
				  default $TSC_EvtCallInfo_Value \
				] \
			 ] \
		  ]
#this defintion only remains for compatibility
TSC_TypeDefs define -EvtGroup TSC_EvtCallInfo_Type_CalledId \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallInfo_Type \
		  Timestamp $TSC_EvtCallInfo_Timestamp \
		  CallId $TSC_EvtCallInfo_CallId \
		  InfoId $TSC_EvtCallInfo_InfoId \
		  Value $TSC_EvtCallInfo_ValueStr\
		  ]
TSC_TypeDefs define -EvtGroup TSC_EvtCallInfo_Type_CallAnalysis \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallInfo_Type \
		  Timestamp $TSC_EvtCallInfo_Timestamp \
		  CallId $TSC_EvtCallInfo_CallId \
		  InfoId $TSC_EvtCallInfo_InfoId \
		  Value $TSC_EvtCallInfo_Value\
		  ]
TSC_TypeDefs define -Name EvtCallInfoSet -EvtGroup TSC_EvtCallInfoSet_Type_CallInfoSet \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallInfoSet_Type \
		  Timestamp $TSC_EvtCallInfoSet_Timestamp \
		  CallId $TSC_EvtCallInfoSet_CallId \
		  Count $TSC_EvtCallInfoSet_Count \
		  CallInfo [list -Count Count -DataType $TSC_CallInfo_t] \
		  ]
TSC_TypeDefs define -Name EvtISDNCallInfoSet \
	-EvtGroup { TSC_EvtCallInfoSet_Type_ISDNMsgSet TSC_EvtCallInfoSet_Type_IESet } \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallInfoSet_Type \
		  Timestamp $TSC_EvtCallInfoSet_Timestamp \
		  CallId $TSC_EvtCallInfoSet_CallId \
		  Count $TSC_EvtCallInfoSet_Count \
		  MessageType $TSC_EvtCallInfoSet_MessageType \
		  Data [list -Count -1 -DataType $CCS_IE_t ] \
		  ]
TSC_TypeDefs define -Name EvtCallState -EvtGroup TSC_EvtCallState_Type_Null \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallState_Type \
		  Timestamp $TSC_EvtCallState_Timestamp \
		  CallId $TSC_EvtCallState_CallId \
		  CallState $TSC_EvtCallState_CallState \
		  Reason $TSC_EvtCallState_Reason \
		 ]
TSC_TypeDefs define -Name EvtCallState -EvtGroup TSC_EvtCallState_Type_Null \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtCallState_Type \
		  Timestamp $TSC_EvtCallState_Timestamp \
		  CallId $TSC_EvtCallState_CallId \
		  CallState $TSC_EvtCallState_CallState \
		  Reason $TSC_EvtCallState_Reason \
		 ]
TSC_TypeDefs define -Name EvtChanState -EvtGroup TSC_EvtChanState_Type_Active \
    -TypeDef [list \
		  EvtGroup $Std_MsgEvtDetected_Label \
		  Type $TSC_EvtChanState_Type \
		  Timestamp $TSC_EvtChanState_Timestamp \
		  ChanState $TSC_EvtChanState_ChanState \
		  ]
TSC_TypeDefs define -Name EvtGCExtension -EvtGroup TSC_EvtGCExtension_Type_Extension \
	-TypeDef [list \
		EvtGroup $Std_MsgEvtDetected_Label \
		Type $TSC_EvtGCExtension_Type \
		Timestamp $TSC_EvtGCExtension_Timestamp \
		Int1Val $TSC_EvtGCExtension_Int1Val \
		Int2Val $TSC_EvtGCExtension_Int2Val \
		Int3Val $TSC_EvtGCExtension_Int3Val \
		Str1Val $TSC_EvtGCExtension_Str1Val \
		Str2Val $TSC_EvtGCExtension_Str2Val \
	]
#Key Value Field Definitions
#this array has indicies which are TSC Keys, the value is a field definition to use to parser the data associated with the key
set TSC_KVSet_FieldDefs(default) [list -DataType $QT_UINT8 -Count ByteLength];#default for non-matched keys is a list of Uint8s
set TSC_KVSet_FieldDefs($TSC_KVSet_Key_NULL) $QS_Empty;#The special NULL key signifies that there is no Value
set TSC_KVSet_FieldDefs($TSC_KVSet_Key_CallInfo) [list -DataType $TSC_CallInfo_t]
set TSC_KVSet_FieldDefs($TSC_KVSet_Key_IE) [list -DataType $QT_UINT8 -Count ByteLength];#KVSet containing ISDN IE data
#the VariantParm key allows the chaning of variant parameters in a kvset
set TSC_KVSet_FieldDefs($TSC_KVSet_Key_VariantParm)   [list \
							-Term {Id 0x0 Type 0x0} \
							-DataType [list \
								       Id $TSC_VariantParm_Id \
								       Type $TSC_VariantParm_Type \
								       Value [list -Switch Id \
										  -Cases [list \
											      0x0 $QS_Empty \
											      default Type \
											     ] \
										 ] \
								      ]\
							]
#generic call control kv set definition
set TSC_KVSet_t [list \
		     Key $TSC_KVSet_Key \
		     ByteLength $TSC_KVSet_Length \
		     Value [list -Switch Key \
				-Cases [array get TSC_KVSet_FieldDefs]
			   ] \
		    ]
#this is a field defintion describing a list of kv sets which appear at the end of a message
set TSC_KVSet_list_t [list -DataType $TSC_KVSet_t -Count -1]
TSC_TypeDefs define -MsgType TSC_MsgAcceptCall \
    -TypeDef [list \
		  CallId $TSC_MsgAcceptCall_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgAnswerCall \
    -TypeDef [list \
		  CallId $TSC_MsgAnswerCall_CallId \
		  NumRings $TSC_MsgAnswerCall_NumRings \
		  KVSet $TSC_KVSet_list_t \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgBlindTransferCall \
    -TypeDef [list \
		  CallId $TSC_MsgBlindTransferCall_CallId \
		  DestAddr $TSC_MsgBlindTransferCall_DestAddr \
		  OrigAddr $TSC_MsgBlindTransferCall_OrigAddr \
		  CallProgress $TSC_MsgBlindTransferCall_CallProgress \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgCancelTransfer \
    -TypeDef [list \
		  CallId $TSC_MsgCancelTransfer_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgCancelComplete \
    -TypeDef [list \
		  CmpltId $TSC_MsgCancelComplete_CmpltId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgCompleteCall \
    -TypeDef [list \
		  CallId $TSC_MsgCompleteCall_CallId \
		  Mode $TSC_MsgCompleteCall_Mode \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgCompleteCallCmplt \
    -TypeDef [list \
		  CmpltId $TSC_MsgCompleteCallCmplt_CmpltId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgCompleteTransfer \
    -TypeDef [list \
		  CallId $TSC_MsgCompleteTransfer_CallId \
		  ConCallId $TSC_MsgCompleteTransfer_ConCallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgDropCall \
    -TypeDef [list \
		  CallId $TSC_MsgDropCall_CallId \
		  Reason $TSC_MsgDropCall_Reason \
		  KVSet $TSC_KVSet_list_t \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgDial \
    -TypeDef [list \
		  CallId $TSC_MsgDial_CallId \
		  DigitString $TSC_MsgDial_DigitString \
		  CallProgress $TSC_MsgDial_CallProgress \
		  EndOfDigits $TSC_MsgDial_EndOfDigits \
		  KVSet $TSC_KVSet_list_t \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgDialCmplt \
    -TypeDef [list \
		  Reason $TSC_MsgDialCmplt_Reason \
		  ]
TSC_TypeDefs define -MsgType TSC_MsgGetCallState \
    -TypeDef [list \
		  CallId $TSC_MsgGetCallState_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgGetCallStateCmplt \
    -TypeDef [list \
		  CallId $TSC_MsgGetCallStateCmplt_CallId \
		  CallState $TSC_MsgGetCallStateCmplt_CallState \
		  Reason $TSC_MsgGetCallStateCmplt_Reason \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgGetChanStateCmplt \
    -TypeDef [list \
		  ChanState $TSC_MsgGetChanStateCmplt_ChanState \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgHoldCall \
    -TypeDef [list \
		  CallId $TSC_MsgHoldCall_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgInitTransfer \
    -TypeDef [list \
		  CallId $TSC_MsgInitTransfer_CallId \
		  DestAddr $TSC_MsgInitTransfer_DestAddr \
		  OrigAddr $TSC_MsgInitTransfer_OrigAddr \
		  CallProgress $TSC_MsgInitTransfer_CallProgress \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgInitTransferCmplt \
    -TypeDef [list \
		  CallId $TSC_MsgInitTransferCmplt_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgMakeCall \
    -TypeDef [list \
		  DestAddr $TSC_MsgMakeCall_DestAddr \
		  OrigAddr $TSC_MsgMakeCall_OrigAddr \
		  CallProgress $TSC_MsgMakeCall_CallProgress \
		  KVSet $TSC_KVSet_list_t \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgMakeCallCmplt \
    -TypeDef [list \
		  CallId $TSC_MsgMakeCallCmplt_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgParkCall \
    -TypeDef [list \
		  CallId $TSC_MsgParkCall_CallId \
		  ParkAddr $TSC_MsgParkCall_ParkAddr \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgParkCallCmplt \
    -TypeDef [list \
		  ParkId $TSC_MsgParkCallCmplt_ParkId \
		  ParkAddr $TSC_MsgParkCallCmplt_ParkAddr \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgPickupCall \
    -TypeDef [list \
		  ParkId $TSC_MsgPickupCall_ParkId \
		  ParkAddr $TSC_MsgPickupCall_ParkAddr \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgPickupCallCmplt \
    -TypeDef [list \
		  CallId $TSC_MsgPickupCallCmplt_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgReconnectCall \
    -TypeDef [list \
		  CallId $TSC_MsgReconnectCall_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgRedirectCall \
    -TypeDef [list \
		  CallId $TSC_MsgRedirectCall_CallId \
		  DestAddr $TSC_MsgRedirectCall_DestAddr \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgReleaseCall \
    -TypeDef [list \
		  CallId $TSC_MsgReleaseCall_CallId \
		  Reason $TSC_MsgReleaseCall_Reason \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgRejectCall \
    -TypeDef [list \
		  CallId $TSC_MsgRejectCall_CallId \
		  Reason $TSC_MsgRejectCall_Reason \
		  KVSet $TSC_KVSet_list_t \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgRetrieveCall \
    -TypeDef [list \
		  CallId $TSC_MsgRetrieveCall_CallId \
		 ]
TSC_TypeDefs define -MsgType TSC_MsgSetChanState \
    -TypeDef [list \
		  State $TSC_MsgSetChanState_state \
		 ]
#the actual embeded message isn't read.  callback handlers should receive the msg, then do an inital read with this structure, then use the
#value of MsgType to do the additional read
TSC_TypeDefs define -Name EvtTrace -EvtGroup TSC_EvtTrace_Type_CallControl \
    -TypeDef [list \
		  EvtGroup $TSC_EvtTrace_Label \
		  Type $TSC_EvtTrace_Type \
		  Timestamp $TSC_EvtTrace_Timestamp \
		  MsgType $TSC_EvtTrace_MsgType \
	      ]
TSC_TypeDefs define -MsgType TSC_MsgGetChanState \
    -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgSetChanStateCmplt \
    -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgSendISDN \
    -TypeDef [list \
		CallId $TSC_MsgSendISDN_CallId \
		MessageType $TSC_MsgSendISDN_MessageType \
		DataLength $TSC_MsgSendISDN_DataLength \
		Data [list -DataType $QT_UINT8 -Count DataLength] \
		]
TSC_TypeDefs define -MsgType TSC_MsgSendISDNCmplt \
    -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgProceedCall \
    -TypeDef [list \
		  CallId $TSC_MsgProceedCall_CallId \
		  KVSet $TSC_KVSet_list_t \
		  ]
TSC_TypeDefs define -MsgType TSC_MsgAttach \
	-TypeDef [list \
					Count $TSC_MsgAttach_Count \
					MediaInfo [list -Count Count \
							 		-DataType [list \
							  						ComponentType $TSC_MsgAttach_MediaInfo_ComponentType \
													InstDesc		  $QS_CompDesc \
												 ] \
								 ] \
				]
TSC_TypeDefs define -MsgType TSC_MsgAttachCmplt \
	 -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgDetach \
	-TypeDef {} 
TSC_TypeDefs define -MsgType TSC_MsgDetachCmplt \
	 -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgSetAlarmMask \
	-TypeDef [list \
					Linenum $TSC_MsgSetAlarmMask_Linenum \
					Alarm_mask $TSC_MsgSetAlarmMask_Alarm_mask \
				]
TSC_TypeDefs define -MsgType TSC_MsgSetAlarmMaskCmplt \
	 -TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgGetAlarmMask \
	-TypeDef [list \
					Linenum $TSC_MsgGetAlarmMask_Linenum \
				]
TSC_TypeDefs define -MsgType TSC_MsgGetAlarmMaskCmplt \
	-TypeDef [list \
					Linenum $TSC_MsgGetAlarmMaskCmplt_Linenum \
					Alarm_mask $TSC_MsgGetAlarmMaskCmplt_Alarm_mask \
				]
TSC_TypeDefs define -MsgType TSC_MsgGCExtension \
	-TypeDef [list \
		Int1Val $TSC_MsgGCExtension_Int1Val \
		Int2Val $TSC_MsgGCExtension_Int2Val \
		Int3Val $TSC_MsgGCExtension_Int3Val \
		Str1Val $TSC_MsgGCExtension_Str1Val \
		Str2Val $TSC_MsgGCExtension_Str2Val \
		]
TSC_TypeDefs define -MsgType TSC_MsgGCExtensionCmplt \
	-TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgResetLineDevice \
	-TypeDef [ list \
	               state $TSC_MsgResetLineDevice_state \
	         ]	
TSC_TypeDefs define -MsgType TSC_MsgResetLineDeviceCmplt \
	-TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgTxRxSignalingGet \
	-TypeDef {}
TSC_TypeDefs define -MsgType TSC_MsgTxRxSignalingGetCmplt \
	-TypeDef [list \
					signalbits $TSC_MsgTxRxSignalingGetCmplt_signalBits \
				]
TSC defineMsgMethod -MethodName AcceptCall \
    -Type $TSC_MsgAcceptCall -TypeDef lookup -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName AnswerCall \
    -Type $TSC_MsgAnswerCall -TypeDef lookup -Defaults {-CallId 0 -NumRings 0 -KVSet {}}
TSC defineMsgMethod -MethodName BlindTransferCall \
    -Type $TSC_MsgBlindTransferCall -TypeDef lookup \
    -Defaults [list -CallId 0 -DestAddr {} -OrigAddr {} -CallProgress $TSC_MsgBlindTransferCall_CallProgress_Disabled]
TSC defineMsgMethod -MethodName CancelTransfer \
    -Type $TSC_MsgCancelTransfer -TypeDef lookup \
    -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName CancelComplete \
    -Type $TSC_MsgCancelComplete -TypeDef lookup
TSC defineMsgMethod -MethodName CompleteCall \
    -Type $TSC_MsgCompleteCall -TypeDef lookup -Defaults {-CallId 0} \
    -RetType $TSC_MsgCompleteCallCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName CompleteTransfer \
    -Type $TSC_MsgCompleteTransfer -TypeDef lookup -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName DropCall \
    -Type $TSC_MsgDropCall -TypeDef lookup \
    -Defaults [list -CallId 0 -Reason $CallStateR_Normal -KVSet {}]
TSC defineMsgMethod -MethodName GetCallState \
    -Type $TSC_MsgGetCallState -TypeDef lookup -Defaults {-CallId 0} \
    -RetType $TSC_MsgGetCallStateCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName GetChanState \
    -Type $TSC_MsgGetChanState -TypeDef lookup \
    -RetType $TSC_MsgGetChanStateCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName HoldCall \
    -Type $TSC_MsgHoldCall -TypeDef lookup \
    -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName InitTransfer \
    -Type $TSC_MsgInitTransfer -TypeDef lookup \
    -Defaults [list -CallId 0 -DestAddr {} -OrigAddr {} \
		   -CallProgress $TSC_MsgInitTransfer_CallProgress_Disabled] \
    -RetType $TSC_MsgInitTransferCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName MakeCall \
    -Type $TSC_MsgMakeCall -TypeDef lookup \
    -Defaults [list -DestAddr {} -OrigAddr {} \
		   -KVSet {} \
		   -CallProgress $TSC_MsgMakeCall_CallProgress_Disabled] \
    -RetType $TSC_MsgMakeCallCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName ParkCall \
    -Type $TSC_MsgParkCall -TypeDef lookup \
    -Defaults {-ParkAddr {} -CallId 0} \
    -RetType $TSC_MsgParkCallCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName PickupCall \
    -Type $TSC_MsgPickupCall -TypeDef lookup \
    -RetType $TSC_MsgPickupCallCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName ReconnectCall \
    -Type $TSC_MsgReconnectCall -TypeDef lookup \
    -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName RedirectCall \
    -Type $TSC_MsgRedirectCall -TypeDef lookup \
    -Defaults {-CallId 0 -DestAddr {}}
TSC defineMsgMethod -MethodName ReleaseCall \
    -Type $TSC_MsgReleaseCall -TypeDef lookup \
    -Defaults [list -CallId 0 -Reason $CallStateR_Normal]
TSC defineMsgMethod -MethodName RejectCall \
    -Type $TSC_MsgRejectCall -TypeDef lookup \
    -Defaults [list -CallId 0 -Reason $TSC_MsgRejectCall_Reason_Busy -KVSet {}]
TSC defineMsgMethod -MethodName RetrieveCall \
    -Type $TSC_MsgRetrieveCall -TypeDef lookup \
    -Defaults {-CallId 0}
TSC defineMsgMethod -MethodName SetChanState \
    -Type $TSC_MsgSetChanState -TypeDef lookup \
    -RetType $TSC_MsgSetChanStateCmplt
TSC defineMsgMethod -MethodName StartSetChanState \
    -Type $TSC_MsgSetChanState -TypeDef lookup
TSC defineMsgMethod -MethodName GetCallInfo \
    -Type $TSC_MsgGetCallInfo -TypeDef lookup \
    -Defaults {-CallId 0 -Count {}} \
    -RetType $TSC_MsgGetCallInfoCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName SendISDN \
    -Type $TSC_MsgSendISDN -TypeDef lookup \
    -Defaults {-CallId 0 -DataLength {}} \
    -RetType $TSC_MsgSendISDNCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName Dial \
    -Type $TSC_MsgDial -TypeDef lookup \
    -Defaults [list -CallId 0 -CallProgress $TSC_MsgDial_CallProgress_Disabled \
		   -EndOfDigits $TSC_MsgDial_EndOfDigits_AUTO -KVSet {}] \
    -RetType $TSC_MsgDialCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName ProceedCall \
    -Type $TSC_MsgProceedCall -TypeDef lookup \
    -Defaults {-CallId 0 -KVSet {}}
TSC defineMsgMethod -MethodName Attach \
	 -Type $TSC_MsgAttach -TypeDef lookup -Defaults {-Count {}} \
	 -RetType $TSC_MsgAttachCmplt -RetTypeDef lookup 
TSC defineMsgMethod -MethodName Detach \
	 -Type $TSC_MsgDetach -TypeDef lookup \
	 -RetType $TSC_MsgDetachCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName SetAlarmMask \
	 -Type $TSC_MsgSetAlarmMask -TypeDef lookup -Defaults {-Alarm_mask 0x0046} \
	 -RetType $TSC_MsgSetAlarmMaskCmplt -RetTypeDef lookup 
TSC defineMsgMethod -MethodName GetAlarmMask \
	 -Type $TSC_MsgGetAlarmMask -TypeDef lookup \
	 -RetType $TSC_MsgGetAlarmMaskCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName GCExtension \
	-Type $TSC_MsgGCExtension -TypeDef lookup \
	-Defaults {-Int1Val 0 -Int2Val 0 -Int3Val 0 -Str1Val {} -Str2Val {} } \
	-RetType $TSC_MsgGCExtensionCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName ResetLineDevice \
    -Type $TSC_MsgResetLineDevice -TypeDef lookup \
    -Defaults {-state 0x100 } \
    -RetType $TSC_MsgResetLineDeviceCmplt -RetTypeDef lookup
TSC defineMsgMethod -MethodName GetSignalBits \
	 -Type $TSC_MsgTxRxSignalingGet -TypeDef lookup \
	 -RetType $TSC_MsgTxRxSignalingGetCmplt -RetTypeDef lookup
return

