# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#report error and file line number
proc perror {args} {
    global linenum
    puts stderr "**** $args"
    exit
}

#CheckParms - check for valid, required, and optional parmaters
#Required Inputs
#-Proc name - the name of the procedure being checked
#-Provided list - the list of provided parameters
#Optional Inputs
#-Required list - the list of required inputs
#-Optional list - the list of optional inputs
#-Switches list - the list of optional switches
proc CheckParms {args} {

    if [catch {
	#puts $args
	array set parms $args

	set procname $parms(-Proc)


	set prov_tmp $parms(-Provided)


	set cp_valid [list -Proc -Provided -Required -Optional -Switches]

	foreach parm [array names parms] {
	    if {[lsearch -exact $cp_valid $parm]==-1} {
		#not a valid option
		error "$parm invalid"
	    }
	}


    } result] {
	#there was an error calling CheckParms
	error "- CheckParms -Proc arg -Provided arg \[-Required arg\] \[-Optional arg\] \[-Switches arg\]"
    }


    if [catch {set required $parms(-Required)} result] {
	set required {}
    }
    if [catch {set optional $parms(-Optional)} result] {
	set optional {}
    }
    if [catch {set switches $parms(-Switches)} result] {
	set switches {}
    }


    set valid [concat $required $optional $switches]

    set valid_list "- ${procname} "


    foreach parm $required {
	lappend valid_list ${parm} arg
    }

    foreach parm $optional {
	set valid_list [concat $valid_list "\[${parm} arg\]"]
    }

    foreach parm $switches {
	set valid_list [concat $valid_list "\[${parm}\]"]
    }


    #check if provided == -?, if so return list of valid parms
    if {$prov_tmp == "-?"} {
	error $valid_list
    }

    #start checking

    #check to see if provided is properly formatted
    set activated_switches {}

    #remove the switches
    foreach parm $switches {
	if {[set a [lsearch -exact $prov_tmp $parm]]>-1} {
	    set prov_tmp [lreplace $prov_tmp $a $a]
	    lappend activated_switches $parm
	}
    }
    
    #check to see that all flags have a paired argument
   if [catch {array set provarr $prov_tmp}] {
	error "error in switches $valid_list"
   }

   set provided [array names provarr]

    #check to see if all provided flags are valid
    #note: switches have already been checked though their removal
   foreach parm $provided {
       if {[lsearch -exact $valid $parm]==-1} {
	   error "$parm not a valid flag to $valid_list"
       }
    }

    #check to make sure all required are provided
    foreach parm $required {
	if {[lsearch -exact $provided $parm]==-1} {
	    error "$parm is a required flag for $valid_list"
	}
    }


    #return a list of switches, and flag arg pairs
    return [concat Switches [list $activated_switches] Flags [list $prov_tmp]]
};#endof CheckParms





proc ReplaceStringInLine {origLine origString newString} {
    #convert line to all lower case, SDL isn't case sensitive
    set line [string tolower $origLine]
    set origString [string tolower $origString]

    #search for origString in line
    set index [string first $origString $line]
    set newStrLen [string length $newString]
    set origStrLen [string length $origString]

    set newline {}

    while {[expr $index != -1]} {
	set newline ${newline}[string range $line -1 [expr $index - 1]]${newString}
	set line [string range $line [expr $index + $origStrLen] end]
	set index [string first $origString $line]
    }

    set newline ${newline}${line}

    return $newline
};#endof ReplaceStringInLine


set linenum 1
#this procedure will read a line from an open file, if term is supplied it will keep reading lines untill it encounters, any text between commentStart and commentStop will be skiped over
proc readLine {file {term {}} {commentStart {}} {commentStop {}} } {
    global linenum
    set line {}
    set termlength [string length $term]
    while [expr 1] {
	if [expr [gets $file newline] == -1] {
	    error eof
	}

	incr linenum

	#compute line length, add one for EOL character
	set linelength [expr [string length $newline] +1]

	if {$commentStart != {} && $term != {}} {
	    set cindex [string first $commentStart $newline]
	    set tindex [string first $term $newline]
	    if {($tindex < $cindex && $tindex != -1) || ($tindex != -1 && $cindex == -1)} {
		#term of line found before comment
		set line "${line} [string range $newline -1 [expr $tindex + $termlength - 1]]"
		seek $file [expr -(($linelength - $tindex) - $termlength) ] current
		return $line
	    } elseif {($cindex <= $tindex && $cindex != -1) || ($tindex == -1 && $cindex != -1)} {
		#start of comment found, read till end of comment and discard
		seek $file [expr -(($linelength - $cindex) - [string length $commentStart]) ] current
		readLine $file $commentStop
		set line "$line [string range $newline -1 [expr $cindex -1]]"
	    } else {
		#neither term or comment was found so read next line and repeat
		set line "$line $newline"
	    }
	} elseif {$commentStart != {} && $term == {}} {
	    set cindex [string first $commentStart $newline]
	    if {$cindex != -1} {
		#start of comment found, read till end of comment and discard
		seek $file [expr -(($linelength - $cindex) - [string length $commentStart]) ] current
		readLine $file $commentStop
		return [string range $newline -1 [expr $cindex -1]]
	    } else {
		#no comment so return entire line
		return $newline
	    }
	} elseif {$commentStart == {} && $term != {}} {
	    set tindex [string first $term $newline]
	    if {$tindex != -1} {
		#term was found. rewind and return
		set line "${line} [string range $newline -1 [expr $tindex + $termlength - 1]]"
		seek $file [expr -(($linelength - $tindex) - $termlength) ] current
		return $line
	    } else {
		#term wasn't found. store and read next line
		set line $newline
	    }
	} else {
	    return $newline
	}
    }
};#endof readLine

#pairs is a kv list of pairs where the first element of the pair will be replaced by the second
proc ReplaceStringInFile {fileName pairs} {

    set in [open $fileName r]
    set out [open ${fileName}.tmp w+]

    while {[expr [gets $in line] != -1]} {
	foreach pair $pairs {
	    set line [ReplaceStringInLine $line [lindex $pair 0] [lindex $pair 1]]
	}
	puts $out $line
    }

    close $in
    close $out

    file rename -force $fileName ${fileName}.orig
    file rename -force ${fileName}.tmp $fileName

};#endof ReplaceStringInFile



#takes in a list and sorts its elements by length, largest first
proc lengthSort {origList} {

    foreach item $origList {
	lappend size_arr([string length $item]) $item
    }

    set size_list [lsort -decreasing -integer [array names size_arr]]

    set result {}

    foreach size $size_list {
	set result [concat $result $size_arr($size)]
    }

    return $result
}


set QT_INT8 0x0
set QT_INT16 [format "0x%x" [expr $QT_INT8 + 1]]
set QT_INT24 [format "0x%x" [expr $QT_INT16 + 1]]
set QT_INT32 [format "0x%x" [expr $QT_INT24 + 1]]
set QT_UINT8 [format "0x%x" [expr $QT_INT32 + 1]]
set QT_UINT16 [format "0x%x" [expr $QT_UINT8 + 1]]
set QT_UINT24 [format "0x%x" [expr $QT_UINT16 + 1]]
set QT_UINT32 [format "0x%x" [expr $QT_UINT24 + 1]]
set QT_FRAC16 [format "0x%x" [expr $QT_UINT32 + 1]]
set QT_FRAC24 [format "0x%x" [expr $QT_FRAC16 + 1]]
set QT_CHAR [format "0x%x" [expr $QT_FRAC24 + 1]]
set QT_CHAR_PACKED [format "0x%x" [expr $QT_CHAR + 1]]
set QT_MEMREF [format "0x%x" [expr $QT_CHAR_PACKED + 1]]
set QT_BUFREF [format "0x%x" [expr $QT_MEMREF + 1]]
set QT_STREAMREF [format "0x%x" [expr $QT_BUFREF + 1]]
set QT_ATTR [format "0x%x" [expr $QT_STREAMREF + 1]]
set QT_COMPDESC [format "0x%x" [expr $QT_ATTR + 1]]
set QT_PARM [format "0x%x" [expr $QT_COMPDESC + 1]]
set QT_NULL [format "0x%x" [expr -1 ]]

catch {set QFIELDDEF_OFFSET [format "0x%x" { 0 }] }
catch {set QFIELDDEF_COUNT [format "0x%x" { 11 }] }
catch {set QFIELDDEF_DATATYPE [format "0x%x" { 19 }] }
catch {set QFIELDDEF_OFFSETMASK [format "0x%x" { 0x0007ff }] }
catch {set QFIELDDEF_COUNTMASK [format "0x%x" { 0x07f800 }] }
catch {set QFIELDDEF_DATATYPEMASK [format "0x%x" { 0xf80000 }] }

proc FieldDefSet {args} {
    array set check [CheckParms -Proc "FieldDefSet" \
			 -Provided $args \
			 -Required {-DataType} \
			 -Optional {-Count -Offset -After}]

    array set parms $check(Flags)

    #required fields
    set datatype $parms(-DataType)

    #optional
    if [catch {set count $parms(-Count)} result] {
	set count 1;#default it to one
    } 
    incr count -1

    if [catch {set offset $parms(-Offset)} result] {
	set offset 0;#default it to zero
    }

    if [info exists parms(-After)] {
	#this is fielddef which this one follows
	#this will overide any supplied offset
	set fd $parms(-After)
	array set after_fd [QS_FieldDefGet $fd]
	set offset $after_fd(Offset)
	incr offset [expr $after_fd(Count) * [QS_DataTypeGetSize $after_fd(DataType)]]
    }

    global QFIELDDEF_OFFSET QFIELDDEF_COUNT QFIELDDEF_DATATYPE
    set fielddef [expr ($offset << $QFIELDDEF_OFFSET) | \
		      ($count << $QFIELDDEF_COUNT) | \
		      ($datatype << $QFIELDDEF_DATATYPE)]
    return [format 0x%x $fielddef]

};#endof FieldDefSet


#FieldDefGet - Gets the values in a FieldDef
#***Inputs***
#FieldDef - the FieldDef to query
#[PreviousValues] - values from earlier msg body
#***Outputs***
#the fiedldef info
#***Exceptions***
proc FieldDefGet {fielddef} {
    global QFIELDDEF_OFFSET QFIELDDEF_COUNT QFIELDDEF_DATATYPE QFIELDDEF_OFFSETMASK QFIELDDEF_COUNTMASK QFIELDDEF_DATATYPEMASK QFIELDDEF_COUNTMASK
 
    set fd(Offset) [expr ($fielddef & $QFIELDDEF_OFFSETMASK) >> $QFIELDDEF_OFFSETMASK]
    set fd(Count) [expr ($fielddef & $QFIELDDEF_COUNTMASK) >> $QFIELDDEF_COUNTMASK]
    set fd(DataType) [expr ($fielddef & $QFIELDDEF_DATATYPEMASK) >> $QFIELDDEF_DATATYPEMASK]
    return [array get fd]
};#endof FieldDefGet

proc compareArrays {nameA nameB ignoreList} {
    upvar $nameA a
    upvar $nameB b

    if [expr [array size a] != [array size b]] {
	#arrays are of different size
	return 0
    }

    foreach index [array names a] {
	if {[lsearch -exact $ignoreList $index] != -1} {
	    #in ignore list, don't check
	    continue
	}
	if ![info exists b($index)] {
	    #element in a not in b
	    return 0
	}
	if {$a($index) != $b($index)} {
	    #element in a != element in b
	    return 0
	}
    }

    return 1
};#endof compareArrays



#remove section from data
proc removeSection {data start end} {

    set sindex [expr [string first $start $data] -1]
    set eindex [expr [string last $end $data] + [string length $end]]

    set pre [string range $data -1 $sindex]
    set post [string range $data $eindex end]

    return ${pre}${post}

}

proc gen_crc32 {proto_str str_len} {

   # 'crc_ord' - CRC polynom order without the leading '1' bit
   # 'polynom' - CRC polynomial without leading '1' bit
   # 'initial_crc' - Initial value of CRC register 
   set crc_ord 32
   set polynom 0x4c11db7
   set initial_crc 0x0

   # set 'crchighbit' to 10000000 00000000 00000000 00000000 
   set crchighbit [expr 1<<[expr $crc_ord-1]]

   # Initialize crc register.
   # Typical initial values are 0x00000000 and 0xFFFFFFFF
   set crc_register $initial_crc

   # Loop through # bytes in original string
	for {set i 0} {$i<$str_len} {incr i} {
		# 'ch' set to the 1st ASCII char in string
      scan $proto_str %c ch
      # 'ch' is stripped from string.
      set proto_str [string replace $proto_str 0 0]

      # Loop throgh each bit in 'ch'.
      # This loop essentially shifts the string into the 
      # CRC register bit by bit and calculates the new CRC
      # 'b' = 1000 0000 --> 0000 0001 
      for {set b 0x80} {$b>0} {set b [expr $b>>1]} {
         # Is MSB of current CRC SET?
			set popped_bit [expr $crc_register & $crchighbit]

         # "pop" the bit
			set crc_register [expr $crc_register<<1]

         # If next bit carried into register is a 1, 
         # update the crc_register to reflect this. This should
         # occur only if the length of the string is 
         # greater than the order of the crc_register (32).
			if {[expr $ch & $b]} {
				set crc_register [expr $crc_register | 1]
			}

         # Was "popped" bit SET?, 
         # Perform binary div (XOR with generator polynomial)
         # Poly = 0100 1100 0001 0001 1101 1011 0111
			if {$popped_bit} {
				set crc_register [expr $crc_register ^ $polynom]
			}
		}
	}

   # Loop through remaining bits of augmented message
   # also updating the CRC as necessary.
	for {set i 0} {$i<$crc_ord} {incr i} { 
		set popped_bit [expr $crc_register & $crchighbit]
		set crc_register [expr $crc_register<<1]
		if {$popped_bit} {
			set crc_register [expr $crc_register^$polynom]
		}
	}
	return $crc_register
}

