# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

if [catch {array set check [CheckParms -Proc audio.qs -Provided $argv_clean \
                            -Required {-board} \
                            -Optional {-line -chan}]} result ] {
    puts stderr $result
    return
}

array set argvarr $argv_clean
cd $qscript_path
source ${qscript_library}/Player_Class.qs
source ${qscript_library}/Recorder_Class.qs
source filecomp.qs

set bitmaps(PLAY) @play.xbm
set bitmaps(RECORD) @rec.xbm
set bitmaps(PAUSE) @pause.xbm
set bitmaps(STOP) @stop.xbm
set bitmaps(UP) @up.xbm
set bitmaps(DOWN) @down.xbm
set bitmaps(NORMAL) @normal.xbm
set bitmaps(TOGGLE) @toggle.xbm

set encoders {
    MULAW64E
    ALAW64E
    OKI32E
    MULAW48E
    ALAW48E
    OKI24E
}

set decoders {
    MULAW64D
    ALAW64D
    OKI32D
    MULAW48D
    ALAW48D
    OKI24D
}

#default coders
set encoder $MULAW64E
set decoder $MULAW64D

proc handleStopEvt {obj type evt} {
    global ply rec
    array set evtarr $evt

    if {$obj == $ply} {
	set thing .control1.play
	global player_pause
	set player_pause 0
    }
    if {$obj == $rec} {
	set thing .control1.record
	global record_pause
	set record_pause 0
    }

    $thing.start configure -state normal
    $thing.stop configure -state disabled
    $thing.pause_resume configure -state disabled
}

proc handleStartEvt {obj type evt} {
    global ply rec
    array set evtarr $evt

    if { $obj == $ply } {
	set thing .control1.play
	global player_pause
	set player_pause 0
    }
    if { $obj == $rec } {
	set thing .control1.record
	global player_pause
	set player_pause 0
    }

    $thing.start configure -state disabled
    $thing.stop configure -state normal
    $thing.pause_resume configure -state normal
}

proc handlePauseEvt {obj type evt } {
    global ply rec
    array set evtarr $evt

    if { $obj == $ply } {
	set thing .control1.play
    }
    if { $obj == $rec } {
	set thing .control1.record
    }

    $thing.start configure -state disabled
    $thing.stop configure -state normal
}

proc quit { } {
    global clust ply rec
    exit
}

proc volumeCtrl { ctrl } {
    global ply volume
    array set retval [$ply AdjVolume -VolumeMode $ctrl]
    set volume $retval(NewVolume)
}

proc speedCtrl { ctrl } {
    global ply speed
    array set retval [$ply AdjSpeed -SpeedMode $ctrl]
    set speed $retval(NewSpeed)
}

proc PlayerPauseResume { } {
    global player_pause ply
    if {$player_pause == 0} {
	$ply Resume
    } else {
	$ply Pause	
    }

}

proc RecorderPauseResume { } {
    global record_pause rec
    if {$record_pause == 0} {
	$rec Resume
    } else {
	$rec Pause
    }
}

proc toggleUnderruns {} {
    global underruns rec ply  Player_ParmUnderrunReporting \
	Player_ParmUnderrunReporting_Off Player_ParmUnderrunReporting_On
    if [expr $underruns] {
	$ply SetParm -Parm $Player_ParmUnderrunReporting -Val $Player_ParmUnderrunReporting_On
    } else {
	$ply SetParm -Parm $Player_ParmUnderrunReporting -Val $Player_ParmUnderrunReporting_Off
    }
}

proc queryBox {{question {Enter Value}} {title {}} {default {}}} {
    set unique [clock seconds]
    set box [toplevel .question$unique]
    wm title $box $title
    frame ${box}.top
    global retval$unique
    set retval$unique $default
    label ${box}.top.label -text $question
    entry ${box}.top.entry -textvariable retval$unique
    pack ${box}.top.label
    pack ${box}.top.entry
    frame ${box}.bottom
    button ${box}.bottom.ok -text "Ok" -command [list set status$unique ok]
    button ${box}.bottom.cancel -text "Cancel" -command [list set status$unique cancel]
    pack ${box}.bottom.ok ${box}.bottom.cancel -side left
    pack ${box}.top
    pack ${box}.bottom
    global status$unique
    vwait status$unique
    if {[set status${unique}] == "ok"} {
	unset status$unique
	destroy $box
	set retval [set retval$unique]
	unset retval$unique
	return $retval
    } else {
	unset status$unique
	destroy $box
	error queryCancel
    }
}

#default values
set line 1
set chan 1

set boardnum $argvarr(-board)
if [info exist argvarr(-line)] {set line $argvarr(-line)}
if [info exist argvarr(-chan)] {set chan $argvarr(-chan)}
wm title . [list DM3 Audio Control $boardnum.$line.$chan]
set board [Board new -init [list -BoardNum $boardnum]]
set clust [$board findClust -Attrs [list \
			 [list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
					[list -key $TSC_AttrLineId -value $line] \
					[list -key $TSC_AttrChanId -value $chan] ] ]

if [catch {set ply [$clust find -InstClass Player]} result] {
    set ply [$clust allocateInst -InstClass Player]
}

if [catch {set rec [$clust find -InstClass Recorder]} result] {
    set rec [$clust allocateInst -InstClass Recorder]
}

$ply asyncRegister -EvtGroup $Player_Event_Type_EvtStopped -Proc handleStopEvt
$ply asyncRegister -EvtGroup $Player_Event_Type_EvtPlaying -Proc handleStartEvt
$ply asyncRegister -EvtGroup $Player_Event_Type_EvtPaused -Proc handlePauseEvt
$rec asyncRegister -EvtGroup $Recorder_Event_Type_EvtStopped -Proc handleStopEvt
$rec asyncRegister -EvtGroup $Recorder_Event_Type_EvtRecording -Proc handleStartEvt
$rec asyncRegister -EvtGroup $Recorder_Event_Type_EvtPaused -Proc handlePauseEvt
$ply DetectEvt -EvtType $Player_Event_Type_EvtStopped
$ply DetectEvt -EvtType $Player_Event_Type_EvtPlaying
$ply DetectEvt -EvtType $Player_Event_Type_EvtPaused
$rec DetectEvt -EvtType $Recorder_Event_Type_EvtStopped
$rec DetectEvt -EvtType $Recorder_Event_Type_EvtRecording
$rec DetectEvt -EvtType $Recorder_Event_Type_EvtPaused
frame .control1
frame .control2
frame .file
menubutton .file.opt -text "File" -menu .file.opt.main -relief raised
menu .file.opt.main
.file.opt.main add command -label "Browse" -command {set filename [fileselect "Select File"];.file.filename xview end}
.file.opt.main add cascade -menu .file.opt.encode -label "Recorder Encoder"
.file.opt.main add cascade -menu .file.opt.decode -label "Player Decoder"
menu .file.opt.encode
.file.opt.encode add command -label "Other" -command {catch {set encoder [queryBox {Enter Id of Encoder to Use} Encoder $encoder]}}

foreach coder [lsort $encoders] {
    .file.opt.encode add radiobutton -label $coder -value [set $coder] -variable encoder
}

menu .file.opt.decode
.file.opt.decode add command -label "Other" -command {catch {set decoder [queryBox {Enter Id of Decoder to Use} Decoder $decoder]}}

foreach coder [lsort $decoders] {
    .file.opt.decode add radiobutton -label $coder -value [set $coder] -variable decoder
}

.file.opt.main add checkbutton -label "Report Underruns" -command toggleUnderruns -variable underruns
.file.opt.main add command -label "Exit" -command quit
entry .file.filename -textvariable filename
pack .file.opt -side left
pack .file.filename -side left

#play controls
set myframe .control1.play
frame $myframe -relief sunken -borderwidth 1
button $myframe.start -text "Play" -bitmap $bitmaps(PLAY) \
    -command {$ply StartPlay -FileName $filename -Decoding $decoder} 
button $myframe.stop -text "Stop" -bitmap $bitmaps(STOP) \
    -command {$ply StopPlay}
checkbutton $myframe.pause_resume -text "Pause" -bitmap $bitmaps(PAUSE) -indicator off \
    -command PlayerPauseResume -variable player_pause
$myframe.start configure -state normal
$myframe.stop configure -state disabled
$myframe.pause_resume configure -state disabled
pack $myframe.start -side left
pack $myframe.stop -side left
pack $myframe.pause_resume -side left

#record controls
set myframe .control1.record
frame $myframe -relief sunken -borderwidth 1
button $myframe.start -text "Record" -bitmap $bitmaps(RECORD) \
    -command {$rec StartRecord -FileName $filename -Encoding $encoder}
button $myframe.stop -text "Stop" -bitmap $bitmaps(STOP) \
    -command {$rec StopRecord}
checkbutton $myframe.pause_resume -text "Pause" -bitmap $bitmaps(PAUSE) -indicator off \
    -command RecorderPauseResume -variable record_pause 
$myframe.start configure -state normal
$myframe.stop configure -state disabled
$myframe.pause_resume configure -state disabled
pack $myframe.start -side left
pack $myframe.stop -side left
pack $myframe.pause_resume -side left

#volume controls
set myframe .control2.volume
frame $myframe -relief sunken -borderwidth 1
frame $myframe.header
label $myframe.header.title -text "Volume"
entry $myframe.header.volume -textvar volume -width 5 -state disabled
pack $myframe.header.title -side left
pack $myframe.header.volume
pack $myframe.header

foreach ctrl {UP DOWN NORMAL TOGGLE} {
    button $myframe.vol$ctrl -text $ctrl -bitmap $bitmaps($ctrl) \
	-command [list volumeCtrl [set Player_MsgAdjVolume_VolumeMode_$ctrl]]
    pack $myframe.vol$ctrl -side left
}

#speed controls
set myframe .control2.speed
frame $myframe -relief sunken -borderwidth 1
frame $myframe.header
label $myframe.header.title -text "Speed"
entry $myframe.header.speed -textvar speed -width 5 -state disabled
pack $myframe.header.title -side left
pack $myframe.header.speed
pack $myframe.header

foreach ctrl {UP DOWN NORMAL TOGGLE} {
    button $myframe.vol$ctrl -text $ctrl -bitmap $bitmaps($ctrl) -command [list \
		  speedCtrl [set Player_MsgAdjSpeed_SpeedMode_$ctrl]]
    pack $myframe.vol$ctrl -side left
}

wm protocol . WM_DELETE_WINDOW quit
label .control1.dummy -width 5
pack .control1.dummy -side left
pack .control1.play -side left 
pack .control1.record -side left
pack .control2.volume -side left
pack .control2.speed -side left
pack .file -anchor w
pack .control1 -anchor w
pack .control2 -anchor w

#check current state of underrun reporting
array set val [$ply GetParm -Parm $Player_ParmUnderrunReporting]
if [expr $val(Val) == $Player_ParmUnderrunReporting_Off] {
    set underruns 0
} else {
    set underruns 1
}



