# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2010 Dialogic Inc.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

source ${qscript_library}/LCON_Class.qs
source ${qscript_path}/linedisplay.qs

#parse command line arguments
if [catch {array set check [CheckParms -Proc lineadmin.qs \
			-Provided $argv_clean -Required {-board} \
			-Optional {-line -lines} -Switches {-advanced -ts16 -log}]} result ] {
	puts stderr $result
	puts stderr "\n"
	wm withdraw .
	return
}

# Get arguments
array set argvarr $check(Flags)

set boardnum $argvarr(-board)

wm title . [list LineAdmin Board $boardnum]

set board [Board new -init [list -BoardNum $boardnum]]

set lines { 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 
	    17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32
	    33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48
	    49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 }

if [info exists argvarr(-line)] {set lines $argvarr(-line)}
if [info exists argvarr(-lines)] {set lines $argvarr(-lines)}

if [expr [lsearch -exact $check(Switches) {-log}] == -1] {
    #switch not supplied, don't show the log
    set showLog 0
} else {
    set showLog 1
}

# Find the lines on the board
set linenums {}
foreach linenum $lines {
	# See if line exists
	if [ catch { set ladClust [$board findClust -Attrs [list\
					      [list -key $Std_ComponentType \
						   -value $LCON_Std_ComponentType] \
					      [list -key $LCON_LineId \
						   -value $linenum] ] ] } result ] {
		# No line admin for line
		# puts stderr $result
		# puts stderr "\n"		
	} else {
		# Get line admin instance in cluster
		set lad [$ladClust find -InstClass LCON]

		# Found a line cluster - add the line to the list
		lappend linenums $linenum

		# Record cluster and instance for this line
		set line($linenum,cluster) $ladClust
		set line($linenum,lad)     $lad

		# Record line number for LAD object
		set line($lad,linenum) $linenum
	}
}

# Build line groups (rows) for display
set rows {}
set row {}
foreach linenum $linenums {
	lappend row $linenum
	lappend statusrow $linenum
	if { [llength $row] > 7 } { 
		lappend rows $row 
		set row {}
	}
	if { [llength $statusrow] > 30 } {
		lappend statusrows $statusrow
		set statusrow {}
	}
}
if { [llength $row] > 0 } { lappend rows $row }
unset row
if { [llength $statusrow] > 0 } { lappend statusrows $statusrow }
unset statusrow
unset linenum

# Alarm events from Line Admin
set rx_alarms_list [list $RED_CFA $YELLOW_CFA $AIS_CFA $LOS_CFA $LOOPBACK_CFA \
		       $RAI_CRC_CFA $TS16_RED_CFA $TS16_YELLOW_CFA \
			$TS16_AIS_CFA $DCHAN_CFA,$BPVS_CFA,$ECS_CFA,CECS_CFA \
			$FERR_CFA, $OOF_CFA]

# Alarms that can be sent via Line Admin
set tx_alarms_list [list $Transmit_RAI $Transmit_AIS \
		       $Transmit_RAI_TS16 $Transmit_AIS_TS16 \
			]

set offColor darkgrey
set alarmOnColor($RED_CFA) red
set alarmOnColor($YELLOW_CFA) yellow
set alarmOnColor($AIS_CFA) blue
set alarmOnColor($LOS_CFA) $offColor
set alarmOnColor($LOOPBACK_CFA) orange
set alarmOnColor($RAI_CRC_CFA) yellow
set alarmOnColor($TS16_RED_CFA) red
set alarmOnColor($TS16_YELLOW_CFA) yellow
set alarmOnColor($TS16_AIS_CFA) blue
set alarmOnColor($DCHAN_CFA) $offColor
set alarmOnColor($Transmit_RAI) yellow
set alarmOnColor($Transmit_AIS) blue
set alarmOnColor($Transmit_RAI_TS16) yellow
set alarmOnColor($Transmit_AIS_TS16) blue

set alarmOffColor($RED_CFA)				$offColor
set alarmOffColor($YELLOW_CFA)			$offColor
set alarmOffColor($AIS_CFA)				$offColor
set alarmOffColor($LOS_CFA)				green
set alarmOffColor($LOOPBACK_CFA)			$offColor
set alarmOffColor($RAI_CRC_CFA)			$offColor
set alarmOffColor($TS16_RED_CFA)			$offColor
set alarmOffColor($TS16_YELLOW_CFA)		$offColor
set alarmOffColor($TS16_AIS_CFA)			$offColor
set alarmOffColor($DCHAN_CFA)				green
set alarmOffColor($Transmit_RAI)			$offColor
set alarmOffColor($Transmit_AIS)			$offColor
set alarmOffColor($Transmit_RAI_TS16)	$offColor
set alarmOffColor($Transmit_AIS_TS16)	$offColor
unset offColor

set alarms_name($RED_CFA) RED_CFA
set alarms_name($YELLOW_CFA) YELLOW_CFA
set alarms_name($AIS_CFA) AIS_CFA
set alarms_name($LOS_CFA) LOS_CFA
set alarms_name($RAI_CRC_CFA) RAI_CRC_CFA
set alarms_name($TS16_RED_CFA) TS16_RED_CFA
set alarms_name($TS16_YELLOW_CFA) TS16_YELLOW_CFA
set alarms_name($TS16_AIS_CFA) TS16_AIS_CFA
set alarms_name($DCHAN_CFA) DCHAN_CFA
set alarms_name($LOOPBACK_CFA) LOOPBACK_CFA
set alarms_name($Transmit_RAI) RAI
set alarms_name($Transmit_AIS) AIS
set alarms_name($Transmit_RAI_TS16) TS16_RAI
set alarms_name($Transmit_AIS_TS16) TS16_AIS
set alarms_name($BPVS_CFA) BPVS_CFA
set alarms_name($ECS_CFA) ECS_CFA
set alarms_name($CECS_CFA) CECS_CFA
set alarms_name($FERR_CFA) FERR_CFA
set alarms_name($OOF_CFA) OOF_CFA




proc handleAsyncAlarms { this type data } {
	global alarm_state line alarms_name
	global LineAlarm_Inactive LineAlarm_Active
	global alarmLed alarmOnColor alarmOffColor

	array set alarm $data

	if { $alarm(State) == $LineAlarm_Active } {
		logString "Line $line($this,linenum) Alarm $alarms_name($alarm(Type)) active\n"
	} else {
		logString "Line $line($this,linenum) Alarm $alarms_name($alarm(Type)) inactive\n"
	}

	set alarm_state($this,$alarm(Type)) $alarm(State)
}

proc handleAsyncLineState {this type arg} {
	global line LineState_InService LineState_OutOfService

	# Get event fields in an array
	array set change $arg

	if { $change(Type) == $LineState_InService } {
		logString "Line $line($this,linenum) put in service\n"
	} else {
		logString "Line $line($this,linenum) put out of service\n"
	}

	set line($this,linestate) $change(Type)
	set line($this,oosreason) $change(Reason)
}

proc get_alarms { lad } {
	global AllAlarms alarm_state LineAlarm_Active alarms_name line

	global LOOPBACK_CFA Loopback_Line Loopback_None

	array set retval [$lad GetAlarms -Alarms $AllAlarms]
    
	foreach alarm $retval(AlarmInfo) {
		array set alarmdata $alarm
		set alarm_state($lad,$alarmdata(Type)) $alarmdata(State)
		if { $alarmdata(State) == $LineAlarm_Active } {
		   logString "Line $line($lad,linenum) reports $alarms_name($alarmdata(Type)) active\n"
			if { $alarmdata(Type) == $LOOPBACK_CFA } {
				set line($line($lad,linenum),loopback) $Loopback_Line
			}
		} else {
			if { $alarmdata(Type) == $LOOPBACK_CFA } {
				set line($line($lad,linenum),loopback) $Loopback_None
			}
		}
		unset alarmdata
	}
}

proc get_linestate { lad } {
	global line LineState_InService LineState_OutOfService

	array set retval [$lad GetLineState]

	if { $retval(LineState) == $LineState_InService } {
		logString "Line $line($lad,linenum) is in service\n"
	} else {
		logString "Line $line($lad,linenum) is out of service\n"
	}

	set line($lad,linestate) $retval(LineState)
	set line($lad,oosreason) $retval(Reason)
}

proc updateAlarm { lad alarm } {
	global alarm_state LineAlarm_Active LineAlarm_Inactive

	if { $alarm_state($lad,$alarm) == $LineAlarm_Active } {
		if [catch {$lad SendAlarm -AlarmId $alarm} result] {
			logError "SendAlarm failed: " $result
		}
	} else {
		if [catch {$lad StopAlarm -AlarmId $alarm} result] {
			logError "StopAlarm failed: " $result
		}
	}
}

proc updateLineState { lad } {
	global line LineState_InService LineState_OutOfService oosreason oospri

	if { $line($lad,linestate) == $LineState_OutOfService } {
#		$indicator configure -fg darkgrey
		if [catch {$lad SetLineState -State $LineState_OutOfService \
						-Reason $oosreason -Priority $oospri} result] {
			set line($lad,linestate) $LineState_OutOfService
			logError "OutOfService failed: " $result
		}
	} else {
#		$indicator configure -fg green
		if [catch {$lad SetLineState -State $LineState_InService} result] {
			set line($lad,linestate) $LineState_InService
			logError "InService failed: " $result
		}
	}
}

frame .display


# Build Line state control and status frame
set disp .display.linestate
frame $disp -relief ridge -borderwidth 3 
#buildLineState2 $disp $linenums
buildLineState $disp $statusrows

pack $disp -side top -anchor nw -expand true  

frame .display.one

# Build Transmit alarm control frame
set disp .display.one.alarmSend
frame $disp -relief ridge -borderwidth 3
label $disp.title -text "Transmit Alarm"
pack $disp.title -side top

buildTx $disp $rows \
			{ " " "RAI" "AIS" "TS16 RAI" "TS16 AIS" } \
			"$Transmit_RAI $Transmit_AIS \
			$Transmit_RAI_TS16 $Transmit_AIS_TS16"
pack $disp -side top -anchor nw -fill x


set disp .display.one.ledStatusAdvanced
frame $disp -relief ridge -borderwidth 3
label $disp.title -text "Adv Alarm Status"
pack $disp.title -side top
buildLedStatus $disp $rows \
			{ " " AIS CRC DChannel } \
			" $AIS_CFA $RAI_CRC_CFA $DCHAN_CFA "

# See if command line requested the Advanced display
if {[lsearch -exact $check(Switches) -advanced] != -1} {
	pack .display.one.ledStatusAdvanced -side top -anchor nw -fill x
	set showAdvanced 1
} else {
	set showAdvanced 0
}

pack .display.one -side left -anchor nw -fill y

frame .display.two

set disp .display.two.ledStatus
frame $disp -relief ridge -borderwidth 3
label $disp.title -text "Alarm Status"
pack $disp.title -side top
buildLedStatus $disp $rows \
			{ " " Red Yellow Signal Loopback } \
			" $RED_CFA $YELLOW_CFA $LOS_CFA $LOOPBACK_CFA " 
pack $disp -side top -anchor nw -fill x

set disp .display.two.ledStatusE1
frame $disp -relief ridge -borderwidth 3
label $disp.title -text "TS16 Alarm Status"
pack $disp.title -side top
buildLedStatus $disp $rows \
			{ " " "Red" "Yellow" "AIS" } \
			" $TS16_RED_CFA $TS16_YELLOW_CFA $TS16_AIS_CFA "

# See if command line requested TS16 display
if {[lsearch -exact $check(Switches) -ts16] != -1} {
	pack .display.two.ledStatusE1 -side top -anchor nw -fill x
	set showE1 1
} else {
	set showE1 0
}

pack .display.two -side left -anchor nw -fill y

pack .display -side top -anchor nw -fill both


proc logString { string } {

	.log.data insert end "[clock format [clock seconds] -format {%m/%d/%Y %I:%M:%S %p}] - "
	#.log.data insert end "[clock format [clock seconds] -format {%a %b %d %I:%M:%S %p}] - "
   .log.data insert end $string
	.log.data see end
   update idletasks
}

proc logError { string error } {

	array set err $error
	if [info exists err(Error)] {
		logString "$string errorCode $err(Error)\n"
	} else {
		logString "$string $error\n"
	}
}

# Create log window
frame .log -border 3 -relief ridge
text .log.data -width 60 -height 5 -yscrollcommand {.log.scroll set} 
scrollbar .log.scroll -command {.log.data yview}
pack .log.data -side left -fill both -expand true -anchor n
pack .log.scroll -fill y -expand true -anchor n


if [expr $showLog] {
    pack .log -side top -expand true -fill both -anchor n
}

# Set default reason and priority for line state
set oosreason $OOSReason_Standby
set oospri $OOSPriority_Immediate

#frame .linestate.reason
#foreach rsn {Startup Diagnostics Maintenance Standby Alarms Null} {
#    radiobutton .linestate.reason.rsn_$rsn -variable oosreason -text $rsn \
#	-value [set OOSReason_$rsn]
#    pack .linestate.reason.rsn_$rsn -side left
#}

#frame .linestate.priority
#foreach pri {Immediate FinishCalls} {
#    radiobutton .linestate.priority.pri_$pri -variable oospri -text $pri \
#	-value [set OOSPriority_$pri]
#    pack .linestate.priority.pri_$pri -side left
#}

#pack .linestate.service -side left
#pack .linestate.priority
#pack .linestate.reason

#pack .linestate

#register event handlers
foreach linenum $linenums {
    $line($linenum,lad) asyncRegister -EvtGroup $AllAlarms -Proc handleAsyncAlarms
    $line($linenum,lad) asyncRegister -EvtGroup $LineState_AllService -Proc handleAsyncLineState
}

proc restart {} {
    global linenums line AllAlarms LineState_AllService boardnum

    logString "LineAdmin restarting on board $boardnum\n\n"

    #cancel evts
    foreach linenum $linenums {
	catch {$line($linenum,lad) CancelEvt -EvtType $AllAlarms}
	catch {$line($linenum,lad) CancelEvt -EvtType $LineState_AllService}
    }

    start

    logString "LineAdmin restarted on board $boardnum\n\n"

};#endof restart

proc start {} {
    global linenums line AllAlarms LineState_AllService

    #register for events
    foreach linenum $linenums {
	$line($linenum,lad) DetectEvt -EvtType $AllAlarms
	$line($linenum,lad) DetectEvt -EvtType $LineState_AllService
    }

    #update line states
    foreach linenum $linenums {
	get_linestate $line($linenum,lad)
    } 

    #update alarm states
    foreach linenum $linenums {
	get_alarms $line($linenum,lad)
    }

};#endof start


proc quit { } {
    exit
}

#button .exit -text exit -command quit

#pack .exit

proc ladSaveLog { fileName } {

	set fileName [tk_getSaveFile -defaultextension log \
			-initialfile $fileName \
			-filetypes {{{Log file} {.log}} {{Text file} {.txt}} {{All files} {*.*}}} \
			-title "Save Line Admin log file as"]

	if {[string length $fileName] > 0} {
		# Save the log
		set logFile [open $fileName w]
		puts $logFile [.log.data get 1.0 end]
		close $logFile
	}
}

menu .menu_file -tearoff false
.menu_file add command -label "Save log" -command { ladSaveLog lineadmin.log }
.menu_file add command -label "Clear log" -command {.log.data delete 0.0 end }
.menu_file add command -label "Reset" -command restart
.menu_file add command -label Exit -command { exit }

# Create Display menu
menu .menu_display -tearoff false
.menu_display add check -label Advanced -variable showAdvanced -command {
	if { $showAdvanced} {
		pack .display.one.ledStatusAdvanced -side left -anchor nw -fill y
	} else {
		# Hide Advanced alarms
		pack forget .display.one.ledStatusAdvanced
	}
}
.menu_display add check -label "Timeslot 16" -variable showE1 -command {
	if { $showE1} {
		pack .display.two.ledStatusE1 -side left -anchor nw -fill y
	} else {
		# Hide E1 alarms
		pack forget .display.two.ledStatusE1
	}
}

.menu_display add check -label "Log" -variable showLog -command {
	if { $showLog} {
	    pack .log -side top -expand true -fill both -anchor n
	} else {
		# Hide Log
		pack forget .log
	}
}

# Create Loopback menu
menu .menu_loopback -tearoff false
foreach linenum $linenums {
	.menu_loopback add check -label "Line $linenum" \
		-variable line($linenum,loopback) \
		-onvalue $Loopback_Line -offvalue $Loopback_None \
		-command " updateLoopback $linenum "
}
unset linenum

proc updateLoopback { linenum } {
	global line Loopback_None Loopback_Line

	if { $line($linenum,loopback) == $Loopback_None } {
		logString "Taking line $linenum out of loopback\n"
	} else {
		logString "Putting line $linenum into loopback\n"
	}
	if [catch { $line($linenum,lad) SetDiagMode -Mode $line($linenum,loopback) } result ] {
		logError "loopback failed: " $result
	}
}

# Add action menu to menu bar
menu .menubar -tearoff false
.menubar add cascade -label File -menu .menu_file
.menubar add cascade -label Display -menu .menu_display
.menubar add cascade -label Loopback -menu .menu_loopback

# Add menu bar to top of window
. config -menu .menubar

wm protocol . WM_DELETE_WINDOW quit

logString "LineAdmin starting on board $boardnum\n\n"

start

logString "LineAdmin started on board $boardnum\n\n"


