# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

source ${qscript_library}/CHPComponent_Class.qs
source ${qscript_library}/TSC_Class.qs

if [catch {array set check [CheckParms -Proc tspconfig.qs -Provided $argv_clean -Required {-board} \
				-Optional {-id}]} result ] {
    puts stderr $result
    return
}

#enum values

#T1 enums
set variant_format_enums_$TSC_ParmProtocolBase_T1_CAS \
    [list \
	 Wink [list Yes $CHP_T1_Variant_Wink_Yes \
		   No $CHP_T1_Variant_Wink_No] \
	 FarEndAnswer [list Yes $CHP_T1_Variant_FarEndAnswer_Yes \
			   No $CHP_T1_Variant_FarEndAnswer_No] \
	 Dial [list Yes $CHP_T1_Variant_Dial_Yes \
		   No $CHP_T1_Variant_Dial_No] \
	 DialFormat [list DTMF $CHP_T1_Variant_DialFormat_DTMF \
			 MF $CHP_T1_Variant_DialFormat_MF \
			 DP $CHP_T1_Variant_DialFormat_DP] \
	 ANI [list No $CHP_T1_Variant_ANI_No \
		  Pre $CHP_T1_Variant_ANI_Pre \
		  Post $CHP_T1_Variant_ANI_Post] \
	 ANIFormat [list DTMF $CHP_T1_Variant_ANIFormat_DTMF \
			MF $CHP_T1_Variant_ANIFormat_MF \
			DP $CHP_T1_Variant_ANIFormat_DP] \
	 DNIS [list Yes $CHP_T1_Variant_DNIS_Yes \
		   No $CHP_T1_Variant_DNIS_No] \
	 DNISFormat [list DTMF $CHP_T1_Variant_DNISFormat_DTMF \
			 MF $CHP_T1_Variant_DNISFormat_MF \
			 DP $CHP_T1_Variant_DNISFormat_DP] \
	 CallProgress [list Yes $CHP_T1_Variant_CallProgress_Yes \
			   No $CHP_T1_Variant_CallProgress_No] \
	 BlindTransfer [list Yes $CHP_T1_Variant_BlindTransfer_Yes \
			    No $CHP_T1_Variant_BlindTransfer_No] \
	 BtAddressDef [list None $CHP_T1_Variant_BtAddressDef_None \
			   Dest $CHP_T1_Variant_BtAddressDef_Dest \
			   Orig $CHP_T1_Variant_BtAddressDef_Orig \
			   DestOrig $CHP_T1_Variant_BtAddressDef_DestOrig \
			   OrigDest $CHP_T1_Variant_BtAddressDef_OrigDest] \
	 BtOrigFormat [list DTMF $CHP_T1_Variant_BtOrigFormat_DTMF \
			   MF $CHP_T1_Variant_BtOrigFormat_MF \
			   DP $CHP_T1_Variant_BtOrigFormat_DP] \
	 BtDestFormat [list DTMF $CHP_T1_Variant_BtDestFormat_DTMF \
			   MF $CHP_T1_Variant_BtDestFormat_MF \
			   DP $CHP_T1_Variant_BtDestFormat_DP] \
	 BtCancelDigitsFormat [list DTMF $CHP_T1_Variant_BtCancelDigitsFormat_DTMF \
				   MF $CHP_T1_Variant_BtCancelDigitsFormat_MF \
				   DP $CHP_T1_Variant_BtCancelDigitsFormat_DP] \
	 ProtocolType [list EM $CHP_T1_Variant_ProtocolType_EM \
			   Loop_FXS $CHP_T1_Variant_ProtocolType_Loop_FXS \
			   Ground_FXS $CHP_T1_Variant_ProtocolType_Ground_FXS \
			   Loop_FXO $CHP_T1_Variant_ProtocolType_Loop_FXO \
			   Ground_FXO $CHP_T1_Variant_ProtocolType_Ground_FXO] \
	]
    

#ISDN enums
set variant_format_enums_$TSC_ParmProtocolBase_ISDN \
    [list \
	 ProtocolType [list 4ESS $CHP_ISDN_Variant_ProtocolType_ISDN_4ESS \
			   5ESS $CHP_ISDN_Variant_ProtocolType_ISDN_5ESS \
			   DMS100 $CHP_ISDN_Variant_ProtocolType_ISDN_DMS100 \
			   NTT $CHP_ISDN_Variant_ProtocolType_ISDN_NTT \
			   NET5 $CHP_ISDN_Variant_ProtocolType_ISDN_NET5] \
	 CallProgress [list No $CHP_ISDN_Variant_CallProgress_No \
			   Yes $CHP_ISDN_Variant_CallProgress_Yes] \
	 ]


#PDK enums
set variant_format_enums_$CHP_PDK_Variant \
    [list \
	 InterCallDelay %d \
	 MakeCallTimeout %d \
	 TonePreDigitTimeout %d \
	 ToneInterDigitTimeout %d \
	 CaSignalTimeout %d \
	 CaAnswerTimeout %d \
	 CaPvdTimeout %d \
	 CaCallProgressOverride [list Off $CHP_PDK_Variant_CaCallProgressOverride_Off \
				     On $CHP_PDK_Variant_CaCallProgressOverride_On \
				     None $CHP_PDK_Variant_CaCallProgressOverride_None] \
	 CaMediaDetectOverride [list Off $CHP_PDK_Variant_CaMediaDetectOverride_Off \
				    On $CHP_PDK_Variant_CaMediaDetectOverride_On \
				    None $CHP_PDK_Variant_CaMediaDetectOverride_None] \
	 CASAlloc [list No $CHP_PDK_Variant_CASAlloc_False \
		       Yes $CHP_PDK_Variant_CASAlloc_True] \
	 ToneGenAlloc [list No $CHP_PDK_Variant_ToneGenAlloc_False \
		       Yes $CHP_PDK_Variant_ToneGenAlloc_True] \
	 ToneDetAlloc [list No $CHP_PDK_Variant_ToneDetAlloc_False \
		       Yes $CHP_PDK_Variant_ToneDetAlloc_True] \
	 ToneBufAlloc [list No $CHP_PDK_Variant_ToneBufAlloc_False \
		       Yes $CHP_PDK_Variant_ToneBufAlloc_True] \
	 ToneR2Alloc [list No $CHP_PDK_Variant_ToneR2Alloc_False \
		       Yes $CHP_PDK_Variant_ToneR2Alloc_True] \
	 CaAlloc [list No $CHP_PDK_Variant_CaAlloc_False \
		       Yes $CHP_PDK_Variant_CaAlloc_True] \
	 ]
	 

array set vparm_prefix [list \
			    $CHP_PDK_Variant CHP_PDK_VParm_ \
			    $CHP_VariantFormat_T1CAS CHP_VParm_ \
			    $CHP_VariantFormat_ISDN CHP_VParm_ \
			    ]

array set variant_fielddef_prefix [list \
			    $CHP_PDK_Variant CHP_PDK_Variant_ \
			    $CHP_VariantFormat_T1CAS CHP_T1_Variant_ \
			    $CHP_VariantFormat_ISDN CHP_ISDN_Variant_ \
			    ]



#array  of read only elements based on format
array set readonly_parms [list \
			      $CHP_VariantFormat_T1CAS  {CallProgress} \
			      $CHP_VariantFormat_ISDN  {CallProgress} \
			      $CHP_PDK_Variant {ProtocolId VendorId Version CompatibilityMask \
						    CASAlloc \
						    ToneGenAlloc ToneDetAlloc \
						    ToneBufAlloc ToneR2Alloc CaAlloc} \
			      ]

#procedures

proc getboard {} {

	global boardNum board comptsc 

	if [info exists board] {
		$board destroy
		unset board
	}

	if [info exists comptsc] {
		$comptsc destroy
		unset comptsc 
	}

	wm title . "DM3 CHP Variant Config - Board $boardNum"

 #find instance

	set board [Board new -init [list -BoardNum $boardNum]]

	set comptsc [$board findComp -CompClass TSCComponent]

}

proc doubleClick {widget field} {
    global boardNum
    #check if field has CASMap in the name
    switch -glob $field {
	CASPulseDialSignalId -
	EM_* -
	LS_PBX* -
	LS_Net* -
	GS_PBX* -
	GS_Net* -
	*CASMap {
	    #double clicked on a CAS signal id, load signal editor for it
	    set signal [string range [$widget get] \
			    [$widget index sel.first] [$widget index sel.last]]
	    exec SignalEditor -board $boardNum -signalId $signal &
	}
	default {
	    #do nothing
	}
    }

}

proc getVariant {} {

    global variant_id variant_format comptsc field_width
	 global CHP_VParm_VariantId CHP_VParm_VariantFormat protocolbase
	 global get_parmidlist parmidlookup
	 global data readonly_parms

	 set head .display.column

	 upvar \#0 variant_format_enums_$protocolbase var_enums

	 array set enums $var_enums

	 #allow modifications to display format

	 $head configure -state normal

	 #remove old fields. This has to be done before clearing out the data array, otherwise
	 #the global data array will never get cleared due to the display field bindings that 
	 #exist with the array elements.

	 $head delete 0.0 end


	 if [info exists data] {
	 	unset data 
	 }

	 if [info exists fields] {
	 	unset fields 
	 }

	 set variantIdlist [list Parm $CHP_VParm_VariantId \
							 		 Val  $variant_id] 		

	 set formatIdlist  [list Parm $CHP_VParm_VariantFormat \
								  	 Val  $variant_format]

	 set getformatlist [linsert $get_parmidlist 0 $formatIdlist]

	 set getparmslist [linsert $getformatlist 0 $variantIdlist]

	 array set result [$comptsc GetxParms -Parms $getparmslist]
	 

    set tmpdata $result(Parms)

	 array set formatarray [lindex $tmpdata 1]

	 set variant_format $formatarray(Val)

    foreach parmset $tmpdata {
	array set variantparm $parmset
	catch {set data($parmidlookup($variantparm(Parm))) $variantparm(Val)}
	 
    }


	 #build new fields

	 set fields [lsort [array names data]]

	 #find longest field name

	 set field_name_length 0
		 
	 foreach field $fields {
	  	if [expr [string length $field] > $field_name_length] {
			set field_name_length [string length $field]
	  	}
	 }

	 foreach field $fields {
	  	frame $head.field_$field
	  	label $head.field_$field.label -text $field -width $field_name_length -anchor e
	   pack $head.field_$field.label -side left -anchor n

	     #check to see if it is readonly
	     if [expr [lsearch -exact $readonly_parms($variant_format) $field] == -1] {
		 set state normal
	     } else {
		 set state disabled
	     }

	     if {[info exists enums($field)] && [expr [llength $enums($field)] > 1]} {
		
				#radio button
		
				text $head.field_$field.box -width $field_width -relief flat -borderwidth 0 -bg [lindex [.control.label_brd configure -bg] end]
				pack $head.field_$field.box -side left -anchor n
				array set opts $enums($field)
				set opt_names [lsort [array names opts]]

				foreach opt $opt_names {
	   	   
		       		radiobutton $head.field_$field.box.radio_$opt -text $opt \
		           	-variable data($field) -value $opts($opt) -state $state
		   		

		   		$head.field_$field.box window create end -window \
		      	$head.field_$field.box.radio_$opt -align top
				}
		
				set end [lindex [split [$head.field_$field.box index $head.field_$field.box.radio_$opt] .] 1]
				incr end $end
				$head.field_$field.box configure -height $end -state disabled
				unset opts
	    	} else {
		    if [info exists enums($field)] {
			set format $enums($field)
			set data($field) [format $format $data($field)]
		    }
				#text field
				entry $head.field_$field.entry -text data($field) -width $field_width -state $state
				pack $head.field_$field.entry -side left -anchor n

		    bind $head.field_$field.entry <Double-Button-1> [list doubleClick $head.field_$field.entry $field]
		    bindtags $head.field_$field.entry [list all Entry $head.field_$field.entry]
	    	}

	    	$head window create end -window $head.field_$field -align top
	    
	 }	
	
	 #lock display format
	
	 $head configure -state disabled
    
};			#end getVariant

proc setVariant {} {

 	global variant_id variant_format comptsc data  
 	global CHP_VParm_VariantId CHP_Variant_VariantId
 	global CHP_VParm_VariantFormat CHP_Variant_Format
 	global CHP_VariantFormat_T1CAS CHP_VariantFormat_ISDN CHP_VariantFormat_PDK
	global vparm_prefix variant_fielddef_prefix readonly_parms

	#build lists of parameter names, fielddefs and values for SetxParms. 

	 if [info exists parmidlist] {
	 	unset parmidlist 
	 }
	
	set variantIdlist [list Parm $CHP_VParm_VariantId \
									FieldDef $CHP_Variant_VariantId \
									Val $variant_id]

	lappend parmidlist $variantIdlist

	set variantformatlist [list Parm $CHP_VParm_VariantFormat \
										 FieldDef $CHP_Variant_Format \
										 Val $variant_format]

	lappend parmidlist $variantformatlist

	set parmnames [array names data]

	foreach pname $parmnames {

	     #check to see if it is readonly
	     if [expr [lsearch -exact $readonly_parms($variant_format) $pname] == -1] {
	       global $variant_fielddef_prefix($variant_format)${pname} \
		   $vparm_prefix($variant_format)${pname} 

	       set parmIdName [set $vparm_prefix($variant_format)${pname}]
	       set parmFieldDef [set $variant_fielddef_prefix($variant_format)${pname}]

	       lappend parmidlist [list Parm $parmIdName FieldDef $parmFieldDef Val $data($pname)]
	   
	   }
 	}

	$comptsc SetxParms -Parms $parmidlist

};	#endof setVariant

proc checkgetVariant {} {

 	global currentboard boardNum comptsc
	global get_parmidlist parmidlookup 
	global variant_id variant_format
	global protocolbase TSC_ParmProtocolBase_ISDN TSC_ParmProtocolBase_T1_CAS
	global CHP_T1_Variant_TypeDef CHP_ISDN_Variant_TypeDef CHP_PDK_Variant_TypeDef
	global CHP_VParm_VariantId CHP_VParm_VariantFormat 
	global CHP_VariantFormat_T1CAS CHP_VariantFormat_ISDN CHP_PDK_Variant
	global vparm_prefix variant_fielddef_prefix 

	if {$currentboard != $boardNum} {
		getboard
		set currentboard boardNum 
		
		if [info exists get_parmidlist] {
			unset get_parmidlist
		}

	   if [info exists parmidlookup] {
	 		unset parmidlookup 
		}

	   set baseprotocollist [list [list Parm $CHP_VParm_VariantId \
	    								         Val  $variant_id]]

	   lappend baseprotocollist [list Parm $CHP_VParm_VariantFormat \
										  	    Val  $variant_format]

	   array set formatresult [$comptsc GetxParms -Parms $baseprotocollist]



      set basedata $formatresult(Parms)

	   array set formatarray [lindex $basedata 1]

	   set variant_format $formatarray(Val)

	   switch -exact -- $variant_format [ list \
			$CHP_VariantFormat_T1CAS { 

				array set parmarray $CHP_T1_Variant_TypeDef
				set protocolbase $TSC_ParmProtocolBase_T1_CAS

			} \
			$CHP_VariantFormat_ISDN { 

				array set parmarray $CHP_ISDN_Variant_TypeDef
				set protocolbase $TSC_ParmProtocolBase_ISDN
			
			} \
			$CHP_PDK_Variant { 
			    global CHP_PDK_VParm_ProtocolId CHP_PDK_VParm_VendorId CHP_PDK_VParm_Version CHP_PDK_VParm_CompatibilityMask PDK_PDP_Formats
			    #get vendorId, protocolId and version
			    array set pvIds [$comptsc GetxParms -Parms [list \
									    [list Parm $CHP_VParm_VariantId Val $variant_id] \
									    [list Parm $CHP_VParm_VariantFormat] \
									    [list Parm $CHP_PDK_VParm_VendorId] \
									    [list Parm $CHP_PDK_VParm_ProtocolId] \
									    [list Parm $CHP_PDK_VParm_Version] \
									    [list Parm $CHP_PDK_VParm_CompatibilityMask] \
									   ] \
						]


			    set parms $pvIds(Parms)
			    
			    #extract vendorId, protocolId and version
			    foreach parm $parms {
				array set parm_arr $parm
				
				if [expr $parm_arr(Parm) == $CHP_PDK_VParm_VendorId] {
				    set vendorId $parm_arr(Val)
				}
				if [expr $parm_arr(Parm) == $CHP_PDK_VParm_ProtocolId] {
				    set protocolId $parm_arr(Val)
				}

				if [expr $parm_arr(Parm) == $CHP_PDK_VParm_Version] {
				    set version $parm_arr(Val)
				}

				if [expr $parm_arr(Parm) == $CHP_PDK_VParm_CompatibilityMask] {
				    set versionMask $parm_arr(Val)
				}

				
			    }

			    if [info exists parmarray] {
				unset parmarray
			    }

			    if [info exists PDK_PDP_Formats([list $vendorId $protocolId $version])] {
				set protocolbase PDK_Protocol_${vendorId}_${protocolId}_${version}
				array set parmarray $PDK_PDP_Formats([list $vendorId $protocolId $version])
			    } else {
				#exact match not found
				#check for compatible one

				foreach name [array names PDK_PDP_Formats] {
				    set p_vend [lindex $name 0]
				    set p_prot [lindex $name 1]
				    set p_ver [lindex $name 2]

				    if [expr ($p_vend == $vendorId) && ($p_prot == $protocolId) && \
					    (($p_ver & $versionMask) == ($version & $versionMask))] {
					#match found
					puts "exact match for PDK Protocol Vendor $vendorId Protocol $protocolId Version $version not found"
					puts "using compatible Version $p_ver"
					
					set protocolbase PDK_Protocol_${p_vend}_${p_prot}_${p_ver}
					array set parmarray $PDK_PDP_Formats([list $p_vend $p_prot $p_ver])

					break
				    }

				}

				if ![info exists parmarray] {
				    #no compatible match found
				    global initFiles
				    puts stderr "No protocol specific info for Vendor $vendorId Protocol $protocolId Version $version CompatibiliyMask $versionMask, only reading standard PDK Variant Parameters"
				    puts stderr "The following protocol module definitions are loaded: $initFiles"
				    set protocolbase $CHP_PDK_Variant
				    array set parmarray $CHP_PDK_Variant_TypeDef
				}
			    }
			
			} \
			default { puts "UNKNOWN PROTOCOL BASE"; uplevel #0 return } \
		]  
	
		array set parmlist $parmarray(-DataType) 
		set get_parmnames [array names parmlist]

		foreach pname $get_parmnames {
		    global  $vparm_prefix($variant_format)${pname} 

	       set parmIdName [set $vparm_prefix($variant_format)${pname}]

		    
	   	lappend get_parmidlist [list Parm $parmIdName  Val   0]

		set parmidlookup($parmIdName) $pname
		}


	}

	getVariant

} 

proc checksetVariant {} {
 
 	global currentboard boardNum
	
	if {$currentboard != $boardNum} {
		getboard
		set currentboard boardNum 
	}
	  
	setVariant
}

set field_width 20
frame .control
frame .display
scrollbar .display.yscroll -command {.display.column yview} -orient vertical
text .display.column -yscrollcommand {.display.yscroll set} -width 50
pack .display.column -side left -expand true -fill both
pack .display.yscroll -fill y -expand true
label .control.label_brd -text "Board"
entry .control.brd -textvariable "boardNum" -width 4
label .control.label_var -text "Variant id"
entry .control.var -textvariable "variant_id" -width 5
label .control.label_for -text "Variant Format"
entry .control.for -textvariable "variant_format" -width 5 -state disabled
button .control.get -text "get" -command checkgetVariant
button .control.set -text "set" -command checksetVariant
button .control.exit -text "exit" -command exit
.display.column configure -bg [lindex [.control.label_brd configure -bg] end]
pack .control.label_brd -side left
pack .control.brd -side left
pack .control.label_var -side left
pack .control.var -side left
pack .control.label_for -side left
pack .control.for -side left
pack .control.get -side left
pack .control.set -side left
pack .control.exit -side left
pack .display -fill both -expand true
pack .control -side left
array set parms $check(Flags)
set boardNum $parms(-board)
set currentboard NONE 
if [catch {set variant_id $parms(-id)} result] {
    set variant_id 2
}

#get all protocol modules in the tools directory
set initFiles [glob -nocomplain ${qscript_path}/*_tspconfig.qs]
if {[pwd] != $qscript_path} {
    #get all the protocol modules in the current directory
    set initFiles [concat $initFiles [glob -nocomplain *_tspconfig.qs]]
}
#load protocol modules
foreach initFile $initFiles {
    if [catch {source $initFile} result] {
	puts stderr "Error loading protocol module $initFile"
    }
}

set variant_format 1

if [catch {checkgetVariant} result] {
    puts stderr $result
    return
}

