/**
* @file appevents.h
* @brief Application level events shared by endpoints and
*        bridged calls
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _APPEVENTS_H
#define  _APPEVENTS_H

// Make sure app events do not overlap with GC/R4 events!!
#define APP_CALLREQ        		    	 0x01
#define APP_M3G_ENDPOINT_OPENED		    0x02
#define APP_SIP_ENDPOINT_OPENED		    0x03
#define APP_M3G_ENDPOINT_PORT_CONNECTED 0x04
#define APP_SIP_ENDPOINT_PORT_CONNECTED 0x05
#define APP_H245_START_REQUEST		    0x06
#define APP_H245_STARTED			       0x07
#define APP_M3G_ENDPOINT_CONNECTED	    0x08
#define APP_SIP_ENDPOINT_CONNECTED	    0x09
#define APP_BRIDGEDCALL_DISCONNECT      0x0A
#define APP_M3G_ENDPOINT_DISCONNECT     0x0B
#define APP_SIP_ENDPOINT_DISCONNECT     0x0C
#define APP_M3G_ENDPOINT_DISCONNECTED   0x0D
#define APP_SIP_ENDPOINT_DISCONNECTED   0x0E
#define APP_SIP_ENDPOINT_ANSWERED           0x0F
#define APP_MM_ENDPOINT_OPENED              0x10
#define APP_MM_ENDPOINT_PORT_CONNECTED      0x11
#define APP_MM_ENDPOINT_IDLE                0x12
#define APP_MM_ENDPOINT_PLAYING             0x13
#define APP_MM_ENDPOINT_RECORDING           0x14
#define APP_MM_ENDPOINT_DISCONNECT        0x15
#define APP_MM_ENDPOINT_DISCONNECTED        0x16
#define APP_BRIDGEDHAIRP_DISCONNECT	    0x17
#define APP_RTSP_ENDPOINT_OPENED              0x18
#define APP_RTSP_ENDPOINT_PORT_CONNECTED      0x19
#define APP_RTSP_ENDPOINT_IDLE                0x20
#define APP_RTSP_ENDPOINT_PLAYING             0x21
#define APP_RTSP_ENDPOINT_RECORDING           0x22
#define APP_RTSP_ENDPOINT_DISCONNECTED        0x23
#endif

