/**
* @file bridgedhairpidle_state.cpp
* @brief Definition of BridgedHairpIdleState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedhairpidle_state.h"
#include "bridgedhairp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"
#include "epstate.h"
#include "main.h"


//*****************************************************************************
// Function: BridgedHairpIdleState::BridgedHairpIdleState(BridgedHairp *pBridgedHairp)
// Description: Initializing constructor
// Return:  BridgedHairpIdleState*
// Parameters: BridgedHairp *pBridgedHairp 
//*****************************************************************************
BridgedHairpIdleState::BridgedHairpIdleState(BridgedHairp* pBridgedHairp) :
   BridgedHairpState(pBridgedHairp)
{
}


//*****************************************************************************
// Function: BridgedHairpIdleState::~BridgedHairpIdleState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedHairpIdleState::~BridgedHairpIdleState()
{
}

//*****************************************************************************
// Function: void BridgedHairpIdleState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpIdleState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_H245_START_REQUEST:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridhedHairpIdleState rcvd:APP_H245_START_REQUEST\n",m_pBridgedHairp->Index());
         ProcessStartH245Request(metaevent);
         break;
      case APP_SIP_ENDPOINT_ANSWERED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridhedHairpIdleState rcvd:APP_SIP_ENDPOINT_ANSWERED\n",m_pBridgedHairp->Index());
         ProcessSipAnswered(metaevent);
         break;
      case APP_SIP_ENDPOINT_DISCONNECT:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridhedHairpIdleState rcvd:APP_SIP_ENDPOINT_DISCONNECT\n",m_pBridgedHairp->Index());
         break;
      case APP_SIP_ENDPOINT_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridhedHairpIdleState rcvd:APP_SIP_ENDPOINT_DISCONNECTED\n",m_pBridgedHairp->Index());
      break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedHairp[%d] BridhedHairpIdleState: Unexpected event type: 0x%x\n",
         m_pBridgedHairp->Index(),metaevent.evttype);
         break;
   }
}


//*****************************************************************************
// Function: void BridgedHairpIdleState::ProcessStartH245Request(METAEVENT metaevent)
// Description: Process a start H245 request
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpIdleState::ProcessStartH245Request(METAEVENT metaevent)
{
   m_pBridgedHairp->ChangeState(CONNECTING_STATE);
}

