/**
* @file bridgedrtspidle_state.h
* @brief Declaration of BridgedRtspIdleState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDRTSPIDLE_STATE_H
#define  _BRIDGEDRTSPIDLE_STATE_H

#include "bridgedrtspstate.h"


//*****************************************************************************
// Class: ::BridgedRtspIdleState
// Description: This BridgedRtspState subclass is for when a BridgedRtsp object
//              is waiting for an inbound endpoint connection
//*****************************************************************************
class BridgedRtspIdleState : public BridgedRtspState
{
public:
   BridgedRtspIdleState(BridgedRtsp* pBridgedRtsp);
   virtual ~BridgedRtspIdleState();
   const char *GetStateStr() { return "IDLE           ";}
   E_BRIDGEDRTSPSTATE GetState() { return IDLE_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   static const int H245_STARTED;
   static const int M3G_CONNECTED;
   static const int RTSP_READY;
 
   bool IsBridgedRtspReady() { return(RTSP_READY == m_StatusBitmask);}

   void ProcessRTSPPlaying(METAEVENT metaevent);
   void ProcessRTSPRecording(METAEVENT metaevent);
   void ProcessEndpointConnected(METAEVENT metaevent);
   void ProcessEndpointDisconnect(METAEVENT metaevent);
};

#endif




