/**
* @file bridgedrtspopening_state.cpp
* @brief Definition of BridgedRtspOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "rtspendpoint.h"
#include "bridgedrtspopening_state.h"
#include "bridgedrtsp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

// static constant members:
const int BridgedRtspOpeningState::RTSP_OPENED             = 0x01;
const int BridgedRtspOpeningState::M3G_OPENED            = 0x02;
const int BridgedRtspOpeningState::BOTH_OPENED           = 0x03;
const int BridgedRtspOpeningState::RTSP_CONNECTED          = 0x10;
const int BridgedRtspOpeningState::M3G_CONNECTED         = 0x20;
const int BridgedRtspOpeningState::BOTH_CONNECTED        = 0x30;

//*****************************************************************************
// Function: BridgedRtspOpeningState::BridgedRtspOpeningState(BridgedRtsp *pBridgedRtsp)
// Description: Initializing constructor
// Return:  BridgedRtspOpeningState*
// Parameters: BridgedRtsp *pBridgedRtsp 
//*****************************************************************************
BridgedRtspOpeningState::BridgedRtspOpeningState(BridgedRtsp* pBridgedRtsp)
   : BridgedRtspState(pBridgedRtsp)
{
}

//*****************************************************************************
// Function: BridgedRtspOpeningState::~BridgedRtspOpeningState()
// Description: Descructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedRtspOpeningState::~BridgedRtspOpeningState()
{
}

//*****************************************************************************
// Function: void BridgedRtspOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_RTSP_ENDPOINT_OPENED:
         LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspOpeningState rcvd:APP_RTSP_ENDPOINT_OPENED\n", m_pBridgedRtsp->Index());
         m_StatusBitmask |= RTSP_OPENED;
         ProcessEndpointOpened(metaevent);
         break;
      case APP_M3G_ENDPOINT_OPENED:
         LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspOpeningState rcvd:APP_M3G_ENDPOINT_OPENED\n", m_pBridgedRtsp->Index());
         m_StatusBitmask |= M3G_OPENED;
         ProcessEndpointOpened(metaevent);
         break;
      case APP_RTSP_ENDPOINT_PORT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspOpeningState rcvd:APP_RTSP_ENDPOINT_PORT_CONNECTED\n", m_pBridgedRtsp->Index());
         m_StatusBitmask |= RTSP_CONNECTED;
         ProcessEndpointConnected(metaevent);
         break;
      case APP_M3G_ENDPOINT_PORT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspOpeningState rcvd:APP_M3G_ENDPOINT_PORT_CONNECTED\n", m_pBridgedRtsp->Index());
         m_StatusBitmask |= M3G_CONNECTED;
         ProcessEndpointConnected(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedRtsp[%d] BridgedRtspOpeningState: Unexpected event type: 0x%x\n", 
		   m_pBridgedRtsp->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedRtspOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
// Description: Process endpoint opened event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
{
   if ( IsBridgedRtspOpened() )
   {
      // send cortspands to RTSP and M3G endpoints to connect to each other
      RTSPEndpoint *pRTSPEndpoint = EndpointMngr::Instance()->GetRTSPEPFromIdx( m_pBridgedRtsp->RTSPIndex());
      Endpoint *pEndpoint = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedRtsp->M3gIndex());

      if ( pRTSPEndpoint && pEndpoint )
      {
         pEndpoint->ConnectToPeer(pRTSPEndpoint->GetAudioRxPortInfo(), pRTSPEndpoint->GetVideoRxPortInfo());
         pRTSPEndpoint->ConnectToPeer(pEndpoint->GetAudioRxPortInfo(), pEndpoint->GetVideoRxPortInfo());
      }
      else
      {
         LOG_ERROR(0,"BridgedRtsp[%d] Endpoint(s) not found\n",m_pBridgedRtsp->Index());
      }
   }
}

//*****************************************************************************
// Function: void BridgedRtspOpeningState::ProcessEndpointConnected(METAEVENT metaevent)
// Description: Process endpoint port connected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspOpeningState::ProcessEndpointConnected(METAEVENT metaevent)
{
   if ( IsBridgedRtspConnected() )
   {
      m_pBridgedRtsp->ChangeState(IDLE_STATE);
   }
}
