/**
* @file bridgedrtsprecording_state.cpp
* @brief Definition of BridgedRtspRecordingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedrtsprecording_state.h"
#include "bridgedrtsp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"
#include "epstate.h"

//*****************************************************************************
// Function: BridgedRtspRecordingState::BridgedRtspRecordingState(BridgedRtsp *pBridgedRtsp)
// Description: Initializing constructor
// Return:  BridgedRtspRecordingState*
// Parameters: BridgedRtsp *pBridgedRtsp 
//*****************************************************************************
BridgedRtspRecordingState::BridgedRtspRecordingState(BridgedRtsp* pBridgedRtsp) :
   BridgedRtspState(pBridgedRtsp)
{
}


//*****************************************************************************
// Function: BridgedRtspRecordingState::~BridgedRtspRecordingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedRtspRecordingState::~BridgedRtspRecordingState()
{
}

//*****************************************************************************
// Function: void BridgedRtspRecordingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspRecordingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_M3G_ENDPOINT_DISCONNECT:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspRecordingState rcvd:APP_M3G_ENDPOINT_DISCONNECT\n",m_pBridgedRtsp->Index());
      break;
      case APP_M3G_ENDPOINT_DISCONNECTED:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspRecordingState rcvd:APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedRtsp->Index());
      Process3GDisconnected(metaevent);
      break;
      case APP_RTSP_ENDPOINT_DISCONNECTED: 
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspRecordingState rcvd:APP_RTSP_ENDPOINT_DISCONNECTED\n",m_pBridgedRtsp->Index());
      break;
      case APP_RTSP_ENDPOINT_IDLE:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspRecordingState rcvd:APP_RTSP_ENDPOINT_IDLE\n",m_pBridgedRtsp->Index());
      // RTSP play has terminated
      ProcessRtspDone(metaevent);
      break;
      default:
	LOG_ERROR(metaevent.evtdev,"BridgedRtsp[%d] BridgedRtspRecordingState: Unexpected event type: 0x%x\n",
		   m_pBridgedRtsp->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedRtspRecordingState::ProcessRTSPRecording(METAEVENT metaevent)
// Description: Process an RTSP recording  event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspRecordingState::ProcessRtspDone(METAEVENT metaevent)
{
   // Record only - return to idle
   m_pBridgedRtsp->ChangeState(IDLE_STATE);

   // Done recording, so replay the file
//     RTSPEndpoint *pRTSPEndpoint = EndpointMngr::Instance()->GetRTSPEPFromIdx( m_pBridgedRtsp->RTSPIndex());
//   if ( pRTSPEndpoint )   { 
//     pRTSPEndpoint->PlayVideoFile();
//     m_pBridgedRtsp->ChangeState(PLAYING_STATE);
//   }
}

void BridgedRtspRecordingState::Process3GDisconnected(METAEVENT metaevent)
{
  // Want to stop the record in progress
  RTSPEndpoint *pRTSPEndpoint = EndpointMngr::Instance()->GetRTSPEPFromIdx( m_pBridgedRtsp->RTSPIndex());
  if (pRTSPEndpoint)  {
    pRTSPEndpoint->StopRTSPRecord();
  }
}

