/**
*
* DIALOGIC CONFIDENTIAL
* Copyright � 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "isdndropping_state.h"
#include "isdnendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

// Temp here
#include "appevents.h"



//*****************************************************************************
// Function: ISDNDroppingState::ISDNDroppingState(ISDNEndpoint *pISDNEndpoint)
// Description: Initializing constructor
// Return:  ISDNDroppingState*
// Parameters: ISDNEndpoint *pISDNEndpoint 
//*****************************************************************************
ISDNDroppingState::ISDNDroppingState(ISDNEndpoint* pISDNEndpoint) :
   ISDNEPState(pISDNEndpoint)
{
}


//*****************************************************************************
// Function: ISDNDroppingState::~ISDNDroppingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
ISDNDroppingState::~ISDNDroppingState()
{
}

//*****************************************************************************
// Function: bool ISDNDroppingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: bool 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void ISDNDroppingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case GCEV_BLOCKED:
        LOG_ENTRY(metaevent.evtdev, "ISDNDropping state: GCEV_BLOCKED received - ignored\n");
        //TODO: ALARM_STATE not implemented
        //m_pISDNEndpoint->ChangeState(ALARM_STATE);
        break;
      
      case GCEV_UNBLOCKED:
        LOG_ENTRY(metaevent.evtdev, "ISDNDropping state: GCEV_UNBLOCKED received - ignored\n");
        break;
       
      case GCEV_DROPCALL:
          LOG_ENTRY(metaevent.evtdev, "ISDNDropping state: GCEV_DROPCALL received\n");
          m_pISDNEndpoint->ReleaseCall();
          m_pISDNEndpoint->ChangeState(RELEASING_STATE);
    	break;
    	
      default:
         LOG_ERROR(metaevent.evtdev,"ISDNDropping state: Unexpected event type:%d\n",metaevent.evttype);
         break;
   }
}


//*****************************************************************************
// Function: void ISDNDroppingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void ISDNDroppingState::Shutdown()
{
  LOG_ENTRY(m_pISDNEndpoint->GetGCISDNHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  //m_pISDNEndpoint->CloseSubDevs();
}


