/**
*
* DIALOGIC CONFIDENTIAL
* Copyright � 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/
#include "isdnopening_state.h"
#include "isdnendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

// Temp here
#include "appevents.h"

// static constant members:
const int ISDNOpeningState::GC_OPENED      = 0x01;
const int ISDNOpeningState::GC_UNBLOCKED   = 0x02;
const int ISDNOpeningState::GC_RESETTED    = 0x04;
const int ISDNOpeningState::FULLY_OPENED   = 0x07;


//*****************************************************************************
// Function: ISDNOpeningState::ISDNOpeningState(ISDNEndpoint *pISDNEndpoint)
// Description: Initializing constructor
// Return:  ISDNOpeningState*
// Parameters: ISDNEndpoint *pISDNEndpoint 
//*****************************************************************************
ISDNOpeningState::ISDNOpeningState(ISDNEndpoint* pISDNEndpoint) :
   ISDNEPState(pISDNEndpoint)
{
}


//*****************************************************************************
// Function: ISDNOpeningState::~ISDNOpeningState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
ISDNOpeningState::~ISDNOpeningState()
{
}

//*****************************************************************************
// Function: bool ISDNOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: bool 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void ISDNOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case GCEV_OPENEX:
         LOG_ENTRY(metaevent.evtdev, "ISDNOpening state: GCEV_OPENEX received\n");
         SetStatus(GC_OPENED);
         ProcessDeviceOpen(metaevent);
         break;
      case GCEV_OPENEX_FAIL:
         LOG_ERROR(metaevent.evtdev, "ISDNOpening state: GCEV_OPENEX_FAIL received - GC open failure\n");
         Shutdown();
         break;
      case GCEV_UNBLOCKED:
         LOG_ENTRY(metaevent.evtdev, "ISDNOpening state: GCEV_UNBLOCKED received\n");
         SetStatus(GC_UNBLOCKED);
         ProcessDeviceOpen(metaevent);
         break;
      case GCEV_RESETLINEDEV:
    	 LOG_ENTRY(metaevent.evtdev, "ISDNOpening state: GCEV_RESETLINEDEV received\n");
         SetStatus(GC_RESETTED);
         ProcessDeviceOpen(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev,"ISDNOpening state: Unexpected event type:%d\n",metaevent.evttype);
         break;
   }
}


//*****************************************************************************
// Function: void ISDNOpeningState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void ISDNOpeningState::Shutdown()
{
  LOG_ENTRY(m_pISDNEndpoint->GetGCISDNHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  //m_pISDNEndpoint->CloseSubDevs();
}


//*****************************************************************************
// Function: void ISDNOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
// Description: Process device open completion event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void ISDNOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
{
   LOG_ENTRY(metaevent.evtdev,"ISDN Endpoint - ProcessDeviceOpen\n");
   if (m_StatusBitmask == FULLY_OPENED)
   {
      LOG_ENTRY(metaevent.evtdev,"ISDNEndpoint -  GC, GC Unblocked, ResetLine received\n");
      m_pISDNEndpoint->SetNetWorkHandle();
      m_pISDNEndpoint->WaitCall();
      m_pISDNEndpoint->ChangeState(WAITCALL_STATE);
   }
   else if (m_StatusBitmask == (GC_UNBLOCKED | GC_OPENED) )
   {
      LOG_ENTRY(metaevent.evtdev,"ISDNEndpoint -  Device Opened and Unblocked Reset Line\n");
      m_pISDNEndpoint->ResetLineDev();
   }
}

