#ifndef _MMCONFIG_H_
#define _MMCONFIG_H_


#include <string>
#include "logger.h"

class EndpointMngr;

class CMMConfig {
public:
   CMMConfig(
     char dtmf, const char *mmOperation, E_SEL_MM_FILE_TYPE mmFileType, E_SEL_AUD_CODER mmAudCoder,
                             E_SEL_VID_CODER mmVidCoder,E_SEL_VID_RES mmVidRes,
                             eVIDEO_FRAMESPERSEC mmFramesPerSec,eVIDEO_BITRATE mmBitRate,
                             const char *mmPlayAudioFileName, const char *mmPlayVideoFileName,
                             const char *mmRecordAudioFileName, const char *mmRecordVideoFileName) {
     m_dtmf = dtmf;
     m_mmOperation.assign(mmOperation);
     m_mmFileType = mmFileType;
     m_mmAudCoder = mmAudCoder;
     m_mmVidCoder = mmVidCoder;
     m_mmVidRes = mmVidRes;
     m_mmVidFramesPerSec = mmFramesPerSec;
     m_mmVidBitRate = mmBitRate;
     m_mmPlayAudioFileName.assign(mmPlayAudioFileName);
     m_mmPlayVideoFileName.assign(mmPlayVideoFileName);
     m_mmRecordAudioFileName.assign(mmRecordAudioFileName);
     m_mmRecordVideoFileName.assign(mmRecordVideoFileName);
     DumpConfig();
   };
   ~CMMConfig();
   const char * GetMMOperation() {return m_mmOperation.c_str();}
   const char * GetMMPlayAudioFileName() {return m_mmPlayAudioFileName.c_str();}
   const char * GetMMPlayVideoFileName() {return m_mmPlayVideoFileName.c_str();}
   const char * GetMMRecordAudioFileName() {return m_mmRecordAudioFileName.c_str();}
   const char * GetMMRecordVideoFileName() {return m_mmRecordVideoFileName.c_str();}
   E_SEL_MM_FILE_TYPE GetMMFileType() {return m_mmFileType;}
   E_SEL_AUD_CODER GetMMAudioCoder() {return m_mmAudCoder;}
   E_SEL_VID_CODER GetMMVideoCoder() {return m_mmVidCoder;}
   E_SEL_VID_RES GetMMVideoResolution() {return m_mmVidRes;}
   eVIDEO_FRAMESPERSEC GetMMVideoFramesPerSec() {return m_mmVidFramesPerSec;}
   eVIDEO_BITRATE GetMMVideoBitRate() {return m_mmVidBitRate;}

   void DumpConfig(){
     //printf("DumpMMConfig: DTMF = '%c', MMoperation=%s, mmFileType=%d, AudCoder=%d, mmVidCoder=%d, mmVidRes=%d, mmFps=%d, mmKbps=%d\n",
     //       m_dtmf, m_mmOperation.c_str(), m_mmFileType, m_mmAudCoder, m_mmVidCoder, m_mmVidRes, m_mmVidFramesPerSec, m_mmVidBitRate);
   }

private:
   char m_dtmf;

   // MM endpoint operationt (PLAY/RECORD) and files to do it from/to
   std::string m_mmOperation;
   std::string m_mmPlayAudioFileName;
   std::string m_mmPlayVideoFileName;
   std::string m_mmRecordAudioFileName;
   std::string m_mmRecordVideoFileName;

   // MM endpoint Audio/Video coder settings
   E_SEL_MM_FILE_TYPE m_mmFileType;
   E_SEL_AUD_CODER m_mmAudCoder;
   E_SEL_VID_CODER m_mmVidCoder;
   E_SEL_VID_RES   m_mmVidRes;
   eVIDEO_FRAMESPERSEC m_mmVidFramesPerSec;
   eVIDEO_BITRATE m_mmVidBitRate;
};

#endif
