/**
* @file mmportconnecting_state.h
* @brief Declaration of MMPortConnectingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _MMPORTCONNECTING_STATE_H
#define  _MMPORTCONNECTING_STATE_H

#include "mmepstate.h"


//*****************************************************************************
// Class: ::MMPortConnectingState
// Description: This MMEPState subclass handles the portconnecting of MM endpoint
//*****************************************************************************
class MMPortConnectingState : public MMEPState
{
public:
   MMPortConnectingState(MMEndpoint* pMMEndpoint);
   ~MMPortConnectingState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "PORTCONNECTING        ";}
   virtual E_MMEPSTATE GetState() { return PORTCONNECTING_STATE;}

private:
   void ProcessPortConnect(METAEVENT metaevent);
   unsigned short GetMMPortConnectCompletionCnt() { return m_MMPortConnectCompletionCnt;};
   void IncrementMMPortConnectCompletionCnt() { m_MMPortConnectCompletionCnt++;};
 
   unsigned short m_MMPortConnectCompletionCnt;

};

#endif


