/**
* @file opening_state.h
* @brief Declaration of OpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _OPENING_STATE_H
#define  _OPENING_STATE_H

#include "epstate.h"


//*****************************************************************************
// Class: ::OpeningState
// Description: This EPState subclass handles the opening of endpoint 
//              subdevices
//*****************************************************************************
class OpeningState : public EPState
{
public:
   OpeningState(Endpoint* pEndpoint);
   ~OpeningState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "OPENING        ";}
   virtual E_EPSTATE GetState() { return OPENING_STATE;}
   void ProcessDeviceOpen(long evtDev);

private:
   static const int NETWORK_OPENED;      // 0x0001;
   static const int NETWORK_UNBLOCKED;   // 0x0002;
   static const int NETWORK_CONFIG_RDY;  // 0x0003;
   static const int NETWORK_CONFIG_SENT; // 0x0004;
   static const int NETWORK_CONFIG_DONE; // 0x0008;
   static const int NETWORK_BIT_MASK;    // 0x000F
   static const int CONTROL_PORT_OPENED; // 0x0010;
   static const int AUDIO_PORT_OPENED;   // 0x0020;
   static const int VIDEO_PORT_OPENED;   // 0x0040;
   static const int PARMS_SET;           // 0x0080
   static const int FULLY_OPENED;        // 0x00FF;
   static const int CONTROL_CAPS_RCVD;   // 0x0100;
   static const int AUDIO_CAPS_RCVD;     // 0x0200;
   static const int VIDEO_CAPS_RCVD;     // 0x0400;
   static const int ALL_CAPS_RCVD;       // 0x0700;


   bool IsEndpointFullyOpened() { return(IsStatusSet(FULLY_OPENED));}
   bool IsAllCapsRecvd() { return(IsStatusSet(ALL_CAPS_RCVD));}
   bool IsNetworkReadyForConfig() { return(NETWORK_CONFIG_RDY == (m_StatusBitmask & NETWORK_BIT_MASK));}
   int m_NumParametersSet;
   void ProcessIfFullyOpened();
   void ProcessResetComplete();
};

#endif


