/**
* @file mmportconnecting_state.cpp
* @brief Definition of RTSPPortConnectingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "rtspportconnecting_state.h"
#include "rtspendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"


//*****************************************************************************
// Function: RTSPPortConnectingState::RTSPPortConnectingState(RTSPEndpoint *pRTSPEndpoint)
// Description: Initializing constructor
// Return:  RTSPPortConnectingState*
// Parameters: RTSPEndpoint *pRTSPEndpoint 
//*****************************************************************************
RTSPPortConnectingState::RTSPPortConnectingState(RTSPEndpoint* pRTSPEndpoint) :
   RTSPEPState(pRTSPEndpoint),
   m_RTSPPortConnectCompletionCnt(0)
{
}

//*****************************************************************************
// Function: RTSPPortConnectingState::~RTSPPortConnectingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
RTSPPortConnectingState::~RTSPPortConnectingState()
{
}

//*****************************************************************************
// Function: void RTSPPortConnectingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void RTSPPortConnectingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
    case DMEV_PORT_CONNECT:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_PORT_CONNECT received\n");
      ProcessPortConnect(metaevent);
        break;
    case DMEV_PORT_CONNECT_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_PORT_CONNECT_FAIL received\n");
        break;
      default:
         LOG_ERROR(metaevent.evtdev,"RTSPPortConnecting state: Unexpected event type: 0x%x\n",
		   metaevent.evttype);
         break;
   }
}

void RTSPPortConnectingState::ProcessPortConnect(METAEVENT metaevent)
{
   // Counting, looking for 2 completion events
   // Should also look at completion status, maybe?  See doc.
 
      IncrementRTSPPortConnectCompletionCnt();
      LOG_ENTRY(metaevent.evtdev, "DMEV_PORT_CONNECT received. Completion cnt = %d\n",
                GetRTSPPortConnectCompletionCnt());
 
      if ( GetRTSPPortConnectCompletionCnt() == 2 )
      {
         // Advance to next state - idle and ready to bridge this RTSP endpoint to a 3G
         m_pRTSPEndpoint->ChangeState(IDLE_STATE);
         m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_PORT_CONNECTED);
      }
}

//*****************************************************************************
// Function: void RTSPPortConnectingState::ProcessUserPrompt(RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt)
// Description: Procerss request from user interface
// Return: void 
// Parameters: RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt 
//*****************************************************************************
/**********
void  RTSPPortConnectingState::ProcessUserPrompt(RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt)
{
   LOG_ERROR(0,"Unexpected user prompt on RTSP endpoint in PORTCONNECTING state: %d\n",
             static_cast<int>(eUserPrompt));
}
******************/

//*****************************************************************************
// Function: void RTSPPortConnectingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void RTSPPortConnectingState::Shutdown()
{
  LOG_ENTRY(m_pRTSPEndpoint->GetIPMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

