/**
* @file shutdown_state.h
* @brief Declaration of ShutdownState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _SHUTDOWN_STATE_H
#define  _SHUTDOWN_STATE_H


#include "epstate.h"


//*****************************************************************************
// Class: ::ShutdownState
// Description: This EPState subclass waits for all shuddown actions to be 
//              completed
//*****************************************************************************
class ShutdownState : public EPState
{
public:
   ShutdownState(Endpoint* pEndpoint);
   ~ShutdownState();
   virtual bool ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual const char *GetStateStr() { return "SHUTDOWN       ";}
   virtual E_EPSTATE GetState() { return SHUTDOWN_STATE;}

   void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt) {}
   void Shutdown() {}

private:
   static const int AUDIO_STOPPED;
   static const int VIDEO_STOPPED;
   static const int MEDIA_STOPPED;
   static const int H245_STOPPED;
   static const int AUDIO_TX_LCN_CLOSED;
   static const int VIDEO_TX_LCN_CLOSED;
   static const int TX_LCNS_CLOSED;

   void CheckMediaStopped();
   void CheckAllLCNsClosed();
   void H245Stopped();
};

#endif


