/**
* @file sipdropping_state.cpp
* @brief Definition of SIPDroppingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "sipdropping_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

//*****************************************************************************
// Function: SIPDroppingState::SIPDroppingState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPDroppingState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPDroppingState::SIPDroppingState(SIPEndpoint* pSIPEndpoint):
   SIPEPState(pSIPEndpoint)
{
   m_pSIPEndpoint = pSIPEndpoint;
}

//*****************************************************************************
// Function: SIPDroppingState::~SIPDroppingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
SIPDroppingState::~SIPDroppingState()
{
}

//*****************************************************************************
// Function: void SIPDroppingState::ProcessEvent(METAEVENT metaevent)
// Description: Process on event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPDroppingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      // GC/R4 events
     case GCEV_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "SIPDropping_state: GCEV_DISCONNECTED received - ignore\n");
         break;
     case GCEV_DROPCALL:
         LOG_ENTRY(metaevent.evtdev, "SIPDropping_state: GCEV_DROPCALL received\n");
         ProcessDropCall(metaevent);
         break;
      case IPMEV_STOPPED:
         LOG_ENTRY(metaevent.evtdev, "SIPDropping_state: IPMEV_STOPPED received\n");
         break;
      default:
         LOG_ERROR(metaevent.evtdev, "SIPDropping_state: Unexpected event type: 0x%x\n", 
                   metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void SIPDroppingState::ProcessDropCall(METAEVENT metaevent)
// Description: Process call dropped event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPDroppingState::ProcessDropCall(METAEVENT metaevent)
{
   // Advance to releasing state
   m_pSIPEndpoint->ChangeState(RELEASING_STATE);
   m_pSIPEndpoint->ProcessDropCall(metaevent);
}

//*****************************************************************************
// Function: void SIPDroppingState::Shutdown()
// Description: Procesds shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPDroppingState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

