/**
* @file sipopening_state.h
* @brief Declaration of SIPOpeningState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _SIPOPENING_STATE_H
#define  _SIPOPENING_STATE_H

#include "sipepstate.h"


//*****************************************************************************
// Class: ::SIPOpeningState
// Description: This SIPEPState subclass handles the opening of SIP endpoint
//*****************************************************************************
class SIPOpeningState : public SIPEPState
{
public:
   SIPOpeningState(SIPEndpoint* pSIPEndpoint);
   ~SIPOpeningState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void ProcessUserPrompt(SIPEPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "IDLE           ";}
   virtual E_SIPEPSTATE GetState() { return IDLE_STATE;}
   void ProcessDeviceOpen(METAEVENT metaevent);

private:
   static const int GC_OPENED;       // 0x01
   static const int IPM_OPENED;      // 0x02
   static const int GC_UNBLOCKED;   // 0x04
   static const int FULLY_OPENED;        // 0x07

   bool IsEndpointFullyOpened() { return(FULLY_OPENED == m_StatusBitmask);}
};

#endif


