/**
* @file sipportconnecting_state.cpp
* @brief Definition of SIPPortConnectingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "sipportconnecting_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

//*****************************************************************************
// Function: SIPPortConnectingState::SIPPortConnectingState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPPortConnectingState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPPortConnectingState::SIPPortConnectingState(SIPEndpoint* pSIPEndpoint) :
   SIPEPState(pSIPEndpoint)
{
   m_StatusBitmask = 0;
   pSIPEndpoint->ZeroIpmPortConnectCompletionCnt();
}

//*****************************************************************************
// Function: SIPPortConnectingState::~SIPPortConnectingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
SIPPortConnectingState::~SIPPortConnectingState()
{
}

//*****************************************************************************
// Function: void SIPPortConnectingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPPortConnectingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case DMEV_PORT_CONNECT:
         ProcessPortConnect(metaevent);
         break;
      case DMEV_PORT_CONNECT_FAIL:
         ProcessPortConnectFail(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev,"SIPPortConnecting state: Unexpected event type: 0x%x\n",
		   metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void SIPPortConnectingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPPortConnectingState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  //m_pSIPEndpoint->ReleaseResources();
  //m_pSIPEndpoint->CloseSubDevs();
}

//*****************************************************************************
// Function: void SIPPortConnectingState::ProcessPortConnect(METAEVENT metaevent)
// Description: Process port connect completion event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPPortConnectingState::ProcessPortConnect(METAEVENT metaevent)
{
   // Counting, looking for 2 completion events
   // Should also look at completion status, maybe?  See doc.

   SIPEndpoint *pSIPEndpoint =  static_cast<SIPEndpoint *>(sr_getUserContext());
   if ( pSIPEndpoint )
   {
      pSIPEndpoint->IncrementIpmPortConnectCompletionCnt();
      LOG_ENTRY(metaevent.evtdev, "SIPPortConnecting state: DMEV_PORT_CONNECT received. Completion cnt = %d\n",
                pSIPEndpoint->GetIpmPortConnectCompletionCnt());

      if ( pSIPEndpoint->GetIpmPortConnectCompletionCnt() == 2 )
      {
         ChangeToNextState(metaevent);
      }
   }
}

//*****************************************************************************
// Function: void SIPPortConnectingState::ProcessPortConnectFail(METAEVENT metaevent)
// Description: Process port connect failed event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPPortConnectingState::ProcessPortConnectFail(METAEVENT metaevent)
{
   LOG_ENTRY(metaevent.evtdev, "SIPPortConnecting state: DMEV_PORT_CONNECT_FAIL received\n");
}


//*****************************************************************************
// Function: void SIPPortConnectingState::ChangeToNextState(METAEVENT metaevent)
// Description: Change toi the next state on successful completion of all 
//              requirements
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPPortConnectingState::ChangeToNextState(METAEVENT metaevent)
{
   // Advance to next state - idle and ready to bridge a call
   m_pSIPEndpoint->ChangeState(IDLE_STATE);
   m_pSIPEndpoint->Notify(APP_SIP_ENDPOINT_PORT_CONNECTED);  
}


