/**
* @file sipreservingmedia_state.h
* @brief Declaration of SIPReservingMediaState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _SIPRESERVINGMEDIA_STATE_H
#define  _SIPRESERVINGMEDIA_STATE_H

#include "sipepstate.h"

//*****************************************************************************
// Class: ::SIPReservingMediaState
// Description: This SIPEPState subclass handles reserving media resources
//*****************************************************************************
class SIPReservingMediaState : public SIPEPState
{
public:
   SIPReservingMediaState(SIPEndpoint* pSIPEndpoint);
   ~SIPReservingMediaState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "RESERVINGMEDIA ";}
   virtual E_SIPEPSTATE GetState() { return RESERVINGMEDIA_STATE;}

private:
   static const int TX_PORTS_RCVD;     // 0x01
   static const int RX_PORTS_RCVD;     // 0x02
   static const int ALL_PORTS_RCVD;    // 0x03
   static const int CODEC_RESERVED;    // 0x04
   static const int ALL_EVENTS_RCVD;   // 0x07

   bool AllPortsReceived() { return(ALL_PORTS_RCVD == m_StatusBitmask);}
   bool AllEventsReceived() { return(ALL_EVENTS_RCVD == m_StatusBitmask);}
   void ProcessRxPortInfo(METAEVENT metaevent);
   void ProcessTxPortInfo(METAEVENT metaevent);
   void ProcessResourceReserved(METAEVENT metaevent);
   void ChangeToNextState(METAEVENT metaevent);
};

#endif


