/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// CnfDemoParams.h: interface for the CnfDemoPrm class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CNFDEMOPRM_H__E5E3A839_DBD7_4192_A383_AE92E822028B__INCLUDED_)
#define AFX_CNFDEMOPRM_H__E5E3A839_DBD7_4192_A383_AE92E822028B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ConfigFile.h"
#include "GenLog.h"


#define DFLT_LOG_FILE_NAME           "CnfDemo.log"

#define DFLT_WELLCOME_FILE_NAME      "welcome.pcm"
#define DFLT_BAD_PASSCODE_FILE_NAME  "invalid.pcm"
#define DFLT_GOODBYE_FILE_NAME       "bye.pcm"
#define DFLT_CALL_LATER_FILE_NAME    "bye.pcm"



// Some conversions ( code to symbolic name )
const char * ip_digit_type_name(int code);
const char * ip_coder_name(int code);
const char * ip_vad_name(int code);
const char * ip_framesize_name(int code);
const char * ip_payload_name(int code);


//
// Cnf parameter class represents one section [Conference] in configuration file
// and holds it's parameters
// 

typedef class CnfParams * PCnfParams;

class CnfParams {
  public:
      //--------
      CnfParams(){
         Init();
      };

      //---------------------
      // copy constructor
      CnfParams(CnfParams &src){
          cnf_id = src.cnf_id;
          pass_code = 0;
          str_storestring(&pass_code, src.pass_code);
          detect_digits = src.detect_digits;
          voice_party   = src.voice_party;
          beep_notify   = src.beep_notify;
          private_log   = src.private_log;
          dtmf_clamping = src.dtmf_clamping;
          tmo = src.tmo;
      };

      // Init members
      void Init(){
         cnf_id = -1;
         pass_code = 0;
         tmo = 0;
         detect_digits = false;
         dtmf_clamping = false;
         voice_party   = false;
         private_log = LOG_NONE;
         beep_notify = false;
      }

      // Destructor
      virtual ~CnfParams(){
          str_deletestoredstring(&pass_code);
      };
      
      // Compare
      int operator == (CnfParams &obj) {
          if (this == &obj){
             return 1;
          }
          return COMPARE_EQUAL == str_compare(pass_code, obj.pass_code);
      }

      int operator > (CnfParams &obj) {
          if (this == &obj){
              return 0;
          }
          return str_compare(pass_code, obj.pass_code);
      } 

      int operator < (CnfParams &obj) {
         if (this == &obj){
             return false;
         }
         return str_compare(obj.pass_code, pass_code);
      }     


      // Dump internal variavles
      void Dump(CGenLog *pLog){
           static const char *obj_name = "CnfParams";
           pLog->Log(LOG_API, obj_name, 
                      "    id = %4d",  cnf_id );
           pLog->Log(LOG_API, obj_name, 
                      "         dtmf_clamping = %s", YESNO(dtmf_clamping));
           pLog->Log(LOG_API, obj_name, 
                      "         digits        = %s", YESNO(detect_digits));
           pLog->Log(LOG_API, obj_name, 
                      "         pass_code     = %s",pass_code);
           pLog->Log(LOG_API, obj_name, 
                      "         voice party   = %s", YESNO(voice_party));
#ifdef _FR2619
           pLog->Log(LOG_API, obj_name, 
                      "         beep_notify   = %s", YESNO(beep_notify));
#endif
           pLog->Log(LOG_API, obj_name, 
                      "         tmo           = %d", tmo);
        return;                 
      }
      
      int cnf_id;
      char *pass_code;
      bool detect_digits;
      bool dtmf_clamping;
      bool voice_party;
      bool beep_notify;
      MSG_TYPE private_log;
      int  tmo;
};  // class CnfParams

//--------------------------------------------------------------
// CnfPrmContainer is a collection of CnfParams objects
//---------------------------------------------------------------
typedef class CnfPrmContainer * PCnfPrmContainer;
class CnfPrmContainer : public list <PCnfParams> {
public:
    CnfPrmContainer() {};
    virtual ~CnfPrmContainer() {};

    // find by pass code
    bool find (const char *pass_code, PCnfParams *ppCnfParams = 0){
         list<PCnfParams>::iterator pos;
         for ( pos = begin(); pos != end(); ++pos) {
               if (COMPARE_EQUAL == str_compare(pass_code, (*pos)->pass_code) ){
                   if (ppCnfParams){
                       *ppCnfParams = *pos;
                   }
                   return true;
               }
         }  
         if ( ppCnfParams){
              *ppCnfParams = 0;
         }
         return false;
    };

     // How many conferences are defined
     size_t GetNumberOfConferences(){
         return size();
     }

     // How many dx devices are requested
     size_t GetNumberOfDxDevices(){
         size_t total = 0;
         list<PCnfParams>::iterator pos;
         PCnfParams pCnfParams;
         for ( pos = begin(); pos != end(); ++pos) {
               pCnfParams = *pos;
               if (pCnfParams->voice_party){
                   ++total;
               }
         }  // for
         return total;
     }

     // retrieve conference parameter by sequential index
     bool GetConferencePrm (unsigned int inx, PCnfParams *ppCnfParams){
         if (inx < size() ){
             list<PCnfParams>::iterator pos = begin();
             unsigned int tmp = 0;
             while(tmp++ < inx){
                   ++pos;
             }
             *ppCnfParams = *pos;
             return true;
         }
         return false;
     };

};// class CnfPrmContainer



//
// Ipt parameter class represents one section [IPT] in configuration file
// and holds it's parameters
// 
typedef class CIptParams * PIptParams;

class CIptParams {
  public:
      //--------
      CIptParams(){
         Init();
      };

      //---------------------
      // copy constructor
      CIptParams(CIptParams &src){
          ipt_id             = src.ipt_id;
          m_number_of_channels = src.m_number_of_channels;
          m_accept_call      = src.m_accept_call;
          m_private_log      = src.m_private_log;
          ip_protocol        = 0;
          str_storestring(&ip_protocol,src.ip_protocol);
          ip_digits          = src.ip_digits;
          ip_coder           = src.ip_coder;
          ip_frame_size      = src.ip_frame_size;
          ip_vad             = src.ip_vad;
          ip_payoad_type     = src.ip_payoad_type;
      };

      // Init members
      void Init(){
           ipt_id               = -1; // not used yet
           m_number_of_channels = 0;
           m_private_log        = LOG_NONE;
           ip_protocol          = 0;
           m_accept_call        = true;
           str_storestring(&ip_protocol, "SIP");
           ip_digits            = IP_DTMF_TYPE_INBAND_RTP;
           ip_coder             = CODER_TYPE_G711ALAW64K;
           ip_frame_size        = CODER_FRAMESIZE_30;
           ip_vad               = CODER_VAD_DISABLE;
           ip_payoad_type       = IP_USE_STANDARD_PAYLOADTYPE;
      };

      // Destructor
      virtual ~CIptParams(){
           str_deletestoredstring(&ip_protocol);
      };
      
      // Dump internal variavles
      void Dump(CGenLog *pLog){
           const char *name;
           static const char *obj_name = "CIptParams";
           pLog->Log(LOG_API, obj_name, 
                      "     [IPT %d]",  ipt_id );

           pLog->Log(LOG_API, obj_name, 
                      "         ipt_id               = %d",    ipt_id );

           pLog->Log(LOG_API, obj_name, 
                      "         m_number_of_channels = %d",    m_number_of_channels );

           pLog->Log(LOG_API, obj_name, 
                      "         m_accept_call        = %s",    YESNO(m_accept_call ) ) ;

           name = log_get_msgtype_name(m_private_log);
           pLog->Log(LOG_API, obj_name, 
                      "         m_private_log        = %d %s", m_private_log, name);

           pLog->Log(LOG_API, obj_name, 
                      "         ip_protocol          = %s",    ip_protocol);

           name = ip_digit_type_name(ip_digits);
           pLog->Log(LOG_API, obj_name, 
                      "         ip_digits            = %d %s", ip_digits, name);

           name = ip_coder_name(ip_coder);
           pLog->Log(LOG_API, obj_name, 
                      "         ip_coder             = %d %s", ip_coder, name);


           name = ip_framesize_name(ip_frame_size);
           pLog->Log(LOG_API, obj_name, 
                      "         ip_frame_size        = %d %s", ip_frame_size, name);

           name = ip_vad_name(ip_vad);
           pLog->Log(LOG_API, obj_name, 
                      "         ip_vad               = %d %s", ip_vad, name);

           name = ip_payload_name(ip_payoad_type);
           pLog->Log(LOG_API, obj_name, 
                      "         ip_payoad_type       = %d %s", ip_payoad_type, name);
        return;                 
      }
      
      unsigned int m_number_of_channels;   // number of timeslots to use with this configuration
      bool m_accept_call;                  // do accept call?
      MSG_TYPE m_private_log;              // private log verbosity level (LOG_NONE to skip)
      char *ip_protocol;                   // "SIP", "H323"
      int ip_digits;                       // "INBAND", "RFC2833"
      eIPM_CODER_TYPE ip_coder;            // CODER_TYPE_G711ALAW64K, ...
      eIPM_CODER_FRAMESIZE ip_frame_size;  // CODER_FRAMESIZE_30,..
      eIPM_CODER_VAD ip_vad;               // use CODER_VAD_DISABLE    
      unsigned int ip_payoad_type;                  // use IP_USE_STANDARD_PAYLOADTYPE
      int ipt_id;                          // unique ud 
};  // class CIptParams



const char *          get_call_control_mode_name(enumIPCCLIBMediaMode mode);
enumIPCCLIBMediaMode  get_call_control_value(const char *name);



typedef enum {
	RESERVE_RESOURCE_NONE,
    RESERVE_RESOURCE,
    RESERVE_RESOURCE_EX
}RESERVE_RESOURCE_TYPE;


RESERVE_RESOURCE_TYPE get_reserve_resource_value(const char *name);
const char *get_reserve_resource_name(RESERVE_RESOURCE_TYPE mode);


//
//  Global parameters
//
typedef class CommonParams * PCommonParams;
class CommonParams {
  public:
      //--------
      CommonParams(){
		  m_call_control_mode = MEDIA_OPERATIONAL_MODE_1PCC;
		  m_reserve_resource_type = RESERVE_RESOURCE_NONE;	   // HMP mode
	      m_maxlogsize    = 10000;     // lines
          m_log_level     = LOG_APP;   // Application, Warning and Error messages
          m_log_file      = 0;
          str_storestring(&m_log_file, DFLT_LOG_FILE_NAME);

          m_welcome_file  = 0;
          str_storestring(&m_welcome_file,DFLT_WELLCOME_FILE_NAME);

          m_bad_passcode_file  = 0;
          str_storestring(&m_bad_passcode_file,DFLT_BAD_PASSCODE_FILE_NAME);

          m_callater_file  = 0;
          str_storestring(&m_callater_file,DFLT_CALL_LATER_FILE_NAME);

          m_goodbye_file  = 0;
          str_storestring(&m_goodbye_file,DFLT_GOODBYE_FILE_NAME);

      };

      // Destructor
      virtual ~CommonParams(){
	      str_deletestoredstring(&m_goodbye_file); 
	      str_deletestoredstring(&m_callater_file); 
	      str_deletestoredstring(&m_bad_passcode_file); 
	      str_deletestoredstring(&m_welcome_file); 
	      str_deletestoredstring(&m_log_file); 
      };
      
      // Dump internal variavles
      void Dump(CGenLog *pLog){
           const char *name;
           static const char *obj_name = "CommonParams";
           name = get_call_control_mode_name(m_call_control_mode);
           pLog->Log(LOG_API, obj_name, 
                      "         m_call_control_mode     = %d %s",  m_call_control_mode, name );

           pLog->Log(LOG_API, obj_name, 
                      "         m_reserve_resource_type = %d %s", m_reserve_resource_type, get_reserve_resource_name(m_reserve_resource_type) );

           pLog->Log(LOG_API, obj_name, 
                      "         m_maxlogsize   = %d",  m_maxlogsize );


           name = log_get_msgtype_name(m_log_level);
           pLog->Log(LOG_API, obj_name, 
                      "         m_log_level         = %d %s", m_log_level, name);

           pLog->Log(LOG_API, obj_name, 
                      "         m_log_file          = %s",    m_log_file);

           pLog->Log(LOG_API, obj_name, 
                      "         m_welcome_file      = %s", m_welcome_file);

           pLog->Log(LOG_API, obj_name, 
                      "         m_bad_passcode_file = %s", m_bad_passcode_file);


           pLog->Log(LOG_API, obj_name, 
                      "         m_callater_file     = %s", m_callater_file);

           pLog->Log(LOG_API, obj_name, 
                      "         m_goodbye_file      = %s", m_goodbye_file);

        return;                 
      };
      
      inline bool  Is3PCCMode(){
		 return MEDIA_OPERATIONAL_MODE_3PCC == m_call_control_mode;
	  }

	  inline RESERVE_RESOURCE_TYPE GetReserveResourceType() {
		  return m_reserve_resource_type;
	  }


	  enumIPCCLIBMediaMode m_call_control_mode;	// MEDIA_OPERATIONAL_MODE_1PCC or 3PCC
	  RESERVE_RESOURCE_TYPE m_reserve_resource_type;
	  
	  unsigned int m_maxlogsize;    // lines
      MSG_TYPE m_log_level;         // verbosity level
      char *   m_log_file;          // log file name
      char *   m_welcome_file;      // wecome message
      char *   m_bad_passcode_file; // bad pass code message
      char *   m_callater_file;     // call later message
      char *   m_goodbye_file;      // goodbye 

}; // class CommonParams



//
//  DTI parameters
//
typedef class DtiParams * PDtiParams;
class DtiParams {
  public:
      //--------
      DtiParams(){
	      m_number_of_channels = 0;     // lines
          m_accept_call   = false;      // do accept calls?
          m_private_log   = LOG_NONE;   // No private log
      };

      // Destructor
      virtual ~DtiParams(){
      };
      
      // Dump internal variavles
      void Dump(CGenLog *pLog){
           const char *name;
           static const char *obj_name = "DtiParams";
           pLog->Log(LOG_API, obj_name, 
                      "         m_number_of_channels = %d",  m_number_of_channels );

           pLog->Log(LOG_API, obj_name, 
                      "         m_accept_call        = %s",  YESNO(m_accept_call));

           name = log_get_msgtype_name(m_private_log);
           pLog->Log(LOG_API, obj_name, 
                      "         m_log_level          = %d %s", m_private_log, name);
        return;                 
      };
      
	  unsigned int m_number_of_channels;
      bool m_accept_call;
      MSG_TYPE m_private_log;         // verbosity level
}; // class DtiParams

//
//  BRD (cnfB1) parameters
//
typedef class BrdParams * PBrdParams;
class BrdParams {
  public:
      //--------
      BrdParams(){
          m_log_level         = LOG_APP;    // Application, Warning and Error messages
	      m_brd_active_talker = false;     
          m_brd_at_interval   = 10;
          m_brd_dtmf_clamping = false;
      };

      // Destructor
      virtual ~BrdParams(){
      };
      
      // Dump internal variavles
      void Dump(CGenLog *pLog){
           const char *name;
           static const char *obj_name = "CBrdParams";
           name = log_get_msgtype_name(m_log_level);
           pLog->Log(LOG_API, obj_name, 
                      "         m_log_level          = %d %s", m_log_level, name);

           pLog->Log(LOG_API, obj_name, 
                      "         m_brd_active_talker  = %d %s",
                      m_brd_active_talker, YESNO(m_brd_active_talker));
           
           pLog->Log(LOG_API, obj_name, 
                      "         m_brd_at_interval    = %d ",
                      m_brd_at_interval);

           pLog->Log(LOG_API, obj_name, 
                      "         m_brd_dtmf_clamping  = %d %s",
                      m_brd_dtmf_clamping, YESNO(m_brd_dtmf_clamping));

        return;                 
      };
       
      MSG_TYPE m_log_level;
      bool m_brd_active_talker;
      int m_brd_at_interval;
      bool m_brd_dtmf_clamping;
}; // class BrdParams



//
// Specific Configuration file reader 
// Based on CnfParams class and customized for cnf_demo configuration file
// 
typedef class CnfDemoPrm * PCnfDemoPrm;

class CnfDemoPrm : public ConfigFile  {
public:
	CnfDemoPrm(CGenLog *pLog);
	virtual ~CnfDemoPrm();


    // Load configuration file and scan & read parameters 
    bool ReadConfigFile(const char *filename);

//    Adjust parameters if (all available) is specified
    bool  AdjustNumberOfDevices(size_t dx_devices,
                                size_t ipt_devices,
                                size_t dti_devices);
public:
    size_t GetRequestedNumberOfDxDevices(){
        size_t total = GetRequestedNumberOfDtiDevices() +
                       GetRequestedNumberOfIptDevices() +
                       m_ConferenceContainer.GetNumberOfDxDevices();
        
           return total;
    }

	inline enumIPCCLIBMediaMode GetPCCMode(){
		   return m_CommonParams.m_call_control_mode;
	}
    inline bool  Is3PCCMode(){
		return m_CommonParams.Is3PCCMode();
	}

    inline RESERVE_RESOURCE_TYPE GetReserveResourceType() {
		  return m_CommonParams.GetReserveResourceType();
	}


    // Global parameters
        // -------------------------
        // section [Common]
private:
       CommonParams m_CommonParams;
public:
       PCommonParams GetCommonPrm (){
           return &m_CommonParams;
       }

       // --------------------------
       // section [Board Parameters] 
private:
       BrdParams m_BrdParams;
public:
       PBrdParams GetBrdPrm(){
           return &m_BrdParams;
       };

        // --------------------------
        // section [Dti] 
private:
       DtiParams m_DtiParams;
public:
       PDtiParams GetDtiPrm (){
           return &m_DtiParams;
       };

       unsigned int GetRequestedNumberOfDtiDevices(){
           if ( MAXUINT == m_DtiParams.m_number_of_channels ){
                return 0;
           }
           return m_DtiParams.m_number_of_channels;
       };

private:
    // -------------------------
    // Sections [conference xxx]
       bool StoreConference();

       CnfPrmContainer m_ConferenceContainer; 

       CnfParams m_cnf_params;  // Scratch, Currently processed values

public:
       PCnfPrmContainer GetConferencePrmContainer(){
            return &m_ConferenceContainer;    
       };

       size_t GetRequestedNumberOfConferences(){
            return m_ConferenceContainer.GetNumberOfConferences();
       }
private:
    // -------------------------
    // Sections [Ipt]
     bool StoreIpt();
     list<PIptParams> m_IptContainer;
     CIptParams m_ipt_params;  // Scratch, Currently processed values

     // How many ipt blocks are defined
     int GetNumberOfIptParams(){
         return m_IptContainer.size();
     }

public:
     // retrieve ipt block by sequential index
     bool GetIptPrm (unsigned int inx, PIptParams *ppIptParams){
         if (inx < m_IptContainer.size() ){
             list<PIptParams>::iterator pos = m_IptContainer.begin();
             unsigned int tmp = 0;
             while(tmp++ < inx){
                   ++pos;
             }
             *ppIptParams = *pos;
             return true;
         }
         return false;
     }

     unsigned int GetRequestedNumberOfIptDevices(const char *protocol = 0) {
         unsigned int total = 0;
         list<PIptParams>::iterator pos = m_IptContainer.begin();
         while(pos != m_IptContainer.end()){
             PIptParams pPrm = *pos;
             if (    ( protocol == 0)
                  || ( COMPARE_EQUAL == str_compare(protocol, pPrm->ip_protocol) ) 
                ){
                if (pPrm->m_number_of_channels!= MAXUINT){
                    total += pPrm->m_number_of_channels;
                }
             }
             ++pos;
         } 
         return total;
     }


///////////////////////////////////////////////
    // dump (LOG) all parameters
public:
    void Dump();

private:

    // Log errors when reading file
        // Log invalid value message
        void LogInvalidValue(const char *token, const char *value);
        // This token exist, but there is no case to handle (app error)
        void LogUnmatchedParameter(const char *token, int line);
        // This token exist, but there is no case to handle (app error)
        void LogUndefinedParameter(const char *token);

    // Read section [Common]
    bool ReadCommonValues(const char * token);
    // Read section [Board Parameters]
    bool ReadBoardValues(const char * token);
    // Read section [dti]
    bool ReadDtiValues(const char * token);
    // Read section [ipt]
    bool ReadIptValues(const char * token);

    // Read Conference
    bool ReadConference(const char * token);


}; // class CnfDemoPrm

#endif // !defined(AFX_CNFDEMOPRM_H__E5E3A839_DBD7_4192_A383_AE92E822028B__INCLUDED_)
