/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// ConfigFile.cpp: implementation of the ConfigFile class.
//
//////////////////////////////////////////////////////////////////////
// ignore MSC2005 fopen/fopen_s security warning
#define _CRT_SECURE_NO_WARNINGS
#include <fcntl.h>
#undef _CRT_SECURE_NO_WARNINGS

#include <ctype.h>
#include "utils.h"
#include "ConfigFile.h"


static const 
#ifdef LINUX
 __attribute__ ((unused)) 
#endif
 char * CNF_MODULE_NAME = "ConfigFile";


//-----------------------------------------------------------
// return error text by error code ( see CFG_ERROR )
// typedef enum {
//    CFG_OK, CFG_ERR_OPEN,  CFG_ERR_FORMAT,   CFG_ERR_LAST
// }CFG_ERROR;
static const char *errors[] = {
    "OK", "FILE_OPEN_ERR", "FILE_READ_ERR","FILE_FORMAT_ERR", "????"
};

//*****************************************************************************
// Purpose	: 
//    Return text for given error code
// Parameters:	
//    [in] error code
// Returns:	const char * - message for specified code or "????" 
//*****************************************************************************
const char *cfg_get_errormsg(CFG_ERROR error){
    if (error > CFG_ERR_LAST) {
        error = CFG_ERR_LAST;
    }
 return errors[error];
}  //	End of function()


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    none
// Returns:	none
//*****************************************************************************
ConfigFile::ConfigFile(CGenLog *pLog):
            CParser(pLog) {
  m_file_name = 0;
  m_file_buf = 0;
  DeleteBuffer();
}  //	End of constructor()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    none
// Returns:	none
//*****************************************************************************
ConfigFile::~ConfigFile() {
  DeleteBuffer();
}  //	End of destructor()


//*****************************************************************************
// Purpose	: 
//    release all buffers and init internal variables
// Parameters:	
//    none
// Returns:	void
//*****************************************************************************
void ConfigFile::DeleteBuffer(){
	ClearBuffer();
	delete[] m_file_buf;
	m_file_buf = 0;
    str_deletestoredstring(&m_file_name);
}  //	End of DeleteBuffer()

//*****************************************************************************
// Purpose	: 
//    Load file content into internal buffer
// Parameters:	
//    [in] file name
// Returns:	error code (CFG_ERROR)
//*****************************************************************************
CFG_ERROR ConfigFile::LoadConfigFile(const char *FileName){
CFG_ERROR rc = CFG_OK;

    // if same file is already loaded, 
    if (COMPARE_EQUAL == str_compare(FileName, m_file_name) ){
        Rewind();
        return CFG_OK;
    }

	FILE * fstr = fopen(FileName, "rb");
	if ( fstr == 0 ) {
            rc =  CFG_ERR_OPEN;
    } else {
        // Get file length
	    size_t length;
	    fseek(fstr, 0, SEEK_END);
	    length = ftell(fstr);
	    fseek(fstr, 0 ,SEEK_SET);
	
        // delete previosely stored data and release memory
        DeleteBuffer();

        // Allocate buffer
    	m_file_buf = new char[length +1];
	    if( fread(m_file_buf, sizeof(char), length, fstr) != length) {
            // Error reading
            DeleteBuffer();
            rc = CFG_ERR_READ;
        } else {
			SetBuffer(m_file_buf);
            // Read Ok
       	    *(m_file_buf + length) = 0;
            // this is current configuration file
            str_storestring(&m_file_name, FileName);
            Rewind();
        } // else - read Ok
      fclose(fstr);
    } // else - file opned
  return rc;
}  //	End of LoadConfigFile()

