/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// IptDevice.h: interface for the CIptDevice class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NTWKDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_)
#define AFX_NTWKDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

const char *dx_get_termination(int termno);  

typedef class CNtwkDevice * PNtwkDevice;

class CNtwkDevice : public CSrlDevice{
public:
	CNtwkDevice(DLG_DEVICE_TYPE devtype,
                PCommonParams pCommonParams, 
                const char *name);

	virtual ~CNtwkDevice();
    // Handle new event
    virtual void HandleEvent(int event,              // event code
                             void *evtdata,          // event data (if any)
                             int evtlen,             // event length    

                             METAEVENT *metaeventp); // meta event

    virtual const char *action_name(int action);
    virtual const char *state_name(int state);
    virtual bool Execute(int action);

    // virtual hooks
    virtual bool OnNewCall() = 0;
    virtual bool OnInitComplete() = 0;


    virtual void dump_notification_data(int event, void *evtdata){
        // forward to gc version
        gc_dump_notification_data(event, evtdata);
    }
// ---------------------
// Common Ntwk functions
// ----------------------
private:
    // to do or not to do: AcceptCall
    virtual bool DoAcceptCall(){
		 return false;
	}

protected:
    virtual bool Close();
    virtual bool AnswerCall();
    virtual bool AcceptCall();
    virtual bool DropCall();
    virtual bool ResetLineDev();
    virtual bool WaitCall();
    virtual bool ReleaseCall();
    virtual bool ModifyCall();
private:
// -------------
// Conference
// -------------
    bool AddParty();
    bool RemoveParty();

// 
    bool Relax();   // Wait call



//-----------------------------
protected:
    CRN m_crn;

private:
    bool ProcessEventInfo(METAEVENT *metaeventp);


private:
    bool InitForNewCall();

    bool CheckForValidConference();
    bool CheckDnis();

    char m_dnis[GC_ADDRSIZE];  // called number (our number)
    char m_ani[GC_ADDRSIZE];   // caller number (who is calling)   
    
    int m_num_inv_passcode;    // number of invalid pass codes

    bool m_do_waitcall;        // set when wait-call is already active 

    GC_INFO    m_gc_info;

// Conference resources
private:
    PCnfConference m_pCnfConf;

}; // class CNtwkDevice

#define CNF_ASSERT(val,msg) { \
   if (0 == val) { \
       LOG(LOG_ASSERT, GetName(), msg); \
       return false; \
   } \
}

#endif // !defined(AFX_NTWKDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_)
