/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// StateMachine.h: interface for the CStateMachine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SDPPARSER_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_)
#define AFX_SDPPARSER_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
typedef enum {
	ADDR_INVALID,	
	ADDR_IP4,
	ADDR_IP6
}IP_ADDR_VERSION;

typedef enum {
	STATE_BGN,
	STATE_MEDIA,
	STATE_SKIP_MEDIA
}P_STATE;


typedef enum {
// media
 SDP_CMD_M,	// media
 SDP_CMD_I,	// media title/session info
 SDP_CMD_C, // Connection information
 SDP_CMD_B, // Bandwidth
 SDP_CMD_K, // encryption key
 SDP_CMD_A, // media attribute line(s)
// Time
 SDP_CMD_T, // time
 SDP_CMD_R, // repeat times
 SDP_CMD_Z,	// time zone

// Session 
 SDP_CMD_V,	// protocol version
 SDP_CMD_O,	// owner/creator and session ID
 SDP_CMD_S, // session name

 SDP_CMD_U,	// URI of description
 SDP_CMD_E,	// email
 SDP_CMD_P,	// phone

}SDP_CMD;



// Media info class
typedef class CnfDemoMediaInfo *PCnfDemoMediaInfo;

class CnfDemoMediaInfo : public CanLog {
  public:
	  CnfDemoMediaInfo(CGenLog *pLog):
                    CanLog(pLog),
                    m_CmdParser(pLog){
		  sdp_i=0;
		  sdp_c=0;
		  sdp_b=0;
		  sdp_k=0;
		  sdp_a=0;
		  sdp_m=0;
		  clear_vars();
	  };
      virtual ~CnfDemoMediaInfo(){
		  clear_vars();
	  }
	  void clear_vars(){
		  str_deletestoredstring(&sdp_i);
		  str_deletestoredstring(&sdp_c);
		  str_deletestoredstring(&sdp_b);
		  str_deletestoredstring(&sdp_k);
		  str_deletestoredstring(&sdp_a);
		  str_deletestoredstring(&sdp_m);
		  *sdp_remote_ip = 0;
		  sdp_remote_ip_version = ADDR_INVALID;
          m_remote_port=0;
		  LOG(LOG_DBG,"CnfDemoMediaInfo","ClearVars");
		  return;
	  }

	  bool ParseMediaDataLines(int sdp_cmd, class CSdpParser *pSdpParser );
      bool Parse_c_line(CSdpParser *pSdpParser);

      
      P_STATE ProcessMediaCommand(const char *cmd);

// Session 
	  char * sdp_i;		// session info
	  char * sdp_c;		// connection info
	  char * sdp_b;		// bandwith
	  char * sdp_k;		// encryption key
	  char * sdp_a;		// media level attrubutes
	  char * sdp_m;		// Media info
    
      unsigned int m_remote_port;
	  char sdp_remote_ip[128];
	  IP_ADDR_VERSION sdp_remote_ip_version;

	  void Dump();
  protected:
      CParser m_CmdParser;// parce single sdp line in 3PCC mode
};


// SDP Parser description
typedef class CSdpParser *PSdpParser;

class CSdpParser : public CParser {
  public:
     CSdpParser(CGenLog *pLog);
     virtual ~CSdpParser();

     bool ParseSdpOffer();
	 void Dump(void);


  private:
	  void clear_vars();
      bool ParseSessionDataLines(SDP_CMD sdp_cmd);

  public:
	  unsigned int sdp_v;		// protocol version 
	  char * sdp_o;		// owner/creator
	  char * sdp_s;		// session name
	  char * sdp_u;		// url;
	  char * sdp_e;		// email
	  char * sdp_p;		// phone
	  char * sdp_z;		// time zone 	
	  char * sdp_r;		// time zone 	
	  char * sdp_a;		// session level attrubutes


	  CnfDemoMediaInfo m_MediaInfo;
	  
	  unsigned int sdp_tstart;
	  unsigned int sdp_tstop;

  private:
	  bool skip_equal(const char *cmd);
      CParser m_CmdParser;// parce single sdp line in 3PCC mode
};



#endif // !defined(AFX_SDPPARSER_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_)
