/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// SrlHandle.h: interface for the CSrlHandle class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SRLDEVICE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
#define AFX_SRLDEVICE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


//
// DEV_DISCONNECT Parameters
typedef enum {
 DEV_CNF_PARTY,
 DEV_DX_PARTY,
 DEV_NTWK_PARTY
} DEV_PARTY;


// Beep parameters
typedef enum {
  BEEP_IN,
  BEEP_OUT,
  BEEP_BYE
} BEEP_TYPE;


/*
  This is base class for any SRL device.
  SRL device is a device that has SRL handle
  implements the following features:
    - SRL state
    - HandleEvent ( the engine will execute to handle any event)
    - Timer - measure time since last function that is expecting termination event


*/

// SRL states
#define SRLSTATE_RESERVED        0x00000001  // initialization complete, device is reserved
#define SRLSTATE_OPENED          0x00000002  // device is opened
#define SRLSTATE_VOICERESERVED   0x00000004  // initialization complete, voice device is reserved
#define SRLSTATE_VOICEOPENED     0x00000008  // voice device is opened


#define SRLSTATE_WAITEVENT       0x00000100  // wait event

#define SRLSTATE_CALL_ACTIVE     0x01000000  // There is a call


#define SRLSTATE_REQUESTED_STOP  0x10000000  // request stop 
#define SRLSTATE_BLOCKED         0x20000000  // GCEV_BLOCKED

#define SRLSTATE_INIT_COMPLETE   0x40000000  // Indicates initialization ready
#define SRLSTATE_FAILED_FATAL    0x80000000  // Fatal failure, request to program to exit
// Anything except reserved:
#define SRLSTATE_ALL             ~(SRLSTATE_RESERVED |SRLSTATE_VOICERESERVED )

typedef enum {
   SET_SRL_STATE,
   RESET_SRL_STATE
}SRL_STATE_ACTION;


typedef class CSrlDevice * PSrlDevice;

// This defines interface for any object
// that can receive SRL events
class CSrlDevice : public CNamedObj, public CanLog,
                                     public CTimer,
                                     public HasExitCode {

public:
	CSrlDevice( DLG_DEVICE_TYPE devtype,
                PCommonParams pCommonParams,
                const char *name);
	virtual ~CSrlDevice();

// ---------------------------
//   SRL Handle
public:

    // Checks if specified handle applies to this object or any sub-object
    virtual bool AreYouHandle(int handle, PSrlDevice *ppDevice) {
        if (    ( m_srl_handle == handle )
             || ( m_dx_srl_handle == handle)
             || ( m_cnf_party_srl_handle == handle ) 
             || ( m_ntwk_srl_handle == handle ) ){
             *ppDevice = this;
             return true;
        }
        return false;
    };

    // Handle new event
    virtual void HandleEvent(int event,              // event code
                             void *evtdata,          // event data (if any)
                             int evtlen,             // event length    
                             METAEVENT *metaeventp); // metaevent
    
    virtual bool ExitRequest();
	bool		 DropRequest();  // reject & drop current call

    SRL_DEVICE_HANDLE GetSrlHandle(){
        return m_srl_handle;
    }
    virtual bool Execute(int action) = 0;
    virtual void dump_notification_data(int event, void *evtdata){
		UNREFERENCED_PARAMETER(event);
		UNREFERENCED_PARAMETER(evtdata);
        return;
    };

// 3PCC
	virtual bool Is3PCCMode(){
		return false;
	}

	virtual RESERVE_RESOURCE_TYPE GetReserveResourceType() {
		return RESERVE_RESOURCE_NONE;
	}

    

protected:
        bool AdvanceStateMachine(int event);


private:
        void action_table_error(int action);

// ---------------------------
//   SRL States
public:
        virtual const char *state_name(int state){
			UNREFERENCED_PARAMETER(state);
            return "not implemented";
        }
        virtual const char *action_name(int action){
			UNREFERENCED_PARAMETER(action);
            return "not implemented";
        }

        virtual bool AreSrlStates(int state, bool compare_flag, PSrlDevice *ppDev) {
            if (ppDev){
                *ppDev=this;
            }
            return IsSrlState(state, compare_flag);
        }

        virtual bool AnySrlState(int state, bool compare_flag, PSrlDevice *ppDev) {
            if (ppDev){
                *ppDev = this;
            }
            if (compare_flag) {
                return 0 != (state & m_srl_state);
            }
            return 0 == (state & m_srl_state);
        }

        // If any specified bit is set(compare_flag = true)
        // or all are reset(compare_flag = false)
        bool IsSrlState(int state, bool compare_flag) {
            if (compare_flag) {
                return 0 != (state & m_srl_state);
            }
            return 0 == (state & m_srl_state);
        }

        int GetSrlState() {
            return m_srl_state;
        };

        bool SetSrlState(int state, SRL_STATE_ACTION action = SET_SRL_STATE){
            switch(action){
                case SET_SRL_STATE:
                     m_srl_state |= state; 
                     break;

                case RESET_SRL_STATE:
                     m_srl_state &= ~state; 
                     break;
            }
           return true;
        };

    private:            
        int m_srl_state;
//=====================
    public:

        bool SetStateMachine(PEVENT_STRU pEventStru, PACTION_STRU pActionStru){
            delete m_pStateMachine;
            m_pStateMachine = new CStateMachine(pEventStru, pActionStru);
            return m_pStateMachine->Validate(this);
        }

        void SetCurrentState(int state);

        int GetCurrentState(){
            if (m_pStateMachine){
                return m_pStateMachine->m_current_state;
            }
            return 0;
        }

        bool FindInStates(int event, PEVENT_STRU *ppNewStateLine);
        bool FindInActions(int action, PACTION_STRU *ppNewActionLine);

        bool IsInRelaxedState(){
             return is_relaxed_state(GetCurrentState());
        };

        bool StateMachineError();

    private:
        PStateMachine m_pStateMachine;

// ==========================
// VOICE
    protected:
        bool open_dx();
        bool close_dx();
        bool set_dx_cst(int events);

        bool DxBeep(BEEP_TYPE beep);
        bool StopDx();
        bool PlayFile(const char *filename);
        bool RecFile();
        bool GetDigits();

        bool ClearDigits();
        bool CloseVoiceFile();
        bool GetTermReason();

        bool RouteVoice();
        bool UnListen();

private:
        SRL_DEVICE_HANDLE m_dx_srl_handle;
	    DX_IOTT    m_iott;
        const char *m_dx_name;     // dx name 
        int file_index;
protected:
        SRL_DEVICE_HANDLE m_srl_handle;
     	DV_DIGIT   m_digits;
        SRL_DEVICE_HANDLE m_ntwk_srl_handle;   // Used in dev_Connect, Either ipml or dti
        SRL_DEVICE_HANDLE m_cnf_party_srl_handle;
		bool separate_ntwk_open; 
// Conference
protected:
        bool DevConnect(DEV_PARTY party);
        bool DevDisconnect(DEV_PARTY party);


// Cnf board
protected:
    bool OpenParty();
    bool CloseParty();

    bool SetPartyAttributes(ECNF_ATTR_STATE clamping);

public:
    class CnfBoard *GetCnfBoard () {
        return m_pCnfBoard;
    }
    void SetCnfBoard (class CnfBoard *pBoard) {
        m_pCnfBoard = pBoard;
    }
private:
    class CnfBoard *m_pCnfBoard;



//===================
// TIMER
    public:

        // Check local timer and pass down in case of container
        virtual bool CheckTmo();

//------------------------------------------------------

        bool PutEvent(int event, 
                      const char *sender,
                      long len = 0,
                      void *datap = 0);

    protected:
        void DumpMissingEvents();


//===================
// Devce specific type
public:
    DLG_DEVICE_TYPE GetDeviceType(){
        return m_type;
    }
private: 
    DLG_DEVICE_TYPE m_type;


// Logging
//----------
// CStateMachine is allowed to log in our log
friend class CStateMachine;

private:
   CFileLog *m_pPrivateLog;
public:
   bool OpenPrivateLog(MSG_TYPE verbosity);
private:
   bool ClosePrivateLog();
// End Logging----------


  // **** error handling
public:
// ipml error
bool process_ipml_error(SRL_DEVICE_HANDLE ipml_handle, const char *ipml_name);

// cnf error
bool process_cnf_error();

// dx error
bool process_dx_error(SRL_DEVICE_HANDLE dx_handle, const char *dx_name);

// devmgmt error
bool process_dev_error();
// gc error
bool process_gc_error();


// **** Dump structures and data

void cnf_dump(CPCNF_ATTR                     pAttr );
void cnf_dump(CPCNF_ATTR_INFO                pAttrInfo );
void cnf_dump(CPCNF_DEVICE_COUNT_INFO        pInfo );
void cnf_dump(CPCNF_CLOSE_INFO               pInfo );
void cnf_dump(CPCNF_EVENT_INFO               pInfo );
void cnf_dump(CPCNF_CONF_OPENED_EVENT_INFO   pInfo );
void cnf_dump(CPCNF_CONF_CLOSED_EVENT_INFO   pInfo );

void cnf_dump(CPCNF_PARTY_ADDED_EVENT_INFO   pInfo );
void cnf_dump(CPCNF_PARTY_REMOVED_EVENT_INFO pInfo );
void cnf_dump(CPCNF_PARTY_INFO               pInfo );

void cnf_dump(CPCNF_DTMF_EVENT_INFO          pInfo );
void cnf_dump(CPCNF_ACTIVE_TALKER_INFO       pInfo );
void cnf_dump(CPCNF_OPEN_PARTY_RESULT        pResult );
void cnf_dump(CPCNF_CLOSE_CONF_INFO          pInfo );
void cnf_dump(CPCNF_OPEN_CONF_RESULT         pResult );

void cnf_dump_notification_data(int event, void *eventdata);


// gc structures
void gc_dump(SC_TSINFO *pInfo);
void gc_dump(GC_INFO *pInfo);

void gc_dump_notification_data(int event, void *eventdata);

// dev structures
void dev_dump(DEV_ERRINFO * pInfo);

// dx structures
void dx_dump(DX_CST * pCst);


protected:
// Global parameters
   PCommonParams m_pCommonParams;


}; // class SrlDevice



#endif // !defined(AFX_SRLDEVICE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
