/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// SrlDeviceContainer.cpp: implementation of the CSrlDeviceContainer class.
//
//////////////////////////////////////////////////////////////////////

#include "pdl.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    [in] Device type (DEV_IPT or DEV_DTI)
//    [in] Configuration parameters (from configuration file)
//    [in] Optional name. When name is 0, use any available from specified type
// Returns:	
//    none
//*****************************************************************************
CSrlDeviceContainer::CSrlDeviceContainer(DLG_DEVICE_TYPE devtype,
                                         PCommonParams pCommonParams,
                                         const char *name)
                   : CSrlDevice(devtype, pCommonParams,  0) {
	 UNREFERENCED_PARAMETER(name);
 return;
} // End CSrlDeviceContainer()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
CSrlDeviceContainer::~CSrlDeviceContainer(){
   list<PSrlDevice>::iterator pos;
   for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
         delete (*pos);
   } 
} // End CSrlDeviceContainer()


//*****************************************************************************
// Purpose	: 
//    Determine if all included devices are in specific state
// Parameters:	
//    [in] state
// Returns:	
//    bool (true  = yes, all are in specified state)
//         (false = no, at least one is in other state
//*****************************************************************************
bool CSrlDeviceContainer::AreSrlStates(int state, bool compare_flag, PSrlDevice *ppDev) {
    if ( GetDeviceType() != DEV_NONE){
          // not pure container - agree locally
        if (!IsSrlState(state, compare_flag)){
            if (ppDev){
                *ppDev = this;
            }
            return false;
        }
    }

    list<PSrlDevice>::iterator pos;
    for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
        if ( !(*pos)->AreSrlStates(state, compare_flag, ppDev) ) {
            return false;
        }
    } 
 return true;
} // End AreSrlStates()

//*****************************************************************************
// Purpose	: 
//    Determine if any included devices are in specific state
// Parameters:	
//    [in] state
// Returns:	
//    bool (true  = yes, at least one is in specified state)
//         (false = no, all are in other than <state> states
//*****************************************************************************
bool CSrlDeviceContainer::AnySrlState(int state, bool compare_flag, PSrlDevice *ppDev) {
    if (CSrlDevice::AnySrlState(state, compare_flag, ppDev)){
        return true;
    }
    list<PSrlDevice>::iterator pos;
    for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
        if ( (*pos)->AnySrlState(state, compare_flag, ppDev) ) {
            return true;
        }
    } 
 return false;
} // End AnySrlState()

//*****************************************************************************
// Purpose	: 
//    Pass exit request down to all devices
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CSrlDeviceContainer::ExitRequest(){
bool brc;
    brc = CSrlDevice::ExitRequest();
    list<PSrlDevice>::iterator pos;
    for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
        brc = (*pos)->ExitRequest() && brc;
    } 
 return brc;
} // End ExitRequest()

//*****************************************************************************
// Purpose	: 
//    Determine if any device is responsible to handle 
//      events sent to specific SRL handle
// Parameters:	
//    [in]  srl handle 
//    [out] holder for device addr ( returns device that owns given handle
// Returns:	
//    true = success - Requested device was found
//    false = fail - Requested device does not belong to 
//           this container or to any nested container
//*****************************************************************************
bool CSrlDeviceContainer::AreYouHandle(int srl_handle, PSrlDevice *ppDevice){
    if (CSrlDevice::AreYouHandle(srl_handle, ppDevice) ){
            return true;
    }                

    list<PSrlDevice>::iterator pos;
    for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
        if ( (*pos)->AreYouHandle(srl_handle , ppDevice) ){
           return true;
        } 
    }  
  return false;
} // End AreYouHandle()

//*****************************************************************************
// Purpose	: 
//    Determine if any device timed out waiting for events
// Parameters:	
//    none
// Returns:	
//    true = yes, at least one tmo is detected (but all devices are checked anyways)
//    false - none of nested devices was timed out
//*****************************************************************************
bool CSrlDeviceContainer::CheckTmo(){ // Check for timeouts
bool brc = false;
    list<PSrlDevice>::iterator pos;
    for ( pos = m_DeviceList.begin(); pos != m_DeviceList.end(); ++pos) {
        PSrlDevice pDev = *pos;
        if ( pDev->CheckTmo() ){
            brc = true;
        }  
    } 
    CSrlDevice::CheckTmo();
 return brc;
} // End CheckTmo()

//*****************************************************************************
// Purpose	: 
//    Dump all members
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
void CSrlDeviceContainer::DumpMembers(){
   LOG(LOG_API, GetName(), "Members: %d ", size());
   list<PSrlDevice>::iterator pos;
   PSrlDevice pDev;
   for ( pos = begin(); pos != end(); ++pos) {
       pDev = *pos;
       LOG(LOG_API, GetName(), "  %s", pDev->GetName());
   } 
 return;
} // End DumpMembers()
